/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.util.Comparator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSyncResults;
import org.rhq.core.domain.content.ContentSyncStatus;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionFormatDescription;
import org.rhq.core.domain.content.ValidatablePackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceMBean;
import org.rhq.enterprise.server.plugin.pc.content.AbstractPackageTypeBehavior;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.PackageDetailsValidationException;
import org.rhq.enterprise.server.plugin.pc.content.PackageTypeBehavior;
import org.rhq.enterprise.server.plugin.pc.content.PackageTypeServerPluginContainer;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentManagerHelper {
    private EntityManager entityManager;
    private static final PackageTypeBehavior DEFAULT_PACKAGE_TYPE_BEHAVIOR = new DefaultPackageTypeBehavior();

    public ContentManagerHelper(EntityManager managerIn) {
        this.entityManager = managerIn;
    }

    public static ContentServerPluginContainer getPluginContainer() throws Exception {
        ContentServerPluginContainer pc = null;
        try {
            ServerPluginServiceMBean mbean = LookupUtil.getServerPluginService();
            if (!mbean.isMasterPluginContainerStarted()) {
                throw new IllegalStateException("The master plugin container is not started!");
            }
            MasterServerPluginContainer master = mbean.getMasterPluginContainer();
            pc = master.getPluginContainerByClass(ContentServerPluginContainer.class);
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception e) {
            throw new Exception("Cannot obtain the content source plugin container", e);
        }
        if (pc == null) {
            throw new Exception("Content source plugin container is null!");
        }
        return pc;
    }

    public static PackageTypeServerPluginContainer getPackageTypePluginContainer() throws Exception {
        PackageTypeServerPluginContainer pc = null;
        try {
            ServerPluginServiceMBean mbean = LookupUtil.getServerPluginService();
            if (!mbean.isMasterPluginContainerStarted()) {
                throw new IllegalStateException("The master plugin container is not started!");
            }
            MasterServerPluginContainer master = mbean.getMasterPluginContainer();
            pc = master.getPluginContainerByClass(PackageTypeServerPluginContainer.class);
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception e) {
            throw new Exception("Cannot obtain the package type plugin container", e);
        }
        if (pc == null) {
            throw new Exception("Package type plugin container is null!");
        }
        return pc;
    }

    public static ResourcePackageDetails installedPackageToDetails(InstalledPackage installedPackage) {
        PackageVersion packageVersion = installedPackage.getPackageVersion();
        ResourcePackageDetails details = ContentManagerHelper.packageVersionToDetails(packageVersion);
        return details;
    }

    public static ResourcePackageDetails packageVersionToDetails(PackageVersion packageVersion) {
        Package generalPackage = packageVersion.getGeneralPackage();
        PackageDetailsKey key = new PackageDetailsKey(generalPackage.getName(), packageVersion.getVersion(), packageVersion.getGeneralPackage().getPackageType().getName(), packageVersion.getArchitecture().getName());
        ResourcePackageDetails details = new ResourcePackageDetails(key);
        details.setClassification(generalPackage.getClassification());
        details.setDisplayName(packageVersion.getDisplayName());
        details.setFileCreatedDate(packageVersion.getFileCreatedDate());
        details.setFileName(packageVersion.getFileName());
        details.setFileSize(packageVersion.getFileSize());
        details.setLicenseName(packageVersion.getLicenseName());
        details.setLicenseVersion(packageVersion.getLicenseVersion());
        details.setLongDescription(packageVersion.getLongDescription());
        details.setMD5(packageVersion.getMD5());
        details.setMetadata(packageVersion.getMetadata());
        details.setSHA256(packageVersion.getSHA256());
        details.setShortDescription(packageVersion.getShortDescription());
        Long created = packageVersion.getFileCreatedDate();
        if (created != null) {
            details.setInstallationTimestamp(created.longValue());
        }
        return details;
    }

    public ContentSyncResults persistSyncResults(Query inProgressQuery, ContentSyncResults results) {
        List inprogressList;
        try {
            inprogressList = inProgressQuery.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        boolean alreadyInProgress = false;
        if (inprogressList.size() > 0) {
            if (results.getStatus() == ContentSyncStatus.INPROGRESS && System.currentTimeMillis() - ((ContentSyncResults)inprogressList.get(0)).getStartTime() < 86400000L) {
                alreadyInProgress = true;
                inprogressList.remove(0);
            }
            for (ContentSyncResults inprogress : inprogressList) {
                inprogress.setStatus(ContentSyncStatus.FAILURE);
                inprogress.setEndTime(Long.valueOf(System.currentTimeMillis()));
                inprogress.setResults("This synchronization seems to have stalled or ended abnormally.");
            }
        }
        ContentSyncResults persistedResults = null;
        if (!alreadyInProgress) {
            this.entityManager.persist((Object)results);
            persistedResults = results;
        }
        return persistedResults;
    }

    public static PackageTypeBehavior getPackageTypeBehavior(int packageTypeId) throws Exception {
        AbstractPackageTypeBehavior<? extends ServerPluginComponent> ret = ContentManagerHelper.getPackageTypePluginContainer().getPluginManager().getBehavior(packageTypeId);
        return ret == null ? DEFAULT_PACKAGE_TYPE_BEHAVIOR : ret;
    }

    public static PackageTypeBehavior getPackageTypeBehavior(String packageTypeName) throws Exception {
        AbstractPackageTypeBehavior<? extends ServerPluginComponent> ret = ContentManagerHelper.getPackageTypePluginContainer().getPluginManager().getBehavior(packageTypeName);
        return ret == null ? DEFAULT_PACKAGE_TYPE_BEHAVIOR : ret;
    }

    private static class DefaultPackageTypeBehavior
    implements PackageTypeBehavior {
        private DefaultPackageTypeBehavior() {
        }

        @Override
        public Comparator<PackageVersion> getPackageVersionComparator(String packageTypeName) {
            return PackageVersion.DEFAULT_COMPARATOR;
        }

        @Override
        public void validateDetails(ValidatablePackageDetailsKey key, Subject origin) throws PackageDetailsValidationException {
        }

        @Override
        public PackageVersionFormatDescription getPackageVersionFormat(String packageTypeName) {
            return null;
        }
    }
}

