/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.naming;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.rhq.enterprise.server.naming.context.ContextDecorator;
import org.rhq.enterprise.server.naming.util.DecoratingInvocationHandler;
import org.rhq.enterprise.server.naming.util.DecoratorPicker;

public class DecoratingInitialContextFactory
implements InitialContextFactory {
    List<DecoratorPicker<Context, ContextDecorator>> pickers;
    private InitialContextFactory factory;
    private Set<Class<? extends Context>> supportedContextInterfaces;

    public DecoratingInitialContextFactory(InitialContextFactory factory, List<DecoratorPicker<Context, ContextDecorator>> decoratorPickers) {
        this.factory = factory;
        this.pickers = decoratorPickers;
        this.supportedContextInterfaces = new HashSet<Class<? extends Context>>();
        for (DecoratorPicker<Context, ContextDecorator> picker : this.pickers) {
            this.supportedContextInterfaces.addAll(picker.getContext().getSupportedInterfaces());
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        Context ctx = this.factory.getInitialContext(environment);
        Set<Class<?>> implementedIfaces = this.getAllImplementedInterfaces(ctx.getClass());
        Class[] ii = new Class[implementedIfaces.size()];
        implementedIfaces.toArray(ii);
        return (Context)Proxy.newProxyInstance(ctx.getClass().getClassLoader(), ii, new DecoratingInvocationHandler(this.pickers, ctx));
    }

    private Set<Class<?>> getAllImplementedInterfaces(Class<?> cls) {
        HashSet<Class<Class<? extends Context>>> ret = new HashSet<Class<Class<? extends Context>>>();
        DecoratingInitialContextFactory.getAllImplementedInterfaces(cls, ret);
        ret.retainAll(this.supportedContextInterfaces);
        return ret;
    }

    private static void getAllImplementedInterfaces(Class<?> cls, Set<Class<?>> output) {
        Class<?>[] ifaces = cls.getInterfaces();
        for (Class<?> iface : Arrays.asList(ifaces)) {
            output.add(iface);
            DecoratingInitialContextFactory.getAllImplementedInterfaces(iface, output);
        }
        if (cls.getSuperclass() != null) {
            DecoratingInitialContextFactory.getAllImplementedInterfaces(cls.getSuperclass(), output);
        }
    }

    public int hashCode() {
        return this.factory.hashCode();
    }

    public boolean equals(Object o) {
        return this.factory.equals(o);
    }
}

