/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rhq.enterprise.server.rest.reporting.CsvWriterException;
import org.rhq.enterprise.server.rest.reporting.DateConverter;
import org.rhq.enterprise.server.rest.reporting.PropertyConverter;
import org.rhq.enterprise.server.rest.reporting.ReportFormatHelper;
import org.rhq.enterprise.server.rest.reporting.SimpleConverter;

public class CsvWriter<T> {
    public final PropertyConverter<T> SIMPLE_CONVERTER = new SimpleConverter();
    public final PropertyConverter<T> DATE_CONVERTER = new DateConverter();
    private Map<String, PropertyConverter<T>> converters = new LinkedHashMap<String, PropertyConverter<T>>();

    public void setColumns(String ... columns) {
        for (String column : columns) {
            this.converters.put(column, this.SIMPLE_CONVERTER);
        }
    }

    public void setPropertyConverter(String propertyName, PropertyConverter<T> propertyConverter) {
        if (!this.converters.containsKey(propertyName)) {
            throw new CsvWriterException(propertyName + " is not a registered property name");
        }
        this.converters.put(propertyName, propertyConverter);
    }

    public void write(T object, OutputStream outputStream) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (String property : this.converters.keySet()) {
            PropertyConverter<T> converter = this.converters.get(property);
            Object value = converter.convert(object, property);
            if (value == null) {
                buffer.append(",");
                continue;
            }
            buffer.append(ReportFormatHelper.cleanForCSV(value.toString())).append(",");
        }
        buffer.delete(buffer.length() - 1, buffer.length()).append("\n");
        outputStream.write(buffer.toString().getBytes());
    }
}

