/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.DriftCriteria;
import org.rhq.core.domain.criteria.GenericDriftCriteria;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.domain.drift.DriftComposite;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ReportsInterceptor;
import org.rhq.enterprise.server.rest.reporting.CsvWriter;
import org.rhq.enterprise.server.rest.reporting.PropertyConverter;
import org.rhq.enterprise.server.rest.reporting.RecentDriftLocal;
import org.rhq.enterprise.server.rest.reporting.ReportFormatHelper;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

@Interceptors(value={ReportsInterceptor.class})
@Stateless
public class RecentDriftHandler
extends AbstractRestBean
implements RecentDriftLocal {
    private final Log log = LogFactory.getLog(RecentDriftHandler.class);
    @EJB
    private DriftManagerLocal driftManager;

    @Override
    public StreamingOutput recentDriftInternal(String categories, Integer snapshot, String path, String definitionName, Long startTime, Long endTime, HttpServletRequest request, Subject user) {
        this.caller = user;
        return this.recentDrift(categories, snapshot, path, definitionName, startTime, endTime, request);
    }

    @Override
    public StreamingOutput recentDrift(final String categories, final Integer snapshot, final String path, final String definitionName, final Long startTime, final Long endTime, final HttpServletRequest request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received request to generate report for " + this.caller));
        }
        return new StreamingOutput(){

            public void write(OutputStream stream) throws IOException, WebApplicationException {
                GenericDriftCriteria criteria = new GenericDriftCriteria();
                criteria.fetchChangeSet(true);
                criteria.addFilterChangeSetStartVersion(Integer.valueOf(1));
                if (startTime != null) {
                    criteria.addFilterStartTime(startTime);
                }
                if (endTime != null) {
                    criteria.addFilterEndTime(endTime);
                }
                if (startTime != null && endTime == null) {
                    Date today = new Date();
                    criteria.addFilterEndTime(Long.valueOf(today.getTime()));
                }
                if (snapshot != null) {
                    RecentDriftHandler.this.log.info((Object)("Drift Snapshot version Filter set for: " + snapshot));
                    criteria.addFilterChangeSetEndVersion(snapshot);
                }
                if (path != null) {
                    RecentDriftHandler.this.log.info((Object)("Drift Path Filter set for: " + path));
                    criteria.addFilterPath(path);
                }
                if (definitionName != null) {
                    RecentDriftHandler.this.log.info((Object)("Drift Definition Filter set for: " + definitionName));
                }
                criteria.addFilterCategories(this.getCategories());
                CriteriaQueryExecutor<DriftComposite, DriftCriteria> queryExecutor = new CriteriaQueryExecutor<DriftComposite, DriftCriteria>(){

                    @Override
                    public PageList<DriftComposite> execute(DriftCriteria criteria) {
                        return RecentDriftHandler.this.driftManager.findDriftCompositesByCriteria(RecentDriftHandler.this.caller, criteria);
                    }
                };
                CriteriaQuery<DriftComposite, DriftCriteria> query = new CriteriaQuery<DriftComposite, DriftCriteria>((DriftCriteria)criteria, queryExecutor);
                CsvWriter csvWriter = new CsvWriter();
                csvWriter.setColumns("drift.ctime", "driftDefinitionName", "drift.changeSet.version", "drift.category", "drift.path", "resource.name", "ancestry", "detailsURL");
                csvWriter.setPropertyConverter("drift.ctime", csvWriter.DATE_CONVERTER);
                csvWriter.setPropertyConverter("ancestry", new PropertyConverter<DriftComposite>(){

                    @Override
                    public Object convert(DriftComposite driftComposite, String propertyName) {
                        return ReportFormatHelper.parseAncestry(driftComposite.getResource().getAncestry());
                    }
                });
                csvWriter.setPropertyConverter("detailsURL", new PropertyConverter<DriftComposite>(){

                    @Override
                    public Object convert(DriftComposite driftComposite, String propertyName) {
                        return this.getDetailsURL(driftComposite);
                    }
                });
                stream.write((this.getHeader() + "\n").getBytes());
                if (definitionName != null) {
                    for (DriftComposite driftComposite : query) {
                        if (driftComposite.getDriftDefinitionName() == null || !driftComposite.getDriftDefinitionName().contains(definitionName)) continue;
                        csvWriter.write(driftComposite, stream);
                    }
                } else {
                    for (DriftComposite driftComposite : query) {
                        csvWriter.write(driftComposite, stream);
                    }
                }
            }

            private DriftCategory[] getCategories() {
                String[] categoryArray;
                ArrayList<DriftCategory> driftCategoryList = new ArrayList<DriftCategory>(10);
                for (String category : categoryArray = categories.split(",")) {
                    RecentDriftHandler.this.log.info((Object)("DriftCategories Filter set for: " + category));
                    driftCategoryList.add(DriftCategory.valueOf((String)category.toUpperCase()));
                }
                return driftCategoryList.toArray(new DriftCategory[driftCategoryList.size()]);
            }

            private String getHeader() {
                return "Creation Time,Definition,Snapshot,Category,Path,Resource,Ancestry,Details URL";
            }

            private String getDetailsURL(DriftComposite driftDetails) {
                String protocol = request.isSecure() ? "https" : "http";
                return protocol + "://" + request.getServerName() + ":" + request.getServerPort() + "/coregui/#Resource/" + driftDetails.getResource().getId() + "/Drift/Definitions/" + driftDetails.getDrift().getChangeSet().getDriftDefinitionId() + "/Drift/0id_" + driftDetails.getDrift().getId();
            }
        };
    }
}

