/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.text.DateFormat;
import java.util.Date;

public class ReportFormatHelper {
    private ReportFormatHelper() {
    }

    public static String cleanForCSV(String input) {
        if (input == null) {
            return " ";
        }
        return input.replace(',', ' ').replace('\n', ' ');
    }

    public static String formatDateTime(long epochMillis) {
        if (epochMillis != 0L) {
            Date date = new Date(epochMillis);
            return DateFormat.getDateTimeInstance(3, 1).format(date);
        }
        return " ";
    }

    public static String formatDate(long epochMillis) {
        if (epochMillis != 0L) {
            Date date = new Date(epochMillis);
            return DateFormat.getDateInstance(3).format(date);
        }
        return " ";
    }

    public static String parseAncestry(String ancestry) {
        if (null == ancestry) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] ancestryEntries = ancestry.split("_::_");
        for (int i = 0; i < ancestryEntries.length; ++i) {
            String[] entryTokens = ancestryEntries[i].split("_:_");
            String ancestorName = entryTokens[2];
            builder.append(i > 0 ? " < " : "");
            builder.append(ancestorName);
        }
        return builder.toString();
    }
}

