/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.scripting.ScriptSourceProvider;

public class FileSystemScriptSourceProvider
implements ScriptSourceProvider {
    private static final Log LOG = LogFactory.getLog(FileSystemScriptSourceProvider.class);
    private static final String DEFAULT_SCHEME = "file";
    private final String scheme;

    public FileSystemScriptSourceProvider() {
        this(DEFAULT_SCHEME);
    }

    public FileSystemScriptSourceProvider(String scheme) {
        this.scheme = scheme;
    }

    public Reader getScriptSource(URI location) {
        String scheme = location.getScheme();
        if (scheme == null || !this.scheme.equals(scheme)) {
            return null;
        }
        File f = this.getFile(location);
        try {
            if (f.exists() && f.isFile() && f.canRead()) {
                return new FileReader(f);
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)("File '" + f.getAbsolutePath() + "' seems to have disappeared while we were trying to open it."), (Throwable)e);
        }
        return null;
    }

    protected File getFile(URI location) {
        String path = location.getPath();
        return new File(path);
    }
}

