/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.provider.jffi.StubCompiler;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.NativeMethod;
import com.kenai.jffi.NativeMethods;
import com.kenai.jffi.PageManager;
import com.kenai.jnr.x86asm.Assembler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

abstract class AbstractX86StubCompiler
extends StubCompiler {
    static final Map<Class, PageHolder> pages = Collections.synchronizedMap(new WeakHashMap());
    final List<Stub> stubs = new LinkedList<Stub>();

    AbstractX86StubCompiler() {
    }

    /*
     * WARNING - void declaration
     */
    void attach(Class clazz) {
        void methods;
        long l;
        if (this.stubs.isEmpty()) {
            return;
        }
        long codeSize = 0L;
        for (Stub stub : this.stubs) {
            codeSize += (long)(stub.assembler.codeSize() + 8);
        }
        PageManager pm = PageManager.getInstance();
        long l2 = pm.allocatePages((int)(l = (codeSize + pm.pageSize() - 1L) / pm.pageSize()), 3);
        if (l2 == 0L) {
            throw new OutOfMemoryError("allocatePages failed for codeSize=" + codeSize);
        }
        PageHolder pageHolder = new PageHolder(l2, l);
        ArrayList<NativeMethod> arrayList = new ArrayList<NativeMethod>(this.stubs.size());
        long l3 = l2;
        for (Stub stub : this.stubs) {
            void buf;
            void asm;
            Assembler assembler = stub.assembler;
            l3 = AbstractX86StubCompiler.align(l3, 8L);
            ByteBuffer byteBuffer = MemoryIO.getInstance().newDirectByteBuffer(l3, assembler.codeSize()).order(ByteOrder.LITTLE_ENDIAN);
            asm.assembler.relocCode(byteBuffer, l3);
            arrayList.add(new NativeMethod(l3, asm.name, asm.signature));
            l3 += (long)buf.codeSize();
        }
        pm.protectPages(l2, (int)l, 5);
        NativeMethods.register(clazz, arrayList);
        pages.put(clazz, (PageHolder)methods);
    }

    static final int align(int offset, int align) {
        return align + (offset - 1 & ~(align - 1));
    }

    static final long align(long offset, long align) {
        return align + (offset - 1L & (align - 1L ^ 0xFFFFFFFFFFFFFFFFL));
    }

    final class PageHolder {
        final long memory;
        final long pageCount;

        public PageHolder(long memory, long pageCount) {
            this.memory = memory;
            this.pageCount = pageCount;
        }

        protected void finalize() throws Throwable {
            PageManager.getInstance().freePages(this.memory, (int)this.pageCount);
        }
    }

    final class Stub {
        final String name;
        final String signature;
        final Assembler assembler;

        public Stub(String name, String signature, Assembler assembler) {
            this.name = name;
            this.signature = signature;
            this.assembler = assembler;
        }
    }
}

