/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.script;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.script.BaseRhqSchemeScriptSourceProvider;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.composite.PackageAndLatestVersionComposite;
import org.rhq.core.domain.criteria.PackageCriteria;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.content.RepoManagerRemote;

public class RepoScriptSourceProvider
extends BaseRhqSchemeScriptSourceProvider
implements StandardBindings.RhqFacadeChangeListener {
    private static final Log LOG = LogFactory.getLog(RepoScriptSourceProvider.class);
    private static final String AUTHORITY = "repositories";
    private RhqFacade rhqFacade;

    public RepoScriptSourceProvider() {
        super(AUTHORITY);
    }

    @Override
    public void rhqFacadeChanged(StandardBindings bindings) {
        this.rhqFacade = bindings.getAssociatedRhqFacade();
    }

    @Override
    protected Reader doGetScriptSource(URI scriptUri) {
        if (this.rhqFacade == null) {
            return null;
        }
        String path = scriptUri.getPath().substring(1);
        int slashIdx = path.indexOf(47);
        if (slashIdx == -1) {
            return null;
        }
        String repoName = path.substring(0, slashIdx);
        String scriptName = path.substring(slashIdx + 1);
        try {
            RepoManagerRemote repoManager = this.rhqFacade.getProxy(RepoManagerRemote.class);
            RepoCriteria repoCrit = new RepoCriteria();
            repoCrit.addFilterName(repoName);
            PageList repos = repoManager.findReposByCriteria(this.rhqFacade.getSubject(), repoCrit);
            if (repos.isEmpty()) {
                return null;
            }
            ContentManagerRemote contentManager = this.rhqFacade.getProxy(ContentManagerRemote.class);
            for (Repo repo : repos) {
                PackageCriteria pCrit = new PackageCriteria();
                pCrit.addFilterName(scriptName);
                pCrit.addFilterRepoId(Integer.valueOf(repo.getId()));
                PageList pvs = contentManager.findPackagesWithLatestVersion(this.rhqFacade.getSubject(), pCrit);
                if (pvs.isEmpty()) continue;
                PackageAndLatestVersionComposite pv = (PackageAndLatestVersionComposite)pvs.get(0);
                byte[] bytes = repoManager.getPackageVersionBytes(this.rhqFacade.getSubject(), repo.getId(), pv.getLatestPackageVersion().getId());
                return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charset.forName("UTF-8"));
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to download bytes for the script: " + scriptUri.toString()), (Throwable)e);
        }
        return null;
    }
}

