/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.commands;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.jws.WebParam;
import org.rhq.bindings.client.RhqManager;
import org.rhq.bindings.output.TabularWriter;
import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.client.utility.ReflectionUtility;

public class HelpCommand
implements ClientCommand {
    @Override
    public String getPromptCommandString() {
        return "help";
    }

    @Override
    public boolean execute(ClientMain client, String[] args) {
        Map<String, ClientCommand> commands = client.getCommands();
        if (args.length == 1) {
            String[][] data = new String[commands.size()][2];
            int i = 0;
            ArrayList<String> cmds = new ArrayList<String>(commands.keySet());
            Collections.sort(cmds);
            for (String name : cmds) {
                ClientCommand command = commands.get(name);
                data[i][0] = name;
                data[i++][1] = command.getHelp();
            }
            TabularWriter tw = new TabularWriter(client.getPrintWriter(), new String[]{"Command", "Description"});
            tw.setWidth(client.getConsoleWidth());
            tw.setHideRowCount(true);
            tw.print(data);
        } else if ("api".equals(args[1])) {
            Map services = client.getRemoteClient().getScriptingAPI();
            if (args.length == 2) {
                TabularWriter tw = new TabularWriter(client.getPrintWriter(), new String[]{"API", "Package"});
                tw.setWidth(client.getConsoleWidth());
                String[][] data = new String[services.size()][2];
                int i = 0;
                for (RhqManager api : services.keySet()) {
                    data[i][0] = api.name();
                    Object service = services.get(api);
                    data[i][1] = service.getClass().getInterfaces()[0].getPackage().getName();
                    ++i;
                }
                tw.print(data);
            } else if (args.length == 3) {
                Object service = services.get(args[2]);
                if (service != null) {
                    Class<?> intf = service.getClass().getInterfaces()[0];
                    Method[] methods = intf.getMethods();
                    Arrays.sort(methods, new Comparator<Method>(){

                        @Override
                        public int compare(Method o1, Method o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    String[][] data = new String[methods.length][2];
                    for (int i = 0; i < methods.length; ++i) {
                        Type returnType = methods[i].getGenericReturnType();
                        data[i][0] = ReflectionUtility.getSimpleTypeString(returnType);
                        Class<?>[] paramTypes = methods[i].getParameterTypes();
                        StringBuilder buf = new StringBuilder();
                        buf.append(methods[i].getName());
                        buf.append("(");
                        Annotation[][] annotations = methods[i].getParameterAnnotations();
                        boolean secondary = false;
                        for (int j = 0; j < paramTypes.length; ++j) {
                            String typeName = paramTypes[j].getSimpleName();
                            if (annotations != null && annotations.length >= i) {
                                Annotation[] as;
                                for (Annotation a : as = annotations[j]) {
                                    if (!(a instanceof WebParam)) continue;
                                    typeName = typeName + " " + ((WebParam)a).name();
                                }
                            }
                            if (secondary) {
                                buf.append(", ");
                            }
                            secondary = true;
                            buf.append(typeName);
                        }
                        buf.append(")");
                        data[i][1] = buf.toString();
                    }
                    TabularWriter tw = new TabularWriter(client.getPrintWriter(), new String[]{"Returns", "Signature"});
                    tw.setWidth(client.getConsoleWidth());
                    tw.print(data);
                } else {
                    client.getPrintWriter().println("Unknown service [" + args[2] + "] - try 'help api' for a listing of services");
                }
            }
        } else {
            String commandName = args[1];
            ClientCommand command = commands.get(commandName);
            if (command == null) {
                client.getPrintWriter().println(this.getPromptCommandString() + ": Unknown command: " + commandName);
            } else {
                client.getPrintWriter().println("Usage: " + command.getSyntax());
                client.getPrintWriter().println(command.getDetailedHelp());
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return this.getPromptCommandString() + " [command] | [api [service]]";
    }

    @Override
    public String getHelp() {
        return "Display help on CLI commands or services";
    }

    @Override
    public String getDetailedHelp() {
        return "Use \"help [command]\" to get detailed help for a command\n\"help api\" will return the list of service APIs available for script execs\n\"help api [service]\" will list the methods provided by the specified service API";
    }
}

