/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.commands;

import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.ClientMain;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.client.script.CommandLineParseException;
import org.rhq.enterprise.clientapi.RemoteClient;

public class LoginCommand
implements ClientCommand {
    private final Log log = LogFactory.getLog(LoginCommand.class);
    private String subsystem = null;

    @Override
    public String getPromptCommandString() {
        return "login";
    }

    @Override
    public boolean execute(ClientMain client, String[] args) {
        if (args.length < 3) {
            throw new CommandLineParseException("Too few arguments");
        }
        if (args.length > 7) {
            throw new CommandLineParseException("Too many arguments");
        }
        String user = args[1];
        String pass = args[2];
        String host = "localhost";
        String transport = null;
        int port = 7080;
        PrintWriter printWriter = client.getPrintWriter();
        try {
            if (args.length == 5) {
                host = args[3];
                port = Integer.parseInt(args[4]);
            } else if (args.length == 6) {
                host = args[3];
                port = Integer.parseInt(args[4]);
                transport = args[5];
            } else if (args.length == 7) {
                host = args[3];
                port = Integer.parseInt(args[4]);
                transport = args[5];
                this.subsystem = args[6];
            }
            this.execute(client, user, pass, host, port, transport);
            printWriter.println("Login successful");
        }
        catch (Exception e) {
            printWriter.println("Login failed: " + e.getMessage());
            printWriter.println(this.usage());
            this.log.debug((Object)("Login failed for " + user + " on " + host + ":" + port + " over transport: " + transport), (Throwable)e);
        }
        return true;
    }

    public Subject execute(ClientMain client, String username, String password) throws Exception {
        return this.execute(client, username, password, "localhost", 7080, null);
    }

    public Subject execute(ClientMain client, String username, String password, String host, int port, String transport) throws Exception {
        RemoteClient remoteClient = null;
        remoteClient = this.subsystem != null && this.subsystem.trim().equalsIgnoreCase("WSREMOTEAPI") ? new RemoteClient(transport, host, port, this.subsystem) : new RemoteClient(transport, host, port);
        client.setTransport(remoteClient.getTransport());
        client.setHost(host);
        client.setPort(port);
        client.setUser(username);
        client.setPass(password);
        Subject subject = remoteClient.login(username, password);
        String version = remoteClient.getServerVersion() + " (" + remoteClient.getServerBuildNumber() + ")";
        client.getPrintWriter().println("Remote server version is: " + version);
        client.setRemoteClient(remoteClient);
        client.setSubject(subject);
        return subject;
    }

    private String usage() {
        return "Usage: " + this.getSyntax();
    }

    @Override
    public String getSyntax() {
        return this.getPromptCommandString() + " username password [host port [transport]]";
    }

    @Override
    public String getHelp() {
        return "Log into a server with specified username and password";
    }

    @Override
    public String getDetailedHelp() {
        return "Log into a server with the specified username and password. The server host name and port may optionally be specified. The host name defaults to localhost and the port to 7080. You may also specify the transport to use when communicating with the server; it must be one of 'servlet' or 'sslservlet'.";
    }
}

