/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLException;
import org.jboss.logging.Logger;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.ServerSocketWrapper;
import org.jboss.remoting.transport.socket.ServerThread;
import org.jboss.remoting.transport.socket.SocketServerInvokerMBean;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.remoting.util.TimerUtil;
import org.jboss.util.propertyeditor.PropertyEditors;

public class SocketServerInvoker
extends ServerInvoker
implements SocketServerInvokerMBean {
    private static final Logger log = Logger.getLogger((Class)SocketServerInvoker.class);
    private static boolean trace = log.isTraceEnabled();
    static int clientCount = 0;
    protected Properties props = new Properties();
    private static int BACKLOG_DEFAULT = 200;
    protected static int MAX_POOL_SIZE_DEFAULT = 300;
    public static final String CHECK_CONNECTION_KEY = "socket.check_connection";
    public static final String SERVER_SOCKET_CLASS_FLAG = "serverSocketClass";
    protected String serverSocketClass = ServerSocketWrapper.class.getName();
    protected List serverSockets = new ArrayList();
    protected boolean running = false;
    protected int backlog = BACKLOG_DEFAULT;
    protected AcceptThread[] acceptThreads;
    protected int numAcceptThreads = 1;
    protected int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected boolean immediateShutdown;
    protected int acceptThreadPriorityIncrement = 0;
    protected ServerSocketRefresh refreshThread;
    protected boolean newServerSocketFactory = false;
    protected Object serverSocketFactoryLock = new Object();
    protected boolean reuseAddress = true;
    protected int receiveBufferSize = -1;
    protected boolean keepAlive;
    protected boolean keepAliveSet;
    protected boolean oOBInline;
    protected boolean oOBInlineSet;
    protected int sendBufferSize = -1;
    protected boolean soLinger;
    protected boolean soLingerSet;
    protected int soLingerDuration = -1;
    protected int trafficClass = -1;
    protected int idleTimeout = -1;
    protected IdleTimerTask idleTimerTask = null;
    protected int writeTimeout = -1;

    public SocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public SocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        log.trace((Object)"entering setNewServerSocketFactory()");
        Object object = this.serverSocketFactoryLock;
        synchronized (object) {
            this.newServerSocketFactory = true;
            this.setServerSocketFactory(serverSocketFactory);
            this.serverSocketFactoryLock.notify();
            log.info((Object)"ServerSocketFactory has been updated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshServerSocket() throws IOException {
        log.trace((Object)"entering refreshServerSocket()");
        Object object = this.serverSocketFactoryLock;
        synchronized (object) {
            for (int i = 0; i < this.acceptThreads.length; ++i) {
                this.newServerSocketFactory = false;
                ServerSocket oldServerSocket = this.acceptThreads[i].getServerSocket();
                InetAddress address = oldServerSocket.getInetAddress();
                int port = oldServerSocket.getLocalPort();
                oldServerSocket.close();
                ServerSocket newServerSocket = null;
                for (int j = 0; j < 5; ++j) {
                    try {
                        newServerSocket = this.createServerSocket(port, this.backlog, address);
                        break;
                    }
                    catch (Exception e) {
                        if (j < 4) {
                            log.warn((Object)"Unable to recreate ServerSocket: will try again in 65 seconds", (Throwable)e);
                            try {
                                Thread.sleep(65000L);
                            }
                            catch (InterruptedException ignored) {}
                            continue;
                        }
                        log.error((Object)"Unable to recreate ServerSocket after 260 seconds", (Throwable)e);
                        return;
                    }
                }
                this.acceptThreads[i].setServerSocket(newServerSocket);
                log.info((Object)(this.acceptThreads[i] + " has been updated with new ServerSocket"));
            }
        }
        log.trace((Object)"leaving refreshServerSocket()");
    }

    protected void setup() throws Exception {
        this.props.putAll((Map<?, ?>)this.getConfiguration());
        SocketServerInvoker.mapJavaBeanProperties(this, this.props, false);
        super.setup();
        String ssclass = this.props.getProperty(SERVER_SOCKET_CLASS_FLAG);
        if (ssclass != null) {
            this.serverSocketClass = ssclass;
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public synchronized void start() throws IOException {
        if (!this.running) {
            log.debug((Object)(this + " starting"));
            if (this.maxPoolSize <= 0) {
                this.maxPoolSize = MAX_POOL_SIZE_DEFAULT;
            }
            this.clientpool = new LRUPool(2, this.maxPoolSize);
            this.clientpool.create();
            this.threadpool = new LinkedList();
            this.createServerSockets();
            this.refreshThread = new ServerSocketRefresh();
            this.refreshThread.setDaemon(true);
            this.refreshThread.start();
            this.acceptThreads = new AcceptThread[this.numAcceptThreads * this.getHomes().size()];
            int i = 0;
            Iterator it = this.serverSockets.iterator();
            while (it.hasNext()) {
                ServerSocket ss = (ServerSocket)it.next();
                for (int j = 0; j < this.numAcceptThreads; ++j) {
                    this.acceptThreads[i] = new AcceptThread(ss, this.refreshThread);
                    this.acceptThreads[i].setPriority(5 + this.acceptThreadPriorityIncrement);
                    if (trace) {
                        log.trace((Object)(this + " created and registered " + this.acceptThreads[i] + " with priority " + this.acceptThreads[i].getPriority()));
                    }
                    ++i;
                }
            }
        }
        try {
            super.start();
        }
        catch (IOException e) {
            log.error((Object)"Error starting SocketServerInvoker.", (Throwable)e);
            this.cleanup();
        }
        if (!this.running) {
            this.running = true;
            for (int i = 0; i < this.acceptThreads.length; ++i) {
                this.acceptThreads[i].start();
            }
        }
        if (this.idleTimeout > 0) {
            if (this.idleTimerTask != null) {
                this.idleTimerTask.cancel();
            }
            this.idleTimerTask = new IdleTimerTask();
            TimerUtil.schedule(this.idleTimerTask, this.idleTimeout * 1000);
        } else if (this.idleTimerTask != null) {
            this.idleTimerTask.cancel();
        }
        log.debug((Object)(this + " started"));
    }

    protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException {
        ServerSocketFactory factory = this.getServerSocketFactory();
        ServerSocket ss = null;
        try {
            ss = factory.createServerSocket();
        }
        catch (SocketException e) {
            if (this.getReuseAddress()) {
                log.warn((Object)"Unable to create unbound ServerSocket: cannot set reuseAddress to true", (Throwable)e);
            }
            ss = factory.createServerSocket(serverBindPort, backlog, bindAddress);
            this.configureServerSocket(ss);
            return ss;
        }
        ss.setReuseAddress(this.getReuseAddress());
        this.configureServerSocket(ss);
        InetSocketAddress address = new InetSocketAddress(bindAddress, serverBindPort);
        SocketServerInvoker.bind(ss, address, backlog);
        return ss;
    }

    protected void createServerSockets() throws IOException {
        ServerSocketFactory factory = this.getServerSocketFactory();
        Iterator it = this.getHomes().iterator();
        while (it.hasNext()) {
            Home home = (Home)it.next();
            InetAddress inetAddress = SocketServerInvoker.getAddressByName(home.host);
            ServerSocket ss = null;
            try {
                ss = factory.createServerSocket();
                ss.setReuseAddress(this.getReuseAddress());
                this.configureServerSocket(ss);
                InetSocketAddress address = new InetSocketAddress(inetAddress, home.port);
                SocketServerInvoker.bind(ss, address, this.backlog);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + " created " + ss));
                }
            }
            catch (SocketException e) {
                if (this.getReuseAddress()) {
                    log.warn((Object)"Unable to create unbound ServerSocket: cannot set reuseAddress to true");
                }
                try {
                    ss = factory.createServerSocket(home.port, this.backlog, inetAddress);
                    this.configureServerSocket(ss);
                }
                catch (IOException e2) {
                    String m = this + " error creating ServerSocket[" + home + "]: " + e2.getMessage();
                    IOException e3 = new IOException(m);
                    log.debug((Object)m, (Throwable)e3);
                    throw e3;
                }
            }
            catch (IOException e) {
                String m = this + " error creating ServerSocket[" + home + "]: " + e.getMessage();
                IOException e2 = new IOException(m);
                log.debug((Object)m, (Throwable)e2);
                throw e2;
            }
            this.serverSockets.add(ss);
        }
    }

    protected void configureServerSocket(ServerSocket ss) throws SocketException {
        if (this.receiveBufferSize != -1) {
            ss.setReceiveBufferSize(this.receiveBufferSize);
        }
    }

    protected String getThreadName(int i) {
        return "AcceptorThread#" + i + ":" + this.getServerBindPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.clientpool != null) {
            LRUPool lRUPool = this.clientpool;
            synchronized (lRUPool) {
                this.clientpool.destroy();
            }
        }
        super.destroy();
    }

    public synchronized void stop() {
        if (this.running) {
            this.cleanup();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        this.running = false;
        if (this.acceptThreads != null) {
            for (int i = 0; i < this.acceptThreads.length; ++i) {
                this.acceptThreads[i].shutdown();
            }
        }
        if (this.refreshThread != null) {
            this.refreshThread.shutdown();
        }
        if (this.idleTimerTask != null) {
            this.idleTimerTask.cancel();
        }
        this.maxPoolSize = 0;
        if (this.clientpool != null) {
            LRUPool lRUPool = this.clientpool;
            synchronized (lRUPool) {
                Set svrThreads = this.clientpool.getContents();
                Iterator itr = svrThreads.iterator();
                while (itr.hasNext()) {
                    Object o = itr.next();
                    ServerThread st = (ServerThread)o;
                    if (this.immediateShutdown) {
                        st.shutdownImmediately();
                        continue;
                    }
                    st.shutdown();
                }
                this.clientpool.flush();
                this.clientpool.stop();
                log.debug((Object)(this + " stopped threads in clientpool"));
                if (this.threadpool != null) {
                    int threadsToShutdown = this.threadpool.size();
                    for (int i = 0; i < threadsToShutdown; ++i) {
                        ServerThread thread = (ServerThread)this.threadpool.removeFirst();
                        if (this.immediateShutdown) {
                            thread.shutdownImmediately();
                            continue;
                        }
                        thread.shutdown();
                    }
                    log.debug((Object)(this + " stopped threads in threadpool"));
                }
            }
        }
        log.debug((Object)(this + " exiting"));
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuse) {
        this.reuseAddress = reuse;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        this.keepAliveSet = true;
    }

    public boolean isOOBInline() {
        return this.oOBInline;
    }

    public void setOOBInline(boolean inline) {
        this.oOBInline = inline;
        this.oOBInlineSet = true;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isSoLinger() {
        return this.soLinger;
    }

    public int getSoLingerDuration() {
        return this.soLingerDuration;
    }

    public void setSoLinger(boolean soLinger) {
        this.soLinger = soLinger;
        this.soLingerSet = true;
    }

    public void setSoLingerDuration(int soLingerDuration) {
        this.soLingerDuration = soLingerDuration;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public int getCurrentThreadPoolSize() {
        return this.threadpool.size();
    }

    public int getCurrentClientPoolSize() {
        return this.clientpool.size();
    }

    public int getNumAcceptThreads() {
        return this.numAcceptThreads;
    }

    public void setNumAcceptThreads(int size) {
        this.numAcceptThreads = size;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog < 0 ? BACKLOG_DEFAULT : backlog;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        if (this.isStarted()) {
            if (idleTimeout > 0) {
                if (this.idleTimerTask != null) {
                    this.idleTimerTask.cancel();
                }
                this.idleTimerTask = new IdleTimerTask();
                TimerUtil.schedule(this.idleTimerTask, idleTimeout * 1000);
            } else if (this.idleTimerTask != null) {
                this.idleTimerTask.cancel();
            }
        }
    }

    public boolean isImmediateShutdown() {
        return this.immediateShutdown;
    }

    public void setImmediateShutdown(boolean immediateShutdown) {
        this.immediateShutdown = immediateShutdown;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public int getAcceptThreadPriorityIncrement() {
        return this.acceptThreadPriorityIncrement;
    }

    public void setAcceptThreadPriorityIncrement(int acceptThreadPriorityIncrement) {
        int resultingPriority = 5 + acceptThreadPriorityIncrement;
        if (resultingPriority < 1 || resultingPriority > 10) {
            log.warn((Object)(this + " resulting priority out of range: " + resultingPriority));
        } else {
            this.acceptThreadPriorityIncrement = acceptThreadPriorityIncrement;
        }
    }

    protected void configureSocket(Socket s) throws SocketException {
        s.setReuseAddress(this.getReuseAddress());
        if (this.keepAliveSet) {
            s.setKeepAlive(this.keepAlive);
        }
        if (this.oOBInlineSet) {
            s.setOOBInline(this.oOBInline);
        }
        if (this.receiveBufferSize > -1) {
            s.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize > -1) {
            s.setSendBufferSize(this.sendBufferSize);
        }
        if (this.soLingerSet && this.soLingerDuration > 0) {
            s.setSoLinger(this.soLinger, this.soLingerDuration);
        }
        if (this.trafficClass > -1) {
            s.setTrafficClass(this.trafficClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInvocation(Socket socket) throws Exception {
        ServerThread worker = null;
        boolean newThread = false;
        LRUPool lRUPool = this.clientpool;
        synchronized (lRUPool) {
            while (worker == null && this.running) {
                if (trace) {
                    log.trace((Object)(this + " trying to get a worker thread from threadpool for processing"));
                }
                if (this.threadpool.size() > 0) {
                    worker = (ServerThread)this.threadpool.removeLast();
                    if (trace) {
                        log.trace((Object)(this + (worker == null ? " found NO threads in threadpool" : " got " + worker + " from threadpool")));
                    }
                } else if (trace) {
                    log.trace((Object)(this + " has an empty threadpool"));
                }
                if (worker != null) continue;
                if (this.clientpool.size() < this.maxPoolSize) {
                    if (trace) {
                        log.trace((Object)(this + " creating new worker thread"));
                    }
                    worker = new ServerThread(socket, this, this.clientpool, this.threadpool, this.getTimeout(), this.writeTimeout, this.serverSocketClass);
                    worker.setPriority(5);
                    if (trace) {
                        log.trace((Object)(this + " created " + worker + " with priority " + worker.getPriority()));
                    }
                    newThread = true;
                }
                if (worker != null) continue;
                if (trace) {
                    log.trace((Object)(this + " trying to evict a thread from clientpool"));
                }
                this.clientpool.evict();
                ((Object)((Object)this.clientpool)).wait(1000L);
                if (!trace) continue;
                log.trace((Object)(this + " notified of clientpool thread availability"));
            }
            if (!this.running) {
                return;
            }
            this.clientpool.insert(worker, worker);
        }
        if (newThread) {
            if (trace) {
                log.trace((Object)(this + " starting " + worker));
            }
            worker.start();
        } else {
            if (trace) {
                log.trace((Object)(this + " reusing " + worker));
            }
            worker.wakeup(socket, this.getTimeout(), this);
        }
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    public String toString() {
        return "SocketServerInvoker[" + this.locator.getHomes() + "]";
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    private static void mapJavaBeanProperties(final Object o, final Properties props, final boolean isStrict) throws IntrospectionException {
        if (SecurityUtility.skipAccessControl()) {
            PropertyEditors.mapJavaBeanProperties((Object)o, (Properties)props, (boolean)isStrict);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IntrospectionException {
                    PropertyEditors.mapJavaBeanProperties((Object)o, (Properties)props, (boolean)isStrict);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IntrospectionException)e.getCause();
        }
    }

    private static Socket accept(final ServerSocket ss) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            return ss.accept();
        }
        try {
            return (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ss.accept();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static void bind(final ServerSocket ss, final SocketAddress address, final int backlog) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            ss.bind(address, backlog);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ss.bind(address, backlog);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static InetAddress getAddressByName(final String host) throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return InetAddress.getByName(host);
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    public class AcceptThread
    extends Thread {
        ServerSocket serverSocket;
        ServerSocketRefresh refreshThread;

        public AcceptThread(ServerSocket serverSocket, ServerSocketRefresh refreshThread) {
            this.serverSocket = serverSocket;
            this.refreshThread = refreshThread;
            this.setName("AcceptorThread[" + serverSocket + "]");
            if (trace) {
                log.trace((Object)(SocketServerInvoker.this + " created " + this));
            }
        }

        public void run() {
            if (trace) {
                log.trace((Object)(this + " started execution of method run()"));
            }
            while (SocketServerInvoker.this.running) {
                try {
                    this.refreshThread.release();
                    if (trace) {
                        log.trace((Object)(this + " is going to wait on serverSocket.accept()"));
                    }
                    Socket socket = SocketServerInvoker.accept(this.serverSocket);
                    if (trace) {
                        log.trace((Object)(this + " accepted " + socket));
                    }
                    SocketServerInvoker.this.configureSocket(socket);
                    SocketServerInvoker.this.processInvocation(socket);
                }
                catch (SSLException e) {
                    log.error((Object)"SSLServerSocket error", (Throwable)e);
                    return;
                }
                catch (ServerInvoker.InvalidStateException e) {
                    log.error((Object)"Cannot proceed without functioning server socket.  Shutting down", (Throwable)e);
                    return;
                }
                catch (Throwable ex) {
                    if (SocketServerInvoker.this.running) {
                        log.error((Object)(this + " failed to handle socket"), ex);
                        continue;
                    }
                    log.trace((Object)(this + " caught exception in run()"), ex);
                }
            }
        }

        public void shutdown() {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                log.debug((Object)(this + " error closing " + this.serverSocket), (Throwable)e);
            }
        }

        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }

        public void setServerSocket(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }
    }

    public class IdleTimerTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object[] svrThreadArray = null;
            HashSet<ServerThread> threadsToShutdown = new HashSet<ServerThread>();
            LRUPool lRUPool = SocketServerInvoker.this.clientpool;
            synchronized (lRUPool) {
                long idleTimeout;
                long idleTime;
                ServerThread svrThread;
                int x;
                long currentTime;
                Set svrThreads = SocketServerInvoker.this.clientpool.getContents();
                svrThreadArray = svrThreads.toArray();
                if (trace && svrThreadArray != null) {
                    log.trace((Object)("Idle timer task fired.  Number of ServerThreads = " + svrThreadArray.length));
                }
                if (svrThreadArray != null) {
                    currentTime = System.currentTimeMillis();
                    for (x = 0; x < svrThreadArray.length; ++x) {
                        svrThread = (ServerThread)svrThreadArray[x];
                        idleTime = currentTime - svrThread.getLastRequestTimestamp();
                        if (trace) {
                            log.trace((Object)("Idle time for ServerThread (" + svrThread + ") is " + idleTime));
                        }
                        if (idleTime <= (idleTimeout = (long)(SocketServerInvoker.this.getIdleTimeout() * 1000))) continue;
                        if (trace) {
                            log.trace((Object)("Idle timeout reached for ServerThread (" + svrThread + ") and will be evicted."));
                        }
                        SocketServerInvoker.this.clientpool.remove(svrThread);
                        threadsToShutdown.add(svrThread);
                    }
                }
                svrThreadArray = null;
                if (SocketServerInvoker.this.threadpool.size() > 0) {
                    svrThreadArray = SocketServerInvoker.this.threadpool.toArray();
                }
                if (trace && svrThreadArray != null) {
                    log.trace((Object)("Number of ServerThread in thead pool = " + svrThreadArray.length));
                }
                if (svrThreadArray != null) {
                    currentTime = System.currentTimeMillis();
                    for (x = 0; x < svrThreadArray.length; ++x) {
                        svrThread = (ServerThread)svrThreadArray[x];
                        idleTime = currentTime - svrThread.getLastRequestTimestamp();
                        if (trace) {
                            log.trace((Object)("Idle time for ServerThread (" + svrThread + ") is " + idleTime));
                        }
                        if (idleTime <= (idleTimeout = (long)(SocketServerInvoker.this.getIdleTimeout() * 1000))) continue;
                        if (trace) {
                            log.trace((Object)("Idle timeout reached for ServerThread (" + svrThread + ") and will be removed from thread pool."));
                        }
                        SocketServerInvoker.this.threadpool.remove(svrThread);
                        threadsToShutdown.add(svrThread);
                    }
                }
            }
            Iterator it = threadsToShutdown.iterator();
            while (it.hasNext()) {
                ServerThread svrThread = (ServerThread)it.next();
                svrThread.shutdown();
            }
        }
    }

    public class ServerSocketRefresh
    extends Thread {
        private boolean running;

        public ServerSocketRefresh() {
            super("ServerSocketRefresh");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                Object object = SocketServerInvoker.this.serverSocketFactoryLock;
                synchronized (object) {
                    if (SocketServerInvoker.this.newServerSocketFactory) {
                        log.debug((Object)"got notice about new ServerSocketFactory");
                        try {
                            log.debug((Object)"refreshing server socket");
                            SocketServerInvoker.this.refreshServerSocket();
                            log.debug((Object)"server socket refreshed");
                        }
                        catch (IOException e) {
                            log.error((Object)"could not refresh server socket", (Throwable)e);
                        }
                    }
                    try {
                        SocketServerInvoker.this.serverSocketFactoryLock.wait();
                        log.trace((Object)"ServerSocketRefresh thread woke up");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            log.debug((Object)"ServerSocketRefresh shutting down");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() throws ServerInvoker.InvalidStateException {
            Object object = SocketServerInvoker.this.serverSocketFactoryLock;
            synchronized (object) {
                log.trace((Object)"passed through ServerSocketRefresh.release()");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.running = false;
            Object object = SocketServerInvoker.this.serverSocketFactoryLock;
            synchronized (object) {
                SocketServerInvoker.this.serverSocketFactoryLock.notify();
            }
        }
    }
}

