/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.MultiCompletor;
import jline.SimpleCompletor;
import mazz.i18n.Msg;
import org.rhq.bindings.ScriptEngineFactory;
import org.rhq.bindings.util.PackageFinder;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.ClientI18NFactory;
import org.rhq.enterprise.client.NoOpRecorder;
import org.rhq.enterprise.client.Recorder;
import org.rhq.enterprise.client.Version;
import org.rhq.enterprise.client.commands.ClientCommand;
import org.rhq.enterprise.client.commands.ScriptCommand;
import org.rhq.enterprise.client.script.CommandLineParseException;
import org.rhq.enterprise.client.utility.CLIMetadataProvider;
import org.rhq.enterprise.client.utility.CodeCompletionCompletorWrapper;
import org.rhq.enterprise.client.utility.DummyCodeCompletion;
import org.rhq.enterprise.clientapi.RemoteClient;
import org.rhq.scripting.CodeCompletion;
import org.rhq.scripting.MetadataProvider;
import org.rhq.scripting.ScriptEngineInitializer;

public class ClientMain {
    private static final Msg MSG = ClientI18NFactory.getMsg();
    private static Map<String, ClientCommand> commands = new HashMap<String, ClientCommand>();
    public static final int DEFAULT_CONSOLE_WIDTH = 80;
    private Thread inputLoopThread;
    private ConsoleReader consoleReader;
    private boolean stdinInput = true;
    private PrintWriter outputWriter;
    private String transport = null;
    private String host = null;
    private int port = 7080;
    private String user;
    private String pass;
    private String language;
    private ArrayList<String> notes = new ArrayList();
    private RemoteClient remoteClient;
    private Subject subject;
    private CodeCompletion codeCompletion;
    private boolean interactiveMode = true;
    private Recorder recorder = new NoOpRecorder();
    private ScriptEngine engine;
    private ScriptEngineInitializer scriptEngineInitializer;

    public static void main(String[] args) throws Exception {
        ClientMain.initCommands();
        ClientMain main = new ClientMain();
        StartupConfiguration config = main.processArguments(args);
        main.initialize();
        config.process();
        if (main.isInteractiveMode()) {
            main.inputLoop();
        }
    }

    private static void initCommands() {
        for (Class<ClientCommand> commandClass : ClientCommand.COMMANDS) {
            try {
                ClientCommand command = commandClass.newInstance();
                commands.put(command.getPromptCommandString(), command);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void initScriptCommand() {
        ScriptCommand sc = (ScriptCommand)commands.get("exec");
        sc.initClient(this);
    }

    private void initCodeCompletion() {
        this.codeCompletion.setScriptContext(this.getScriptEngine().getContext());
        this.codeCompletion.setMetadataProvider((MetadataProvider)new CLIMetadataProvider());
    }

    public ClientMain() {
        this.outputWriter = new PrintWriter(System.out, true);
    }

    private void initialize() throws IOException {
        this.outputWriter = new PrintWriter(System.out, true);
        this.initScriptCommand();
        if (this.isInteractiveMode()) {
            this.consoleReader = new ConsoleReader();
            SimpleCompletor commandCompletor = new SimpleCompletor(commands.keySet().toArray(new String[commands.size()]));
            ArgumentCompletor helpCompletor = new ArgumentCompletor(new Completor[]{new SimpleCompletor("help"), new SimpleCompletor(commands.keySet().toArray(new String[commands.size()]))});
            this.codeCompletion = ScriptEngineFactory.getCodeCompletion((String)this.getLanguage());
            if (this.codeCompletion == null) {
                this.codeCompletion = new DummyCodeCompletion();
            }
            this.initCodeCompletion();
            this.consoleReader.addCompletor((Completor)new MultiCompletor(new Completor[]{new CodeCompletionCompletorWrapper(this.codeCompletion, this.outputWriter, this.consoleReader), helpCompletor, commandCompletor}));
            this.consoleReader.setUsePagination(true);
        }
    }

    public String getUserInput(String prompt) {
        String input_string = "";
        while (input_string != null && input_string.trim().length() == 0) {
            if (prompt == null) {
                if (!this.loggedIn()) {
                    prompt = "unconnected$ ";
                } else {
                    String loggedInUser = "";
                    if (this.getSubject() != null && this.getSubject().getName() != null) {
                        loggedInUser = this.getSubject().getName();
                    }
                    prompt = loggedInUser.trim().length() > 0 ? loggedInUser + "@" + this.host + ":" + this.port + "$ " : this.host + ":" + this.port + "$ ";
                }
            }
            try {
                this.outputWriter.flush();
                input_string = this.consoleReader.readLine(prompt);
            }
            catch (Exception e) {
                input_string = null;
            }
        }
        if (input_string != null && !this.stdinInput) {
            this.outputWriter.println(input_string);
        }
        return input_string;
    }

    public ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    public boolean loggedIn() {
        return this.subject != null && this.remoteClient != null && this.remoteClient.isLoggedIn();
    }

    private void inputLoop() {
        Runnable loop_runnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    String cmd = ClientMain.this.getUserInput(null);
                    try {
                        ClientMain.this.recorder.record(cmd);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        String[] cmd_args = ClientMain.this.parseCommandLine(cmd);
                        boolean can_continue = ClientMain.this.executePromptCommand(cmd_args);
                        if (can_continue) continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(ClientMain.this.outputWriter);
                        continue;
                    }
                    break;
                }
            }
        };
        this.inputLoopThread = new Thread(loop_runnable);
        this.inputLoopThread.setName("RHQ Client Prompt Input Thread");
        this.inputLoopThread.setDaemon(false);
        this.inputLoopThread.start();
    }

    public boolean executePromptCommand(String[] args) throws Exception {
        String cmd = args[0];
        if (commands.containsKey(cmd)) {
            ClientCommand command = commands.get(cmd);
            if (this.shouldDisplayHelp(args)) {
                this.outputWriter.println("Usage: " + command.getSyntax());
                this.outputWriter.println(command.getDetailedHelp());
                return true;
            }
            try {
                boolean response = command.execute(this, args);
                this.processNotes(this.outputWriter);
                this.outputWriter.println("");
                return response;
            }
            catch (CommandLineParseException e) {
                this.outputWriter.println(command.getPromptCommandString() + ": " + e.getMessage());
                this.outputWriter.println("Usage: " + command.getSyntax());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.outputWriter.println(command.getPromptCommandString() + ": An incorrect number of arguments was specified.");
                this.outputWriter.println("Usage: " + command.getSyntax());
            }
        } else {
            boolean result = commands.get("exec").execute(this, args);
            if (this.loggedIn()) {
                this.codeCompletion.setScriptContext(this.getScriptEngine().getContext());
            }
            return result;
        }
        return true;
    }

    private boolean shouldDisplayHelp(String[] args) {
        if (args.length < 2) {
            return false;
        }
        return args[1].equals("-h") || args[1].equals("--help");
    }

    private void processNotes(PrintWriter outputWriter2) {
        if (outputWriter2 != null && this.notes.size() > 0) {
            for (String line : this.notes) {
                outputWriter2.println("-> " + line);
            }
            this.notes.clear();
        }
    }

    public String[] parseCommandLine(String cmdLine) {
        if (cmdLine == null) {
            return new String[]{""};
        }
        ByteArrayInputStream in = new ByteArrayInputStream(cmdLine.getBytes());
        StreamTokenizer strtok = new StreamTokenizer(new InputStreamReader(in));
        ArrayList<String> args = new ArrayList<String>();
        boolean keep_going = true;
        boolean isScriptFileCommand = false;
        boolean isNamedArgs = false;
        strtok.ordinaryChars(48, 57);
        strtok.ordinaryChar(46);
        strtok.ordinaryChar(45);
        strtok.ordinaryChar(39);
        strtok.wordChars(33, 127);
        while (keep_going) {
            int nextToken;
            try {
                if (isScriptFileCommand && args.size() > 2 && ((String)args.get(args.size() - 2)).equals("-f")) {
                    strtok.resetSyntax();
                    strtok.ordinaryChars(48, 57);
                    strtok.ordinaryChar(46);
                    strtok.ordinaryChar(45);
                    strtok.quoteChar(39);
                    strtok.quoteChar(34);
                    strtok.wordChars(33, 33);
                    strtok.wordChars(35, 38);
                    strtok.wordChars(40, 127);
                }
                nextToken = strtok.nextToken();
            }
            catch (IOException e) {
                nextToken = -1;
            }
            if (nextToken == -3) {
                if (args.size() > 0 && strtok.sval.equals("-f")) {
                    isScriptFileCommand = true;
                }
                args.add(strtok.sval);
                if (!strtok.sval.equals("--args-style=named")) continue;
                isNamedArgs = true;
                continue;
            }
            if (nextToken == 34 || nextToken == 39) {
                args.add(strtok.sval);
                continue;
            }
            if (nextToken != -1 && nextToken != 10) continue;
            keep_going = false;
        }
        if (isNamedArgs) {
            ArrayList newArgs = new ArrayList();
            int namedArgsIndex = args.indexOf("--args-style=named");
            for (int i = 0; i <= namedArgsIndex; ++i) {
                newArgs.add(args.get(i));
            }
            String namedArg = null;
            for (int i = namedArgsIndex + 1; i < args.size(); ++i) {
                if (namedArg == null && ((String)args.get(i)).endsWith("=")) {
                    namedArg = (String)args.get(i);
                    continue;
                }
                if (namedArg != null) {
                    newArgs.add((String)args.get(i - 1) + (String)args.get(i));
                    namedArg = null;
                    continue;
                }
                newArgs.add(args.get(i));
            }
            return newArgs.toArray(new String[newArgs.size()]);
        }
        return args.toArray(new String[args.size()]);
    }

    private void displayUsage() {
        this.outputWriter.println("rhq-cli.sh [-h] [-u user] [-p pass] [-P] [-s host] [-t port] [-v] [-f file]|[-c command]");
    }

    StartupConfiguration processArguments(String[] args) throws IllegalArgumentException, IOException {
        int code;
        StartupConfiguration config = new StartupConfiguration();
        String sopts = "-:hu:p:Ps:t:r:c:f:v";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("user", 1, null, 117), new LongOpt("password", 1, null, 112), new LongOpt("prompt", 2, null, 80), new LongOpt("host", 1, null, 115), new LongOpt("port", 1, null, 116), new LongOpt("transport", 1, null, 114), new LongOpt("command", 1, null, 99), new LongOpt("file", 0, null, 102), new LongOpt("version", 0, null, 118), new LongOpt("language", 1, null, 108), new LongOpt("args-style", 1, null, -2)};
        Getopt getopt = new Getopt("Cli", args, sopts, lopts, false);
        ArrayList<String> execCmdLine = new ArrayList<String>();
        execCmdLine.add("exec");
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    config.invalidArgs = true;
                    break;
                }
                case 1: {
                    execCmdLine.add(getopt.getOptarg());
                    break;
                }
                case 104: {
                    config.displayUsage = true;
                    break;
                }
                case 117: {
                    this.user = getopt.getOptarg();
                    break;
                }
                case 112: {
                    this.pass = getopt.getOptarg();
                    break;
                }
                case 80: {
                    config.askForPassword = true;
                    break;
                }
                case 99: {
                    this.interactiveMode = false;
                    execCmdLine.add(getopt.getOptarg());
                    break;
                }
                case 102: {
                    this.interactiveMode = false;
                    execCmdLine.add("-f");
                    execCmdLine.add(getopt.getOptarg());
                    break;
                }
                case -2: {
                    execCmdLine.add("--args-style=" + getopt.getOptarg());
                    break;
                }
                case 115: {
                    this.setHost(getopt.getOptarg());
                    break;
                }
                case 114: {
                    this.setTransport(getopt.getOptarg());
                    break;
                }
                case 116: {
                    String portArg = getopt.getOptarg();
                    try {
                        this.setPort(Integer.parseInt(portArg));
                    }
                    catch (Exception e) {
                        this.outputWriter.println("Invalid port [" + portArg + "]");
                        System.exit(1);
                    }
                    break;
                }
                case 118: {
                    config.showDetailedVersion = true;
                    if (args.length != 1) break;
                    config.showVersionAndExit = true;
                    break;
                }
                case 108: {
                    this.language = getopt.getOptarg();
                }
            }
        }
        if (!this.interactiveMode) {
            config.commandsToExec = execCmdLine;
        }
        return config;
    }

    public RemoteClient getRemoteClient() {
        return this.remoteClient;
    }

    public void setRemoteClient(RemoteClient remoteClient) {
        this.remoteClient = remoteClient;
        this.initScriptCommand();
        if (this.isInteractiveMode()) {
            this.initCodeCompletion();
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public PrintWriter getPrintWriter() {
        return this.outputWriter;
    }

    public void setPrintWriter(PrintWriter writer) {
        this.outputWriter = writer;
    }

    public String getLanguage() {
        return this.language == null ? "javascript" : this.language;
    }

    public int getConsoleWidth() {
        return this.consoleReader == null ? 80 : this.consoleReader.getTermwidth();
    }

    public ScriptEngine getScriptEngine() {
        if (this.engine == null) {
            try {
                this.engine = ScriptEngineFactory.getScriptEngine((String)this.getLanguage(), (PackageFinder)new PackageFinder(Arrays.asList(ClientMain.getLibDir())), null);
                if (this.engine == null) {
                    throw new IllegalStateException("The scripting language '" + this.getLanguage() + "' could not be loaded.");
                }
                this.scriptEngineInitializer = ScriptEngineFactory.getInitializer((String)this.getLanguage());
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.engine;
    }

    public String getUsefulErrorMessage(ScriptException e) {
        return this.scriptEngineInitializer.extractUserFriendlyErrorMessage(e);
    }

    public Map<String, ClientCommand> getCommands() {
        return commands;
    }

    public void addMenuNote(String note) {
        if (note != null && note.trim().length() > 0) {
            this.notes.add(note);
        }
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(Recorder recorder) {
        this.recorder = recorder;
    }

    private static File getLibDir() {
        String cwd = System.getProperty("user.dir");
        return new File(cwd, "lib");
    }

    private class StartupConfiguration {
        public boolean askForPassword;
        public boolean displayUsage;
        public List<String> commandsToExec;
        public boolean invalidArgs;
        public boolean showVersionAndExit;
        public boolean showDetailedVersion;

        private StartupConfiguration() {
        }

        public void process() throws Exception {
            if (this.invalidArgs) {
                ClientMain.this.displayUsage();
                throw new IllegalArgumentException(MSG.getMsg("ClientMain.badArgs", new Object[0]));
            }
            if (this.displayUsage) {
                ClientMain.this.displayUsage();
            }
            if (this.askForPassword) {
                ClientMain.this.setPass(ClientMain.this.getConsoleReader().readLine("password: ", Character.valueOf('\u0000')));
            }
            if (ClientMain.this.isInteractiveMode()) {
                String version = this.showDetailedVersion ? Version.getProductNameAndVersionBuildInfo() : Version.getProductNameAndVersion();
                ClientMain.this.outputWriter.println(version);
                if (this.showVersionAndExit) {
                    System.exit(0);
                }
            }
            if (ClientMain.this.getUser() != null && ClientMain.this.getPass() != null) {
                ClientCommand loginCmd = ClientMain.this.getCommands().get("login");
                if (ClientMain.this.getHost() != null) {
                    loginCmd.execute(ClientMain.this, new String[]{"login", ClientMain.this.getUser(), ClientMain.this.getPass(), ClientMain.this.getHost(), String.valueOf(ClientMain.this.getPort()), ClientMain.this.getTransport()});
                } else {
                    loginCmd.execute(ClientMain.this, new String[]{"login", ClientMain.this.getUser(), ClientMain.this.getPass()});
                }
                if (!ClientMain.this.loggedIn()) {
                    return;
                }
            }
            if (this.commandsToExec != null && !this.commandsToExec.isEmpty()) {
                ClientMain.this.getCommands().get("exec").execute(ClientMain.this, this.commandsToExec.toArray(new String[this.commandsToExec.size()]));
            }
        }
    }
}

