/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.impl.identify;

import java.io.Serializable;

public abstract class Identification
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_AGENT = "agent";
    public static final String TYPE_SERVER = "server";
    private final String m_type;
    private final String m_locator;
    private final long m_timestamp;

    public Identification(String type, String locator) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type=null");
        }
        if (locator == null) {
            throw new IllegalArgumentException("locator=null");
        }
        this.m_type = type;
        this.m_locator = locator;
        this.m_timestamp = System.currentTimeMillis();
    }

    public String getInvokerLocator() {
        return this.m_locator;
    }

    public String getType() {
        return this.m_type;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Identification)) {
            return false;
        }
        Identification compareThis = (Identification)obj;
        return this.m_type.equals(compareThis.m_type) && this.m_locator.equals(compareThis.m_locator);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getType().hashCode();
        result = 37 * result + this.getInvokerLocator().hashCode();
        return result;
    }
}

