/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.agentclient.impl;

import org.rhq.core.clientapi.agent.bundle.BundleAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.content.ContentAgentService;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.agent.drift.DriftAgentService;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.clientapi.agent.operation.OperationAgentService;
import org.rhq.core.clientapi.agent.support.SupportAgentService;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.server.ExternalizableStrategy;
import org.rhq.enterprise.communications.Ping;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;
import org.rhq.enterprise.communications.command.client.SendCallback;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.safeinvoker.HibernateDetachUtility;

public class AgentClientImpl
implements AgentClient {
    private final Agent agent;
    private final ClientCommandSender sender;
    private final ClientRemotePojoFactory clientRemotePojoFactory;

    public AgentClientImpl(Agent agent, ClientCommandSender sender) {
        if (agent == null) {
            throw new IllegalArgumentException("agent==null");
        }
        if (sender == null) {
            throw new IllegalArgumentException("sender==null");
        }
        this.agent = agent;
        this.sender = sender;
        this.clientRemotePojoFactory = sender.getClientRemotePojoFactory();
        this.sender.setSendCallbacks(new SendCallback[]{new ExternalizableStrategySendCallback()});
        this.clientRemotePojoFactory.setDeliveryGuaranteed(ClientRemotePojoFactory.GuaranteedDelivery.DISABLED);
    }

    @Override
    public Agent getAgent() {
        return this.agent;
    }

    public String toString() {
        return this.getAgent().toString();
    }

    @Override
    public void startSending() {
        this.sender.startSending();
    }

    @Override
    public void stopSending() {
        this.sender.stopSending(false);
    }

    @Override
    public boolean ping(long timeoutMillis) {
        try {
            ClientRemotePojoFactory factory = this.sender.getClientRemotePojoFactory();
            factory.setTimeout(Long.valueOf(timeoutMillis));
            Ping pinger = (Ping)factory.getRemotePojo(Ping.class);
            pinger.ping("", null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public BundleAgentService getBundleAgentService() {
        return (BundleAgentService)this.clientRemotePojoFactory.getRemotePojo(BundleAgentService.class);
    }

    @Override
    public BundleAgentService getBundleAgentService(Long timeout) {
        return (BundleAgentService)this.clientRemotePojoFactory.getRemotePojo(BundleAgentService.class, timeout);
    }

    @Override
    public ContentAgentService getContentAgentService() {
        return (ContentAgentService)this.clientRemotePojoFactory.getRemotePojo(ContentAgentService.class);
    }

    @Override
    public ContentAgentService getContentAgentService(Long timeout) {
        return (ContentAgentService)this.clientRemotePojoFactory.getRemotePojo(ContentAgentService.class, timeout);
    }

    @Override
    public ResourceFactoryAgentService getResourceFactoryAgentService() {
        return (ResourceFactoryAgentService)this.clientRemotePojoFactory.getRemotePojo(ResourceFactoryAgentService.class);
    }

    @Override
    public ResourceFactoryAgentService getResourceFactoryAgentService(Long timeout) {
        return (ResourceFactoryAgentService)this.clientRemotePojoFactory.getRemotePojo(ResourceFactoryAgentService.class, timeout);
    }

    @Override
    public DiscoveryAgentService getDiscoveryAgentService() {
        return (DiscoveryAgentService)this.clientRemotePojoFactory.getRemotePojo(DiscoveryAgentService.class);
    }

    @Override
    public DiscoveryAgentService getDiscoveryAgentService(Long timeout) {
        return (DiscoveryAgentService)this.clientRemotePojoFactory.getRemotePojo(DiscoveryAgentService.class, timeout);
    }

    @Override
    public MeasurementAgentService getMeasurementAgentService() {
        return (MeasurementAgentService)this.clientRemotePojoFactory.getRemotePojo(MeasurementAgentService.class);
    }

    @Override
    public MeasurementAgentService getMeasurementAgentService(Long timeout) {
        return (MeasurementAgentService)this.clientRemotePojoFactory.getRemotePojo(MeasurementAgentService.class, timeout);
    }

    @Override
    public OperationAgentService getOperationAgentService() {
        return (OperationAgentService)this.clientRemotePojoFactory.getRemotePojo(OperationAgentService.class);
    }

    @Override
    public OperationAgentService getOperationAgentService(Long timeout) {
        return (OperationAgentService)this.clientRemotePojoFactory.getRemotePojo(OperationAgentService.class, timeout);
    }

    @Override
    public ConfigurationAgentService getConfigurationAgentService() {
        return (ConfigurationAgentService)this.clientRemotePojoFactory.getRemotePojo(ConfigurationAgentService.class);
    }

    @Override
    public ConfigurationAgentService getConfigurationAgentService(Long timeout) {
        return (ConfigurationAgentService)this.clientRemotePojoFactory.getRemotePojo(ConfigurationAgentService.class, timeout);
    }

    @Override
    public SupportAgentService getSupportAgentService() {
        return (SupportAgentService)this.clientRemotePojoFactory.getRemotePojo(SupportAgentService.class);
    }

    @Override
    public SupportAgentService getSupportAgentService(Long timeout) {
        return (SupportAgentService)this.clientRemotePojoFactory.getRemotePojo(SupportAgentService.class, timeout);
    }

    @Override
    public DriftAgentService getDriftAgentService() {
        return (DriftAgentService)this.clientRemotePojoFactory.getRemotePojo(DriftAgentService.class);
    }

    @Override
    public DriftAgentService getDriftAgentService(Long timeout) {
        return (DriftAgentService)this.clientRemotePojoFactory.getRemotePojo(DriftAgentService.class, timeout);
    }

    private static class ExternalizableStrategySendCallback
    implements SendCallback {
        public void sending(Command command) {
            try {
                HibernateDetachUtility.nullOutUninitializedFields((Object)command, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ExternalizableStrategy.setStrategy((ExternalizableStrategy.Subsystem)ExternalizableStrategy.Subsystem.AGENT);
        }

        public CommandResponse sent(Command command, CommandResponse response) {
            return response;
        }
    }
}

