/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.internal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.alert.composite.AbstractAlertConditionCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionAvailabilityCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionControlCategoryComposite;
import org.rhq.core.domain.alert.composite.AlertConditionResourceConfigurationCategoryComposite;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.internal.AbstractConditionCache;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheUtils;
import org.rhq.enterprise.server.alert.engine.mbean.AlertConditionCacheMonitor;
import org.rhq.enterprise.server.alert.engine.model.AvailabilityCacheElement;
import org.rhq.enterprise.server.alert.engine.model.AvailabilityDurationCacheElement;
import org.rhq.enterprise.server.alert.engine.model.AvailabilityDurationComposite;
import org.rhq.enterprise.server.alert.engine.model.InvalidCacheElementException;
import org.rhq.enterprise.server.alert.engine.model.ResourceConfigurationCacheElement;
import org.rhq.enterprise.server.alert.engine.model.ResourceOperationCacheElement;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

class GlobalConditionCache
extends AbstractConditionCache {
    private Map<Integer, Map<Integer, List<ResourceOperationCacheElement>>> resourceOperationCache = new HashMap<Integer, Map<Integer, List<ResourceOperationCacheElement>>>();
    private Map<Integer, List<AvailabilityCacheElement>> availabilityCache = new HashMap<Integer, List<AvailabilityCacheElement>>();
    private Map<Integer, List<AvailabilityDurationCacheElement>> availabilityDurationCache = new HashMap<Integer, List<AvailabilityDurationCacheElement>>();
    private Map<Integer, List<ResourceConfigurationCacheElement>> resourceConfigurationCache = new HashMap<Integer, List<ResourceConfigurationCacheElement>>();
    private AlertConditionManagerLocal alertConditionManager = LookupUtil.getAlertConditionManager();
    private SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();

    public GlobalConditionCache() {
        this.loadCaches();
    }

    private AlertConditionCacheStats loadCaches() {
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            log.debug((Object)"Loading Global Condition Cache...");
            Subject overlord = this.subjectManager.getOverlord();
            EnumSet<AlertConditionCategory> supportedCategories = EnumSet.of(AlertConditionCategory.AVAILABILITY, AlertConditionCategory.AVAIL_DURATION, AlertConditionCategory.CONTROL, AlertConditionCategory.RESOURCE_CONFIG);
            for (AlertConditionCategory nextCategory : supportedCategories) {
                int rowsProcessed = 0;
                PageControl pc = new PageControl();
                pc.setPageNumber(0);
                pc.setPageSize(250);
                while (true) {
                    PageList<? extends AbstractAlertConditionCategoryComposite> alertConditions = null;
                    alertConditions = this.alertConditionManager.getAlertConditionComposites(overlord, null, nextCategory, pc);
                    if (alertConditions.isEmpty()) break;
                    for (AbstractAlertConditionCategoryComposite nextComposite : alertConditions) {
                        this.insertAlertConditionComposite(nextComposite, stats);
                    }
                    if ((rowsProcessed += alertConditions.size()) >= alertConditions.getTotalSize()) break;
                    pc.setPageNumber(pc.getPageNumber() + 1);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded " + rowsProcessed + " Alert Condition Composites of type '" + nextCategory + "'"));
            }
            log.debug((Object)"Loaded Global Condition Cache");
        }
        catch (Throwable t) {
            log.error((Object)"Error loading global condition cache", t);
        }
        return stats;
    }

    private void insertAlertConditionComposite(AbstractAlertConditionCategoryComposite composite, AlertConditionCacheStats stats) {
        AlertCondition alertCondition = composite.getCondition();
        int alertConditionId = alertCondition.getId();
        AlertConditionCategory alertConditionCategory = alertCondition.getCategory();
        AlertConditionOperator alertConditionOperator = AlertConditionCacheUtils.getAlertConditionOperator(alertCondition);
        if (alertConditionCategory == AlertConditionCategory.AVAILABILITY) {
            AlertConditionAvailabilityCategoryComposite availabilityComposite = (AlertConditionAvailabilityCategoryComposite)composite;
            try {
                AvailabilityCacheElement cacheElement = new AvailabilityCacheElement(alertConditionOperator, availabilityComposite.getAvailabilityType(), alertConditionId);
                this.addTo("availabilityCache", this.availabilityCache, availabilityComposite.getResourceId(), cacheElement, alertConditionId, stats);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create AvailabilityCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, availabilityComposite.getAvailabilityType(), AvailabilityType.UP, icee)));
            }
        } else if (alertConditionCategory == AlertConditionCategory.AVAIL_DURATION) {
            AlertConditionAvailabilityCategoryComposite availabilityComposite = (AlertConditionAvailabilityCategoryComposite)composite;
            try {
                AvailabilityDurationCacheElement cacheElement = new AvailabilityDurationCacheElement(availabilityComposite.getAlertDefinitionId(), alertConditionOperator, alertCondition.getOption(), availabilityComposite.getAvailabilityType(), alertConditionId);
                this.addTo("availabilityDurationCache", this.availabilityDurationCache, availabilityComposite.getResourceId(), cacheElement, alertConditionId, stats);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create AvailabilityCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, availabilityComposite.getAvailabilityType(), alertConditionOperator.toString(), icee)));
            }
        } else if (alertConditionCategory == AlertConditionCategory.CONTROL) {
            AlertConditionControlCategoryComposite controlComposite = (AlertConditionControlCategoryComposite)composite;
            String option = alertCondition.getOption();
            OperationRequestStatus operationRequestStatus = OperationRequestStatus.valueOf((String)option.toUpperCase());
            try {
                ResourceOperationCacheElement cacheElement = new ResourceOperationCacheElement(alertConditionOperator, operationRequestStatus, alertConditionId);
                this.addToResourceOperationCache(controlComposite.getResourceId(), controlComposite.getOperationDefinitionId(), cacheElement, alertConditionId, stats);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create ResourceOperationCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, null, operationRequestStatus, icee)));
            }
        } else if (alertConditionCategory == AlertConditionCategory.RESOURCE_CONFIG) {
            AlertConditionResourceConfigurationCategoryComposite resourceConfigurationComposite = (AlertConditionResourceConfigurationCategoryComposite)composite;
            ResourceConfigurationCacheElement cacheElement = null;
            try {
                cacheElement = new ResourceConfigurationCacheElement(alertConditionOperator, resourceConfigurationComposite.getResourceConfiguration(), alertConditionId);
            }
            catch (InvalidCacheElementException icee) {
                log.info((Object)("Failed to create EventCacheElement with parameters: " + AlertConditionCacheUtils.getCacheElementErrorString(alertConditionId, alertConditionOperator, null, null, icee)));
            }
            this.addTo("resourceConfigurationCache", this.resourceConfigurationCache, resourceConfigurationComposite.getResourceId(), cacheElement, alertConditionId, stats);
        }
    }

    public AlertConditionCacheStats checkConditions(OperationHistory operationHistory) {
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            if (operationHistory instanceof ResourceOperationHistory) {
                ResourceOperationHistory resourceOperationHistory = (ResourceOperationHistory)operationHistory;
                Resource resource = resourceOperationHistory.getResource();
                OperationDefinition operationDefinition = resourceOperationHistory.getOperationDefinition();
                OperationRequestStatus operationStatus = resourceOperationHistory.getStatus();
                List<ResourceOperationCacheElement> cacheElements = this.lookupResourceOperationHistoryCacheElements(resource.getId(), operationDefinition.getId());
                this.processCacheElements(cacheElements, operationStatus, resourceOperationHistory.getModifiedTime(), stats, new Object[0]);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)(this.getClass().getSimpleName() + " does not support checking conditions against " + operationHistory.getClass().getSimpleName() + " types"));
            }
            AlertConditionCacheMonitor.getMBean().incrementOperationCacheElementMatches(stats.matched);
            AlertConditionCacheMonitor.getMBean().incrementOperationProcessingTime(stats.getAge());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check OperationHistory[size=1] - " + stats));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error during global cache processing: ", t);
        }
        return stats;
    }

    public AlertConditionCacheStats checkConditions(ResourceConfigurationUpdate update) {
        if (update == null) {
            return new AlertConditionCacheStats();
        }
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            Resource resource = update.getResource();
            List<ResourceConfigurationCacheElement> cacheElements = this.lookupResourceConfigurationCacheElements(resource.getId());
            this.processCacheElements(cacheElements, update.getConfiguration(), update.getCreatedTime(), stats, new Object[0]);
            AlertConditionCacheMonitor.getMBean().incrementResourceConfigurationCacheElementMatches(stats.matched);
            AlertConditionCacheMonitor.getMBean().incrementResourceConfigurationProcessingTime(stats.getAge());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check " + update + " - " + stats));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error during global cache processing: ", t);
        }
        return stats;
    }

    public AlertConditionCacheStats checkConditions(Availability ... availabilities) {
        if (availabilities == null || availabilities.length == 0) {
            return new AlertConditionCacheStats();
        }
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            for (Availability availability : availabilities) {
                Resource resource = availability.getResource();
                AvailabilityType availabilityType = availability.getAvailabilityType();
                List<AvailabilityCacheElement> cacheElements = this.lookupAvailabilityCacheElements(resource.getId());
                this.processCacheElements(cacheElements, availabilityType, availability.getStartTime(), stats, new Object[0]);
                List<AvailabilityDurationCacheElement> durationCacheElements = this.lookupAvailabilityDurationCacheElements(resource.getId());
                AvailabilityDurationCacheElement.checkCacheElements(durationCacheElements, resource, availabilityType);
            }
            AlertConditionCacheMonitor.getMBean().incrementAvailabilityCacheElementMatches(stats.matched);
            AlertConditionCacheMonitor.getMBean().incrementAvailabilityProcessingTime(stats.getAge());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check Availability[size=" + availabilities.length + "] - " + stats));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error during global cache processing: ", t);
        }
        return stats;
    }

    public AlertConditionCacheStats checkConditions(AvailabilityDurationComposite ... composites) {
        if (null == composites || composites.length == 0) {
            return new AlertConditionCacheStats();
        }
        AlertConditionCacheStats stats = new AlertConditionCacheStats();
        try {
            block2: for (AvailabilityDurationComposite composite : composites) {
                List<AvailabilityDurationCacheElement> cacheElements = this.lookupAvailabilityDurationCacheElements(composite.getResourceId());
                if (null == cacheElements || cacheElements.isEmpty()) continue;
                for (AvailabilityDurationCacheElement cacheElement : cacheElements) {
                    if (composite.getConditionId() != cacheElement.getAlertConditionTriggerId()) continue;
                    ArrayList<AvailabilityDurationCacheElement> cacheElementAsList = new ArrayList<AvailabilityDurationCacheElement>(1);
                    cacheElementAsList.add(cacheElement);
                    this.processCacheElements(cacheElementAsList, composite.getAvailabilityType(), System.currentTimeMillis(), stats, new Object[0]);
                    continue block2;
                }
            }
            AlertConditionCacheMonitor.getMBean().incrementAvailabilityDurationCacheElementMatches(stats.matched);
            AlertConditionCacheMonitor.getMBean().incrementAvailabilityDurationProcessingTime(stats.getAge());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check AvailabilityDuration[size=" + composites.length + "] - " + stats));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error during global cache processing: ", t);
        }
        return stats;
    }

    private boolean addToResourceOperationCache(Integer resourceId, Integer operationDefinitionId, ResourceOperationCacheElement cacheElement, Integer alertConditionId, AlertConditionCacheStats stats) {
        Map operationDefinitionMap = this.resourceOperationCache.get(resourceId);
        if (operationDefinitionMap == null) {
            operationDefinitionMap = new HashMap<Integer, List<ResourceOperationCacheElement>>();
            this.resourceOperationCache.put(resourceId, operationDefinitionMap);
        }
        return this.addTo("operationDefinitionMap", operationDefinitionMap, operationDefinitionId, cacheElement, alertConditionId, stats);
    }

    private List<ResourceOperationCacheElement> lookupResourceOperationHistoryCacheElements(int resourceId, int definitionId) {
        Map<Integer, List<ResourceOperationCacheElement>> operationDefinitionMap = this.resourceOperationCache.get(resourceId);
        if (operationDefinitionMap == null) {
            return null;
        }
        return operationDefinitionMap.get(definitionId);
    }

    private List<AvailabilityCacheElement> lookupAvailabilityCacheElements(int resourceId) {
        return this.availabilityCache.get(resourceId);
    }

    private List<AvailabilityDurationCacheElement> lookupAvailabilityDurationCacheElements(int resourceId) {
        return this.availabilityDurationCache.get(resourceId);
    }

    private List<ResourceConfigurationCacheElement> lookupResourceConfigurationCacheElements(int resourceId) {
        return this.resourceConfigurationCache.get(resourceId);
    }

    @Override
    public int getCacheSize(AlertConditionCacheCoordinator.Cache cache) {
        if (cache == AlertConditionCacheCoordinator.Cache.AvailabilityCache) {
            return AlertConditionCacheUtils.getMapListCount(this.availabilityCache);
        }
        if (cache == AlertConditionCacheCoordinator.Cache.AvailabilityDurationCache) {
            return AlertConditionCacheUtils.getMapListCount(this.availabilityDurationCache);
        }
        if (cache == AlertConditionCacheCoordinator.Cache.ResourceConfigurationCache) {
            return AlertConditionCacheUtils.getMapListCount(this.resourceConfigurationCache);
        }
        if (cache == AlertConditionCacheCoordinator.Cache.ResourceOperationCache) {
            return AlertConditionCacheUtils.getMapMapListCount(this.resourceOperationCache);
        }
        throw new IllegalArgumentException("The " + GlobalConditionCache.class.getSimpleName() + " either does not manage caches of type " + (Object)((Object)cache.type) + ", or does not support obtaining their size");
    }
}

