/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.as.controller.client.ModelControllerClient;
import org.rhq.common.jbossas.client.controller.DeploymentJBossASClient;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.service.ManagementService;

public class CoreServer
implements CoreServerMBean {
    private static final String PRODUCT_INFO_PROPERTIES_RESOURCE_PATH = "org/rhq/enterprise/server/core/ProductInfo.properties";
    private final Log log = LogFactory.getLog(CoreServer.class);
    private static final String VERSION_FILE = "rhq-server-version.properties";
    private static final String PROP_PRODUCT_VERSION = "Product-Version";
    private static final String PROP_BUILD_NUMBER = "Build-Number";
    private static final String PROP_BUILD_DATE = "Build-Date";
    private Properties buildProps;
    private Date bootTime;

    protected void start() throws Exception {
        this.buildProps = this.loadBuildProperties();
        this.bootTime = new Date();
        String version = this.getVersion();
        String buildNumber = this.getBuildNumber();
        String buildDate = this.buildProps.getProperty(PROP_BUILD_DATE, "?");
        this.log.info((Object)("Version=[" + version + "], Build Number=[" + buildNumber + "], Build Date=[" + buildDate + "]"));
    }

    public String getName() {
        return "RHQ Server";
    }

    public String getVersion() {
        return this.buildProps.getProperty(PROP_PRODUCT_VERSION, "?");
    }

    public String getBuildNumber() {
        return this.buildProps.getProperty(PROP_BUILD_NUMBER, "?");
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    public File getInstallDir() {
        String rhqHome = System.getProperty("rhq.server.home");
        if (rhqHome != null) {
            return new File(rhqHome);
        }
        File homeDir = new File(this.getServerEnvironmentAttribute("logDir"));
        return homeDir.getParentFile();
    }

    public File getJBossServerHomeDir() {
        File baseDir = new File(this.getServerEnvironmentAttribute("baseDir"));
        return baseDir;
    }

    public File getJBossServerDataDir() {
        File dataDir = new File(this.getServerEnvironmentAttribute("dataDir"));
        return dataDir;
    }

    public File getJBossServerTempDir() {
        File tempDir = new File(this.getServerEnvironmentAttribute("tempDir"));
        return tempDir;
    }

    public File getEarDeploymentDir() {
        ModelControllerClient mcc = SecurityActions.getModelControllerClient();
        try {
            DeploymentJBossASClient client = new DeploymentJBossASClient(mcc);
            String earPath = client.getDeploymentPath("rhq.ear");
            File file = new File(earPath);
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                mcc.close();
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductInfo getProductInfo() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(PRODUCT_INFO_PROPERTIES_RESOURCE_PATH);
        if (inputStream != null) {
            Properties props = new Properties();
            try {
                try {
                    props.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load product info properties from class loader resource [org/rhq/enterprise/server/core/ProductInfo.properties].");
            }
            ProductInfo productInfo = new ProductInfo();
            productInfo.setBuildNumber(props.getProperty("buildNumber"));
            productInfo.setFullName(props.getProperty("fullName"));
            productInfo.setHelpDocRoot(props.getProperty("helpDocRoot"));
            productInfo.setName(props.getProperty("name"));
            productInfo.setSalesEmail(props.getProperty("salesEmail"));
            productInfo.setShortName(props.getProperty("shortName"));
            productInfo.setSupportEmail(props.getProperty("supportEmail"));
            productInfo.setUrlDomain(props.getProperty("urlDomain"));
            productInfo.setUrl(props.getProperty("url"));
            productInfo.setVersion(props.getProperty("version"));
            HashMap<String, String> helpViewContent = new HashMap<String, String>();
            for (String propertyName : props.stringPropertyNames()) {
                if (!propertyName.startsWith("view_help_section")) continue;
                helpViewContent.put(propertyName, props.getProperty(propertyName));
            }
            productInfo.setHelpViewContent(helpViewContent);
            return productInfo;
        }
        throw new IllegalStateException("Failed to find class loader resource [org/rhq/enterprise/server/core/ProductInfo.properties].");
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        return mbs;
    }

    private String getServerEnvironmentAttribute(String attributeName) {
        try {
            MBeanServer mbs = this.getMBeanServer();
            ObjectName name = ObjectNameFactory.create((String)"jboss.as:core-service=server-environment");
            Object value = mbs.getAttribute(name, attributeName);
            return value != null ? value.toString() : null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadBuildProperties() {
        Properties buildProps = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            InputStream stream = classLoader.getResourceAsStream(VERSION_FILE);
            try {
                buildProps.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            this.log.fatal((Object)("Failed to load [rhq-server-version.properties] via class loader [" + classLoader + "]"));
        }
        return buildProps;
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        private static ModelControllerClient getModelControllerClient() {
            if (System.getSecurityManager() == null) {
                return ManagementService.getClient();
            }
            return AccessController.doPrivileged(new PrivilegedAction<ModelControllerClient>(){

                @Override
                public ModelControllerClient run() {
                    return ManagementService.getClient();
                }
            });
        }
    }
}

