/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.drift.DriftServerService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.DriftDefinitionCriteria;
import org.rhq.core.domain.drift.DriftComplianceStatus;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftSnapshot;
import org.rhq.core.domain.drift.DriftSnapshotRequest;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;
import org.rhq.enterprise.server.util.LookupUtil;

public class DriftServerServiceImpl
implements DriftServerService {
    private Log log = LogFactory.getLog(DriftServerServiceImpl.class);

    public void sendChangesetZip(int resourceId, long zipSize, InputStream zipStream) {
        try {
            DriftManagerLocal driftManager = LookupUtil.getDriftManager();
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            driftManager.addChangeSet(overlord, resourceId, zipSize, zipStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendFilesZip(int resourceId, String driftDefinitionName, String token, long zipSize, InputStream zipStream) {
        try {
            DriftManagerLocal driftManager = LookupUtil.getDriftManager();
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            driftManager.addFiles(overlord, resourceId, driftDefinitionName, token, zipSize, zipStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void repeatChangeSet(int resourceId, String driftDefName, int version) {
        DriftManagerLocal driftManager = LookupUtil.getDriftManager();
        driftManager.processRepeatChangeSet(resourceId, driftDefName, version);
    }

    public Map<Integer, List<DriftDefinition>> getDriftDefinitions(Set<Integer> resourceIds) {
        DriftDefinitionCriteria criteria = new DriftDefinitionCriteria();
        criteria.addFilterResourceIds(resourceIds.toArray(new Integer[resourceIds.size()]));
        criteria.fetchConfiguration(Boolean.valueOf(true));
        final Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        CriteriaQueryExecutor<DriftDefinition, DriftDefinitionCriteria> queryExecutor = new CriteriaQueryExecutor<DriftDefinition, DriftDefinitionCriteria>(){

            @Override
            public PageList<DriftDefinition> execute(DriftDefinitionCriteria criteria) {
                return LookupUtil.getDriftManager().findDriftDefinitionsByCriteria(overlord, criteria);
            }
        };
        CriteriaQuery<DriftDefinition, DriftDefinitionCriteria> definitions = new CriteriaQuery<DriftDefinition, DriftDefinitionCriteria>(criteria, queryExecutor);
        HashMap<Integer, List<DriftDefinition>> result = new HashMap<Integer, List<DriftDefinition>>();
        for (DriftDefinition driftDef : definitions) {
            Integer resourceId = driftDef.getResource().getId();
            ArrayList<DriftDefinition> list = (ArrayList<DriftDefinition>)result.get(resourceId);
            if (null == list) {
                list = new ArrayList<DriftDefinition>();
                result.put(resourceId, list);
            }
            list.add(driftDef);
        }
        return result;
    }

    public DriftSnapshot getCurrentSnapshot(int driftDefinitionId) {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        return LookupUtil.getDriftManager().getSnapshot(overlord, new DriftSnapshotRequest(driftDefinitionId));
    }

    public DriftSnapshot getSnapshot(int driftDefinitionId, int startVersion, int endVersion) {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        return LookupUtil.getDriftManager().getSnapshot(overlord, new DriftSnapshotRequest(driftDefinitionId, Integer.valueOf(startVersion), Integer.valueOf(endVersion)));
    }

    public void updateCompliance(int resourceId, String driftDefName, DriftComplianceStatus complianceStatus) {
        DriftDefinitionCriteria criteria = new DriftDefinitionCriteria();
        criteria.setStrict(true);
        criteria.addFilterResourceIds(new Integer[]{resourceId});
        criteria.addFilterName(driftDefName);
        DriftManagerLocal driftMgr = LookupUtil.getDriftManager();
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        Subject overlord = subjectMgr.getOverlord();
        PageList<DriftDefinition> definitions = driftMgr.findDriftDefinitionsByCriteria(overlord, criteria);
        if (definitions.isEmpty()) {
            this.log.warn((Object)("Cannot update compliance for [resourceId: " + resourceId + ", driftDefinitionName: " + driftDefName + "]. Could not find drift definition."));
            return;
        }
        DriftDefinition definition = (DriftDefinition)definitions.get(0);
        definition.setComplianceStatus(complianceStatus);
        driftMgr.updateDriftDefinition(overlord, definition);
    }
}

