/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.disambiguation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationPolicy;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.resource.disambiguation.MutableDisambiguationReport;
import org.rhq.enterprise.server.resource.disambiguation.ReportPartitions;
import org.rhq.enterprise.server.resource.disambiguation.ResourceResolution;

public enum DefaultDisambiguationUpdateStrategies implements DisambiguationUpdateStrategy
{
    EXACT{

        @Override
        public <T> void update(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
            1.updateResources(policy, report, true, true);
            int nofParents = policy.size() - 1;
            if (nofParents < 0) {
                nofParents = 0;
            }
            if (nofParents == 0) {
                report.parents.clear();
            } else {
                while (report.parents.size() > nofParents) {
                    report.parents.remove(report.parents.size() - 1);
                }
            }
        }

        @Override
        public <T> boolean partitionFurther(ReportPartitions<T> partitions) {
            return true;
        }
    }
    ,
    KEEP_AT_LEAST_ONE_PARENT{

        @Override
        public <T> void update(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
            2.updateResources(policy, report, true, true);
            int nofParents = policy.size() - 1;
            if (nofParents < 1) {
                nofParents = 1;
            }
            while (report.parents.size() > nofParents) {
                report.parents.remove(report.parents.size() - 1);
            }
        }

        @Override
        public EnumSet<ResourceResolution> resourceLevelRepartitionableResolutions() {
            return EnumSet.allOf(ResourceResolution.class);
        }

        @Override
        public <T> boolean partitionFurther(ReportPartitions<T> partitions) {
            return true;
        }
    }
    ,
    KEEP_PARENTS_TO_TOPMOST_SERVERS{

        @Override
        public <T> void update(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
            3.updateResources(policy, report, true, true);
            if (policy.size() > 1 && report.parents.size() > policy.size() - 1) {
                report.parents.remove(report.parents.size() - 1);
            }
        }

        @Override
        public EnumSet<ResourceResolution> resourceLevelRepartitionableResolutions() {
            return EnumSet.allOf(ResourceResolution.class);
        }

        @Override
        public <T> boolean partitionFurther(ReportPartitions<T> partitions) {
            return partitions.getDisambiguationPolicy().size() < 6;
        }
    }
    ,
    KEEP_ALL_PARENTS{

        @Override
        public <T> void update(DisambiguationPolicy policy, MutableDisambiguationReport<T> report) {
            4.updateResources(policy, report, true, true);
        }

        @Override
        public EnumSet<ResourceResolution> resourceLevelRepartitionableResolutions() {
            return EnumSet.of(ResourceResolution.NAME);
        }

        @Override
        public EnumSet<ResourceResolution> alwaysRepartitionableResolutions() {
            return EnumSet.of(ResourceResolution.NAME);
        }

        @Override
        public <T> boolean partitionFurther(ReportPartitions<T> partitions) {
            return false;
        }
    };

    private static final DisambiguationPolicy.Level OVERRIDING_RESOLUTION;

    public static <T> void updateResources(DisambiguationPolicy policy, MutableDisambiguationReport<T> report, boolean honorAmbiguousTypeNamesList, boolean pushDownPluginInfo) {
        int disambiguationPolicyIndex;
        List<String> ambiguousTypeNames = honorAmbiguousTypeNamesList ? policy.getAmbiguousTypeNames() : Collections.emptyList();
        String resourcePlugin = report.resource.resourceType.plugin;
        ArrayList<String> parentPlugins = new ArrayList<String>(report.parents.size());
        DefaultDisambiguationUpdateStrategies.updateResource((DisambiguationPolicy.Level)policy.get(0), report.resource, ambiguousTypeNames);
        for (disambiguationPolicyIndex = 1; disambiguationPolicyIndex < policy.size() && disambiguationPolicyIndex - 1 < report.parents.size(); ++disambiguationPolicyIndex) {
            DisambiguationPolicy.Level resolutionLevel = (DisambiguationPolicy.Level)policy.get(disambiguationPolicyIndex);
            MutableDisambiguationReport.Resource parent = report.parents.get(disambiguationPolicyIndex - 1);
            if (pushDownPluginInfo) {
                parentPlugins.add(parent.resourceType.plugin);
            }
            DefaultDisambiguationUpdateStrategies.updateResource(resolutionLevel, parent, ambiguousTypeNames);
        }
        --disambiguationPolicyIndex;
        while (disambiguationPolicyIndex < report.parents.size()) {
            if (pushDownPluginInfo) {
                parentPlugins.add(report.parents.get((int)disambiguationPolicyIndex).resourceType.plugin);
            }
            DefaultDisambiguationUpdateStrategies.updateResource(OVERRIDING_RESOLUTION, report.parents.get(disambiguationPolicyIndex), ambiguousTypeNames);
            ++disambiguationPolicyIndex;
        }
        if (pushDownPluginInfo) {
            String plugin;
            for (int i = report.parents.size() - 1; i >= 0; --i) {
                String plugin2 = report.parents.get((int)i).resourceType.plugin;
                if (plugin2 == null || i <= 0 || !plugin2.equals(parentPlugins.get(i - 1))) continue;
                report.parents.get((int)(i - 1)).resourceType.plugin = plugin2;
                report.parents.get((int)i).resourceType.plugin = null;
            }
            if (report.parents.size() > 0 && (plugin = report.parents.get((int)0).resourceType.plugin) != null && plugin.equals(resourcePlugin)) {
                report.resource.resourceType.plugin = resourcePlugin;
                report.parents.get((int)0).resourceType.plugin = null;
            }
        }
    }

    @Override
    public EnumSet<ResourceResolution> resourceLevelRepartitionableResolutions() {
        return EnumSet.noneOf(ResourceResolution.class);
    }

    @Override
    public EnumSet<ResourceResolution> alwaysRepartitionableResolutions() {
        return EnumSet.noneOf(ResourceResolution.class);
    }

    private static void updateResource(DisambiguationPolicy.Level resolutionLevel, MutableDisambiguationReport.Resource resource, List<String> ambiguousTypeNames) {
        switch (resolutionLevel.getResourceResolution()) {
            case NAME: 
            case TYPE: {
                if (ambiguousTypeNames.contains(resource.resourceType.name)) break;
                resource.resourceType.plugin = null;
                break;
            }
            case PLUGIN: {
                if (resolutionLevel.isDeciding() || ambiguousTypeNames.contains(resource.resourceType.name)) break;
                resource.resourceType.plugin = null;
            }
        }
    }

    public static DefaultDisambiguationUpdateStrategies getDefault() {
        return KEEP_ALL_PARENTS;
    }

    static {
        OVERRIDING_RESOLUTION = new DisambiguationPolicy.Level(ResourceResolution.TYPE);
    }
}

