/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.domain;

import com.wordnik.swagger.annotations.ApiClass;
import com.wordnik.swagger.annotations.ApiProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.rhq.enterprise.server.rest.domain.AlertDefinitionRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@ApiClass(value="This class represents a single fired alert.")
@XmlRootElement(name="alert")
public class AlertRest {
    private int id;
    private String name;
    private AlertDefinitionRest alertDefinition;
    private ResourceWithType resource;
    private boolean definitionEnabled;
    String ackBy;
    long ackTime;
    long alertTime;
    String description;
    List<Link> links = new ArrayList<Link>();

    public void setResource(ResourceWithType resource) {
        this.resource = resource;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlertDefinition(AlertDefinitionRest alertDefinitionId) {
        this.alertDefinition = alertDefinitionId;
    }

    @ApiProperty(value="The id of the alert")
    public int getId() {
        return this.id;
    }

    @ApiProperty(value="Name of the alert, taken from the AlertDefinition")
    public String getName() {
        return this.name;
    }

    @ApiProperty(value="AlertDefinition from which the alert was fired")
    public AlertDefinitionRest getAlertDefinition() {
        return this.alertDefinition;
    }

    @ApiProperty(value="Is the definition enabled (=active)?")
    public boolean isDefinitionEnabled() {
        return this.definitionEnabled;
    }

    public void setDefinitionEnabled(boolean definitionEnabled) {
        this.definitionEnabled = definitionEnabled;
    }

    @ApiProperty(value="The user that acknowledged the alert (if any)")
    public String getAckBy() {
        return this.ackBy;
    }

    public void setAckBy(String ackBy) {
        this.ackBy = ackBy;
    }

    @ApiProperty(value="Timestamp of the acknowledgement")
    public long getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(long ackTime) {
        this.ackTime = ackTime;
    }

    @ApiProperty(value="Timestamp when the alert has been fired")
    public long getAlertTime() {
        return this.alertTime;
    }

    public void setAlertTime(long alertTime) {
        this.alertTime = alertTime;
    }

    @ApiProperty(value="Description of the alert")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiProperty(value="The resource on which the alert was fired")
    public ResourceWithType getResource() {
        return this.resource;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void addLink(Link link) {
        this.links.add(link);
    }
}

