/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.domain;

import com.wordnik.swagger.annotations.ApiClass;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.composite.ResourceAvailabilitySummary;
import org.rhq.enterprise.server.rest.domain.Link;

@ApiClass(value="Describes the availability summary for a resource")
@XmlRootElement
public class AvailabilitySummary {
    private long currentTime;
    private long upTime;
    private long downTime;
    private long disabledTime;
    private long unknownTime;
    private int failures;
    private int disabled;
    private long lastChange;
    private AvailabilityType current;
    private int resourceId;
    private double disabledPercentage;
    private double upPercentage;
    private long knownTime;
    private long mtbf;
    private long mttr;
    private double downPercentage;
    List<Link> links = new ArrayList<Link>();

    public AvailabilitySummary() {
    }

    public AvailabilitySummary(int resourceId, ResourceAvailabilitySummary ras) {
        this.resourceId = resourceId;
        this.currentTime = ras.getCurrentTime();
        this.upTime = ras.getUpTime();
        this.downTime = ras.getDownTime();
        this.disabledTime = ras.getDisabledTime();
        this.unknownTime = ras.getUnknownTime();
        this.failures = ras.getFailures();
        this.disabled = ras.getDisabled();
        this.lastChange = ras.getLastChange().getTime();
        this.current = ras.getCurrent();
        this.disabledPercentage = ras.getDisabledPercentage();
        this.downPercentage = ras.getDownPercentage();
        this.upPercentage = ras.getUpPercentage();
        this.knownTime = ras.getKnownTime();
        this.unknownTime = ras.getUnknownTime();
        this.mtbf = ras.getMTBF();
        this.mttr = ras.getMTTR();
    }

    public AvailabilityType getCurrent() {
        return this.current;
    }

    public void setCurrent(AvailabilityType current) {
        this.current = current;
    }

    public int getDisabled() {
        return this.disabled;
    }

    public void setDisabled(int disabled) {
        this.disabled = disabled;
    }

    public long getDisabledTime() {
        return this.disabledTime;
    }

    public void setDisabledTime(long disabledTime) {
        this.disabledTime = disabledTime;
    }

    public long getDownTime() {
        return this.downTime;
    }

    public void setDownTime(long downTime) {
        this.downTime = downTime;
    }

    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int failures) {
        this.failures = failures;
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(long lastChange) {
        this.lastChange = lastChange;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public long getUnknownTime() {
        return this.unknownTime;
    }

    public void setUnknownTime(long unknownTime) {
        this.unknownTime = unknownTime;
    }

    public long getUpTime() {
        return this.upTime;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public double getDisabledPercentage() {
        return this.disabledPercentage;
    }

    public void setDisabledPercentage(double disabledPercentage) {
        this.disabledPercentage = disabledPercentage;
    }

    public double getDownPercentage() {
        return this.downPercentage;
    }

    public void setDownPercentage(double downPercentage) {
        this.downPercentage = downPercentage;
    }

    public long getKnownTime() {
        return this.knownTime;
    }

    public void setKnownTime(long knownTime) {
        this.knownTime = knownTime;
    }

    public long getMtbf() {
        return this.mtbf;
    }

    public void setMtbf(long mtbf) {
        this.mtbf = mtbf;
    }

    public long getMttr() {
        return this.mttr;
    }

    public void setMttr(long mttr) {
        this.mttr = mttr;
    }

    public double getUpPercentage() {
        return this.upPercentage;
    }

    public void setUpPercentage(double upPercentage) {
        this.upPercentage = upPercentage;
    }
}

