/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.storage;

import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.ClusterInitService;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.cloud.TopologyManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.storage.StorageClientManagerBean;

@Singleton
public class StorageClusterHeartBeatJob {
    private final Log log = LogFactory.getLog(StorageClusterHeartBeatJob.class);
    @EJB
    private ServerManagerLocal serverManager;
    @EJB
    private StorageNodeManagerLocal storageNodeManager;
    @EJB
    private TopologyManagerLocal topologyManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private StorageClientManagerBean storageClientManager;
    @Resource
    private TimerService timerService;

    public void scheduleJob() {
        long initialDelay = 3000L;
        long interval = 60000L;
        this.timerService.createIntervalTimer(initialDelay, interval, new TimerConfig(null, false));
    }

    @Timeout
    public void checkClusterHeartBeat() {
        ClusterInitService clusterInitService = new ClusterInitService();
        Server server = this.serverManager.getServer();
        List<StorageNode> storageNodes = this.storageNodeManager.getStorageNodes();
        if (storageNodes.isEmpty()) {
            this.log.error((Object)"No storage nodes were found in the RHQ database. If this is your only RHQ server make sure that the rhq.cassandra.seeds property in <rhq-server-basedir>/bin/rhq-server.properties is properly configured. If you edit this property, you will have to restart the server for the change to take effect. The server will now go into maintenance mode since connectivity to storage nodes cannot be verified.");
            this.putServerInMaintenanceMode(server);
        } else {
            boolean pingable = clusterInitService.ping(storageNodes, 1);
            if (pingable) {
                if (server.getOperationMode() != Server.OperationMode.NORMAL) {
                    this.changeServerMode(server, Server.OperationMode.NORMAL);
                    this.log.info((Object)"Restarting storage client subsystem...");
                    this.storageClientManager.init();
                }
                return;
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)(server + " is unable to connect to any Cassandra node. Server will go into maintenance mode."));
            }
            this.putServerInMaintenanceMode(server);
        }
    }

    private void putServerInMaintenanceMode(Server rhqServer) {
        this.changeServerMode(rhqServer, Server.OperationMode.MAINTENANCE);
        this.log.info((Object)"Preparing to shut down storage client subsystem");
        this.storageClientManager.shutdown();
    }

    private void changeServerMode(Server rhqServer, Server.OperationMode mode) {
        if (rhqServer.getOperationMode() == mode) {
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Moving " + rhqServer + " from " + rhqServer.getOperationMode() + " to " + mode));
        }
        this.topologyManager.updateServerMode(this.subjectManager.getOverlord(), new Integer[]{rhqServer.getId()}, mode);
    }
}

