/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.sync.ExporterMessages;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.sync.DefaultImportConfigurationDescriptor;
import org.rhq.enterprise.server.sync.ExportWriter;
import org.rhq.enterprise.server.sync.Synchronizer;
import org.rhq.enterprise.server.sync.exporters.Exporter;
import org.rhq.enterprise.server.sync.exporters.ExportingIterator;
import org.rhq.enterprise.server.sync.util.IndentingXMLStreamWriter;
import org.rhq.enterprise.server.sync.validators.ConsistencyValidator;
import org.rhq.enterprise.server.xmlschema.ConfigurationInstanceDescriptorUtil;

public class ExportingInputStream
extends InputStream {
    private static final Log LOG = LogFactory.getLog(ExportingInputStream.class);
    private Set<Synchronizer<?, ?>> synchronizers;
    private Map<String, ExporterMessages> messagesPerExporter;
    private PipedInputStream inputStream;
    private PipedOutputStream exportOutput;
    private Thread exportRunner;
    private Throwable unexpectedExporterException;
    private boolean zipOutput;
    private Marshaller configurationMarshaller;

    public ExportingInputStream(Set<Synchronizer<?, ?>> synchronizers, Map<String, ExporterMessages> messagesPerExporter) throws IOException {
        this(synchronizers, messagesPerExporter, 65536, true);
    }

    public ExportingInputStream(Set<Synchronizer<?, ?>> synchronizers, Map<String, ExporterMessages> messagesPerExporter, int size, boolean zip) throws IOException {
        this.synchronizers = synchronizers;
        this.messagesPerExporter = messagesPerExporter;
        this.inputStream = new PipedInputStream(size);
        this.exportOutput = new PipedOutputStream(this.inputStream);
        this.zipOutput = zip;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DefaultImportConfigurationDescriptor.class});
            this.configurationMarshaller = context.createMarshaller();
            this.configurationMarshaller.setProperty("jaxb.fragment", (Object)true);
            this.configurationMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.configurationMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        this.checkState();
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkState();
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkState();
        return this.inputStream.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkState();
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.exportRunner.interrupt();
        this.inputStream.close();
        this.exportOutput.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    private void checkState() throws IOException {
        if (this.exportRunner == null) {
            this.exportRunner = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExportingInputStream.this.exporterMain();
                }
            });
            this.exportRunner.setDaemon(true);
            this.exportRunner.setName("Configuration Export Thread");
            this.exportRunner.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            this.exportRunner.start();
        }
        if (this.unexpectedExporterException != null) {
            throw new IOException("The exporter thread failed with an uncaught exception.", this.unexpectedExporterException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void exporterMain() {
        block21: {
            OutputStream out;
            XMLStreamWriter wrt;
            block19: {
                wrt = null;
                out = null;
                XMLOutputFactory ofactory = XMLOutputFactory.newInstance();
                ofactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
                try {
                    out = this.exportOutput;
                    if (this.zipOutput) {
                        out = new GZIPOutputStream(out);
                    }
                    wrt = new IndentingXMLStreamWriter(ofactory.createXMLStreamWriter(out, "UTF-8"));
                }
                catch (XMLStreamException e) {
                    LOG.error((Object)"Failed to create the XML stream writer to output the export file to.", (Throwable)e);
                    if (wrt != null) {
                        try {
                            wrt.close();
                        }
                        catch (XMLStreamException e2) {
                            LOG.warn((Object)"Failed to close the exporter XML stream.", (Throwable)e2);
                        }
                    }
                    ExportingInputStream.safeClose(out);
                    return;
                }
                this.exportPrologue(wrt);
                for (Synchronizer<?, ?> exp : this.synchronizers) {
                    this.exportSingle(wrt, exp);
                }
                this.exportEpilogue(wrt);
                wrt.flush();
                if (wrt == null) break block19;
                try {
                    wrt.close();
                }
                catch (XMLStreamException e) {
                    LOG.warn((Object)"Failed to close the exporter XML stream.", (Throwable)e);
                }
            }
            ExportingInputStream.safeClose(out);
            break block21;
            catch (Exception e) {
                block20: {
                    try {
                        LOG.error((Object)"Error while exporting.", (Throwable)e);
                        this.unexpectedExporterException = e;
                        if (wrt == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (wrt != null) {
                            try {
                                wrt.close();
                            }
                            catch (XMLStreamException e3) {
                                LOG.warn((Object)"Failed to close the exporter XML stream.", (Throwable)e3);
                            }
                        }
                        ExportingInputStream.safeClose(out);
                        throw throwable;
                    }
                    try {
                        wrt.close();
                    }
                    catch (XMLStreamException e4) {
                        LOG.warn((Object)"Failed to close the exporter XML stream.", (Throwable)e4);
                    }
                }
                ExportingInputStream.safeClose(out);
            }
        }
    }

    private void exportPrologue(XMLStreamWriter wrt) throws XMLStreamException {
        wrt.setDefaultNamespace("urn:xmlns:rhq-configuration-export");
        wrt.writeStartDocument();
        wrt.writeStartElement("urn:xmlns:rhq-configuration-export", "configuration-export");
        wrt.writeNamespace("ci", "urn:xmlns:rhq-configuration-instance");
        wrt.writeNamespace("c", "urn:xmlns:rhq-configuration");
        this.writeValidators(wrt);
    }

    private void writeValidators(XMLStreamWriter wrt) throws XMLStreamException {
        HashSet<ConsistencyValidator> allValidators = new HashSet<ConsistencyValidator>();
        for (Synchronizer<?, ?> syn : this.synchronizers) {
            allValidators.addAll(syn.getRequiredValidators());
        }
        for (ConsistencyValidator cv : allValidators) {
            wrt.writeStartElement("validator");
            wrt.writeAttribute("class", cv.getClass().getName());
            cv.exportState(new ExportWriter(wrt));
            wrt.writeEndElement();
        }
    }

    private void exportEpilogue(XMLStreamWriter wrt) throws XMLStreamException {
        wrt.writeEndDocument();
    }

    private void exportSingle(XMLStreamWriter wrt, Synchronizer<?, ?> syn) throws XMLStreamException {
        ExporterMessages messages = new ExporterMessages();
        this.messagesPerExporter.put(syn.getClass().getName(), messages);
        wrt.writeStartElement("urn:xmlns:rhq-configuration-export", "entities");
        wrt.writeAttribute("id", syn.getClass().getName());
        Exporter<?, ?> exp = syn.getExporter();
        ExportingIterator<?> it = exp.getExportingIterator();
        DefaultImportConfigurationDescriptor importConfig = this.getDefaultImportConfiguraton(syn);
        if (importConfig != null) {
            try {
                this.configurationMarshaller.marshal((Object)importConfig, wrt);
            }
            catch (JAXBException e) {
                throw new XMLStreamException(e);
            }
        }
        messages.setPerEntityErrorMessages(new ArrayList());
        messages.setPerEntityNotes(new ArrayList());
        while (it.hasNext()) {
            it.next();
            wrt.writeStartElement("urn:xmlns:rhq-configuration-export", "entity");
            wrt.writeStartElement("urn:xmlns:rhq-configuration-export", "data");
            Exception exportError = null;
            try {
                it.export(new ExportWriter(wrt));
            }
            catch (XMLStreamException e) {
                throw e;
            }
            catch (Exception e) {
                exportError = e;
            }
            wrt.writeEndElement();
            if (exportError == null) {
                String notes = it.getNotes();
                if (notes != null) {
                    messages.getPerEntityNotes().add(notes);
                    wrt.writeStartElement("urn:xmlns:rhq-configuration-export", "notes");
                    wrt.writeCharacters(notes);
                    wrt.writeEndElement();
                }
            } else {
                String message = ThrowableUtil.getStackAsString((Throwable)exportError);
                messages.getPerEntityErrorMessages().add(message);
                wrt.writeStartElement("urn:xmlns:rhq-configuration-export", "error-message");
                wrt.writeCharacters(message);
                wrt.writeEndElement();
            }
            wrt.writeEndElement();
        }
        String notes = exp.getNotes();
        messages.setExporterNotes(notes);
        if (notes != null) {
            wrt.writeStartElement("urn:xmlns:rhq-configuration-export", "notes");
            wrt.writeCharacters(notes);
            wrt.writeEndElement();
        }
        wrt.writeEndElement();
    }

    private static void safeClose(Closeable str) {
        try {
            if (str != null) {
                str.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to close an output stream. This shouldn't happen.", (Throwable)e);
        }
    }

    private DefaultImportConfigurationDescriptor getDefaultImportConfiguraton(Synchronizer<?, ?> synchronizer) {
        ConfigurationTemplate template;
        DefaultImportConfigurationDescriptor ret = null;
        ConfigurationDefinition def = synchronizer.getImporter().getImportConfigurationDefinition();
        if (def != null && (template = def.getDefaultTemplate()) != null) {
            ret = DefaultImportConfigurationDescriptor.create(ConfigurationInstanceDescriptorUtil.createConfigurationInstance((ConfigurationDefinition)def, (Configuration)template.getConfiguration()));
        }
        return ret;
    }
}

