/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.Iterator;
import java.util.List;

public class BatchIterator<T>
implements Iterable<List<T>> {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private int batchSize;
    private int index;
    private List<T> data;

    @Override
    public Iterator<List<T>> iterator() {
        return new Iterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return BatchIterator.this.hasMoreBatches();
            }

            @Override
            public List<T> next() {
                return BatchIterator.this.getNextBatch();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This iterator does not support the remove operation");
            }
        };
    }

    public BatchIterator(List<T> data) {
        this(data, 1000);
    }

    public BatchIterator(List<T> data, int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batch size must be greater than zero");
        }
        this.batchSize = batchSize;
        this.index = 0;
        this.data = data;
    }

    public boolean hasMoreBatches() {
        return this.index < this.data.size();
    }

    public List<T> getNextBatch() {
        List<T> batch = null;
        if (this.index + this.batchSize < this.data.size()) {
            batch = this.data.subList(this.index, this.index + this.batchSize);
            this.index += this.batchSize;
        } else {
            batch = this.data.subList(this.index, this.data.size());
            this.index = this.data.size();
        }
        return batch;
    }
}

