/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.management.ManagementFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.stat.Statistics;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.enterprise.server.util.HibernateStatisticsStopWatch;
import org.rhq.enterprise.server.util.LookupUtil;

public class HibernatePerformanceMonitor {
    private static final Log log = LogFactory.getLog(HibernatePerformanceMonitor.class);
    private ConcurrentMap<Long, HibernateStatisticsStopWatch> watches;
    private static HibernatePerformanceMonitor singleton = new HibernatePerformanceMonitor();
    private AtomicLong idGenerator = new AtomicLong(0L);

    private HibernatePerformanceMonitor() {
        this.watches = new ConcurrentHashMap<Long, HibernateStatisticsStopWatch>();
    }

    public static HibernatePerformanceMonitor get() {
        return singleton;
    }

    public static boolean isLoggingEnabled() {
        return log.isDebugEnabled();
    }

    public void zeroStats() {
        if (HibernatePerformanceMonitor.isLoggingEnabled()) {
            EntityManager entityManager = LookupUtil.getEntityManager();
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            Statistics stats = PersistenceUtility.getStatisticsService((EntityManager)entityManager, (MBeanServer)platformMBeanServer);
            stats.clear();
        }
    }

    public long start() {
        if (HibernatePerformanceMonitor.isLoggingEnabled()) {
            EntityManager entityManager = LookupUtil.getEntityManager();
            HibernateStatisticsStopWatch watch = new HibernateStatisticsStopWatch(entityManager);
            long id = this.idGenerator.incrementAndGet();
            this.watches.put(id, watch);
            watch.start();
            return id;
        }
        return 0L;
    }

    public void stop(long id, String logPrefix) {
        if (HibernatePerformanceMonitor.isLoggingEnabled()) {
            HibernateStatisticsStopWatch watch = (HibernateStatisticsStopWatch)this.watches.remove(id);
            if (watch == null) {
                return;
            }
            watch.stop();
            String cause = "";
            if (watch.getQueryExecutions() != 0L) {
                if ((double)watch.getConnects() / (double)(watch.getEntityLoads() + watch.getQueryExecutions()) >= 5.0) {
                    cause = "(perf: N+1 issue?) ";
                }
                if ((double)watch.getTransations() / (double)watch.getQueryExecutions() >= 5.0) {
                    cause = "(perf: xaction nesting?) ";
                } else if (watch.getTransations() > 10L) {
                    cause = "(perf: too many xactions?)";
                }
            }
            if (watch.getTime() > 3000L) {
                cause = "(perf: slowness?) ";
            }
            String callingContext = " for " + (logPrefix == null ? "(unknown)" : logPrefix);
            log.debug((Object)(watch.toString() + cause + callingContext));
        }
    }
}

