/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.mx.util.MBeanProxyExt;
import org.jetbrains.annotations.NotNull;
import org.rhq.enterprise.server.alert.AlertConditionManagerBean;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerBean;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerBean;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerBean;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerBean;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerBean;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerBean;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.jms.AlertConditionConsumerBean;
import org.rhq.enterprise.server.alert.engine.jms.CachedConditionProducerBean;
import org.rhq.enterprise.server.alert.engine.jms.CachedConditionProducerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerBean;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferencesCacheBean;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferencesCacheLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerBean;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerBean;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerBean;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.cloud.AffinityGroupManagerBean;
import org.rhq.enterprise.server.cloud.AffinityGroupManagerLocal;
import org.rhq.enterprise.server.cloud.FailoverListManagerBean;
import org.rhq.enterprise.server.cloud.FailoverListManagerLocal;
import org.rhq.enterprise.server.cloud.PartitionEventManagerBean;
import org.rhq.enterprise.server.cloud.PartitionEventManagerLocal;
import org.rhq.enterprise.server.cloud.StatusManagerBean;
import org.rhq.enterprise.server.cloud.StatusManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerBean;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.cloud.TopologyManagerBean;
import org.rhq.enterprise.server.cloud.TopologyManagerLocal;
import org.rhq.enterprise.server.cloud.instance.CacheConsistencyManagerBean;
import org.rhq.enterprise.server.cloud.instance.CacheConsistencyManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerBean;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.common.EntityManagerFacade;
import org.rhq.enterprise.server.common.EntityManagerFacadeLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerBean;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.configuration.DynamicConfigurationPropertyBean;
import org.rhq.enterprise.server.configuration.DynamicConfigurationPropertyLocal;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerBean;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.content.AdvisoryManagerBean;
import org.rhq.enterprise.server.content.AdvisoryManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerBean;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerBean;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerBean;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.content.DistributionManagerBean;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerBean;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerBean;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerBean;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.EmailManagerBean;
import org.rhq.enterprise.server.core.EmailManagerLocal;
import org.rhq.enterprise.server.core.RemoteClientManagerBean;
import org.rhq.enterprise.server.core.RemoteClientManagerLocal;
import org.rhq.enterprise.server.core.StartupBean;
import org.rhq.enterprise.server.core.StartupLocal;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.dashboard.DashboardManagerBean;
import org.rhq.enterprise.server.dashboard.DashboardManagerLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossBean;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.drift.DriftManagerBean;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.drift.DriftTemplateManagerBean;
import org.rhq.enterprise.server.drift.DriftTemplateManagerLocal;
import org.rhq.enterprise.server.drift.JPADriftServerBean;
import org.rhq.enterprise.server.drift.JPADriftServerLocal;
import org.rhq.enterprise.server.event.EventManagerBean;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerBean;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerLocal;
import org.rhq.enterprise.server.inventory.InventoryManagerBean;
import org.rhq.enterprise.server.inventory.InventoryManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerBean;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerBean;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementBaselineManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementCompressionManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementCompressionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementProblemManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementProblemManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementViewManagerBean;
import org.rhq.enterprise.server.measurement.MeasurementViewManagerLocal;
import org.rhq.enterprise.server.measurement.MetricsManagerBean;
import org.rhq.enterprise.server.measurement.MetricsManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerBean;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.plugin.ServerPluginsBean;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceMBean;
import org.rhq.enterprise.server.report.DataAccessManagerBean;
import org.rhq.enterprise.server.report.DataAccessManagerLocal;
import org.rhq.enterprise.server.resource.PlatformUtilizationManagerBean;
import org.rhq.enterprise.server.resource.PlatformUtilizationManagerLocal;
import org.rhq.enterprise.server.resource.ProductVersionManagerBean;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerBean;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceBossBean;
import org.rhq.enterprise.server.resource.ResourceBossLocal;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerBean;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerBean;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerBean;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerRemote;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerBean;
import org.rhq.enterprise.server.resource.cluster.ClusterManagerLocal;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerBean;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerBean;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionExpressionBuilderManagerBean;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionExpressionBuilderManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerBean;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerBean;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerBean;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerBean;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.search.SavedSearchManagerBean;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.subsystem.AlertSubsystemManagerBean;
import org.rhq.enterprise.server.subsystem.AlertSubsystemManagerLocal;
import org.rhq.enterprise.server.subsystem.ConfigurationSubsystemManagerBean;
import org.rhq.enterprise.server.subsystem.ConfigurationSubsystemManagerLocal;
import org.rhq.enterprise.server.subsystem.OperationHistorySubsystemManagerBean;
import org.rhq.enterprise.server.subsystem.OperationHistorySubsystemManagerLocal;
import org.rhq.enterprise.server.support.SupportManagerBean;
import org.rhq.enterprise.server.support.SupportManagerLocal;
import org.rhq.enterprise.server.sync.SynchronizationManagerBean;
import org.rhq.enterprise.server.sync.SynchronizationManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerBean;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.tagging.TagManagerBean;
import org.rhq.enterprise.server.tagging.TagManagerLocal;
import org.rhq.enterprise.server.test.TestBean;
import org.rhq.enterprise.server.test.TestLocal;

public final class LookupUtil {
    private LookupUtil() {
    }

    public static DataSource getDataSource() {
        try {
            InitialContext context = new InitialContext();
            DataSource ds = (DataSource)context.lookup("java:jboss/datasources/RHQDS");
            context.close();
            return ds;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get the data source", e);
        }
    }

    public static TransactionManager getTransactionManager() {
        try {
            InitialContext context = new InitialContext();
            String jndi = "java:jboss/TransactionManager";
            TransactionManager tm = (TransactionManager)context.lookup(jndi);
            context.close();
            return tm;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get the transaction manager", e);
        }
    }

    public static EntityManager getEntityManager() {
        try {
            InitialContext context = new InitialContext();
            EntityManagerFactory factory = (EntityManagerFactory)context.lookup("java:jboss/RHQEntityManagerFactory");
            context.close();
            return factory.createEntityManager();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create an entity manager", e);
        }
    }

    public static CachedConditionProducerBean getActiveConditionProducer() {
        return LookupUtil.lookupLocal(CachedConditionProducerBean.class);
    }

    public static AlertConditionConsumerBean getActiveConditionConsumer() {
        return LookupUtil.lookupLocal(AlertConditionConsumerBean.class);
    }

    public static RemoteClientManagerLocal getRemoteClientManager() {
        return (RemoteClientManagerLocal)LookupUtil.lookupLocal(RemoteClientManagerBean.class);
    }

    public static AgentManagerLocal getAgentManager() {
        return (AgentManagerLocal)LookupUtil.lookupLocal(AgentManagerBean.class);
    }

    public static AlertConditionCacheManagerLocal getAlertConditionCacheManager() {
        return (AlertConditionCacheManagerLocal)LookupUtil.lookupLocal(AlertConditionCacheManagerBean.class);
    }

    public static AlertConditionManagerLocal getAlertConditionManager() {
        return (AlertConditionManagerLocal)LookupUtil.lookupLocal(AlertConditionManagerBean.class);
    }

    public static AlertDefinitionManagerLocal getAlertDefinitionManager() {
        return (AlertDefinitionManagerLocal)LookupUtil.lookupLocal(AlertDefinitionManagerBean.class);
    }

    public static GroupAlertDefinitionManagerLocal getGroupAlertDefinitionManager() {
        return (GroupAlertDefinitionManagerLocal)LookupUtil.lookupLocal(GroupAlertDefinitionManagerBean.class);
    }

    public static AlertManagerLocal getAlertManager() {
        return (AlertManagerLocal)LookupUtil.lookupLocal(AlertManagerBean.class);
    }

    public static AlertNotificationManagerLocal getAlertNotificationManager() {
        return (AlertNotificationManagerLocal)LookupUtil.lookupLocal(AlertNotificationManagerBean.class);
    }

    public static AlertTemplateManagerLocal getAlertTemplateManager() {
        return (AlertTemplateManagerLocal)LookupUtil.lookupLocal(AlertTemplateManagerBean.class);
    }

    public static AlertSubsystemManagerLocal getAlertSubsystemManager() {
        return (AlertSubsystemManagerLocal)LookupUtil.lookupLocal(AlertSubsystemManagerBean.class);
    }

    public static AuthorizationManagerLocal getAuthorizationManager() {
        return (AuthorizationManagerLocal)LookupUtil.lookupLocal(AuthorizationManagerBean.class);
    }

    public static AvailabilityManagerLocal getAvailabilityManager() {
        return (AvailabilityManagerLocal)LookupUtil.lookupLocal(AvailabilityManagerBean.class);
    }

    public static BundleManagerLocal getBundleManager() {
        return (BundleManagerLocal)LookupUtil.lookupLocal(BundleManagerBean.class);
    }

    public static CallTimeDataManagerLocal getCallTimeDataManager() {
        return (CallTimeDataManagerLocal)LookupUtil.lookupLocal(CallTimeDataManagerBean.class);
    }

    public static ConfigurationManagerLocal getConfigurationManager() {
        return (ConfigurationManagerLocal)LookupUtil.lookupLocal(ConfigurationManagerBean.class);
    }

    public static DynamicConfigurationPropertyLocal getDynamicConfigurationProperty() {
        return (DynamicConfigurationPropertyLocal)LookupUtil.lookupLocal(DynamicConfigurationPropertyBean.class);
    }

    public static ConfigurationSubsystemManagerLocal getConfigurationSubsystemManager() {
        return (ConfigurationSubsystemManagerLocal)LookupUtil.lookupLocal(ConfigurationSubsystemManagerBean.class);
    }

    public static ContentManagerLocal getContentManager() {
        return (ContentManagerLocal)LookupUtil.lookupLocal(ContentManagerBean.class);
    }

    public static ContentUIManagerLocal getContentUIManager() {
        return (ContentUIManagerLocal)LookupUtil.lookupLocal(ContentUIManagerBean.class);
    }

    public static DiscoveryBossLocal getDiscoveryBoss() {
        return (DiscoveryBossLocal)LookupUtil.lookupLocal(DiscoveryBossBean.class);
    }

    public static EmailManagerLocal getEmailManagerBean() {
        return (EmailManagerLocal)LookupUtil.lookupLocal(EmailManagerBean.class);
    }

    public static EntityManagerFacadeLocal getEntityManagerFacade() {
        Class<EntityManagerFacade> clazz = EntityManagerFacade.class;
        return (EntityManagerFacadeLocal)LookupUtil.lookupByName(clazz.getSimpleName(), clazz.getName() + "Local");
    }

    public static EventManagerLocal getEventManager() {
        return (EventManagerLocal)LookupUtil.lookupLocal(EventManagerBean.class);
    }

    public static FailoverListManagerLocal getFailoverListManager() {
        return (FailoverListManagerLocal)LookupUtil.lookupLocal(FailoverListManagerBean.class);
    }

    public static GroupDefinitionManagerLocal getGroupDefinitionManager() {
        return (GroupDefinitionManagerLocal)LookupUtil.lookupLocal(GroupDefinitionManagerBean.class);
    }

    public static GroupDefinitionExpressionBuilderManagerLocal getGroupDefinitionExpressionBuilderManager() {
        return (GroupDefinitionExpressionBuilderManagerLocal)LookupUtil.lookupLocal(GroupDefinitionExpressionBuilderManagerBean.class);
    }

    public static MetricsManagerLocal getMetricsManager() {
        return (MetricsManagerLocal)LookupUtil.lookupLocal(MetricsManagerBean.class);
    }

    public static MeasurementDefinitionManagerLocal getMeasurementDefinitionManager() {
        return (MeasurementDefinitionManagerLocal)LookupUtil.lookupLocal(MeasurementDefinitionManagerBean.class);
    }

    public static MeasurementScheduleManagerLocal getMeasurementScheduleManager() {
        return (MeasurementScheduleManagerLocal)LookupUtil.lookupLocal(MeasurementScheduleManagerBean.class);
    }

    public static MeasurementDataManagerLocal getMeasurementDataManager() {
        return (MeasurementDataManagerLocal)LookupUtil.lookupLocal(MeasurementDataManagerBean.class);
    }

    public static MeasurementChartsManagerLocal getMeasurementChartsManager() {
        return (MeasurementChartsManagerLocal)LookupUtil.lookupLocal(MeasurementChartsManagerBean.class);
    }

    public static MeasurementCompressionManagerLocal getMeasurementCompressionManager() {
        return (MeasurementCompressionManagerLocal)LookupUtil.lookupLocal(MeasurementCompressionManagerBean.class);
    }

    public static MeasurementProblemManagerLocal getMeasurementProblemManager() {
        return (MeasurementProblemManagerLocal)LookupUtil.lookupLocal(MeasurementProblemManagerBean.class);
    }

    public static MeasurementViewManagerLocal getMeasurementViewManager() {
        return (MeasurementViewManagerLocal)LookupUtil.lookupLocal(MeasurementViewManagerBean.class);
    }

    public static MeasurementBaselineManagerLocal getMeasurementBaselineManager() {
        return (MeasurementBaselineManagerLocal)LookupUtil.lookupLocal(MeasurementBaselineManagerBean.class);
    }

    public static MeasurementOOBManagerLocal getOOBManager() {
        return (MeasurementOOBManagerLocal)LookupUtil.lookupLocal(MeasurementOOBManagerBean.class);
    }

    public static OperationManagerLocal getOperationManager() {
        return (OperationManagerLocal)LookupUtil.lookupLocal(OperationManagerBean.class);
    }

    public static OperationHistorySubsystemManagerLocal getOperationHistorySubsystemManager() {
        return (OperationHistorySubsystemManagerLocal)LookupUtil.lookupLocal(OperationHistorySubsystemManagerBean.class);
    }

    public static PartitionEventManagerLocal getPartitionEventManager() {
        return (PartitionEventManagerLocal)LookupUtil.lookupLocal(PartitionEventManagerBean.class);
    }

    public static ConfigurationMetadataManagerLocal getConfigurationMetadataManager() {
        return (ConfigurationMetadataManagerLocal)LookupUtil.lookupLocal(ConfigurationMetadataManagerBean.class);
    }

    public static ContentSourceMetadataManagerLocal getContentSourceMetadataManager() {
        return (ContentSourceMetadataManagerLocal)LookupUtil.lookupLocal(ContentSourceMetadataManagerBean.class);
    }

    public static ContentSourceManagerLocal getContentSourceManager() {
        return (ContentSourceManagerLocal)LookupUtil.lookupLocal(ContentSourceManagerBean.class);
    }

    public static DriftManagerLocal getDriftManager() {
        return (DriftManagerLocal)LookupUtil.lookupLocal(DriftManagerBean.class);
    }

    public static DriftTemplateManagerLocal getDriftTemplateManager() {
        return (DriftTemplateManagerLocal)LookupUtil.lookupLocal(DriftTemplateManagerBean.class);
    }

    public static JPADriftServerLocal getJPADriftServer() {
        return (JPADriftServerLocal)LookupUtil.lookupLocal(JPADriftServerBean.class);
    }

    public static RepoManagerLocal getRepoManagerLocal() {
        return (RepoManagerLocal)LookupUtil.lookupLocal(RepoManagerBean.class);
    }

    public static DistributionManagerLocal getDistributionManagerLocal() {
        return (DistributionManagerLocal)LookupUtil.lookupLocal(DistributionManagerBean.class);
    }

    public static AdvisoryManagerLocal getAdvisoryManagerLocal() {
        return (AdvisoryManagerLocal)LookupUtil.lookupLocal(AdvisoryManagerBean.class);
    }

    public static AffinityGroupManagerLocal getAffinityGroupManager() {
        return (AffinityGroupManagerLocal)LookupUtil.lookupLocal(AffinityGroupManagerBean.class);
    }

    public static TopologyManagerLocal getTopologyManager() {
        return (TopologyManagerLocal)LookupUtil.lookupLocal(TopologyManagerBean.class);
    }

    public static StorageNodeManagerLocal getStorageNodeManager() {
        return (StorageNodeManagerLocal)LookupUtil.lookupLocal(StorageNodeManagerBean.class);
    }

    public static ClusterManagerLocal getClusterManager() {
        return (ClusterManagerLocal)LookupUtil.lookupLocal(ClusterManagerBean.class);
    }

    public static ServerManagerLocal getServerManager() {
        return (ServerManagerLocal)LookupUtil.lookupLocal(ServerManagerBean.class);
    }

    public static CacheConsistencyManagerLocal getCacheConsistencyManager() {
        return (CacheConsistencyManagerLocal)LookupUtil.lookupLocal(CacheConsistencyManagerBean.class);
    }

    public static RemoteInstallManagerLocal getRemoteInstallManager() {
        return (RemoteInstallManagerLocal)LookupUtil.lookupLocal(RemoteInstallManagerBean.class);
    }

    public static PluginManagerLocal getPluginManager() {
        return (PluginManagerLocal)LookupUtil.lookupLocal(PluginManagerBean.class);
    }

    public static ResourceMetadataManagerLocal getResourceMetadataManager() {
        return (ResourceMetadataManagerLocal)LookupUtil.lookupLocal(ResourceMetadataManagerBean.class);
    }

    public static ResourceBossLocal getResourceBoss() {
        return (ResourceBossLocal)LookupUtil.lookupLocal(ResourceBossBean.class);
    }

    public static ResourceGroupManagerLocal getResourceGroupManager() {
        return (ResourceGroupManagerLocal)LookupUtil.lookupLocal(ResourceGroupManagerBean.class);
    }

    public static ResourceManagerLocal getResourceManager() {
        return (ResourceManagerLocal)LookupUtil.lookupLocal(ResourceManagerBean.class);
    }

    public static ResourceAvailabilityManagerLocal getResourceAvailabilityManager() {
        return (ResourceAvailabilityManagerLocal)LookupUtil.lookupLocal(ResourceAvailabilityManagerBean.class);
    }

    public static ResourceFactoryManagerLocal getResourceFactoryManager() {
        return (ResourceFactoryManagerLocal)LookupUtil.lookupLocal(ResourceFactoryManagerBean.class);
    }

    public static ResourceTypeManagerLocal getResourceTypeManager() {
        return (ResourceTypeManagerLocal)LookupUtil.lookupLocal(ResourceTypeManagerBean.class);
    }

    public static ResourceTypeManagerRemote getResourceTypeManagerRemote() {
        return (ResourceTypeManagerRemote)LookupUtil.lookupRemote(ResourceTypeManagerBean.class);
    }

    public static RoleManagerLocal getRoleManager() {
        return (RoleManagerLocal)LookupUtil.lookupLocal(RoleManagerBean.class);
    }

    public static SchedulerLocal getSchedulerBean() {
        return (SchedulerLocal)LookupUtil.lookupLocal(SchedulerBean.class);
    }

    public static SavedSearchManagerLocal getSavedSearchManager() {
        return (SavedSearchManagerLocal)LookupUtil.lookupLocal(SavedSearchManagerBean.class);
    }

    public static SubjectManagerLocal getSubjectManager() {
        return (SubjectManagerLocal)LookupUtil.lookupLocal(SubjectManagerBean.class);
    }

    public static SystemManagerLocal getSystemManager() {
        return (SystemManagerLocal)LookupUtil.lookupLocal(SystemManagerBean.class);
    }

    public static ProductVersionManagerLocal getProductVersionManager() {
        return (ProductVersionManagerLocal)LookupUtil.lookupLocal(ProductVersionManagerBean.class);
    }

    public static CachedConditionProducerLocal getCachedConditionProducerLocal() {
        return (CachedConditionProducerLocal)LookupUtil.lookupLocal(CachedConditionProducerBean.class);
    }

    public static SupportManagerLocal getSupportManager() {
        return (SupportManagerLocal)LookupUtil.lookupLocal(SupportManagerBean.class);
    }

    public static StatusManagerLocal getStatusManager() {
        return (StatusManagerLocal)LookupUtil.lookupLocal(StatusManagerBean.class);
    }

    public static ServerPluginsLocal getServerPlugins() {
        return (ServerPluginsLocal)LookupUtil.lookupLocal(ServerPluginsBean.class);
    }

    public static TagManagerLocal getTagManager() {
        return (TagManagerLocal)LookupUtil.lookupLocal(TagManagerBean.class);
    }

    public static InventoryManagerLocal getInventoryManager() {
        return (InventoryManagerLocal)LookupUtil.lookupLocal(InventoryManagerBean.class);
    }

    public static DashboardManagerLocal getDashboardManagerLocal() {
        return (DashboardManagerLocal)LookupUtil.lookupLocal(DashboardManagerBean.class);
    }

    public static SynchronizationManagerLocal getSynchronizationManager() {
        return (SynchronizationManagerLocal)LookupUtil.lookupLocal(SynchronizationManagerBean.class);
    }

    public static PlatformUtilizationManagerLocal getPlatformUtilizationManager() {
        return (PlatformUtilizationManagerLocal)LookupUtil.lookupLocal(PlatformUtilizationManagerBean.class);
    }

    public static SubjectPreferencesCacheLocal getSubjectPreferencesCache() {
        return (SubjectPreferencesCacheLocal)LookupUtil.lookupLocal(SubjectPreferencesCacheBean.class);
    }

    public static StartupLocal getStartupLocal() {
        return (StartupLocal)LookupUtil.lookupLocal(StartupBean.class);
    }

    public static CoreServerMBean getCoreServer() {
        MBeanServer mbs = LookupUtil.getJBossMBeanServer();
        CoreServerMBean rhqServer = (CoreServerMBean)MBeanProxyExt.create(CoreServerMBean.class, (ObjectName)CoreServerMBean.OBJECT_NAME, (MBeanServer)mbs);
        return rhqServer;
    }

    public static PluginDeploymentScannerMBean getPluginDeploymentScanner() {
        MBeanServer jBossMBeanServer = LookupUtil.getJBossMBeanServer();
        PluginDeploymentScannerMBean scanner = (PluginDeploymentScannerMBean)MBeanProxyExt.create(PluginDeploymentScannerMBean.class, (ObjectName)PluginDeploymentScannerMBean.OBJECT_NAME, (MBeanServer)jBossMBeanServer);
        return scanner;
    }

    public static ServerPluginServiceMBean getServerPluginService() {
        MBeanServer jBossMBeanServer = LookupUtil.getJBossMBeanServer();
        ServerPluginServiceMBean service = (ServerPluginServiceMBean)MBeanProxyExt.create(ServerPluginServiceMBean.class, (ObjectName)ServerPluginServiceMBean.OBJECT_NAME, (MBeanServer)jBossMBeanServer);
        return service;
    }

    private static MBeanServer getJBossMBeanServer() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        return mbs;
    }

    public static Object getEjb(String beanName, String interfaceName) {
        return LookupUtil.lookupByName(beanName, interfaceName);
    }

    public static TestLocal getTest() {
        return (TestLocal)LookupUtil.lookupLocal(TestBean.class);
    }

    private static String getLocalJNDIName(String beanName, String interfaceName) {
        return "java:global/rhq/rhq-enterprise-server-ejb3/" + beanName + "!" + interfaceName;
    }

    private static <T> String getLocalJNDIName(@NotNull Class<? extends T> beanClass) {
        return LookupUtil.getLocalJNDIName(beanClass.getSimpleName(), beanClass.getName().replace("Bean", "Local"));
    }

    private static <T> String getRemoteJNDIName(@NotNull Class<? extends T> beanClass) {
        return "java:global/rhq/rhq-enterprise-server-ejb3/" + beanClass.getSimpleName() + "!" + beanClass.getName().replace("Bean", "Remote");
    }

    private static <T> T lookupLocal(Class<? extends T> type) {
        String localJNDIName = "-not initialized-";
        try {
            localJNDIName = LookupUtil.getLocalJNDIName(type);
            return (T)LookupUtil.lookup(localJNDIName);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup local interface to EJB " + type + ", localJNDI=[" + localJNDIName + "]", e);
        }
    }

    private static Object lookupByName(String beanName, String localInterfaceName) {
        String localJNDIName = "-not initialized-";
        try {
            localJNDIName = LookupUtil.getLocalJNDIName(beanName, localInterfaceName);
            return LookupUtil.lookup(localJNDIName);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup local interface to EJB " + beanName + ", localJNDI=[" + localJNDIName + "]", e);
        }
    }

    private static <T> T lookupRemote(Class<? extends T> type) {
        try {
            return (T)LookupUtil.lookup(LookupUtil.getRemoteJNDIName(type));
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup remote interface to EJB " + type, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lookup(String name) throws NamingException {
        InitialContext initialContext = new InitialContext();
        try {
            Object object = initialContext.lookup(name);
            return object;
        }
        finally {
            initialContext.close();
        }
    }

    public static DataAccessManagerLocal getDataAccessManager() {
        return (DataAccessManagerLocal)LookupUtil.lookupLocal(DataAccessManagerBean.class);
    }

    public static LdapGroupManagerLocal getLdapGroupManager() {
        return (LdapGroupManagerLocal)LookupUtil.lookupLocal(LdapGroupManagerBean.class);
    }
}

