/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.clientapi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.rhq.bindings.client.AbstractRhqFacade;
import org.rhq.bindings.client.RhqManager;
import org.rhq.bindings.util.InterfaceSimplifier;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.enterprise.clientapi.RemoteClientProxy;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.server.auth.SubjectManagerRemote;
import org.rhq.enterprise.server.system.SystemManagerRemote;

public class RemoteClient
extends AbstractRhqFacade {
    private static final Log LOG = LogFactory.getLog(RemoteClient.class);
    public static final String NONSECURE_TRANSPORT = "servlet";
    public static final String SECURE_TRANSPORT = "sslservlet";
    private String transport;
    private final String host;
    private final int port;
    private boolean loggedIn;
    private boolean connected;
    private Map<RhqManager, Object> managers;
    private Subject subject;
    private Client remotingClient;
    private String subsystem = null;
    private ProductInfo serverInfo = null;

    public RemoteClient(String host, int port) {
        this(null, host, port);
    }

    public RemoteClient(String transport, String host, int port) {
        this(transport, host, port, null);
    }

    public RemoteClient(String transport, String host, int port, String subsystem) {
        this.transport = transport != null ? transport : this.guessTransport(port);
        this.host = host;
        this.port = port;
        this.subsystem = subsystem;
    }

    public <T> T remoteInvoke(RhqManager manager, Method method, Class<T> expectedReturnType, Object ... parameters) throws Throwable {
        String methodSig = manager.remote().getName() + ":" + method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        String[] paramSig = new String[paramTypes.length];
        for (int x = 0; x < paramTypes.length; ++x) {
            paramSig[x] = paramTypes[x].getName();
        }
        NameBasedInvocation request = new NameBasedInvocation(methodSig, parameters, paramSig);
        Object response = this.getRemotingClient().invoke((Object)request);
        if (response instanceof Throwable) {
            throw (Throwable)response;
        }
        return response == null ? null : (T)expectedReturnType.cast(response);
    }

    public Subject login(String user, String password) throws Exception {
        this.logout();
        this.doConnect();
        Method loginMethod = SubjectManagerRemote.class.getDeclaredMethod("login", String.class, String.class);
        try {
            this.subject = this.remoteInvoke(RhqManager.SubjectManager, loginMethod, Subject.class, user, password);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception("Failed to login due to a throwable of type " + e.getClass().getName(), e);
        }
        this.loggedIn = true;
        return this.subject;
    }

    public void logout() {
        if (this.loggedIn && this.subject != null) {
            try {
                Method logoutMethod = SubjectManagerRemote.class.getDeclaredMethod("logout", Subject.class);
                this.remoteInvoke(RhqManager.SubjectManager, logoutMethod, Void.class, this.subject);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Couldn't find the logout method on the SubjectManagerRemote interface.", e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.doDisconnect();
        this.subject = null;
        this.loggedIn = false;
    }

    public void connect() throws Exception {
        if (this.loggedIn) {
            String name = null == this.subject ? "" : this.subject.getName();
            throw new IllegalStateException("User " + name + " must log out before connection can be established.");
        }
        this.doDisconnect();
        this.doConnect();
        this.connected = true;
    }

    public void disconnect() {
        if (this.loggedIn) {
            String name = null == this.subject ? "" : this.subject.getName();
            throw new IllegalStateException("User " + name + " is logged in. Call logout() instead of disconnect().");
        }
        this.doDisconnect();
        this.connected = false;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public URI getRemoteURI() {
        try {
            return new URI(this.getTransport(), null, this.getHost(), this.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Error creating the remote URI with transport, host and port: " + this.getTransport() + ", " + this.getHost() + " and " + this.getPort()), (Throwable)e);
            return null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    protected String guessTransport(int port) {
        return String.valueOf(port).endsWith("443") ? SECURE_TRANSPORT : NONSECURE_TRANSPORT;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public Map<RhqManager, Object> getScriptingAPI() {
        if (this.managers == null) {
            this.managers = new HashMap<RhqManager, Object>();
            for (RhqManager manager : RhqManager.values()) {
                if (!manager.enabled()) continue;
                try {
                    Object proxy = RemoteClient.getProcessor(this, manager, true);
                    this.managers.put(manager, proxy);
                }
                catch (Throwable e) {
                    LOG.error((Object)("Failed to load manager " + manager + " due to missing class."), e);
                }
            }
        }
        return this.managers;
    }

    public <T> T getProxy(Class<T> remoteApiIface) {
        RhqManager manager = RhqManager.forInterface(remoteApiIface);
        if (manager == null) {
            throw new IllegalArgumentException("Unknown remote interface " + remoteApiIface);
        }
        return RemoteClient.getProcessor(this, manager, false);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + "transport=" + this.transport + ", host=" + this.host + ", port=" + this.port + ", subsystem=" + this.subsystem + ", connected=" + this.connected + ", loggedIn=" + this.loggedIn + ", subject=" + this.subject + ']';
    }

    Client getRemotingClient() {
        return this.remotingClient;
    }

    public String getServerVersion() {
        return this.serverInfo != null ? this.serverInfo.getVersion() : null;
    }

    public String getServerVersionUpdate() {
        return this.serverInfo != null ? this.serverInfo.getVersionUpdate() : null;
    }

    public String getServerBuildNumber() {
        return this.serverInfo != null ? this.serverInfo.getBuildNumber() : null;
    }

    private static <T> T getProcessor(RemoteClient remoteClient, RhqManager manager, boolean simplify) {
        try {
            RemoteClientProxy gpc = new RemoteClientProxy(remoteClient, manager);
            Class intf = simplify ? InterfaceSimplifier.simplify((Class)manager.remote()) : manager.remote();
            return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{intf}, (InvocationHandler)((Object)gpc));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get remote connection proxy", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisconnect() {
        try {
            if (this.remotingClient != null && this.remotingClient.isConnected()) {
                this.remotingClient.disconnect();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
        finally {
            this.remotingClient = null;
            this.serverInfo = null;
        }
    }

    private void doConnect() throws Exception {
        String locatorURI = this.transport + "://" + this.host + ":" + this.port + "/jboss-remoting-servlet-invoker/ServerInvokerServlet";
        InvokerLocator locator = new InvokerLocator(locatorURI);
        String subsystem = "REMOTEAPI";
        if (this.subsystem != null && this.subsystem.trim().equalsIgnoreCase("WSREMOTEAPI")) {
            subsystem = "WSREMOTEAPI";
        }
        Map<String, String> remotingConfig = this.buildRemotingConfig(locatorURI);
        this.remotingClient = new Client(locator, subsystem, remotingConfig);
        this.remotingClient.connect();
        try {
            Method getProductInfoMethod = SystemManagerRemote.class.getDeclaredMethod("getProductInfo", Subject.class);
            this.serverInfo = this.remoteInvoke(RhqManager.SystemManager, getProductInfoMethod, ProductInfo.class, this.subject);
            this.checkServerSupported(this.serverInfo);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find the getProductInfo(Subject) method on the SystemManager.", e);
        }
        catch (Exception e) {
            this.doDisconnect();
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unknown error occured during connect.", e);
        }
    }

    private Map<String, String> buildRemotingConfig(String locatorURI) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (SecurityUtil.isTransportSecure((String)locatorURI)) {
            this.setConfigProp(config, "org.jboss.remoting.keyStore", "data/keystore.dat");
            this.setConfigProp(config, "org.jboss.remoting.keyStoreAlgorithm", System.getProperty("java.vendor", "").contains("IBM") ? "IbmX509" : "SunX509");
            this.setConfigProp(config, "org.jboss.remoting.keyStoreType", "JKS");
            this.setConfigProp(config, "org.jboss.remoting.keyStorePassword", "password");
            this.setConfigProp(config, "org.jboss.remoting.keyPassword", "password");
            this.setConfigProp(config, "org.jboss.remoting.trustStore", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStoreAlgorithm", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStoreType", null);
            this.setConfigProp(config, "org.jboss.remoting.trustStorePassword", null);
            this.setConfigProp(config, "org.jboss.remoting.sslProtocol", null);
            this.setConfigProp(config, "org.jboss.remoting.keyAlias", "self");
            this.setConfigProp(config, "org.jboss.remoting.serverAuthMode", "false");
            config.put("org.jboss.remoting.socket.useClientMode", "true");
            SSLSocketBuilder dummy_sslbuilder = new SSLSocketBuilder();
            try {
                dummy_sslbuilder.setKeyStoreURL((String)config.get("org.jboss.remoting.keyStore"));
            }
            catch (Exception e) {
                SecurityUtil.createKeyStore((String)((String)config.get("org.jboss.remoting.keyStore")), (String)((String)config.get("org.jboss.remoting.keyAlias")), (String)"CN=RHQ, OU=RedHat, O=redhat.com, C=US", (String)((String)config.get("org.jboss.remoting.keyStorePassword")), (String)((String)config.get("org.jboss.remoting.keyPassword")), (String)"DSA", (int)36500);
                dummy_sslbuilder.setKeyStoreURL((String)config.get("org.jboss.remoting.keyStore"));
            }
            config.put("org.jboss.security.ignoreHttpsHost", "true");
        }
        return config;
    }

    private void setConfigProp(Map<String, String> configMap, String propName, String defaultValue) {
        String propValue = System.getProperty(propName, defaultValue);
        if (propValue != null) {
            configMap.put(propName, propValue);
        }
    }

    private void checkServerSupported(ProductInfo serverVersionInfo) throws IllegalStateException {
        boolean supported;
        String serverVersionString;
        String propName = "rhq.client.version-check";
        String versionCheckProp = System.getProperty("rhq.client.version-check", "true");
        if (!versionCheckProp.equalsIgnoreCase("true")) {
            return;
        }
        String clientVersionString = System.getProperty("rhq.client.version", null);
        try {
            ComparableVersion serverVersion;
            ComparableVersion clientVersion;
            int laterVersionCheck;
            if (clientVersionString == null) {
                clientVersionString = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
            }
            if (clientVersionString == null) {
                clientVersionString = " undefined ";
            }
            supported = (laterVersionCheck = (clientVersion = new ComparableVersion(clientVersionString)).compareTo((Object)(serverVersion = new ComparableVersion(serverVersionString = this.serverInfo.getVersion())))) >= 0;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot determine if server version is supported.", e);
        }
        if (!supported) {
            String errMsg = "This client [" + clientVersionString + "] does not support the remote server [" + serverVersionString + "]";
            throw new IllegalStateException(errMsg);
        }
    }
}

