/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.scripting.python;

import java.lang.reflect.Method;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.python.core.Py;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.rhq.scripting.ScriptEngineInitializer;
import org.rhq.scripting.ScriptSourceProvider;
import org.rhq.scripting.python.PythonSourceProvider;
import org.rhq.scripting.util.SandboxedScriptEngine;

public class PythonScriptEngineInitializer
implements ScriptEngineInitializer {
    private static final Log LOG = LogFactory.getLog(PythonScriptEngineInitializer.class);
    private ScriptEngineManager engineManager = new ScriptEngineManager();

    public ScriptEngine instantiate(Set<String> packages, PermissionCollection permissions) throws ScriptException {
        ScriptEngine eng = this.engineManager.getEngineByName("python");
        for (String pkg : packages) {
            try {
                eng.eval("from " + pkg + " import *\n");
            }
            catch (ScriptException e) {
                LOG.info((Object)("Python script engine could not pre-import members of package '" + pkg + "'."));
            }
        }
        return permissions == null ? eng : new SandboxedScriptEngine(eng, permissions);
    }

    public void installScriptSourceProvider(ScriptEngine scriptEngine, ScriptSourceProvider provider) {
        PySystemState sys = Py.getSystemState();
        if (sys != null) {
            sys.path_hooks.append(new PythonSourceProvider(provider));
        }
    }

    public Set<String> generateIndirectionMethods(String boundObjectName, Set<Method> overloadedMethods) {
        if (overloadedMethods == null || overloadedMethods.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Integer> argCnts = new HashSet<Integer>();
        for (Method m : overloadedMethods) {
            argCnts.add(m.getParameterTypes().length);
        }
        String methodName = overloadedMethods.iterator().next().getName();
        StringBuilder functionBody = new StringBuilder();
        functionBody.append("def ").append(methodName).append("(*args, **kwargs):\n");
        functionBody.append("\t").append("if len(kwargs) > 0:\n");
        functionBody.append("\t\t").append("raise ValueError(\"Named arguments not supported for Java methods\")\n");
        functionBody.append("\t").append("argCnt = len(args)\n");
        for (Integer argCnt : argCnts) {
            functionBody.append("\t").append("if argCnt == ").append(argCnt).append(":\n");
            functionBody.append("\t\treturn ").append(boundObjectName).append(".").append(methodName).append("(");
            int last = argCnt - 1;
            for (int i = 0; i < argCnt; ++i) {
                functionBody.append("args[").append(i).append("]");
                if (i >= last) continue;
                functionBody.append(", ");
            }
            functionBody.append(")\n");
        }
        return Collections.singleton(functionBody.toString());
    }

    public String extractUserFriendlyErrorMessage(ScriptException e) {
        return e.getMessage();
    }

    static {
        Properties props = new Properties();
        props.put("python.packages.paths", "rhq.python.additional.classpath,java.class.path,sun.boot.class.path");
        props.put("python.packages.directories", "rhq.python.additional.package.dirs,java.ext.dirs");
        props.put("python.cachedir.skip", (Object)false);
        PythonInterpreter.initialize(System.getProperties(), props, null);
    }
}

