/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.scripting.python;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.imp;
import org.rhq.scripting.ScriptSourceProvider;

public class PythonSourceProvider
extends PyObject {
    private static final long serialVersionUID = 1L;
    private static final String RHQ_PATH_EXTENSION_PREFIX = "__rhq__:";
    private ScriptSourceProvider scriptSourceProvider;
    private String currentPathPrefix;

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        if (args[0].toString().startsWith(RHQ_PATH_EXTENSION_PREFIX)) {
            this.currentPathPrefix = args[0].toString().substring(RHQ_PATH_EXTENSION_PREFIX.length());
            return this;
        }
        throw Py.ImportError("unable to handle");
    }

    public PythonSourceProvider(ScriptSourceProvider scriptSourceProvider) {
        this.scriptSourceProvider = scriptSourceProvider;
    }

    public PyObject find_module(String name) {
        return this.find_module(name, Py.None);
    }

    public PyObject find_module(String name, PyObject path) {
        try {
            URI uri = new URI(this.currentPathPrefix + name + ".py");
            return this.scriptSourceProvider.getScriptSource(uri) == null ? Py.None : new Loader(this.currentPathPrefix);
        }
        catch (URISyntaxException e) {
            return Py.None;
        }
    }

    @Override
    public String toString() {
        return this.getType().toString();
    }

    public class Loader
    extends PyObject {
        private static final long serialVersionUID = 1L;
        private String prefix;

        public Loader(String prefix) {
            this.prefix = prefix;
        }

        public PyObject load_module(String name) {
            try {
                URI uri = new URI(this.prefix + name + ".py");
                Reader rdr = PythonSourceProvider.this.scriptSourceProvider.getScriptSource(uri);
                return imp.createFromSource(name, new ReaderInputStream(rdr), uri.toString());
            }
            catch (URISyntaxException e) {
                return Py.None;
            }
        }
    }

    private static class ReaderInputStream
    extends InputStream {
        private Reader rdr;

        public ReaderInputStream(Reader rdr) {
            this.rdr = rdr;
        }

        @Override
        public int read() throws IOException {
            return this.rdr.read();
        }
    }
}

