/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.FailureException;
import org.rhq.common.jbossas.client.controller.JBossASClient;

public class DatasourceJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_DATASOURCES = "datasources";
    public static final String DATA_SOURCE = "data-source";
    public static final String XA_DATA_SOURCE = "xa-data-source";
    public static final String JDBC_DRIVER = "jdbc-driver";
    public static final String CONNECTION_PROPERTIES = "connection-properties";
    public static final String XA_DATASOURCE_PROPERTIES = "xa-datasource-properties";
    public static final String OP_ENABLE = "enable";

    public DatasourceJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public void removeDatasource(String name) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        if (this.isDatasource(name)) {
            addr.add(DATA_SOURCE, name);
        } else if (this.isXADatasource(name)) {
            addr.add(XA_DATA_SOURCE, name);
        } else {
            return;
        }
        this.remove(addr);
    }

    public boolean isDatasourceEnabled(String name) throws Exception {
        return this.isDatasourceEnabled(false, name);
    }

    public boolean isXADatasourceEnabled(String name) throws Exception {
        return this.isDatasourceEnabled(true, name);
    }

    private boolean isDatasourceEnabled(boolean isXA, String name) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        addr.add(isXA ? XA_DATA_SOURCE : DATA_SOURCE, name);
        ModelNode results = this.readResource(addr);
        boolean enabledFlag = false;
        if (results.hasDefined("enabled")) {
            ModelNode enabled = results.get("enabled");
            enabledFlag = enabled.asBoolean(false);
        }
        return enabledFlag;
    }

    public void enableDatasource(String name) throws Exception {
        this.enableDatasource(false, name);
    }

    public void enableXADatasource(String name) throws Exception {
        this.enableDatasource(true, name);
    }

    private void enableDatasource(boolean isXA, String name) throws Exception {
        if (this.isDatasourceEnabled(isXA, name)) {
            return;
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        addr.add(isXA ? XA_DATA_SOURCE : DATA_SOURCE, name);
        ModelNode request = DatasourceJBossASClient.createRequest(OP_ENABLE, addr);
        request.get("persistent").set(true);
        ModelNode results = this.execute(request);
        if (!DatasourceJBossASClient.isSuccess(results)) {
            throw new FailureException(results);
        }
    }

    public boolean isJDBCDriver(String jdbcDriverName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        return null != this.findNodeInList(addr, haystack = JDBC_DRIVER, jdbcDriverName);
    }

    public boolean isDatasource(String datasourceName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        return null != this.findNodeInList(addr, haystack = DATA_SOURCE, datasourceName);
    }

    public boolean isXADatasource(String datasourceName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES);
        return null != this.findNodeInList(addr, haystack = XA_DATA_SOURCE, datasourceName);
    }

    public ModelNode createNewJdbcDriverRequest(String name, String moduleName, String driverXaClassName) {
        String dmr;
        if (driverXaClassName != null) {
            String dmrTemplate = "{\"driver-module-name\" => \"%s\" , \"driver-name\" => \"%s\" , \"driver-xa-datasource-class-name\" => \"%s\" }";
            dmr = String.format(dmrTemplate, moduleName, name, driverXaClassName);
        } else {
            String dmrTemplate = "{\"driver-module-name\" => \"%s\" , \"driver-name\" => \"%s\" }";
            dmr = String.format(dmrTemplate, name, moduleName);
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, JDBC_DRIVER, name);
        ModelNode request = ModelNode.fromString((String)dmr);
        request.get("operation").set("add");
        request.get("address").set(addr.getAddressNode());
        return request;
    }

    public ModelNode createNewDatasourceRequest(String name, int blockingTimeoutWaitMillis, String connectionUrlExpression, String driverName, String exceptionSorterClassName, int idleTimeoutMinutes, boolean jta, int minPoolSize, int maxPoolSize, int preparedStatementCacheSize, String securityDomain, String staleConnectionCheckerClassName, String transactionIsolation, String validConnectionCheckerClassName, Map<String, String> connectionProperties) {
        String jndiName = "java:jboss/datasources/" + name;
        String dmrTemplate = "{\"blocking-timeout-wait-millis\" => %dL , \"connection-url\" => expression \"%s\" , \"driver-name\" => \"%s\" , \"exception-sorter-class-name\" => \"%s\" , \"idle-timeout-minutes\" => %dL , \"jndi-name\" => \"%s\" , \"jta\" => %s , \"min-pool-size\" => %d , \"max-pool-size\" => %d , \"prepared-statements-cache-size\" => %dL , \"security-domain\" => \"%s\" , \"stale-connection-checker-class-name\" => \"%s\" , \"transaction-isolation\" => \"%s\" , \"use-java-context\" => true , \"valid-connection-checker-class-name\" => \"%s\" }";
        String dmr = String.format(dmrTemplate, blockingTimeoutWaitMillis, connectionUrlExpression, driverName, exceptionSorterClassName, idleTimeoutMinutes, jndiName, jta, minPoolSize, maxPoolSize, preparedStatementCacheSize, securityDomain, staleConnectionCheckerClassName, transactionIsolation, validConnectionCheckerClassName);
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, name);
        ModelNode request1 = ModelNode.fromString((String)dmr);
        request1.get("operation").set("add");
        request1.get("address").set(addr.getAddressNode());
        if (connectionProperties == null || connectionProperties.size() == 0) {
            return request1;
        }
        ModelNode[] batch = new ModelNode[1 + connectionProperties.size()];
        batch[0] = request1;
        int n = 1;
        for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
            addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, name, CONNECTION_PROPERTIES, entry.getKey());
            ModelNode requestN = new ModelNode();
            requestN.get("operation").set("add");
            requestN.get("address").set(addr.getAddressNode());
            DatasourceJBossASClient.setPossibleExpression(requestN, "value", entry.getValue());
            batch[n++] = requestN;
        }
        return DatasourceJBossASClient.createBatchRequest(batch);
    }

    public ModelNode createNewDatasourceRequest(String name, String connectionUrlExpression, String driverName, boolean jta, Map<String, String> connectionProperties) {
        String jndiName = "java:jboss/datasources/" + name;
        String dmrTemplate = "{\"connection-url\" => expression \"%s\" , \"driver-name\" => \"%s\" , \"jndi-name\" => \"%s\" , \"jta\" => %s , \"use-java-context\" => true }";
        String dmr = String.format(dmrTemplate, connectionUrlExpression, driverName, jndiName, jta);
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, name);
        ModelNode request1 = ModelNode.fromString((String)dmr);
        request1.get("operation").set("add");
        request1.get("address").set(addr.getAddressNode());
        if (connectionProperties == null || connectionProperties.size() == 0) {
            return request1;
        }
        ModelNode[] batch = new ModelNode[1 + connectionProperties.size()];
        batch[0] = request1;
        int n = 1;
        for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
            addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, DATA_SOURCE, name, CONNECTION_PROPERTIES, entry.getKey());
            ModelNode requestN = new ModelNode();
            requestN.get("operation").set("add");
            requestN.get("address").set(addr.getAddressNode());
            if (entry.getValue().indexOf("${") > -1) {
                requestN.get("value").setExpression(entry.getValue());
            } else {
                requestN.get("value").set(entry.getValue());
            }
            batch[n++] = requestN;
        }
        return DatasourceJBossASClient.createBatchRequest(batch);
    }

    public ModelNode createNewXADatasourceRequest(String name, int blockingTimeoutWaitMillis, String driverName, String xaDataSourceClass, String exceptionSorterClassName, int idleTimeoutMinutes, int minPoolSize, int maxPoolSize, Boolean noRecovery, Boolean noTxSeparatePool, int preparedStatementCacheSize, String recoveryPluginClassName, String securityDomain, String staleConnectionCheckerClassName, String transactionIsolation, String validConnectionCheckerClassName, Map<String, String> xaDatasourceProperties) {
        String jndiName = "java:jboss/datasources/" + name;
        String dmrTemplate = "{\"xa-datasource-class\" => \"%s\", \"blocking-timeout-wait-millis\" => %dL , \"driver-name\" => \"%s\" , \"exception-sorter-class-name\" => \"%s\" , \"idle-timeout-minutes\" => %dL , \"jndi-name\" => \"%s\" , \"jta\" => true , \"min-pool-size\" => %d , \"max-pool-size\" => %d , \"no-recovery\" => %b , \"no-tx-separate-pool\" => %b , \"prepared-statements-cache-size\" => %dL , \"recovery-plugin-class-name\" => \"%s\" , \"security-domain\" => \"%s\" , \"stale-connection-checker-class-name\" => \"%s\" , \"transaction-isolation\" => \"%s\" , \"use-java-context\" => true , \"valid-connection-checker-class-name\" => \"%s\" }";
        String dmr = String.format(dmrTemplate, xaDataSourceClass, blockingTimeoutWaitMillis, driverName, exceptionSorterClassName, idleTimeoutMinutes, jndiName, minPoolSize, maxPoolSize, noRecovery, noTxSeparatePool, preparedStatementCacheSize, recoveryPluginClassName, securityDomain, staleConnectionCheckerClassName, transactionIsolation, validConnectionCheckerClassName);
        Address addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, XA_DATA_SOURCE, name);
        ModelNode request1 = ModelNode.fromString((String)dmr);
        request1.get("operation").set("add");
        request1.get("address").set(addr.getAddressNode());
        if (xaDatasourceProperties == null || xaDatasourceProperties.size() == 0) {
            return request1;
        }
        ModelNode[] batch = new ModelNode[1 + xaDatasourceProperties.size()];
        batch[0] = request1;
        int n = 1;
        for (Map.Entry<String, String> entry : xaDatasourceProperties.entrySet()) {
            addr = Address.root().add("subsystem", SUBSYSTEM_DATASOURCES, XA_DATA_SOURCE, name, XA_DATASOURCE_PROPERTIES, entry.getKey());
            ModelNode requestN = new ModelNode();
            requestN.get("operation").set("add");
            requestN.get("address").set(addr.getAddressNode());
            DatasourceJBossASClient.setPossibleExpression(requestN, "value", entry.getValue());
            batch[n++] = requestN;
        }
        ModelNode result = DatasourceJBossASClient.createBatchRequest(batch);
        if (null == noRecovery) {
            result.get("steps").get(0).remove("no-recovery");
        }
        if (null == noTxSeparatePool) {
            result.get("steps").get(0).remove("no-tx-separate-pool");
        }
        if (null == recoveryPluginClassName) {
            result.get("steps").get(0).remove("recovery-plugin-class-name");
        }
        if (null == staleConnectionCheckerClassName) {
            result.get("steps").get(0).remove("stale-connection-checker-class-name");
        }
        return result;
    }
}

