/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.jbossas.client.controller;

import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.rhq.common.jbossas.client.controller.Address;
import org.rhq.common.jbossas.client.controller.JBossASClient;

public class VaultJBossASClient
extends JBossASClient {
    public static final String CORE_SERVICE = "core-service";
    public static final String VAULT = "vault";

    public VaultJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isVault() throws Exception {
        Address addr = Address.root().add(CORE_SERVICE, VAULT);
        ModelNode queryNode = VaultJBossASClient.createRequest("read-resource", addr);
        ModelNode results = this.execute(queryNode);
        return VaultJBossASClient.isSuccess(results);
    }

    public String getVaultClass() throws Exception {
        Address addr = Address.root().add(CORE_SERVICE, VAULT);
        ModelNode vaultNode = this.readResource(addr);
        if (vaultNode == null) {
            return null;
        }
        ModelNode codeNode = vaultNode.get("code");
        if (codeNode == null) {
            return null;
        }
        return codeNode.asString();
    }

    public ModelNode createNewVaultRequest(String className) {
        String dmrTemplate = "{\"code\" => \"%s\"}";
        String dmr = String.format(dmrTemplate, className);
        Address addr = Address.root().add(CORE_SERVICE, VAULT);
        ModelNode request = ModelNode.fromString((String)dmr);
        request.get("operation").set("add");
        request.get("address").set(addr.getAddressNode());
        return request;
    }
}

