/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.control;

import java.util.LinkedList;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.server.control.Commands;
import org.rhq.server.control.ControlCommand;
import org.rhq.server.control.RHQControlException;
import org.rhq.server.control.UsageException;

public class RHQControl {
    private final Log log = LogFactory.getLog(RHQControl.class);
    private Commands commands = new Commands();

    public void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        String syntax = "rhqctl <cmd> [options]";
        String header = "\nwhere <cmd> is one of:";
        String footer = "\n* For help on a specific command: rhqctl <cmd> --help\n\n* Limit commands to a single component with one of: --storage, --server, --agent";
        helpFormatter.setOptPrefix("");
        helpFormatter.printHelp(syntax, header, this.commands.getOptions(), footer);
    }

    public void exec(String[] args) {
        try {
            if (args.length == 0) {
                this.printUsage();
            } else {
                String commandName = this.findCommand(this.commands, args);
                ControlCommand command = this.commands.get(commandName);
                command.exec(this.getCommandLine(commandName, args));
            }
        }
        catch (UsageException e) {
            this.printUsage();
        }
        catch (RHQControlException e) {
            this.log.error((Object)(e.getMessage() + " [Cause: " + e.getCause() + "]"));
        }
    }

    private String findCommand(Commands commands, String[] args) throws RHQControlException {
        LinkedList<String> commandNames = new LinkedList<String>();
        for (String arg : args) {
            if (!commands.contains(arg)) continue;
            commandNames.add(arg);
        }
        if (commandNames.size() != 1) {
            throw new UsageException();
        }
        return (String)commandNames.get(0);
    }

    private String[] getCommandLine(String cmd, String[] args) {
        String[] cmdLine = new String[args.length - 1];
        int i = 0;
        for (String arg : args) {
            if (arg.equals(cmd)) continue;
            cmdLine[i++] = arg;
        }
        return cmdLine;
    }

    public static void main(String[] args) throws Exception {
        RHQControl control = new RHQControl();
        try {
            control.exec(args);
            System.exit(0);
        }
        catch (RHQControlException e) {
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            control.log.error((Object)("There was an unxpected error: " + rootCause.getMessage()), rootCause);
            System.exit(1);
        }
    }
}

