/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.security.test;

import java.io.IOException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.client.ScriptableAbstractEJB3Test;
import org.rhq.enterprise.server.system.SystemManagerBean;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class JndiAccessTest
extends ScriptableAbstractEJB3Test {
    public void testScriptCantOverrideSystemProperties() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        try {
            engine.eval("java.lang.System.setProperty('java.naming.factory.url.pkgs', 'counterfeit');");
        }
        catch (ScriptException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("access denied (\"java.util.PropertyPermission\" \"java.naming.factory.url.pkgs\" \"write\")"), (String)"The script shouldn't have write access to the system properties.");
        }
    }

    public void testEjbsAccessibleThroughPrivilegedCode() {
        LookupUtil.getSubjectManager().getOverlord();
    }

    public void testEjbsAccessibleThroughLocalClient() throws ScriptException, IOException {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        engine.eval("SubjectManager.getSubjectByName('rhqadmin');");
    }

    public void testLocalEjbsInaccessibleThroughJndiLookup() throws ScriptException, IOException {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        String jndiName = "java:global/rhq/rhq-server/" + SystemManagerBean.class.getSimpleName() + "!" + SystemManagerBean.class.getName().replace("Bean", "Local");
        try {
            engine.eval("var ctx = new javax.naming.InitialContext();\nvar systemManager = ctx.lookup('" + jndiName + "');\n" + "systemManager.isDebugModeEnabled();");
            Assert.fail((String)"The script shouldn't have been able to call local SLSB method.");
        }
        catch (ScriptException e) {
            JndiAccessTest.checkIsDesiredSecurityException(e);
        }
    }

    public void testLocalEjbsInaccessibleThroughJndiLookupWithCustomUrlPackages() throws ScriptException, IOException {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        String jndiName = "java:global/rhq/rhq-server/" + SystemManagerBean.class.getSimpleName() + "!" + SystemManagerBean.class.getName().replace("Bean", "Local");
        try {
            engine.eval("var env = new java.util.Hashtable();\nenv.put('java.naming.factory.url.pkgs', 'org.jboss.as.naming.interfaces');\nvar ctx = new javax.naming.InitialContext(env);\nvar systemManager = ctx.lookup('" + jndiName + "');\n" + "systemManager.isDebugModeEnabled();");
            Assert.fail((String)"The script shouldn't have been able to call local SLSB method.");
        }
        catch (ScriptException e) {
            JndiAccessTest.checkIsDesiredSecurityException(e);
        }
    }

    public void testRemoteEjbsInaccessibleThroughJndiLookup() throws ScriptException, IOException {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        String jndiName = "java:global/rhq/rhq-server/" + SystemManagerBean.class.getSimpleName() + "!" + SystemManagerBean.class.getName().replace("Bean", "Remote");
        try {
            engine.eval("var ctx = new javax.naming.InitialContext();\nvar systemManager = ctx.lookup('" + jndiName + "');\n" + "systemManager.getSystemSettings(subject);");
            Assert.fail((String)"The script shouldn't have been able to call remote SLSB method directly.");
        }
        catch (ScriptException e) {
            JndiAccessTest.checkIsDesiredSecurityException(e);
        }
    }

    public void testScriptCantUseSessionManagerMethods() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        final ScriptEngine engine = this.getEngine(overlord);
        class G {
            private String sessionManager = "org.rhq.enterprise.server.auth.SessionManager.getInstance().";

            G() {
            }

            public void testInvoke(String methodCall) throws ScriptException {
                String code = this.sessionManager + methodCall;
                try {
                    engine.eval(code);
                    Assert.fail((String)("The script shouldn't have been able to call a method on a SessionManager: " + methodCall));
                }
                catch (ScriptException e) {
                    JndiAccessTest.checkIsDesiredSecurityException(e);
                }
            }
        }
        G manager = new G();
        manager.testInvoke("getLastAccess(0);");
        manager.testInvoke("getOverlord()");
        manager.testInvoke("getSubject(2);");
        manager.testInvoke("invalidate(0);");
        manager.testInvoke("invalidate(\"\");");
        manager.testInvoke("put(new org.rhq.core.domain.auth.Subject());");
        manager.testInvoke("put(new org.rhq.core.domain.auth.Subject(), 0);");
    }

    public void testScriptCantObtainRawJDBCConnectionsWithoutCredentials() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        try {
            engine.eval("var ctx = new javax.naming.InitialContext();\nvar datasource = ctx.lookup('java:jboss/datasources/RHQDS');\ncon = datasource.getConnection();");
            Assert.fail((String)"The script shouldn't have been able to obtain the datasource from the JNDI.");
        }
        catch (ScriptException e) {
            JndiAccessTest.checkIsDesiredSecurityException(e);
        }
    }

    public void testScriptCantUseEntityManager() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        try {
            engine.eval("var ctx = new javax.naming.InitialContext();\nvar entityManagerFactory = ctx.lookup('java:jboss/RHQEntityManagerFactory');\nvar entityManager = entityManagerFactory.createEntityManager();\nentityManager.find(java.lang.Class.forName('org.rhq.core.domain.resource.Resource'), java.lang.Integer.valueOf('10001'));");
            Assert.fail((String)"The script shouldn't have been able to use the EntityManager.");
        }
        catch (ScriptException e) {
            JndiAccessTest.checkIsDesiredSecurityException(e);
        }
        try {
            engine.eval("var env = new java.util.Hashtable();env.put('java.naming.factory.initial', 'org.jboss.as.naming.InitialContextFactory');var ctx = new javax.naming.InitialContext(env);\nvar entityManagerFactory = ctx.lookup('java:jboss/RHQEntityManagerFactory');\nvar entityManager = entityManagerFactory.createEntityManager();\nentityManager.find(java.lang.Class.forName('org.rhq.core.domain.resource.Resource'), java.lang.Integer.valueOf('10001'));");
            Assert.fail((String)"The script shouldn't have been able to use the EntityManager even using custom initial context factory.");
        }
        catch (ScriptException e) {
            JndiAccessTest.checkIsDesiredSecurityException(e);
        }
    }

    public void testProxyFactoryWorksWithSecuredScriptEngine() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        try {
            engine.eval("var resource = ProxyFactory.getResource(10001);");
        }
        catch (ScriptException e) {
            JndiAccessTest.checkIsNotASecurityException(e);
        }
    }

    private static void checkIsDesiredSecurityException(ScriptException e) {
        String permissionTrace;
        String message = e.getMessage();
        if (!message.contains(permissionTrace = "org.rhq.allow.server.internals.access")) {
            Assert.fail((String)"The script exception doesn't seem to be caused by the AllowRhqServerInternalsAccessPermission security exception. ", (Throwable)e);
        }
    }

    private static void checkIsNotASecurityException(ScriptException e) {
        String permissionTrace;
        String message = e.getMessage();
        if (message.contains(permissionTrace = "org.rhq.allow.server.internals.access")) {
            Assert.fail((String)"The script exception does seem to be caused by the AllowRhqServerInternalsAccessPermission security exception although it shouldn't. ", (Throwable)e);
        }
    }
}

