/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.security.test;

import java.util.UUID;
import javax.script.ScriptEngine;
import org.rhq.bindings.client.RhqManager;
import org.rhq.bindings.util.SimplifiedClass;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.client.ScriptableAbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptingAPIServerTest
extends ScriptableAbstractEJB3Test {
    @Test
    public void testProxyFactoryCorrectlyDefinesMethodsAndProperties() throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                ResourceType rt = ScriptingAPIServerTest.this.createResourceType();
                Resource r = ScriptingAPIServerTest.this.createResource(rt);
                Subject overlord = LookupUtil.getSubjectManager().getOverlord();
                ScriptEngine engine = ScriptingAPIServerTest.this.getEngine(overlord);
                engine.eval("var r = ProxyFactory.getResource(" + r.getId() + ");");
                String detectedMeasurementType = (String)engine.eval("typeof(r.measurement);");
                String detectedOperationType = (String)engine.eval("typeof(r.operation);");
                ScriptingAPIServerTest.this.assertEquals("object", detectedMeasurementType);
                ScriptingAPIServerTest.this.assertEquals("function", detectedOperationType);
            }
        });
    }

    @Test
    public void testManagersHaveSimplifiedSignatures() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ScriptEngine engine = this.getEngine(overlord);
        for (RhqManager m : RhqManager.values()) {
            String name;
            if (!m.enabled() || (name = m.name()).contains("TagManager") && !RhqManager.TagManager.enabled()) continue;
            Object scriptedManager = engine.eval(name);
            this.assertNotNull(scriptedManager);
            Class<?> implementedIface = scriptedManager.getClass().getInterfaces()[0];
            Assert.assertNotEquals((Object)m.remote(), implementedIface);
            this.assertNotNull(implementedIface.getAnnotation(SimplifiedClass.class));
        }
    }

    private ResourceType createResourceType() {
        ResourceType resourceType = new ResourceType("ScriptingAPITestType", "dummy", ResourceCategory.PLATFORM, null);
        MeasurementDefinition measurement = new MeasurementDefinition("measurement", MeasurementCategory.PERFORMANCE, MeasurementUnits.BYTES, DataType.MEASUREMENT, true, 1L, DisplayType.DETAIL);
        measurement.setDisplayName("measurement");
        resourceType.addMetricDefinition(measurement);
        ConfigurationDefinition params = new ConfigurationDefinition("dummy", null);
        params.put((PropertyDefinition)new PropertyDefinitionSimple("parameter", null, true, PropertySimpleType.BOOLEAN));
        OperationDefinition operation = new OperationDefinition(resourceType, "operation");
        operation.setDisplayName("operation");
        operation.setParametersConfigurationDefinition(params);
        resourceType.addOperationDefinition(operation);
        this.getEntityManager().persist((Object)resourceType);
        return resourceType;
    }

    private Resource createResource(ResourceType resourceType) {
        Resource resource = new Resource("key", "resource", resourceType);
        resource.setUuid(UUID.randomUUID().toString());
        this.getEntityManager().persist((Object)resource);
        return resource;
    }
}

