/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.TestServerPluginServiceMBean;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginService;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

public abstract class TestServerPluginService
extends ServerPluginService
implements TestServerPluginServiceMBean {
    public TestMasterServerPluginContainer master;
    public MasterServerPluginContainerConfiguration masterConfig;

    protected TestServerPluginService(File tmpdir) {
        this.masterConfig = new MasterServerPluginContainerConfiguration(tmpdir, tmpdir, tmpdir, null);
    }

    public MasterServerPluginContainer createMasterPluginContainer() {
        this.master = new TestMasterServerPluginContainer();
        this.master.initialize(this.masterConfig);
        return this.master;
    }

    protected abstract List<AbstractTypeServerPluginContainer> createPluginContainers(MasterServerPluginContainer var1);

    public static ServerPlugin getPlugin(ServerPluginEnvironment env) {
        return TestServerPluginService.getPlugin(env.getPluginUrl(), env.getPluginDescriptor());
    }

    public static ServerPlugin getPlugin(URL pluginUrl, ServerPluginDescriptorType pluginDescriptor) {
        try {
            Configuration pluginConfig = null;
            Configuration scheduledJobsConfig = null;
            ConfigurationDefinition configDef = ServerPluginDescriptorMetadataParser.getPluginConfigurationDefinition((ServerPluginDescriptorType)pluginDescriptor);
            if (configDef != null) {
                pluginConfig = configDef.getDefaultTemplate().createConfiguration();
            }
            if ((configDef = ServerPluginDescriptorMetadataParser.getScheduledJobsDefinition((ServerPluginDescriptorType)pluginDescriptor)) != null) {
                scheduledJobsConfig = configDef.getDefaultTemplate().createConfiguration();
            }
            File pluginFile = new File(pluginUrl.toURI());
            PluginKey pluginKey = PluginKey.createServerPluginKey((String)new ServerPluginType(pluginDescriptor).stringify(), (String)pluginDescriptor.getName());
            ServerPlugin plugin = new ServerPlugin(0, pluginKey.getPluginName(), pluginFile.getName(), pluginDescriptor.getDisplayName(), true, PluginStatusType.INSTALLED, pluginDescriptor.getDescription(), "", MessageDigestGenerator.getDigestString((File)pluginFile), pluginDescriptor.getVersion(), pluginDescriptor.getVersion(), pluginConfig, scheduledJobsConfig, new ServerPluginType(pluginDescriptor).stringify(), System.currentTimeMillis(), System.currentTimeMillis());
            return plugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ServerPlugin getPlugin(URL pluginUrl) throws Exception {
        ServerPluginDescriptorType type = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)pluginUrl);
        return TestServerPluginService.getPlugin(pluginUrl, type);
    }

    protected Map<URL, ? extends ServerPluginDescriptorType> preloadAllPlugins() throws Exception {
        return null;
    }

    private class TestMasterServerPluginContainer
    extends MasterServerPluginContainer {
        private TestMasterServerPluginContainer() {
        }

        protected ClassLoader createRootServerPluginClassLoader() {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }

        protected Map<URL, ? extends ServerPluginDescriptorType> preloadAllPlugins() throws Exception {
            Map<URL, ? extends ServerPluginDescriptorType> plugins = TestServerPluginService.this.preloadAllPlugins();
            if (plugins != null) {
                return plugins;
            }
            File pluginDir = this.getConfiguration().getPluginDirectory();
            if (pluginDir == null || pluginDir.listFiles() == null || pluginDir.listFiles().length == 0) {
                return new HashMap();
            }
            return super.preloadAllPlugins();
        }

        protected List<PluginKey> getDisabledPluginKeys() {
            return new ArrayList<PluginKey>();
        }

        protected List<AbstractTypeServerPluginContainer> createPluginContainers() {
            return TestServerPluginService.this.createPluginContainers(this);
        }
    }
}

