/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class AlertDefinitionManagerBeanTest
extends AbstractEJB3Test {
    private static final Log LOG = LogFactory.getLog(AlertDefinitionManagerBeanTest.class);
    private final String prefix = ((Object)((Object)this)).getClass().getSimpleName() + "_";
    private final String subjectName = this.prefix + "subject";
    private final String roleName = this.prefix + "role";
    private final String groupName = this.prefix + "group";
    private final String resourceName = this.prefix + "resource";
    private final String measurementDefName = this.prefix + "measurement";
    private AlertDefinitionManagerLocal alertDefinitionManager;
    private ResourceGroupManagerLocal resourceGroupManager;
    private RoleManagerLocal roleManager;
    private SubjectManagerLocal subjectManager;
    private TestData testData;

    @Override
    protected void beforeMethod() throws Exception {
        this.alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.resourceGroupManager = LookupUtil.getResourceGroupManager();
        this.roleManager = LookupUtil.getRoleManager();
        this.createTestData();
        this.prepareScheduler();
    }

    private void createTestData() {
        this.testData = this.executeInTransaction(false, new TransactionCallbackReturnable<TestData>(){

            @Override
            public TestData execute() throws Exception {
                TestData newTestData = new TestData();
                Subject subject = SessionTestHelper.createNewSubject(AlertDefinitionManagerBeanTest.this.em, AlertDefinitionManagerBeanTest.this.subjectName);
                newTestData.setSubject(subject);
                Role role = SessionTestHelper.createNewRoleForSubject(AlertDefinitionManagerBeanTest.this.em, subject, AlertDefinitionManagerBeanTest.this.roleName, Permission.MANAGE_ALERTS);
                newTestData.setRole(role);
                ResourceType resourceType = SessionTestHelper.createNewResourceType(AlertDefinitionManagerBeanTest.this.em);
                MeasurementDefinition dynamicMeasuremenDef = new MeasurementDefinition(resourceType, AlertDefinitionManagerBeanTest.this.measurementDefName);
                dynamicMeasuremenDef.setDefaultOn(true);
                dynamicMeasuremenDef.setDataType(DataType.MEASUREMENT);
                dynamicMeasuremenDef.setMeasurementType(NumericType.DYNAMIC);
                AlertDefinitionManagerBeanTest.this.em.persist((Object)dynamicMeasuremenDef);
                newTestData.setResourceType(resourceType);
                ResourceGroup resourceGroup = new ResourceGroup(AlertDefinitionManagerBeanTest.this.groupName, resourceType);
                resourceGroup = AlertDefinitionManagerBeanTest.this.resourceGroupManager.createPrivateResourceGroup(subject, resourceGroup);
                newTestData.setResourceGroup(resourceGroup);
                AlertDefinitionManagerBeanTest.this.roleManager.setAssignedResourceGroups(AlertDefinitionManagerBeanTest.this.subjectManager.getOverlord(), role.getId(), new int[]{resourceGroup.getId()});
                Resource resource = SessionTestHelper.createNewResourceForGroup(AlertDefinitionManagerBeanTest.this.em, resourceGroup, AlertDefinitionManagerBeanTest.this.resourceName);
                newTestData.setResource(resource);
                return newTestData;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            this.deleteTestData();
        }
        finally {
            this.unprepareScheduler();
        }
    }

    private void deleteTestData() throws Exception {
        if (this.testData != null) {
            this.resourceGroupManager.deleteResourceGroup(this.subjectManager.getOverlord(), this.testData.getResourceGroup().getId());
            for (Integer alertDefinitionId : this.testData.getAlertDefinitionIds()) {
                this.removeEntity(AlertDefinition.class, alertDefinitionId);
            }
            this.removeEntity(Resource.class, this.testData.getResource().getId());
            this.removeEntity(ResourceType.class, this.testData.getResourceType().getId());
            this.subjectManager.deleteSubjects(this.subjectManager.getOverlord(), new int[]{this.testData.getSubject().getId()});
            this.roleManager.deleteRoles(this.subjectManager.getOverlord(), new int[]{this.testData.getRole().getId()});
            this.testData = null;
        }
    }

    private void removeEntity(final Class<?> entityClass, final Object entityId) {
        try {
            this.executeInTransaction(false, new TransactionCallback(){

                @Override
                public void execute() throws Exception {
                    Object object = AlertDefinitionManagerBeanTest.this.em.find(entityClass, entityId);
                    if (object instanceof Resource) {
                        ResourceTreeHelper.deleteResource(AlertDefinitionManagerBeanTest.this.em, (Resource)object);
                    } else {
                        AlertDefinitionManagerBeanTest.this.em.remove(object);
                        AlertDefinitionManagerBeanTest.this.em.flush();
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to delete object from database: " + entityClass + "[id=" + entityId + "]"), (Throwable)e);
        }
    }

    @Test
    public void testEnableAlertDefinitions() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                LinkedList<Integer> alertDefinitionIds = new LinkedList<Integer>();
                for (int i = 0; i < 50; ++i) {
                    alertDefinitionIds.add(AlertDefinitionManagerBeanTest.this.createAlertDefinitionAndGetId(AlertDefinitionManagerBeanTest.this.prefix + "alertdef_" + String.valueOf(i), false));
                }
                List alertDefinitionToEnableIds = alertDefinitionIds.subList(12, 37);
                int enabledCount = AlertDefinitionManagerBeanTest.this.alertDefinitionManager.enableAlertDefinitions(AlertDefinitionManagerBeanTest.this.testData.getSubject(), ArrayUtils.unwrapCollection(alertDefinitionToEnableIds));
                AlertDefinitionManagerBeanTest.this.assertEquals(alertDefinitionToEnableIds.size(), enabledCount);
            }
        });
    }

    @Test
    public void testDisableAlertDefinitions() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                LinkedList<Integer> alertDefinitionIds = new LinkedList<Integer>();
                for (int i = 0; i < 50; ++i) {
                    alertDefinitionIds.add(AlertDefinitionManagerBeanTest.this.createAlertDefinitionAndGetId(AlertDefinitionManagerBeanTest.this.prefix + "alertdef_" + String.valueOf(i), true));
                }
                List alertDefinitionToDisableIds = alertDefinitionIds.subList(17, 48);
                int disabledCount = AlertDefinitionManagerBeanTest.this.alertDefinitionManager.disableAlertDefinitions(AlertDefinitionManagerBeanTest.this.testData.getSubject(), ArrayUtils.unwrapCollection(alertDefinitionToDisableIds));
                AlertDefinitionManagerBeanTest.this.assertEquals(alertDefinitionToDisableIds.size(), disabledCount);
            }
        });
    }

    @Test
    public void testIsResourceOrGroupAlertDefinition() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourceAlertDefinitionId = AlertDefinitionManagerBeanTest.this.createAlertDefinitionAndGetId(AlertDefinitionManagerBeanTest.this.prefix + "resource_Alertdef", true);
                int groupAlertDefinitionId = AlertDefinitionManagerBeanTest.this.createGroupAlertDefinitionAndGetId(AlertDefinitionManagerBeanTest.this.prefix + "group_Alertdef");
                AlertDefinitionManagerBeanTest.this.assertTrue("Failed to detect a group alert definition", AlertDefinitionManagerBeanTest.this.alertDefinitionManager.isGroupAlertDefinition(Integer.valueOf(groupAlertDefinitionId)));
                AlertDefinitionManagerBeanTest.this.assertFalse("Should not have detected a group alert definition", AlertDefinitionManagerBeanTest.this.alertDefinitionManager.isGroupAlertDefinition(Integer.valueOf(resourceAlertDefinitionId)));
                AlertDefinitionManagerBeanTest.this.assertTrue("Failed to detect a resource alert definition", AlertDefinitionManagerBeanTest.this.alertDefinitionManager.isResourceAlertDefinition(Integer.valueOf(resourceAlertDefinitionId)));
                AlertDefinitionManagerBeanTest.this.assertFalse("Should not have detected a resource alert definition", AlertDefinitionManagerBeanTest.this.alertDefinitionManager.isResourceAlertDefinition(Integer.valueOf(groupAlertDefinitionId)));
            }
        });
    }

    @Test
    void testBug846451() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                String name = AlertDefinitionManagerBeanTest.this.prefix + "group_Alertdef";
                int groupAlertDefinitionId = AlertDefinitionManagerBeanTest.this.createGroupAlertDefinitionAndGetId(name);
                AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
                criteria.addFilterResourceGroupIds(new Integer[]{AlertDefinitionManagerBeanTest.this.testData.getResourceGroup().getId()});
                PageList result = AlertDefinitionManagerBeanTest.this.alertDefinitionManager.findAlertDefinitionsByCriteria(AlertDefinitionManagerBeanTest.this.testData.getSubject(), criteria);
                AlertDefinitionManagerBeanTest.this.assertNotNull(result);
                AlertDefinitionManagerBeanTest.this.assertEquals(1, result.size());
                AlertDefinitionManagerBeanTest.this.assertEquals(name, ((AlertDefinition)result.get(0)).getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    void testAddRemoveGroupMembers() throws Exception {
        Resource resource2 = null;
        Resource resource3 = null;
        try {
            this.startTransaction();
            String name = this.prefix + "group_Alertdef";
            int groupAlertDefinitionId = this.createGroupAlertDefinitionAndGetId(name);
            String resource2Name = this.resourceName + "_2";
            String resource3Name = this.resourceName + "_3";
            resource2 = SessionTestHelper.createNewResource(this.em, resource2Name, this.testData.getResourceType());
            resource3 = SessionTestHelper.createNewResource(this.em, resource3Name, this.testData.getResourceType());
            this.commitTransaction();
            LookupUtil.getResourceGroupManager().addResourcesToGroup(this.subjectManager.getOverlord(), this.testData.getResourceGroup().getId(), new int[]{resource2.getId()});
            LookupUtil.getResourceGroupManager().addResourcesToGroup(this.subjectManager.getOverlord(), this.testData.getResourceGroup().getId(), new int[]{resource3.getId()});
            int[] ids = new int[]{resource2.getId(), resource3.getId()};
            AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
            criteria.fetchConditions(true);
            criteria.addFilterResourceIds(new Integer[]{ids[0], ids[1]});
            PageList result = this.alertDefinitionManager.findAlertDefinitionsByCriteria(this.testData.getSubject(), criteria);
            this.assertNotNull(result);
            this.assertEquals(2, result.size());
            this.assertEquals(name, ((AlertDefinition)result.get(0)).getName());
            this.assertEquals(name, ((AlertDefinition)result.get(1)).getName());
            this.assertTrue(((AlertDefinition)result.get(0)).getId() != ((AlertDefinition)result.get(1)).getId());
            this.assertEquals(1, ((AlertDefinition)result.get(0)).getConditions().size());
            this.assertEquals(1, ((AlertDefinition)result.get(1)).getConditions().size());
            LookupUtil.getResourceGroupManager().removeResourcesFromGroup(this.subjectManager.getOverlord(), this.testData.getResourceGroup().getId(), new int[]{resource2.getId()});
            result = this.alertDefinitionManager.findAlertDefinitionsByCriteria(this.testData.getSubject(), criteria);
            this.assertNotNull(result);
            this.assertEquals(1, result.size());
            LookupUtil.getResourceGroupManager().removeResourcesFromGroup(this.subjectManager.getOverlord(), this.testData.getResourceGroup().getId(), new int[]{resource3.getId()});
            result = this.alertDefinitionManager.findAlertDefinitionsByCriteria(this.testData.getSubject(), criteria);
            this.assertNotNull(result);
            this.assertEquals(0, result.size());
        }
        catch (Throwable throwable) {
            Resource[] resources2 = new Resource[]{resource2, resource3};
            try {
                this.startTransaction();
                Resource[] arr$ = resources2;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        this.commitTransaction();
                        throw throwable;
                    }
                    Resource r = arr$[i$];
                    if (null != r) {
                        r = (Resource)this.em.find(Resource.class, (Object)r.getId());
                        Set ads = r.getAlertDefinitions();
                        for (AlertDefinition ad : ads) {
                            this.em.remove((Object)ad);
                        }
                        ResourceTreeHelper.deleteResource(this.em, r);
                    }
                    ++i$;
                }
            }
            catch (Exception e) {
                this.rollbackTransaction();
            }
            throw throwable;
        }
        Resource[] resources = new Resource[]{resource2, resource3};
        try {
            this.startTransaction();
            Resource[] arr$ = resources;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) {
                    this.commitTransaction();
                    return;
                }
                Resource r = arr$[i$];
                if (null != r) {
                    r = (Resource)this.em.find(Resource.class, (Object)r.getId());
                    Set ads = r.getAlertDefinitions();
                    for (AlertDefinition ad : ads) {
                        this.em.remove((Object)ad);
                    }
                    ResourceTreeHelper.deleteResource(this.em, r);
                }
                ++i$;
            }
        }
        catch (Exception e) {
            this.rollbackTransaction();
            return;
        }
    }

    private int createAlertDefinitionAndGetId(String name, boolean enabled) {
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName(name);
        alertDefinition.setPriority(AlertPriority.MEDIUM);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setConditionExpression(BooleanExpression.ANY);
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setEnabled(enabled);
        alertDefinition = this.alertDefinitionManager.createAlertDefinitionInNewTransaction(this.testData.getSubject(), alertDefinition, Integer.valueOf(this.testData.getResource().getId()), true);
        this.testData.getAlertDefinitionIds().add(alertDefinition.getId());
        return alertDefinition.getId();
    }

    private int createGroupAlertDefinitionAndGetId(String name) {
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName(name);
        alertDefinition.setPriority(AlertPriority.MEDIUM);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setConditionExpression(BooleanExpression.ANY);
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setGroup(this.testData.getResourceGroup());
        alertDefinition.setEnabled(true);
        AlertCondition ac = new AlertCondition();
        ac.setCategory(AlertConditionCategory.THRESHOLD);
        ac.setMeasurementDefinition(this.testData.getMeasurementDef());
        ac.setComparator("<");
        ac.setThreshold(Double.valueOf(0.5));
        alertDefinition.addCondition(ac);
        AlertDefinition newAlertDefinition = this.alertDefinitionManager.createAlertDefinitionInNewTransaction(this.testData.getSubject(), alertDefinition, null, true);
        this.testData.getAlertDefinitionIds().add(newAlertDefinition.getId());
        return newAlertDefinition.getId();
    }

    private static final class TestData {
        private Subject subject;
        private Role role;
        private ResourceType resourceType;
        private MeasurementDefinition measurementDef;
        private ResourceGroup resourceGroup;
        private Resource resource;
        private List<Integer> alertDefinitionIds = new LinkedList<Integer>();

        private TestData() {
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void setSubject(Subject subject) {
            this.subject = subject;
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        public MeasurementDefinition getMeasurementDef() {
            return this.measurementDef;
        }

        public void setMeasurementDef(MeasurementDefinition measurementDef) {
            this.measurementDef = measurementDef;
        }

        public ResourceGroup getResourceGroup() {
            return this.resourceGroup;
        }

        public void setResourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }

        public List<Integer> getAlertDefinitionIds() {
            return this.alertDefinitionIds;
        }
    }
}

