/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.shared.ResourceBuilder;
import org.rhq.core.domain.shared.ResourceTypeBuilder;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.TestServerPluginService;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.TestAlertSender;
import org.rhq.enterprise.server.alert.TestAlertSenderPluginService;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;

@Test(groups={"alert"})
public class AlertDefinitionWithComplexNotificationsTest
extends AbstractEJB3Test {
    private static final Log LOG = LogFactory.getLog(AlertDefinitionWithComplexNotificationsTest.class);
    private final String universalName = ((Object)((Object)this)).getClass().getSimpleName();
    private Server server;
    private Agent agent;
    private Subject subject;
    private Role role;
    private ResourceType resourceType;
    private ResourceGroup resourceGroup;
    private Set<Resource> resources;
    private AlertDefinition templateAlertDefinition;
    private AlertDefinition groupAlertDefinition;
    private AlertDefinition resourceAlertDefinition;
    private ServerPlugin serverPlugin;
    private Set<Object> junk = new LinkedHashSet<Object>();
    private int resourceLevelAlertDefinitionId;
    private int groupLevelAlertDefinitionId;
    private int templateLevelAlertDefinitionId;
    private Resource copyTestsResource;
    private TestAlertSenderPluginService alertSenderService;
    private TestServerCommunicationsService agentService;

    @Test
    public void singleMergedTest() throws Exception {
        try {
            this.prepareDB();
            this.containerSetup();
            this.login();
            System.out.println("Running test: testNotificationsCopiedOnAlertTemplateApplication");
            this.testNotificationsCopiedOnAlertTemplateApplication();
            System.out.println("Running test: testNotificationsCopiedOnGroupMemberAddition");
            this.testNotificationsCopiedOnGroupMemberAddition();
            System.out.println("Running test: testCorrectSubjectPassedOnResourceLevelAlertDefinitionCreation");
            this.testCorrectSubjectPassedOnResourceLevelAlertDefCreation();
            System.out.println("Running test: testCorrectSubjectPassedOnGroupLevelAlertDefinitionCreation");
            this.testCorrectSubjectPassedOnGroupLevelAlertDefCreation();
            System.out.println("Running test: testCorrectSubjectPassedOnTemplateLevelAlertDefinitionCreation");
            this.testCorrectSubjectPassedOnTemplateLevelAlertDefCreation();
            System.out.println("Running test: testNoValidationWhenNoNotificationUpdateOnResourceLevel");
            this.testNoValidationWhenNoNotificationUpdateOnResourceLevel();
            System.out.println("Running test: testNoValidationWhenNoNotificationUpdateOnGroupLevel");
            this.testNoValidationWhenNoNotificationUpdateOnGroupLevel();
            System.out.println("Running test: testNoValidationWhenNoNotificationUpdateOnTemplateLevel");
            this.testNoValidationWhenNoNotificationUpdateOnTemplateLevel();
            System.out.println("Running test: testCorrectSubjectPassedOnResourceLevelAlertDefinitionUpdate");
            this.testCorrectSubjectPassedOnResourceLevelAlertDefinitionUpdate();
            System.out.println("Running test: testCorrectSubjectPassedOnGroupLevelAlertDefinitionUpdate");
            this.testCorrectSubjectPassedOnGroupLevelAlertDefinitionUpdate();
            System.out.println("Running test: testCorrectSubjectPassedOnTemplateLevelAlertDefinitionUpdate");
            this.testCorrectSubjectPassedOnTemplateLevelAlertDefinitionUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.logout();
            this.cleanDB();
            this.containerTearDown();
        }
    }

    private void prepareDB() {
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Object res;
                EntityManager em = AlertDefinitionWithComplexNotificationsTest.this.getEntityManager();
                AlertDefinitionWithComplexNotificationsTest.this.agent = new Agent(AlertDefinitionWithComplexNotificationsTest.this.universalName, "localhost", 0, "foo", "bar");
                AlertDefinitionWithComplexNotificationsTest.this.server = new Server();
                AlertDefinitionWithComplexNotificationsTest.this.server.setAddress("localhost");
                AlertDefinitionWithComplexNotificationsTest.this.server.setName(AlertDefinitionWithComplexNotificationsTest.this.universalName);
                AlertDefinitionWithComplexNotificationsTest.this.server.setOperationMode(Server.OperationMode.NORMAL);
                AlertDefinitionWithComplexNotificationsTest.this.server.setAgents(Collections.singletonList(AlertDefinitionWithComplexNotificationsTest.this.agent));
                AlertDefinitionWithComplexNotificationsTest.this.role = new Role(AlertDefinitionWithComplexNotificationsTest.this.universalName);
                AlertDefinitionWithComplexNotificationsTest.this.role.addPermission(Permission.MANAGE_INVENTORY);
                AlertDefinitionWithComplexNotificationsTest.this.role.addPermission(Permission.MANAGE_SETTINGS);
                AlertDefinitionWithComplexNotificationsTest.this.subject = new Subject(AlertDefinitionWithComplexNotificationsTest.this.universalName, true, false);
                AlertDefinitionWithComplexNotificationsTest.this.subject.addRole(AlertDefinitionWithComplexNotificationsTest.this.role);
                AlertDefinitionWithComplexNotificationsTest.this.resourceType = new ResourceTypeBuilder().createPlatformResourceType().withId(0).withName(AlertDefinitionWithComplexNotificationsTest.this.universalName).withPlugin(AlertDefinitionWithComplexNotificationsTest.this.universalName).build();
                MeasurementDefinition md = new MeasurementDefinition(AlertDefinitionWithComplexNotificationsTest.this.universalName, MeasurementCategory.PERFORMANCE, MeasurementUnits.PERCENTAGE, DataType.MEASUREMENT, false, 100000L, DisplayType.DETAIL);
                AlertDefinitionWithComplexNotificationsTest.this.resourceType.addMetricDefinition(md);
                AlertDefinitionWithComplexNotificationsTest.this.resourceGroup = new ResourceGroup(AlertDefinitionWithComplexNotificationsTest.this.universalName, AlertDefinitionWithComplexNotificationsTest.this.resourceType);
                AlertDefinitionWithComplexNotificationsTest.this.resources = new LinkedHashSet();
                for (int i = 0; i < 10; ++i) {
                    res = AlertDefinitionWithComplexNotificationsTest.this.createResourceForTest(AlertDefinitionWithComplexNotificationsTest.this.universalName + i);
                    AlertDefinitionWithComplexNotificationsTest.this.resources.add(res);
                    AlertDefinitionWithComplexNotificationsTest.this.resourceGroup.addExplicitResource(res);
                }
                AlertDefinitionWithComplexNotificationsTest.this.templateAlertDefinition = AlertDefinitionWithComplexNotificationsTest.this.createDefinitionForTest("template", true);
                AlertDefinitionWithComplexNotificationsTest.this.templateAlertDefinition.setResourceType(AlertDefinitionWithComplexNotificationsTest.this.resourceType);
                AlertDefinitionWithComplexNotificationsTest.this.groupAlertDefinition = AlertDefinitionWithComplexNotificationsTest.this.createDefinitionForTest("group", true);
                AlertDefinitionWithComplexNotificationsTest.this.groupAlertDefinition.setGroup(AlertDefinitionWithComplexNotificationsTest.this.resourceGroup);
                AlertDefinitionWithComplexNotificationsTest.this.resourceAlertDefinition = AlertDefinitionWithComplexNotificationsTest.this.createDefinitionForTest("resource", true);
                AlertDefinitionWithComplexNotificationsTest.this.resourceAlertDefinition.setResource((Resource)AlertDefinitionWithComplexNotificationsTest.this.resources.iterator().next());
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.agent);
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.server);
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.role);
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.subject);
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.resourceType);
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.resourceGroup);
                for (Resource r : AlertDefinitionWithComplexNotificationsTest.this.resources) {
                    em.persist((Object)r);
                }
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.templateAlertDefinition);
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.groupAlertDefinition);
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.resourceAlertDefinition);
                AlertDefinitionWithComplexNotificationsTest.this.alertSenderService = new TestAlertSenderPluginService(AlertDefinitionWithComplexNotificationsTest.this.getTempDir());
                AlertDefinitionWithComplexNotificationsTest.this.prepareCustomServerPluginService(AlertDefinitionWithComplexNotificationsTest.this.alertSenderService);
                ((AlertDefinitionWithComplexNotificationsTest)AlertDefinitionWithComplexNotificationsTest.this).alertSenderService.masterConfig.getPluginDirectory().mkdirs();
                AlertDefinitionWithComplexNotificationsTest.this.unprepareServerPluginService();
                JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                archive.addClass(TestAlertSender.class);
                res = this.getClass().getClassLoader().getResource("test-alert-sender-serverplugin.xml");
                archive.addAsResource((URL)res, "META-INF/rhq-serverplugin.xml");
                File pluginFile = new File(((AlertDefinitionWithComplexNotificationsTest)AlertDefinitionWithComplexNotificationsTest.this).alertSenderService.masterConfig.getPluginDirectory(), "test-aler-plugin.jar");
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(pluginFile, true);
                AlertDefinitionWithComplexNotificationsTest.this.serverPlugin = TestServerPluginService.getPlugin(pluginFile.toURI().toURL());
                em.persist((Object)AlertDefinitionWithComplexNotificationsTest.this.serverPlugin);
                em.flush();
            }
        });
    }

    private void containerSetup() {
        this.prepareScheduler();
        this.alertSenderService = new TestAlertSenderPluginService(this.getTempDir());
        this.prepareCustomServerPluginService(this.alertSenderService);
        this.alertSenderService.masterConfig.getPluginDirectory().mkdirs();
        this.alertSenderService.startMasterPluginContainer();
        this.agentService = this.prepareForTestAgents();
    }

    private void containerTearDown() throws Exception {
        this.unprepareServerPluginService();
        this.unprepareForTestAgents();
        this.unprepareScheduler();
    }

    private void cleanDB() throws Exception {
        for (Object o : this.junk) {
            this.removeNoExceptions(o);
        }
        this.removeNoExceptions(this.resourceAlertDefinition);
        this.removeNoExceptions(this.groupAlertDefinition);
        this.removeNoExceptions(this.templateAlertDefinition);
        LookupUtil.getResourceGroupManager().deleteResourceGroup(LookupUtil.getSubjectManager().getOverlord(), this.resourceGroup.getId());
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                AlertDefinitionWithComplexNotificationsTest.this.em.createQuery("delete from AlertNotification an where an.senderName like 'Test Alert Sender%'").executeUpdate();
                AlertDefinitionWithComplexNotificationsTest.this.em.createQuery("delete from AlertCondition ac where ac.name like '" + AlertDefinitionWithComplexNotificationsTest.this.universalName + "%'").executeUpdate();
                AlertDefinitionWithComplexNotificationsTest.this.em.createQuery("delete from AlertDefinition ad where ad.name like '" + AlertDefinitionWithComplexNotificationsTest.this.universalName + "%'").executeUpdate();
            }
        });
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                AlertDefinitionWithComplexNotificationsTest.this.em.clear();
                for (Resource r : AlertDefinitionWithComplexNotificationsTest.this.resources) {
                    r = (Resource)AlertDefinitionWithComplexNotificationsTest.this.em.find(Resource.class, (Object)r.getId());
                    try {
                        ResourceTreeHelper.deleteResource(AlertDefinitionWithComplexNotificationsTest.this.em, r);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to DELETE Resource from database: " + r), (Throwable)e);
                    }
                }
            }
        });
        this.removeNoExceptions(this.resourceType);
        this.removeNoExceptions(this.subject);
        this.removeNoExceptions(this.role);
        this.removeNoExceptions(this.server);
        this.removeNoExceptions(this.agent);
        this.removeNoExceptions(this.serverPlugin);
    }

    private void login() throws Exception {
        this.subject = SessionManager.getInstance().put(this.subject);
    }

    private void logout() throws Exception {
        if (this.subject != null) {
            SessionManager.getInstance().invalidate(this.subject.getSessionId().intValue());
        } else {
            System.err.println("Empty subject, the setup failed horribly. Not throwing an exception to allow the database clean.");
        }
    }

    private Resource getCopyTestsResource() throws Exception {
        if (this.copyTestsResource == null) {
            String keyAndName = this.universalName + "-copyTests";
            LookupUtil.getResourceManager().createResource(this.subject, this.createResourceForTest(keyAndName), -1);
            ResourceCriteria crit = new ResourceCriteria();
            crit.addFilterResourceKey(keyAndName);
            crit.fetchExplicitGroups(true);
            crit.fetchAlertDefinitions(true);
            PageList foundResources = LookupUtil.getResourceManager().findResourcesByCriteria(this.subject, crit);
            this.assertEquals("A new resource should have been created", 1, foundResources.size());
            Resource res = (Resource)foundResources.get(0);
            this.resources.add(res);
            this.copyTestsResource = res;
        }
        return this.copyTestsResource;
    }

    private void testNotificationsCopiedOnAlertTemplateApplication() throws Exception {
        TestAlertSender.setExpectedSubject(null);
        TestAlertSender.resetValidateMethodCallCount();
        Resource res = this.getCopyTestsResource();
        LookupUtil.getAlertTemplateManager().updateAlertDefinitionsForResource(LookupUtil.getSubjectManager().getOverlord(), Integer.valueOf(res.getId()));
        this.assertEquals("No validation should occur on the copied notifications", 0, TestAlertSender.getValidateMethodCallCount());
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        AlertDefinitionCriteria adCrit = new AlertDefinitionCriteria();
        adCrit.addFilterResourceIds(new Integer[]{res.getId()});
        adCrit.fetchAlertNotifications(true);
        PageList foundAlertDefs = adm.findAlertDefinitionsByCriteria(this.subject, adCrit);
        this.junk.addAll((Collection<Object>)foundAlertDefs);
        this.assertEquals("The new resource should have an alert definition obtained from the template.", 1, foundAlertDefs.size());
        AlertDefinition defWithNotifications = (AlertDefinition)foundAlertDefs.get(0);
        this.testSingleDependentAlertDefinition(defWithNotifications, ParentType.TEMPLATE, defWithNotifications.getParentId());
    }

    private void testNotificationsCopiedOnGroupMemberAddition() throws Exception {
        TestAlertSender.setExpectedSubject(null);
        TestAlertSender.resetValidateMethodCallCount();
        Resource res = this.getCopyTestsResource();
        LookupUtil.getResourceGroupManager().addResourcesToGroup(this.subject, this.resourceGroup.getId(), new int[]{res.getId()});
        this.assertEquals("No validation should occur on the copied notifications", 0, TestAlertSender.getValidateMethodCallCount());
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        AlertDefinitionCriteria adCrit = new AlertDefinitionCriteria();
        adCrit.addFilterResourceIds(new Integer[]{res.getId()});
        adCrit.fetchAlertNotifications(true);
        PageList foundAlertDefs = adm.findAlertDefinitionsByCriteria(this.subject, adCrit);
        this.junk.addAll((Collection<Object>)foundAlertDefs);
        this.assertEquals("The new resource should have an alert definition obtained from the group.", 2, foundAlertDefs.size());
        AlertDefinition groupOriginatingDef = null;
        for (AlertDefinition d : foundAlertDefs) {
            if (!(this.universalName + ":group").equals(d.getName())) continue;
            groupOriginatingDef = d;
            break;
        }
        this.assertNotNull("The alert definition originating from the group not present on the resource.", groupOriginatingDef);
        this.testSingleDependentAlertDefinition(groupOriginatingDef, ParentType.GROUP, groupOriginatingDef.getGroupAlertDefinition().getId());
    }

    private void testCorrectSubjectPassedOnResourceLevelAlertDefCreation() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        Resource res = this.resources.iterator().next();
        AlertDefinition def = this.createDefinitionForTest("testCorrectSubjectPassedOnResourceLevelAlertDef", false);
        def.setResource(res);
        def = adm.createAlertDefinitionInNewTransaction(this.subject, def, Integer.valueOf(res.getId()), true);
        this.resourceLevelAlertDefinitionId = def.getId();
        this.junk.add(def);
        this.testMainAlertDefinition(this.resourceLevelAlertDefinitionId);
    }

    private void testCorrectSubjectPassedOnGroupLevelAlertDefCreation() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        GroupAlertDefinitionManagerLocal gadm = LookupUtil.getGroupAlertDefinitionManager();
        AlertDefinition def = this.createDefinitionForTest("testCorrectSubjectPassedOnGroupLevelAlertDef", false);
        def.setGroup(this.resourceGroup);
        int id = gadm.createGroupAlertDefinitions(this.subject, def, Integer.valueOf(this.resourceGroup.getId()));
        def.setId(id);
        this.groupLevelAlertDefinitionId = id;
        this.junk.add(def);
        this.testMainAlertDefinition(id);
        List<AlertDefinition> deps = this.testDependentAlertDefinitions(id, ParentType.GROUP);
        this.junk.addAll(deps);
    }

    private void testCorrectSubjectPassedOnTemplateLevelAlertDefCreation() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        AlertTemplateManagerLocal atm = LookupUtil.getAlertTemplateManager();
        AlertDefinition def = this.createDefinitionForTest("testCorrectSubjectPassedOnTemplateLevelAlertDef", false);
        def.setGroup(this.resourceGroup);
        int id = atm.createAlertTemplate(this.subject, def, Integer.valueOf(this.resourceType.getId()));
        def.setId(id);
        this.templateLevelAlertDefinitionId = id;
        this.junk.add(def);
        this.testMainAlertDefinition(id);
        List<AlertDefinition> deps = this.testDependentAlertDefinitions(id, ParentType.TEMPLATE);
        this.junk.addAll(deps);
    }

    private void testNoValidationWhenNoNotificationUpdateOnResourceLevel() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        TestAlertSender.resetValidateMethodCallCount();
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        AlertDefinitionCriteria crit = new AlertDefinitionCriteria();
        crit.addFilterId(Integer.valueOf(this.resourceLevelAlertDefinitionId));
        crit.fetchAlertNotifications(true);
        crit.fetchConditions(true);
        PageList foundDefs = adm.findAlertDefinitionsByCriteria(this.subject, crit);
        this.assertEquals("Failed to find the previously created resource level alert definition.", 1, foundDefs.size());
        AlertDefinition foundDef = (AlertDefinition)foundDefs.get(0);
        foundDef.setEnabled(true);
        adm.updateAlertDefinition(this.subject, this.resourceLevelAlertDefinitionId, foundDef, false);
        this.assertEquals("The notification validation method shouldn't have been called", 0, TestAlertSender.getValidateMethodCallCount());
    }

    private void testNoValidationWhenNoNotificationUpdateOnGroupLevel() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        TestAlertSender.resetValidateMethodCallCount();
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        AlertDefinitionCriteria crit = new AlertDefinitionCriteria();
        crit.addFilterId(Integer.valueOf(this.groupLevelAlertDefinitionId));
        crit.fetchAlertNotifications(true);
        crit.fetchConditions(true);
        PageList foundDefs = adm.findAlertDefinitionsByCriteria(this.subject, crit);
        this.assertEquals("Failed to find the previously created group level alert definition.", 1, foundDefs.size());
        AlertDefinition foundDef = (AlertDefinition)foundDefs.get(0);
        foundDef.setEnabled(true);
        GroupAlertDefinitionManagerLocal gadm = LookupUtil.getGroupAlertDefinitionManager();
        gadm.updateGroupAlertDefinitions(this.subject, foundDef, true);
        this.assertEquals("The notification validation method shouldn't have been called", 0, TestAlertSender.getValidateMethodCallCount());
    }

    private void testNoValidationWhenNoNotificationUpdateOnTemplateLevel() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        TestAlertSender.resetValidateMethodCallCount();
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        AlertDefinitionCriteria crit = new AlertDefinitionCriteria();
        crit.addFilterId(Integer.valueOf(this.templateLevelAlertDefinitionId));
        crit.fetchAlertNotifications(true);
        crit.fetchConditions(true);
        PageList foundDefs = adm.findAlertDefinitionsByCriteria(this.subject, crit);
        this.assertEquals("Failed to find the previously created resource level alert definition.", 1, foundDefs.size());
        AlertDefinition foundDef = (AlertDefinition)foundDefs.get(0);
        foundDef.setEnabled(true);
        AlertTemplateManagerLocal atm = LookupUtil.getAlertTemplateManager();
        atm.updateAlertTemplate(this.subject, foundDef, true);
        this.assertEquals("The notification validation method shouldn't have been called", 0, TestAlertSender.getValidateMethodCallCount());
    }

    private void testCorrectSubjectPassedOnResourceLevelAlertDefinitionUpdate() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        TestAlertSender.resetValidateMethodCallCount();
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        AlertDefinitionCriteria crit = new AlertDefinitionCriteria();
        crit.addFilterId(Integer.valueOf(this.resourceLevelAlertDefinitionId));
        crit.fetchAlertNotifications(true);
        crit.fetchConditions(true);
        PageList foundDefs = adm.findAlertDefinitionsByCriteria(this.subject, crit);
        this.assertEquals("Failed to find the previously created resource level alert definition.", 1, foundDefs.size());
        AlertDefinition foundDef = (AlertDefinition)foundDefs.get(0);
        AlertNotification newNotif = this.createAlertNotificationForTest(foundDef, false);
        adm.updateAlertDefinition(this.subject, this.resourceLevelAlertDefinitionId, foundDef, false);
        this.assertEquals("Validation should have been called for a new notification during alert def update", 1, TestAlertSender.getValidateMethodCallCount());
    }

    private void testCorrectSubjectPassedOnGroupLevelAlertDefinitionUpdate() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        TestAlertSender.resetValidateMethodCallCount();
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        AlertDefinitionCriteria crit = new AlertDefinitionCriteria();
        crit.addFilterId(Integer.valueOf(this.groupLevelAlertDefinitionId));
        crit.fetchAlertNotifications(true);
        crit.fetchConditions(true);
        PageList foundDefs = adm.findAlertDefinitionsByCriteria(this.subject, crit);
        this.assertEquals("Failed to find the previously created group level alert definition.", 1, foundDefs.size());
        AlertDefinition foundDef = (AlertDefinition)foundDefs.get(0);
        AlertNotification newNotif = this.createAlertNotificationForTest(foundDef, false);
        GroupAlertDefinitionManagerLocal gadm = LookupUtil.getGroupAlertDefinitionManager();
        gadm.updateGroupAlertDefinitions(this.subject, foundDef, true);
        this.assertEquals("Validation should have been called for a new notification during alert def update", 1, TestAlertSender.getValidateMethodCallCount());
    }

    private void testCorrectSubjectPassedOnTemplateLevelAlertDefinitionUpdate() throws Exception {
        TestAlertSender.setExpectedSubject(this.subject);
        TestAlertSender.resetValidateMethodCallCount();
        AlertDefinitionManagerLocal adm = LookupUtil.getAlertDefinitionManager();
        AlertDefinitionCriteria crit = new AlertDefinitionCriteria();
        crit.addFilterId(Integer.valueOf(this.templateLevelAlertDefinitionId));
        crit.fetchAlertNotifications(true);
        crit.fetchConditions(true);
        PageList foundDefs = adm.findAlertDefinitionsByCriteria(this.subject, crit);
        this.assertEquals("Failed to find the previously created template level alert definition.", 1, foundDefs.size());
        AlertDefinition foundDef = (AlertDefinition)foundDefs.get(0);
        AlertNotification newNotif = this.createAlertNotificationForTest(foundDef, false);
        AlertTemplateManagerLocal atm = LookupUtil.getAlertTemplateManager();
        atm.updateAlertTemplate(this.subject, foundDef, true);
        this.assertEquals("Validation should have been called for a new notification during alert def update", 1, TestAlertSender.getValidateMethodCallCount());
    }

    private void removeNoExceptions(final Object o) {
        try {
            this.executeInTransaction(false, new TransactionCallback(){

                @Override
                public void execute() {
                    EntityManager em = AlertDefinitionWithComplexNotificationsTest.this.getEntityManager();
                    Object o2 = em.merge(o);
                    if (o2 instanceof Resource) {
                        ResourceTreeHelper.deleteResource(em, (Resource)o2);
                    } else {
                        em.remove(o2);
                    }
                    em.flush();
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to DELETE an object from database: " + o), (Throwable)e);
        }
    }

    private AlertDefinition createDefinition(String name) {
        AlertDefinition ret = new AlertDefinition();
        ret.setName(this.universalName + ":" + name);
        ret.setPriority(AlertPriority.MEDIUM);
        ret.setConditionExpression(BooleanExpression.ANY);
        ret.setRecoveryId(Integer.valueOf(0));
        AlertCondition ac = new AlertCondition();
        ac.setName(this.universalName + ":" + name);
        ac.setCategory(AlertConditionCategory.THRESHOLD);
        ac.setComparator(">");
        ac.setThreshold(Double.valueOf(0.75));
        ret.addCondition(ac);
        AlertDampening dampener = new AlertDampening(AlertDampening.Category.PARTIAL_COUNT);
        dampener.setPeriod(15);
        dampener.setPeriodUnits(AlertDampening.TimeUnits.MINUTES);
        dampener.setValue(10);
        ret.setAlertDampening(dampener);
        return ret;
    }

    private AlertDefinition createDefinitionForTest(String name, boolean precanned) {
        AlertDefinition def = this.createDefinition(name);
        this.createAlertNotificationForTest(def, precanned);
        return def;
    }

    private AlertNotification createAlertNotificationForTest(AlertDefinition alertDefinition, boolean precanned) {
        AlertNotification notif = new AlertNotification("Test Alert Sender");
        Configuration alertConfig = new Configuration();
        Random randomGenerator = new Random();
        String randomValue = randomGenerator.nextInt(100) + " - " + randomGenerator.nextInt(200);
        alertConfig.put((Property)new PropertySimple(randomValue, (Object)randomValue));
        if (precanned) {
            alertConfig.put((Property)new PropertySimple("persistent", (Object)"persistentephemeral"));
        } else {
            alertConfig.put((Property)new PropertySimple("persistent", (Object)"persistent"));
            alertConfig.put((Property)new PropertySimple("ephemeral", (Object)"ephemeral"));
        }
        Configuration extraConfig = new Configuration();
        if (precanned) {
            extraConfig.put((Property)new PropertySimple("persistent", (Object)"persistentephemeral"));
        } else {
            extraConfig.put((Property)new PropertySimple("persistent", (Object)"persistent"));
            extraConfig.put((Property)new PropertySimple("ephemeral", (Object)"ephemeral"));
        }
        notif.setConfiguration(alertConfig);
        notif.setExtraConfiguration(extraConfig);
        alertDefinition.addAlertNotification(notif);
        notif.setAlertDefinition(alertDefinition);
        return notif;
    }

    private void testMainAlertDefinition(int id) {
        AlertDefinitionCriteria crit = new AlertDefinitionCriteria();
        crit.addFilterId(Integer.valueOf(id));
        crit.fetchAlertNotifications(true);
        PageList checkList = LookupUtil.getAlertDefinitionManager().findAlertDefinitionsByCriteria(this.subject, crit);
        this.assertNotNull("Failed to retrieve the save alert definition", checkList);
        this.assertEquals("The alert definition should have been saved.", 1, checkList.size());
        AlertDefinition check = (AlertDefinition)checkList.get(0);
        this.assertEquals("There should be exactly 1 notification on the definition", 1, check.getAlertNotifications().size());
        Configuration config = ((AlertNotification)check.getAlertNotifications().get(0)).getConfiguration();
        this.assertEquals("Unexpected persistent value in notif config", "persistentephemeral", config.getSimpleValue("persistent", null));
        this.assertNull("Ephemeral property seems to have been saved", config.getSimpleValue("ephemeral", null));
    }

    private List<AlertDefinition> testDependentAlertDefinitions(int expectedParentId, ParentType parentType) {
        AlertDefinitionCriteria crit = new AlertDefinitionCriteria();
        HashSet<Integer> resourceIds = new HashSet<Integer>(this.resources.size());
        for (Resource r : this.resources) {
            resourceIds.add(r.getId());
        }
        if (parentType == ParentType.TEMPLATE) {
            crit.addFilterAlertTemplateParentId(Integer.valueOf(expectedParentId));
        } else if (parentType == ParentType.GROUP) {
            crit.addFilterGroupAlertDefinitionId(Integer.valueOf(expectedParentId));
        }
        crit.fetchAlertNotifications(true);
        PageList checkList = LookupUtil.getAlertDefinitionManager().findAlertDefinitionsByCriteria(this.subject, crit);
        this.assertNotNull("Failed to retrieve the save alert definition", checkList);
        this.assertEquals("The dependent alert definitions should have been saved.", this.resources.size(), checkList.size());
        for (AlertDefinition check : checkList) {
            this.testSingleDependentAlertDefinition(check, parentType, expectedParentId);
        }
        return checkList;
    }

    private void testSingleDependentAlertDefinition(AlertDefinition alertDef, ParentType parentType, int expectedParentId) {
        this.assertEquals("There should be exactly 1 notification on the definition " + alertDef, 1, alertDef.getAlertNotifications().size());
        Configuration config = ((AlertNotification)alertDef.getAlertNotifications().get(0)).getConfiguration();
        this.assertEquals("Unexpected persistent value in notif config " + alertDef, "persistentephemeral", config.getSimpleValue("persistent", null));
        this.assertNull("Ephemeral property seems to have been saved " + alertDef, config.getSimpleValue("ephemeral", null));
        if (parentType == ParentType.GROUP) {
            this.assertEquals("The group parent id has unexpected value", expectedParentId, alertDef.getGroupAlertDefinition().getId());
        } else if (parentType == ParentType.TEMPLATE) {
            this.assertEquals("The parent id has unexpected value", (Object)expectedParentId, alertDef.getParentId());
        }
    }

    private Resource createResourceForTest(String resourceKey) {
        Resource res = new ResourceBuilder().createPlatform().withRandomUuid().withResourceKey(resourceKey).withResourceType(this.resourceType).withName(resourceKey).withInventoryStatus(InventoryStatus.COMMITTED).build();
        res.setAgent(this.agent);
        return res;
    }

    private static enum ParentType {
        GROUP,
        TEMPLATE;

    }
}

