/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

@Test(groups={"alert"})
public class GroupAlertDefinitionManagerBeanTest
extends AbstractEJB3Test {
    private static final Log LOG = LogFactory.getLog(GroupAlertDefinitionManagerBeanTest.class);
    public static final int NUMBER_OF_RESOURCES_TO_CREATE = 3753;
    private final String prefix = ((Object)((Object)this)).getClass().getSimpleName() + "_";
    private final String subjectName = this.prefix + "subject";
    private final String roleName = this.prefix + "role";
    private final String groupName = this.prefix + "group";
    private final String resourceName = this.prefix + "resource";
    private SubjectManagerLocal subjectManager;
    private RoleManagerLocal roleManager;
    private ResourceGroupManagerLocal resourceGroupManager;
    private GroupAlertDefinitionManagerLocal groupAlertDefinitionManager;
    private AlertDefinitionManagerLocal alertDefinitionManager;
    private TestData testData;

    @Override
    protected void beforeMethod() throws Exception {
        this.subjectManager = LookupUtil.getSubjectManager();
        this.roleManager = LookupUtil.getRoleManager();
        this.resourceGroupManager = LookupUtil.getResourceGroupManager();
        this.groupAlertDefinitionManager = LookupUtil.getGroupAlertDefinitionManager();
        this.alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
        this.createTestData();
        this.prepareScheduler();
    }

    public void testBug738799() {
        this.assertEquals(this.testData.getResources().size(), this.getChildrenAlertDefinitionIds(this.testData.getGroupAlertDefinitionId()).size());
        int modified = this.groupAlertDefinitionManager.removeGroupAlertDefinitions(this.testData.getSubject(), new Integer[]{this.testData.getGroupAlertDefinitionId()});
        this.assertEquals(modified, 1);
        this.assertEquals(0, this.getChildrenAlertDefinitionIds(this.testData.getGroupAlertDefinitionId()).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            this.deleteTestData();
        }
        finally {
            this.testData = null;
            this.unprepareScheduler();
        }
    }

    private void createTestData() throws Exception {
        this.testData = this.executeInTransaction(false, new TransactionCallbackReturnable<TestData>(){

            @Override
            public TestData execute() throws Exception {
                TestData newTestData = new TestData();
                Subject subject = SessionTestHelper.createNewSubject(GroupAlertDefinitionManagerBeanTest.this.em, GroupAlertDefinitionManagerBeanTest.this.subjectName);
                newTestData.setSubject(subject);
                Role role = SessionTestHelper.createNewRoleForSubject(GroupAlertDefinitionManagerBeanTest.this.em, subject, GroupAlertDefinitionManagerBeanTest.this.roleName, Permission.MANAGE_ALERTS, Permission.MANAGE_SETTINGS, Permission.MANAGE_INVENTORY);
                newTestData.setRole(role);
                ResourceType resourceType = SessionTestHelper.createNewResourceType(GroupAlertDefinitionManagerBeanTest.this.em);
                newTestData.setResourceType(resourceType);
                ResourceGroup resourceGroup = new ResourceGroup(GroupAlertDefinitionManagerBeanTest.this.groupName, resourceType);
                resourceGroup = GroupAlertDefinitionManagerBeanTest.this.resourceGroupManager.createResourceGroup(subject, resourceGroup);
                newTestData.setResourceGroup(resourceGroup);
                GroupAlertDefinitionManagerBeanTest.this.roleManager.setAssignedResourceGroups(GroupAlertDefinitionManagerBeanTest.this.subjectManager.getOverlord(), role.getId(), new int[]{resourceGroup.getId()});
                return newTestData;
            }
        });
        this.testData.setResources(new ArrayList(3753));
        while (this.testData.getResources().size() < 3753) {
            this.executeInTransaction(false, new TransactionCallback(){

                @Override
                public void execute() throws Exception {
                    for (int i = 0; i < 50 && GroupAlertDefinitionManagerBeanTest.this.testData.getResources().size() < 3753; ++i) {
                        GroupAlertDefinitionManagerBeanTest.this.testData.getResources().add(SessionTestHelper.createNewResource(GroupAlertDefinitionManagerBeanTest.this.em, GroupAlertDefinitionManagerBeanTest.this.resourceName, GroupAlertDefinitionManagerBeanTest.this.testData.getResourceType()));
                    }
                }
            });
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(this.testData.getResources().size() + " resources created"));
        }
        int[] resourceIds = new int[this.testData.getResources().size()];
        for (int i = 0; i < this.testData.getResources().size(); ++i) {
            resourceIds[i] = ((Resource)this.testData.getResources().get(i)).getId();
        }
        this.resourceGroupManager.setAssignedResources(this.testData.getSubject(), this.testData.getResourceGroup().getId(), resourceIds, true);
        this.testData.setGroupAlertDefinitionId(this.createGroupAlertDefinition(this.testData.getSubject(), this.testData.getResourceGroup()).getId());
    }

    private AlertDefinition createGroupAlertDefinition(Subject subject, ResourceGroup resourceGroup) {
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName(AlertConditionOperator.AVAIL_GOES_UP.name());
        alertDefinition.setPriority(AlertPriority.MEDIUM);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setConditionExpression(BooleanExpression.ANY);
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setGroup(resourceGroup);
        alertDefinition.setEnabled(true);
        AlertCondition alertCondition = new AlertCondition(alertDefinition, AlertConditionCategory.AVAILABILITY);
        alertCondition.setName(AlertConditionOperator.AVAIL_GOES_UP.name());
        alertDefinition.addCondition(alertCondition);
        this.groupAlertDefinitionManager.createGroupAlertDefinitions(subject, alertDefinition, Integer.valueOf(resourceGroup.getId()));
        return alertDefinition;
    }

    private void deleteTestData() throws Exception {
        if (this.testData != null) {
            this.groupAlertDefinitionManager.removeGroupAlertDefinitions(this.subjectManager.getOverlord(), new Integer[]{this.testData.getGroupAlertDefinitionId()});
            this.resourceGroupManager.deleteResourceGroup(this.subjectManager.getOverlord(), this.testData.getResourceGroup().getId());
            this.alertDefinitionManager.purgeUnusedAlertDefinitions();
            for (Resource resource : this.testData.getResources()) {
                this.removeEntity(Resource.class, resource.getId());
            }
            this.removeEntity(ResourceType.class, this.testData.getResourceType().getId());
            this.subjectManager.deleteSubjects(this.subjectManager.getOverlord(), new int[]{this.testData.getSubject().getId()});
            this.roleManager.deleteRoles(this.subjectManager.getOverlord(), new int[]{this.testData.getRole().getId()});
        }
    }

    private void removeEntity(final Class<?> entityClass, final Object entityId) {
        try {
            this.executeInTransaction(false, new TransactionCallback(){

                @Override
                public void execute() throws Exception {
                    Object object = GroupAlertDefinitionManagerBeanTest.this.em.find(entityClass, entityId);
                    if (object instanceof Resource) {
                        ResourceTreeHelper.deleteResource(GroupAlertDefinitionManagerBeanTest.this.em, (Resource)object);
                    } else {
                        GroupAlertDefinitionManagerBeanTest.this.em.remove(object);
                        GroupAlertDefinitionManagerBeanTest.this.em.flush();
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to delete object from database: " + entityClass + "[id=" + entityId + "]"), (Throwable)e);
        }
    }

    private List<Integer> getChildrenAlertDefinitionIds(final int groupAlertDefinitionId) {
        return this.executeInTransaction(false, new TransactionCallbackReturnable<List<Integer>>(){

            @Override
            public List<Integer> execute() throws Exception {
                TypedQuery query = GroupAlertDefinitionManagerBeanTest.this.getEntityManager().createNamedQuery("AlertDefinition.findByGroupAlertDefinitionId", Integer.class);
                query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
                return query.getResultList();
            }
        });
    }

    private static final class TestData {
        private Subject subject;
        private Role role;
        private ResourceType resourceType;
        private ResourceGroup resourceGroup;
        private List<Resource> resources;
        private int groupAlertDefinitionId;

        private TestData() {
        }

        private Subject getSubject() {
            return this.subject;
        }

        private void setSubject(Subject subject) {
            this.subject = subject;
        }

        private Role getRole() {
            return this.role;
        }

        private void setRole(Role role) {
            this.role = role;
        }

        private ResourceType getResourceType() {
            return this.resourceType;
        }

        private void setResourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        private ResourceGroup getResourceGroup() {
            return this.resourceGroup;
        }

        private void setResourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
        }

        private List<Resource> getResources() {
            return this.resources;
        }

        private void setResources(List<Resource> resources) {
            this.resources = resources;
        }

        private int getGroupAlertDefinitionId() {
            return this.groupAlertDefinitionId;
        }

        private void setGroupAlertDefinitionId(int groupAlertDefinitionId) {
            this.groupAlertDefinitionId = groupAlertDefinitionId;
        }
    }
}

