/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderValidationResults;
import org.testng.Assert;

public class TestAlertSender
extends AlertSender<ServerPluginComponent> {
    public static final String NAME = "Test Alert Sender";
    public static final String PERSISTENT_PROPERTY_NAME = "persistent";
    public static final String PERSISTEN_PROPERTY_EXPECTED_VALUE = "persistentephemeral";
    public static final String EPHEMERAL_PROPERTY_NAME = "ephemeral";
    private static Subject EXPECTED_SUBJECT;
    private static volatile int VALIDATE_METHOD_CALL_COUNT;
    private static Runnable VALIDATION_CHECKER;

    public static void setExpectedSubject(Subject subject) {
        EXPECTED_SUBJECT = subject;
    }

    public static void setValidationChecker(Runnable validationChecker) {
        VALIDATION_CHECKER = validationChecker;
    }

    public static int getValidateMethodCallCount() {
        return VALIDATE_METHOD_CALL_COUNT;
    }

    public static void resetValidateMethodCallCount() {
        VALIDATE_METHOD_CALL_COUNT = 0;
    }

    public SenderResult send(Alert alert) {
        SenderResult ret = new SenderResult();
        ret.addSuccessMessage("kachny");
        return ret;
    }

    public AlertSenderValidationResults validateAndFinalizeConfiguration(Subject subject) {
        ++VALIDATE_METHOD_CALL_COUNT;
        if (EXPECTED_SUBJECT != null && !subject.equals((Object)EXPECTED_SUBJECT)) {
            throw new AssertionError((Object)("Unexpected subject. Expected " + EXPECTED_SUBJECT + " but was " + subject));
        }
        if (VALIDATION_CHECKER != null) {
            VALIDATION_CHECKER.run();
        }
        if (this.alertParameters.getSimple(EPHEMERAL_PROPERTY_NAME) == null) {
            Assert.fail((String)"Ephemeral property not present in alert parameters during validation. This should never happen.");
        }
        if (this.extraParameters.getSimple(EPHEMERAL_PROPERTY_NAME) == null) {
            Assert.fail((String)"Ephemeral property not present in extra parameters during validation. This should never happen.");
        }
        this.updateConfig(this.alertParameters);
        this.updateConfig(this.extraParameters);
        return new AlertSenderValidationResults(this.alertParameters, this.extraParameters);
    }

    private void updateConfig(Configuration configuration) {
        String persistentValue = configuration.getSimpleValue(PERSISTENT_PROPERTY_NAME, "");
        String ephemeralValue = configuration.getSimpleValue(EPHEMERAL_PROPERTY_NAME, "");
        configuration.put((Property)new PropertySimple(PERSISTENT_PROPERTY_NAME, (Object)(persistentValue + ephemeralValue)));
        configuration.remove(EPHEMERAL_PROPERTY_NAME);
    }
}

