/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.test;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class AlertConditionTest
extends UpdatePluginMetadataTestBase {
    private static final boolean ENABLED = true;
    private Resource resource;

    @Override
    protected String getSubsystemDirectory() {
        return "alerts";
    }

    @Override
    protected void afterMethod() throws Exception {
        if (this.resource != null) {
            this.deleteNewResource(this.resource);
            this.resource = null;
        }
        super.afterMethod();
    }

    @Test(enabled=true)
    public void testBZ735262_InsideRangeCondition() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        this.createAlertDefinitionWithOneInsideRangeCondition(metricDef, this.resource.getId());
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(60L), request, Double.valueOf(20.0)));
        report.addData(new MeasurementDataNumeric(this.getTimestamp(30L), request, Double.valueOf(70.0)));
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 0) : "no alerts should have fired: " + alerts;
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(15L), request, Double.valueOf(50.0)));
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
    }

    @Test(enabled=true)
    public void testBZ735262_OutsideRangeCondition() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        this.createAlertDefinitionWithOneOutsideRangeCondition(metricDef, this.resource.getId());
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(60L), request, Double.valueOf(50.0)));
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 0) : "no alerts should have fired: " + alerts;
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(15L), request, Double.valueOf(20.0)));
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
    }

    @Test(enabled=true)
    public void testBZ736685_DeleteConditionLogButNoAlert() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        AlertDefinition alertDef = this.createAlertDefinitionWithTwoConditionsALL(metricDef, this.resource.getId());
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(60L), request, Double.valueOf(20.0)));
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 0) : "no alerts should have fired: " + alerts;
        int condId = 0;
        for (AlertCondition cond : alertDef.getConditions()) {
            if (!cond.getComparator().equals("<")) continue;
            condId = cond.getId();
            break;
        }
        assert (condId > 0) : "failed to get the condition ID - something is wrong with test setup";
        AlertCondition conditionWithLogs = this.getAlertConditionWithLogs(condId);
        Set logs = conditionWithLogs.getConditionLogs();
        assert (logs != null && logs.size() > 0) : "missing condition log - we should have one that was generated";
        AlertConditionLog log = (AlertConditionLog)logs.iterator().next();
        assert (log.getAlert() == null) : "condition should not have fired an alert: " + logs;
        int resourceId = this.resource.getId();
        this.deleteNewResource(this.resource);
        this.resource = null;
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        PageList defs = alertDefManager.findAlertDefinitions(this.getOverlord(), resourceId, PageControl.getUnlimitedInstance());
        assert (defs.isEmpty()) : "failed to delete the alert definition - are condition logs still around?";
    }

    @Test(enabled=true)
    public void testAvailChangeAlert() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        this.createAlertDefinitionWithAvailChangeCondition(this.resource.getId(), AlertConditionOperator.AVAIL_GOES_DOWN);
        this.createAlertDefinitionWithAvailChangeCondition(this.resource.getId(), AlertConditionOperator.AVAIL_GOES_NOT_UP);
        AvailabilityReport availReport = new AvailabilityReport("-dummy agent-");
        availReport.addAvailability(new AvailabilityReport.Datum(this.resource.getId(), AvailabilityType.UP, System.currentTimeMillis()));
        AvailabilityManagerLocal availManager = LookupUtil.getAvailabilityManager();
        availManager.mergeAvailabilityReport(availReport);
        Thread.sleep(3000L);
        PageList<Alert> alerts = this.getAlerts(this.resource.getId());
        assert (alerts.size() == 0) : "No alert should have fired on the initial avail reporting: " + alerts;
        availReport = new AvailabilityReport("-dummy agent-");
        availReport.addAvailability(new AvailabilityReport.Datum(this.resource.getId(), AvailabilityType.DOWN, System.currentTimeMillis() + 10L));
        availManager.mergeAvailabilityReport(availReport);
        Thread.sleep(3000L);
        alerts = this.getAlerts(this.resource.getId());
        assert (alerts.size() == 2) : "Two alerts should have fired on the avail change: " + alerts;
        assert (!((Alert)alerts.get(0)).getAlertDefinition().getName().equals(((Alert)alerts.get(1)).getAlertDefinition().getName())) : "Alerts should have been from different definitions";
        int resourceId = this.resource.getId();
        this.deleteNewResource(this.resource);
        this.resource = null;
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        PageList defs = alertDefManager.findAlertDefinitions(this.getOverlord(), resourceId, PageControl.getUnlimitedInstance());
        assert (defs.isEmpty()) : "failed to delete the alert definition - are condition logs still around?";
    }

    @Test(enabled=true)
    public void testAvailDurationAlert() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        this.createAlertDefinitionWithAvailDurationCondition(this.resource.getId(), "testAvailDurationAlertDef_1", AlertConditionOperator.AVAIL_DURATION_DOWN, 10);
        this.createAlertDefinitionWithAvailDurationCondition(this.resource.getId(), "testAvailDurationAlertDef_2", AlertConditionOperator.AVAIL_DURATION_DOWN, 10);
        AvailabilityReport availReport = new AvailabilityReport("-dummy agent-");
        availReport.addAvailability(new AvailabilityReport.Datum(this.resource.getId(), AvailabilityType.UP, System.currentTimeMillis()));
        AvailabilityManagerLocal availManager = LookupUtil.getAvailabilityManager();
        availManager.mergeAvailabilityReport(availReport);
        Thread.sleep(4000L);
        PageList<Alert> alerts = this.getAlerts(this.resource.getId());
        assert (alerts.size() == 0) : "No alert should have fired on the initial avail reporting: " + alerts;
        availReport = new AvailabilityReport("-dummy agent-");
        availReport.addAvailability(new AvailabilityReport.Datum(this.resource.getId(), AvailabilityType.DOWN, System.currentTimeMillis() + 10L));
        availManager.mergeAvailabilityReport(availReport);
        Thread.sleep(4000L);
        alerts = this.getAlerts(this.resource.getId());
        assert (alerts.size() == 0) : "No alert should have fired after 4s, will take at least 10s: " + alerts;
        Thread.sleep(10000L);
        alerts = this.getAlerts(this.resource.getId());
        assert (alerts.size() == 2) : "Two alerts should have fired on the avail duration: " + alerts;
        int resourceId = this.resource.getId();
        this.deleteNewResource(this.resource);
        this.resource = null;
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        PageList defs = alertDefManager.findAlertDefinitions(this.getOverlord(), resourceId, PageControl.getUnlimitedInstance());
        assert (defs.isEmpty()) : "failed to delete the alert definition - are condition logs still around?";
    }

    @Test(enabled=true)
    public void testBZ830463_updateDef() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule();
        AlertDefinition alertDef = this.createAlertDefinitionWithOneInsideRangeCondition(metricDef, this.resource.getId());
        assert (alertDef.getConditions().size() == 1) : "1 alertDef condition should exist";
        AlertCondition condition = (AlertCondition)alertDef.getConditions().iterator().next();
        int conditionId = condition.getId();
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(15L), request, Double.valueOf(50.0)));
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
        Alert alert = (Alert)alerts.get(0);
        assert (alert.getConditionLogs().size() == 1) : "1 condition log should exist";
        AlertConditionLog conditionLog = (AlertConditionLog)alert.getConditionLogs().iterator().next();
        Assert.assertEquals((int)conditionLog.getCondition().getId(), (int)conditionId, (String)"original condition should have been associated with the alert");
        String updatedDesc = "Updated Description";
        alertDef.setDescription(updatedDesc);
        AlertDefinition updatedAlertDef = LookupUtil.getAlertDefinitionManager().updateAlertDefinition(this.getOverlord(), alertDef.getId(), alertDef, false);
        assert (updatedDesc.equals(updatedAlertDef.getDescription())) : "Description should be updated";
        assert (updatedAlertDef.getConditions().size() == 1) : "1 alertDef condition should exist after the update";
        assert (((AlertCondition)updatedAlertDef.getConditions().iterator().next()).getId() == condition.getId()) : "condition should not be updated";
        alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
        alert = (Alert)alerts.get(0);
        assert (alert.getConditionLogs().size() == 1) : "1 condition log should exist after the update";
        conditionLog = (AlertConditionLog)alert.getConditionLogs().iterator().next();
        Assert.assertEquals((int)conditionLog.getCondition().getId(), (int)conditionId, (String)"original condition should still have been associated with the alert");
        condition.setThreshold(Double.valueOf(41.0));
        updatedAlertDef = LookupUtil.getAlertDefinitionManager().updateAlertDefinition(this.getOverlord(), alertDef.getId(), alertDef, true);
        assert (updatedAlertDef.getConditions().size() == 1) : "1 alertDef condition should exist after the update";
        assert (((AlertCondition)updatedAlertDef.getConditions().iterator().next()).getId() != condition.getId()) : "condition should be updated";
        alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
        alert = (Alert)alerts.get(0);
        assert (alert.getConditionLogs().size() == 1) : "1 condition log should exist after the update";
        conditionLog = (AlertConditionLog)alert.getConditionLogs().iterator().next();
        Assert.assertEquals((int)conditionLog.getCondition().getId(), (int)conditionId, (String)"original condition should still have been associated with the alert");
    }

    @Test(enabled=true)
    public void testBZ1058534_changeCondition() throws Exception {
        MeasurementDefinition metricDef = this.createResourceWithMetricSchedule("type-with-trait.xml", "TypeWithTrait");
        AlertDefinition alertDef = this.createAlertDefinitionWithChangeFromNull(metricDef, this.resource.getId());
        assert (alertDef.getConditions().size() == 1) : "1 alertDef condition should exist";
        AlertCondition condition = (AlertCondition)alertDef.getConditions().iterator().next();
        int conditionId = condition.getId();
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataTrait(this.getTimestamp(15L), request, "Foo"));
        MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
        dataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
        Alert alert = (Alert)alerts.get(0);
        assert (alert.getConditionLogs().size() == 1) : "1 condition log should exist";
        AlertConditionLog conditionLog = (AlertConditionLog)alert.getConditionLogs().iterator().next();
        Assert.assertEquals((int)conditionLog.getCondition().getId(), (int)conditionId, (String)"original condition should have been associated with the alert");
    }

    public void testDampeningWorksAcrossConditionCacheReloads() throws Exception {
        MeasurementDefinition measDef = this.createResourceWithMetricSchedule();
        AlertDefinition alertDef = this.createAlertDefinitionWithDampening(measDef, this.resource.getId());
        Resource resourceWithSchedules = this.loadResourceWithSchedules(this.resource.getId());
        MeasurementSchedule schedule = (MeasurementSchedule)resourceWithSchedules.getSchedules().iterator().next();
        MeasurementDataManagerLocal measurementDataManager = LookupUtil.getMeasurementDataManager();
        MeasurementScheduleRequest request = new MeasurementScheduleRequest(schedule);
        MeasurementReport report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(25L), request, Double.valueOf(0.0)));
        measurementDataManager.mergeMeasurementReport(report);
        Thread.sleep(3000L);
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(20L), request, Double.valueOf(0.0)));
        measurementDataManager.mergeMeasurementReport(report);
        Thread.sleep(3000L);
        this.reloadAllAlertConditionCaches();
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(15L), request, Double.valueOf(1.0)));
        measurementDataManager.mergeMeasurementReport(report);
        Thread.sleep(3000L);
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(10L), request, Double.valueOf(0.0)));
        measurementDataManager.mergeMeasurementReport(report);
        Thread.sleep(3000L);
        PageList<Alert> alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 0) : "No alert should have fired: " + alerts;
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(5L), request, Double.valueOf(0.0)));
        measurementDataManager.mergeMeasurementReport(report);
        Thread.sleep(3000L);
        this.reloadAllAlertConditionCaches();
        request = new MeasurementScheduleRequest(schedule);
        report = new MeasurementReport();
        report.addData(new MeasurementDataNumeric(this.getTimestamp(0L), request, Double.valueOf(0.0)));
        measurementDataManager.mergeMeasurementReport(report);
        Thread.sleep(5000L);
        alerts = this.getAlerts(resourceWithSchedules.getId());
        assert (alerts.size() == 1) : "1 alert should have fired: " + alerts;
    }

    private PageList<Alert> getAlerts(int resourceId) {
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        AlertCriteria alertCriteria = new AlertCriteria();
        alertCriteria.addFilterResourceIds(new Integer[]{resourceId});
        alertCriteria.fetchConditionLogs(true);
        PageList alerts = alertManager.findAlertsByCriteria(this.getOverlord(), alertCriteria);
        return alerts;
    }

    private AlertCondition getAlertConditionWithLogs(final int conditionId) {
        return this.executeInTransaction(false, new TransactionCallbackReturnable<AlertCondition>(){

            @Override
            public AlertCondition execute() throws Exception {
                AlertCondition cond = (AlertCondition)AlertConditionTest.this.em.find(AlertCondition.class, (Object)conditionId);
                cond.getConditionLogs().size();
                return cond;
            }
        });
    }

    private Resource loadResourceWithSchedules(int resourceId) {
        ResourceCriteria resourceCriteria = new ResourceCriteria();
        resourceCriteria.addFilterId(Integer.valueOf(resourceId));
        resourceCriteria.fetchSchedules(true);
        Resource resourceWithSchedules = this.getResource(resourceCriteria);
        assert (resourceWithSchedules != null) : "could not obtain resource from DB";
        assert (resourceWithSchedules.getSchedules() != null && resourceWithSchedules.getSchedules().size() == 1) : "missing schedule";
        return resourceWithSchedules;
    }

    private AlertDefinition createAlertDefinitionWithTwoConditionsALL(MeasurementDefinition metricDef, int resourceId) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(2);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.THRESHOLD);
        cond1.setName(metricDef.getDisplayName());
        cond1.setComparator(">");
        cond1.setThreshold(Double.valueOf(40.0));
        cond1.setOption(null);
        cond1.setMeasurementDefinition(metricDef);
        conditions.add(cond1);
        AlertCondition cond2 = new AlertCondition();
        cond2.setCategory(AlertConditionCategory.THRESHOLD);
        cond2.setName(metricDef.getDisplayName());
        cond2.setComparator("<");
        cond2.setThreshold(Double.valueOf(60.0));
        cond2.setOption(null);
        cond2.setMeasurementDefinition(metricDef);
        conditions.add(cond2);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("two condition ALL alert");
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        alertDefinition = alertDefManager.createAlertDefinitionInNewTransaction(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId), true);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private AlertDefinition createAlertDefinitionWithDampening(MeasurementDefinition metricDef, int resourceId) {
        AlertCondition cond = new AlertCondition();
        cond.setCategory(AlertConditionCategory.THRESHOLD);
        cond.setName(metricDef.getDisplayName());
        cond.setComparator("=");
        cond.setThreshold(Double.valueOf(0.0));
        cond.setOption(null);
        cond.setMeasurementDefinition(metricDef);
        AlertDampening dampening = new AlertDampening(AlertDampening.Category.CONSECUTIVE_COUNT);
        dampening.setValue(3);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("alert with consecutive count = 3 dampening");
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(dampening);
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(Collections.singleton(cond));
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        alertDefinition = alertDefManager.createAlertDefinitionInNewTransaction(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId), true);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private AlertDefinition createAlertDefinitionWithOneInsideRangeCondition(MeasurementDefinition metricDef, int resourceId) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(1);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.RANGE);
        cond1.setName(metricDef.getDisplayName());
        cond1.setThreshold(Double.valueOf(40.0));
        cond1.setOption(Double.valueOf(60.0).toString());
        cond1.setComparator("<");
        cond1.setMeasurementDefinition(metricDef);
        conditions.add(cond1);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("one inside-range condition alert");
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        alertDefinition = alertDefManager.createAlertDefinitionInNewTransaction(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId), true);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private AlertDefinition createAlertDefinitionWithChangeFromNull(MeasurementDefinition metricDef, int resourceId) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(1);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.TRAIT);
        cond1.setName(metricDef.getDisplayName());
        cond1.setMeasurementDefinition(metricDef);
        conditions.add(cond1);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("one trait change from null alert");
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        alertDefinition = alertDefManager.createAlertDefinitionInNewTransaction(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId), true);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private AlertDefinition createAlertDefinitionWithAvailChangeCondition(int resourceId, AlertConditionOperator condition) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(1);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.AVAILABILITY);
        cond1.setName(condition.name());
        cond1.setThreshold(null);
        cond1.setOption(null);
        cond1.setComparator(null);
        cond1.setMeasurementDefinition(null);
        conditions.add(cond1);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("avail change: " + condition.name());
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        alertDefinition = alertDefManager.createAlertDefinitionInNewTransaction(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId), true);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private AlertDefinition createAlertDefinitionWithAvailDurationCondition(int resourceId, String alertDefName, AlertConditionOperator condition, int duration) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(1);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.AVAIL_DURATION);
        cond1.setName(condition.name());
        cond1.setThreshold(null);
        cond1.setOption(String.valueOf(duration));
        cond1.setComparator(null);
        cond1.setMeasurementDefinition(null);
        conditions.add(cond1);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName(alertDefName);
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        alertDefinition = alertDefManager.createAlertDefinitionInNewTransaction(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId), true);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private AlertDefinition createAlertDefinitionWithOneOutsideRangeCondition(MeasurementDefinition metricDef, int resourceId) {
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(1);
        AlertCondition cond1 = new AlertCondition();
        cond1.setCategory(AlertConditionCategory.RANGE);
        cond1.setName(metricDef.getDisplayName());
        cond1.setThreshold(Double.valueOf(40.0));
        cond1.setOption(Double.valueOf(60.0).toString());
        cond1.setComparator(">");
        cond1.setMeasurementDefinition(metricDef);
        conditions.add(cond1);
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName("one outside-range condition alert");
        alertDefinition.setEnabled(true);
        alertDefinition.setPriority(AlertPriority.HIGH);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setConditionExpression(BooleanExpression.ALL);
        alertDefinition.setConditions(conditions);
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        alertDefinition = alertDefManager.createAlertDefinitionInNewTransaction(this.getOverlord(), alertDefinition, Integer.valueOf(resourceId), true);
        assert (alertDefinition != null && alertDefinition.getId() > 0) : "did not persist alert def properly: " + alertDefinition;
        this.reloadAllAlertConditionCaches();
        return alertDefinition;
    }

    private MeasurementDefinition createResourceWithMetricSchedule() throws Exception {
        return this.createResourceWithMetricSchedule("type-with-metric.xml", "TypeWithMetrics");
    }

    private MeasurementDefinition createResourceWithMetricSchedule(String plugin, String typeName) throws Exception {
        this.registerPlugin(plugin);
        ResourceType resourceType = this.getResourceType(typeName);
        assert (resourceType != null) : "failed to deploy resource type";
        assert (resourceType.getMetricDefinitions() != null) : "failed to create metric defs";
        assert (resourceType.getMetricDefinitions().size() == 1) : "do not have the expected number of metric defs";
        final MeasurementDefinition metricDef = (MeasurementDefinition)resourceType.getMetricDefinitions().iterator().next();
        this.resource = this.persistNewResource(resourceType.getName());
        assert (this.resource != null && this.resource.getId() > 0) : "failed to create test resource";
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                MeasurementSchedule schedule = new MeasurementSchedule(metricDef, AlertConditionTest.this.resource);
                AlertConditionTest.this.em.persist((Object)schedule);
            }
        });
        this.createServerIdentity();
        return metricDef;
    }

    private MeasurementDefinition createResourceWithTraitSchedule() throws Exception {
        this.registerPlugin("type-with-trait.xml");
        ResourceType resourceType = this.getResourceType("TypeWithTrait");
        assert (resourceType != null) : "failed to deploy resource type";
        assert (resourceType.getMetricDefinitions() != null) : "failed to create metric defs";
        assert (resourceType.getMetricDefinitions().size() == 1) : "do not have the expected number of metric defs";
        final MeasurementDefinition metricDef = (MeasurementDefinition)resourceType.getMetricDefinitions().iterator().next();
        this.resource = this.persistNewResource(resourceType.getName());
        assert (this.resource != null && this.resource.getId() > 0) : "failed to create test resource";
        this.executeInTransaction(false, new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                MeasurementSchedule schedule = new MeasurementSchedule(metricDef, AlertConditionTest.this.resource);
                AlertConditionTest.this.em.persist((Object)schedule);
            }
        });
        this.createServerIdentity();
        return metricDef;
    }

    private long getTimestamp(long secondsAgo) {
        return System.currentTimeMillis() - secondsAgo * 1000L;
    }

    private void reloadAllAlertConditionCaches() {
        LookupUtil.getAlertConditionCacheManager().reloadAllCaches();
    }
}

