/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.test;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerBeanTest;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class AlertManagerTest
extends AbstractEJB3Test {
    private static final Log LOG = LogFactory.getLog(AlertDefinitionManagerBeanTest.class);
    private AlertManagerLocal alertManager;
    private AlertDefinitionManagerLocal alertDefinitionManager;
    private ResourceGroupManagerLocal resourceGroupManager;
    private RoleManagerLocal roleManager;
    private SubjectManagerLocal subjectManager;
    private TestData testData;

    @Override
    protected void beforeMethod() throws Exception {
        this.alertManager = LookupUtil.getAlertManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.resourceGroupManager = LookupUtil.getResourceGroupManager();
        this.roleManager = LookupUtil.getRoleManager();
        this.alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
        this.createTestData();
        this.prepareScheduler();
    }

    private void createTestData() {
        this.testData = this.executeInTransaction(false, new TransactionCallbackReturnable<TestData>(){

            @Override
            public TestData execute() throws Exception {
                TestData newTestData = new TestData();
                Subject subject = SessionTestHelper.createNewSubject(AlertManagerTest.this.em, "fake subject");
                newTestData.setSubject(subject);
                Role role = SessionTestHelper.createNewRoleForSubject(AlertManagerTest.this.em, subject, "fake role", Permission.values());
                newTestData.setRole(role);
                ResourceType resourceType = SessionTestHelper.createNewResourceType(AlertManagerTest.this.em);
                newTestData.setResourceType(resourceType);
                ResourceGroup resourceGroup = new ResourceGroup("fake group", resourceType);
                resourceGroup = AlertManagerTest.this.resourceGroupManager.createPrivateResourceGroup(subject, resourceGroup);
                newTestData.setResourceGroup(resourceGroup);
                AlertManagerTest.this.roleManager.setAssignedResourceGroups(AlertManagerTest.this.subjectManager.getOverlord(), role.getId(), new int[]{resourceGroup.getId()});
                Resource resource = SessionTestHelper.createNewResourceForGroup(AlertManagerTest.this.em, resourceGroup, "fake resource");
                newTestData.setResource(resource);
                return newTestData;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            this.deleteTestData();
        }
        finally {
            this.unprepareScheduler();
        }
    }

    private void deleteTestData() throws Exception {
        if (this.testData != null) {
            this.removeAlerts();
            this.removeEntity(AlertDefinition.class, this.testData.getAlertDefinitionId());
            this.removeEntity(ResourceGroup.class, this.testData.getResourceGroup().getId());
            this.removeEntity(Resource.class, this.testData.getResource().getId());
            this.removeEntity(ResourceType.class, this.testData.getResourceType().getId());
            this.removeEntity(Subject.class, this.testData.getSubject().getId());
            this.removeEntity(Role.class, this.testData.getRole().getId());
            this.testData = null;
        }
    }

    private void removeAlerts() {
        try {
            this.executeInTransaction(false, new TransactionCallback(){

                @Override
                public void execute() throws Exception {
                    AlertManagerTest.this.alertManager.deleteAlertsByContext(AlertManagerTest.this.subjectManager.getOverlord(), EntityContext.forSubsystemView());
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to remove alerts", (Throwable)e);
        }
    }

    private void removeEntity(final Class<?> entityClass, final Object entityId) {
        try {
            this.executeInTransaction(false, new TransactionCallback(){

                @Override
                public void execute() throws Exception {
                    Object object = AlertManagerTest.this.em.find(entityClass, entityId);
                    if (object instanceof Resource) {
                        ResourceTreeHelper.deleteResource(AlertManagerTest.this.em, (Resource)object);
                    } else {
                        AlertManagerTest.this.em.remove(object);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to delete object from database: " + entityClass + "[id=" + entityId + "]"), (Throwable)e);
        }
    }

    @Test
    public void testDeleteAlertsByResourceContext() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourceAlertDefinitionId = AlertManagerTest.this.createResourceAlertDefinitionAndGetId("fake resource alertdef");
                AlertManagerTest.this.alertManager.fireAlert(resourceAlertDefinitionId);
                PageList foundAlerts = AlertManagerTest.this.findAlertsByDefinitionIds(new Integer[]{resourceAlertDefinitionId});
                AlertManagerTest.this.assertEquals(1, foundAlerts.size());
                AlertManagerTest.this.alertManager.deleteAlertsByContext(AlertManagerTest.this.testData.getSubject(), EntityContext.forResource((int)AlertManagerTest.this.testData.getResource().getId()));
                foundAlerts = AlertManagerTest.this.findAlertsByDefinitionIds(new Integer[0]);
                AlertManagerTest.this.assertEquals(0, foundAlerts.size());
            }
        });
    }

    @Test
    public void testDeleteAlertsByGroupContext() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourceAlertDefinitionId = AlertManagerTest.this.createResourceAlertDefinitionAndGetId("fake resource alertdef");
                AlertManagerTest.this.alertManager.fireAlert(resourceAlertDefinitionId);
                PageList foundAlerts = AlertManagerTest.this.findAlertsByDefinitionIds(new Integer[]{resourceAlertDefinitionId});
                AlertManagerTest.this.assertEquals(1, foundAlerts.size());
                AlertManagerTest.this.alertManager.deleteAlertsByContext(AlertManagerTest.this.testData.getSubject(), EntityContext.forGroup((int)AlertManagerTest.this.testData.getResourceGroup().getId()));
                foundAlerts = AlertManagerTest.this.findAlertsByDefinitionIds(new Integer[]{resourceAlertDefinitionId});
                AlertManagerTest.this.assertEquals(0, foundAlerts.size());
            }
        });
    }

    @Test
    public void testAcknowledgeAlertCriteria() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourceAlertDefinitionId = AlertManagerTest.this.createResourceAlertDefinitionAndGetId("fake resource alertdef");
                AlertManagerTest.this.alertManager.fireAlert(resourceAlertDefinitionId);
                AlertCriteria c = new AlertCriteria();
                c.addFilterAlertDefinitionIds(new Integer[]{resourceAlertDefinitionId});
                c.addFilterUnacknowledgedOnly(Boolean.TRUE);
                PageList result = AlertManagerTest.this.alertManager.findAlertsByCriteria(AlertManagerTest.this.testData.getSubject(), c);
                AlertManagerTest.this.assertEquals(1, result.size());
                c.addFilterUnacknowledgedOnly(Boolean.FALSE);
                c.addFilterAcknowledgingSubject("");
                result = AlertManagerTest.this.alertManager.findAlertsByCriteria(AlertManagerTest.this.testData.getSubject(), c);
                AlertManagerTest.this.assertTrue(result.isEmpty());
                long testStartTimeStamp = System.currentTimeMillis();
                int count = AlertManagerTest.this.alertManager.acknowledgeAlertsByContext(AlertManagerTest.this.testData.getSubject(), EntityContext.forResource((int)AlertManagerTest.this.testData.getResource().getId()));
                AlertManagerTest.this.assertEquals(1, count);
                result = AlertManagerTest.this.alertManager.findAlertsByCriteria(AlertManagerTest.this.testData.getSubject(), c);
                AlertManagerTest.this.assertEquals(1, result.size());
                Alert alert = (Alert)result.get(0);
                AlertManagerTest.this.em.refresh((Object)alert);
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgeTime());
                AlertManagerTest.this.assertEquals(AlertManagerTest.this.testData.getSubject().getName(), alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertTrue("Alert should just have been acknowledged", alert.getAcknowledgeTime() >= testStartTimeStamp);
                c.addFilterAcknowledgingSubject(AlertManagerTest.this.testData.getSubject().getName());
                c.setStrict(true);
                result = AlertManagerTest.this.alertManager.findAlertsByCriteria(AlertManagerTest.this.testData.getSubject(), c);
                AlertManagerTest.this.assertEquals(1, result.size());
                alert = (Alert)result.get(0);
                AlertManagerTest.this.em.refresh((Object)alert);
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgeTime());
                AlertManagerTest.this.assertEquals(AlertManagerTest.this.testData.getSubject().getName(), alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertTrue("Alert should just have been acknowledged", alert.getAcknowledgeTime() >= testStartTimeStamp);
                c.addFilterUnacknowledgedOnly(Boolean.TRUE);
                c.addFilterAcknowledgingSubject(null);
                result = AlertManagerTest.this.alertManager.findAlertsByCriteria(AlertManagerTest.this.testData.getSubject(), c);
                AlertManagerTest.this.assertTrue(result.isEmpty());
            }
        });
    }

    @Test
    public void testAcknowledgeAlertsByTemplateContext() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                try {
                    AlertManagerTest.this.alertManager.acknowledgeAlertsByContext(AlertManagerTest.this.testData.getSubject(), EntityContext.forTemplate((int)42));
                    AlertManagerTest.this.fail("It should not be possible to acknowledge alerts by template context");
                }
                catch (Exception e) {
                    AlertManagerTest.this.assertEquals(e.getCause().getClass(), IllegalArgumentException.class);
                }
            }
        });
    }

    @Test
    public void testAcknowledgeAlertsByResourceContext() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourceAlertDefinitionId = AlertManagerTest.this.createResourceAlertDefinitionAndGetId("fake resource alertdef");
                AlertManagerTest.this.alertManager.fireAlert(resourceAlertDefinitionId);
                long testStartTimeStamp = System.currentTimeMillis();
                int count = AlertManagerTest.this.alertManager.acknowledgeAlertsByContext(AlertManagerTest.this.testData.getSubject(), EntityContext.forResource((int)AlertManagerTest.this.testData.getResource().getId()));
                AlertManagerTest.this.assertEquals(1, count);
                PageList foundAlerts = AlertManagerTest.this.findAlertsByDefinitionIds(new Integer[]{resourceAlertDefinitionId});
                AlertManagerTest.this.assertEquals(1, foundAlerts.size());
                Alert alert = (Alert)foundAlerts.iterator().next();
                AlertManagerTest.this.em.refresh((Object)alert);
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgeTime());
                AlertManagerTest.this.assertEquals(AlertManagerTest.this.testData.getSubject().getName(), alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertTrue("Alert should just have been acknowledged", alert.getAcknowledgeTime() >= testStartTimeStamp);
            }
        });
    }

    @Test
    public void testAcknowledgeAlertsByGroupContext() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourceAlertDefinitionId = AlertManagerTest.this.createResourceAlertDefinitionAndGetId("fake resource alertdef");
                AlertManagerTest.this.alertManager.fireAlert(resourceAlertDefinitionId);
                long testStartTimeStamp = System.currentTimeMillis();
                int count = AlertManagerTest.this.alertManager.acknowledgeAlertsByContext(AlertManagerTest.this.testData.getSubject(), EntityContext.forGroup((int)AlertManagerTest.this.testData.getResourceGroup().getId()));
                AlertManagerTest.this.assertEquals(1, count);
                PageList foundAlerts = AlertManagerTest.this.findAlertsByDefinitionIds(new Integer[]{resourceAlertDefinitionId});
                AlertManagerTest.this.assertEquals(1, foundAlerts.size());
                Alert alert = (Alert)foundAlerts.iterator().next();
                AlertManagerTest.this.em.refresh((Object)alert);
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgeTime());
                AlertManagerTest.this.assertEquals(AlertManagerTest.this.testData.getSubject().getName(), alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertTrue("Alert should just have been acknowledged", alert.getAcknowledgeTime() >= testStartTimeStamp);
            }
        });
    }

    @Test
    public void testAcknowledgeAlertsBySubsystemContext() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourceAlertDefinitionId = AlertManagerTest.this.createResourceAlertDefinitionAndGetId("fake resource alertdef");
                AlertManagerTest.this.alertManager.fireAlert(resourceAlertDefinitionId);
                long testStartTimeStamp = System.currentTimeMillis();
                int count = AlertManagerTest.this.alertManager.acknowledgeAlertsByContext(AlertManagerTest.this.testData.getSubject(), EntityContext.forSubsystemView());
                AlertManagerTest.this.assertEquals(1, count);
                PageList foundAlerts = AlertManagerTest.this.findAlertsByDefinitionIds(new Integer[]{resourceAlertDefinitionId});
                AlertManagerTest.this.assertEquals(1, foundAlerts.size());
                Alert alert = (Alert)foundAlerts.iterator().next();
                AlertManagerTest.this.em.refresh((Object)alert);
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertNotNull(alert.getAcknowledgeTime());
                AlertManagerTest.this.assertEquals(AlertManagerTest.this.testData.getSubject().getName(), alert.getAcknowledgingSubject());
                AlertManagerTest.this.assertTrue("Alert should just have been acknowledged", alert.getAcknowledgeTime() >= testStartTimeStamp);
            }
        });
    }

    private PageList<Alert> findAlertsByDefinitionIds(Integer ... alertDefinitionIds) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterAlertDefinitionIds(alertDefinitionIds);
        return this.alertManager.findAlertsByCriteria(this.testData.getSubject(), criteria);
    }

    private int createResourceAlertDefinitionAndGetId(String name) {
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName(name);
        alertDefinition.setPriority(AlertPriority.MEDIUM);
        alertDefinition.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDefinition.setConditionExpression(BooleanExpression.ANY);
        alertDefinition.setRecoveryId(Integer.valueOf(0));
        alertDefinition.setEnabled(true);
        alertDefinition = this.alertDefinitionManager.createAlertDefinitionInNewTransaction(this.testData.getSubject(), alertDefinition, Integer.valueOf(this.testData.getResource().getId()), true);
        this.testData.setAlertDefinitionId(alertDefinition.getId());
        return alertDefinition.getId();
    }

    private static final class TestData {
        private Subject subject;
        private Role role;
        private ResourceType resourceType;
        private ResourceGroup resourceGroup;
        private Resource resource;
        private int alertDefinitionId;

        private TestData() {
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void setSubject(Subject subject) {
            this.subject = subject;
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        public ResourceGroup getResourceGroup() {
            return this.resourceGroup;
        }

        public void setResourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }

        public int getAlertDefinitionId() {
            return this.alertDefinitionId;
        }

        public void setAlertDefinitionId(int alertDefinitionId) {
            this.alertDefinitionId = alertDefinitionId;
        }
    }
}

