/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.authz.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.group.LdapGroup;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.collection.ArrayUtils;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

@Test
public class RoleManagerBeanTest
extends AbstractEJB3Test {
    private SubjectManagerLocal subjectManager;
    private RoleManagerLocal roleManager;
    private LdapGroupManagerLocal ldapManager;

    @Override
    protected void beforeMethod() {
        this.roleManager = LookupUtil.getRoleManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.ldapManager = LookupUtil.getLdapGroupManager();
    }

    public void testGetAllRoles() {
        assert (this.roleManager.findRoles(PageControl.getUnlimitedInstance()).size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSubjectRoles() throws Exception {
        this.getTransactionManager().begin();
        try {
            PageList roles = this.roleManager.findRolesBySubject(this.subjectManager.getOverlord().getId(), PageControl.getUnlimitedInstance());
            assert (roles.size() == 1);
            Role role = (Role)roles.get(0);
            assert (role.getName().equals("Super User Role")) : "Superuser should have only the super user role: " + role;
            assert (role.getPermissions().contains(Permission.MANAGE_SECURITY));
            assert (role.getPermissions().contains(Permission.MANAGE_INVENTORY));
            assert (role.getPermissions().contains(Permission.MANAGE_SETTINGS));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRoleSubjects() throws Exception {
        this.getTransactionManager().begin();
        try {
            PageList roles = this.roleManager.findRolesBySubject(this.subjectManager.getOverlord().getId(), PageControl.getUnlimitedInstance());
            for (Role role : roles) {
                PageList subjects = this.roleManager.findSubjectsByRole(Integer.valueOf(role.getId()), PageControl.getUnlimitedInstance());
                if (!role.getName().equals("Super User Role")) continue;
                assert (subjects.size() >= 1) : "At least rhqadmin must have super user role: " + subjects;
                for (Subject s : subjects) {
                    if (s.getId() == 1 || s.getName().equals("admin")) assert (false) : "getRoleSubjects() is not supposed to return the superuser" + s;
                }
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRolesByIds() throws Exception {
        this.getTransactionManager().begin();
        try {
            PageList all_roles = this.roleManager.findRoles(PageControl.getUnlimitedInstance());
            ArrayList<Integer> role_id_list = new ArrayList<Integer>(all_roles.size());
            for (Role role : all_roles) {
                role_id_list.add(role.getId());
            }
            PageList roles = this.roleManager.findRolesByIds(role_id_list.toArray(new Integer[role_id_list.size()]), PageControl.getUnlimitedInstance());
            assert (roles.size() == all_roles.size());
            assert (roles.containsAll((Collection)all_roles));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAvailableRolesForSubject() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject superuser = this.subjectManager.getOverlord();
            superuser = this.createSession(superuser);
            Subject subject = new Subject();
            subject.setName("dummy-subject");
            subject = this.subjectManager.createSubject(superuser, subject);
            subject = this.createSession(subject);
            Role new_role = new Role("dummy-role");
            Role new_role2 = new Role("dummy-role2");
            new_role = this.roleManager.createRole(superuser, new_role);
            new_role2 = this.roleManager.createRole(superuser, new_role2);
            PageList all_roles = this.roleManager.findRoles(PageControl.getUnlimitedInstance());
            assert (all_roles.size() >= 3) : "There should at least be the two dummy roles and the super user role";
            PageList roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[0], PageControl.getUnlimitedInstance());
            assert (roles.size() == all_roles.size()) : "All roles should be available for this subject";
            assert (roles.containsAll((Collection)all_roles));
            roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[]{new_role.getId()}, PageControl.getUnlimitedInstance());
            assert (roles.size() + 1 == all_roles.size()) : "All roles but one should be available for this subject";
            assert (!roles.contains((Object)new_role));
            roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[]{new_role.getId(), new_role2.getId()}, PageControl.getUnlimitedInstance());
            assert (roles.size() + 2 == all_roles.size()) : "All roles but two should be available for this subject";
            assert (!roles.contains((Object)new_role));
            assert (!roles.contains((Object)new_role2));
            this.roleManager.addRolesToSubject(superuser, subject.getId(), new int[]{new_role.getId()});
            roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[0], PageControl.getUnlimitedInstance());
            assert (roles.size() + 1 == all_roles.size()) : "All but one role should be available for this subject";
            assert (!roles.contains((Object)new_role)) : "We already assigned this new role to the subject - it isn't available";
            roles = this.roleManager.findAvailableRolesForSubject(superuser, Integer.valueOf(subject.getId()), new Integer[]{new_role2.getId()}, PageControl.getUnlimitedInstance());
            assert (roles.size() + 2 == all_roles.size()) : "One is already assigned and one is excluded so all but two roles should be available for this subject";
            assert (!roles.contains((Object)new_role)) : "We already assigned this new role to the subject - it isn't available";
            assert (!roles.contains((Object)new_role2)) : "We excluded this new role - it isn't available";
            try {
                this.roleManager.findAvailableRolesForSubject(subject, Integer.valueOf(subject.getId()), new Integer[0], PageControl.getUnlimitedInstance());
            }
            catch (PermissionException s) {
                // empty catch block
            }
        }
        finally {
            try {
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRoles() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject newSubject1 = new Subject();
            newSubject1.setName("role-manager-subject");
            newSubject1.setFsystem(false);
            Subject newSubject2 = new Subject();
            newSubject2.setName("secondary-role-manager");
            newSubject2.setFsystem(false);
            Role role = new Role("role-manager-role");
            role.setFsystem(Boolean.valueOf(false));
            role.addSubject(newSubject1);
            Subject superuser = this.subjectManager.getOverlord();
            this.subjectManager.createSubject(superuser, newSubject1);
            newSubject1 = this.createSession(newSubject1);
            this.subjectManager.createSubject(superuser, newSubject2);
            newSubject2 = this.createSession(newSubject2);
            this.assertEquals("Role should not be created or assigned yet", 0, this.roleManager.findRolesBySubject(newSubject1.getId(), PageControl.getUnlimitedInstance()).size());
            role = this.roleManager.createRole(superuser, role);
            this.assertEquals("Role should be assigned at the time the role is created", 1, this.roleManager.findRolesBySubject(newSubject1.getId(), PageControl.getUnlimitedInstance()).size());
            this.roleManager.addRolesToSubject(superuser, newSubject2.getId(), new int[]{role.getId()});
            this.assertEquals("Role should be assigned", 1, this.roleManager.findRolesBySubject(newSubject2.getId(), PageControl.getUnlimitedInstance()).size());
            this.roleManager.removeRolesFromSubject(superuser, newSubject1.getId(), new int[]{role.getId()});
            this.assertEquals("Role should have been unassigned", 0, this.roleManager.findRolesBySubject(newSubject1.getId(), PageControl.getUnlimitedInstance()).size());
            this.roleManager.deleteRoles(superuser, new int[]{role.getId()});
            this.assertFalse("Roles should have been deleted", this.roleManager.findRoles(PageControl.getUnlimitedInstance()).contains((Object)role));
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLdapGroups() throws Exception {
        this.getTransactionManager().begin();
        try {
            Subject superuser = this.subjectManager.getOverlord();
            superuser = this.createSession(superuser);
            Role role = new Role("role-manager-role");
            role.setFsystem(Boolean.valueOf(false));
            role = this.roleManager.createRole(superuser, role);
            LdapGroup group = new LdapGroup();
            group.setName("Foo");
            role.addLdapGroup(group);
            assert (this.ldapManager.findLdapGroupsByRole(role.getId(), PageControl.getUnlimitedInstance()).size() == 1) : "Ldap Group Foo Should be assigned";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    @Test
    public void testSetAssignedSubjectRoles() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject");
                ArrayList<Role> roles = new ArrayList<Role>();
                for (int i = 0; i < 17; ++i) {
                    roles.add(SessionTestHelper.createNewRoleForSubject(RoleManagerBeanTest.this.em, subject, "fake role " + String.valueOf(i)));
                }
                List rolesToKeep = roles.subList(5, 14);
                int[] rolesToKeepIds = new int[rolesToKeep.size()];
                for (int i = 0; i < rolesToKeep.size(); ++i) {
                    rolesToKeepIds[i] = ((Role)rolesToKeep.get(i)).getId();
                }
                RoleManagerBeanTest.this.roleManager.setAssignedSubjectRoles(RoleManagerBeanTest.this.subjectManager.getOverlord(), subject.getId(), rolesToKeepIds);
                RoleManagerBeanTest.this.assertTrue(subject.getRoles().containsAll(rolesToKeep) && rolesToKeep.containsAll(subject.getRoles()));
            }
        });
    }

    @Test
    public void testGetPermissions() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject");
                HashSet<Permission> permissions = new HashSet<Permission>();
                permissions.addAll(EnumSet.allOf(Permission.class));
                Role role = SessionTestHelper.createNewRoleForSubject(RoleManagerBeanTest.this.em, subject, "fake role", permissions.toArray(new Permission[permissions.size()]));
                Set foundPermissions = RoleManagerBeanTest.this.roleManager.getPermissions(Integer.valueOf(role.getId()));
                RoleManagerBeanTest.this.assertEquals(permissions, foundPermissions);
            }
        });
    }

    @Test
    public void testUpdateRole() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject");
                HashSet<Permission> originalPermissions = new HashSet<Permission>();
                originalPermissions.addAll(EnumSet.allOf(Permission.class));
                Role originalRole = SessionTestHelper.createNewRoleForSubject(RoleManagerBeanTest.this.em, subject, "fake role", originalPermissions.toArray(new Permission[originalPermissions.size()]));
                ResourceGroup resourceGroup = SessionTestHelper.createNewCompatibleGroupForRole(RoleManagerBeanTest.this.em, originalRole, "fake group");
                Role role = new Role();
                role.setId(originalRole.getId());
                role.setName("fake role name modified");
                role.setDescription("fake role description modified");
                HashSet permissions = new HashSet(originalRole.getPermissions());
                permissions.remove(Permission.MANAGE_SECURITY);
                permissions.remove(Permission.MANAGE_INVENTORY);
                permissions.remove(Permission.MANAGE_DRIFT);
                role.setPermissions(permissions);
                Subject subject1 = SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject 1");
                role.getSubjects().add(subject1);
                Subject subject2 = SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject 2");
                role.getSubjects().add(subject2);
                role.getSubjects().remove(subject);
                ResourceGroup resourceGroup1 = SessionTestHelper.createNewCompatibleGroupForRole(RoleManagerBeanTest.this.em, originalRole, "fake group 1");
                role.getResourceGroups().add(resourceGroup1);
                ResourceGroup resourceGroup2 = SessionTestHelper.createNewCompatibleGroupForRole(RoleManagerBeanTest.this.em, originalRole, "fake group 2");
                role.getResourceGroups().add(resourceGroup2);
                role.getResourceGroups().remove(resourceGroup);
                role = RoleManagerBeanTest.this.roleManager.updateRole(RoleManagerBeanTest.this.subjectManager.getOverlord(), role);
                RoleManagerBeanTest.this.assertEquals("fake role name modified", role.getName());
                RoleManagerBeanTest.this.assertEquals("fake role description modified", role.getDescription());
                RoleManagerBeanTest.this.assertEquals(permissions, role.getPermissions());
                List<Subject> expectedSubjects = Arrays.asList(subject1, subject2);
                RoleManagerBeanTest.this.assertTrue(role.getSubjects().containsAll(expectedSubjects) && expectedSubjects.containsAll(role.getSubjects()));
                List<ResourceGroup> expectedResourceGroups = Arrays.asList(resourceGroup1, resourceGroup2);
                RoleManagerBeanTest.this.assertTrue(role.getResourceGroups().containsAll(expectedResourceGroups) && expectedResourceGroups.containsAll(role.getResourceGroups()));
            }
        });
    }

    @Test
    public void testSetAssignedResourceGroups() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject");
                Role role = SessionTestHelper.createNewRoleForSubject(RoleManagerBeanTest.this.em, subject, "fake role");
                ArrayList<ResourceGroup> resourceGroups = new ArrayList<ResourceGroup>();
                for (int i = 0; i < 17; ++i) {
                    resourceGroups.add(SessionTestHelper.createNewCompatibleGroupForRole(RoleManagerBeanTest.this.em, role, "fake group " + String.valueOf(i)));
                }
                List resourceGroupsToKeep = resourceGroups.subList(5, 14);
                int[] resourceGroupsToKeepIds = new int[resourceGroupsToKeep.size()];
                for (int i = 0; i < resourceGroupsToKeep.size(); ++i) {
                    resourceGroupsToKeepIds[i] = ((ResourceGroup)resourceGroupsToKeep.get(i)).getId();
                }
                RoleManagerBeanTest.this.roleManager.setAssignedResourceGroups(RoleManagerBeanTest.this.subjectManager.getOverlord(), role.getId(), resourceGroupsToKeepIds);
                RoleManagerBeanTest.this.assertTrue(role.getResourceGroups().containsAll(resourceGroupsToKeep) && resourceGroupsToKeep.containsAll(role.getResourceGroups()));
            }
        });
    }

    @Test
    public void testSetAssignedSubjects() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject");
                Role role = SessionTestHelper.createNewRoleForSubject(RoleManagerBeanTest.this.em, subject, "fake role");
                ArrayList<Subject> subjects = new ArrayList<Subject>();
                for (int i = 0; i < 17; ++i) {
                    subjects.add(SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject " + String.valueOf(i)));
                }
                List subjectsToKeep = subjects.subList(5, 14);
                int[] subjectsToKeepIds = new int[subjectsToKeep.size()];
                for (int i = 0; i < subjectsToKeep.size(); ++i) {
                    subjectsToKeepIds[i] = ((Subject)subjectsToKeep.get(i)).getId();
                }
                RoleManagerBeanTest.this.roleManager.setAssignedSubjects(RoleManagerBeanTest.this.subjectManager.getOverlord(), role.getId(), subjectsToKeepIds);
                RoleManagerBeanTest.this.assertTrue(role.getSubjects().containsAll(subjectsToKeep) && subjectsToKeep.containsAll(role.getSubjects()));
            }
        });
    }

    @Test
    public void testSetRolesFromResourceGroup() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(RoleManagerBeanTest.this.em, "fake subject");
                Role role = SessionTestHelper.createNewRoleForSubject(RoleManagerBeanTest.this.em, subject, "fake role");
                ResourceGroup resourceGroup = SessionTestHelper.createNewCompatibleGroupForRole(RoleManagerBeanTest.this.em, role, "fake resource group");
                LinkedList<Integer> rolesIds = new LinkedList<Integer>();
                LinkedList<Integer> rolesToRemoveIds = new LinkedList<Integer>();
                LinkedList<Role> rolesToKeep = new LinkedList<Role>();
                for (int i = 0; i < 17; ++i) {
                    Role newRole = SessionTestHelper.createNewRoleForSubject(RoleManagerBeanTest.this.em, subject, "fake role " + String.valueOf(i));
                    rolesIds.add(newRole.getId());
                    if (i < 5 || i >= 14) {
                        rolesToRemoveIds.add(newRole.getId());
                        continue;
                    }
                    rolesToKeep.add(newRole);
                }
                rolesToRemoveIds.add(role.getId());
                RoleManagerBeanTest.this.roleManager.addRolesToResourceGroup(RoleManagerBeanTest.this.subjectManager.getOverlord(), resourceGroup.getId(), ArrayUtils.unwrapCollection(rolesIds));
                RoleManagerBeanTest.this.roleManager.removeRolesFromResourceGroup(RoleManagerBeanTest.this.subjectManager.getOverlord(), resourceGroup.getId(), ArrayUtils.unwrapCollection(rolesToRemoveIds));
                LinkedList<Role> expected = rolesToKeep;
                Set actual = resourceGroup.getRoles();
                RoleManagerBeanTest.this.assertTrue("Expected " + expected + " but was " + actual, actual.containsAll(expected) && expected.containsAll(actual));
            }
        });
    }
}

