/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ejb.EJBException;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.hibernate.LazyInitializationException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleGroup;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.criteria.BundleCriteria;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleFileCriteria;
import org.rhq.core.domain.criteria.BundleGroupCriteria;
import org.rhq.core.domain.criteria.BundleResourceDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleVersionCriteria;
import org.rhq.core.domain.criteria.RoleCriteria;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.bundle.BundleDistributionInfo;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.bundle.TestBundlePluginComponent;
import org.rhq.enterprise.server.bundle.TestBundleServerPluginService;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestAgentClient;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;

@Test
public class BundleManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean TESTS_ENABLED = true;
    private static final String TEST_PREFIX = BundleManagerBeanTest.class.getSimpleName();
    private static final String TEST_BUNDLE_DESTBASEDIR_PROP = TEST_PREFIX + ".destBaseDirProp";
    private static final String TEST_BUNDLE_DESTBASEDIR_PROP_VALUE = TEST_PREFIX + "/destBaseDir";
    private static final String TEST_BUNDLE_GROUP_NAME = TEST_PREFIX + ".bundleGroup";
    private static final String TEST_DESTBASEDIR_NAME = TEST_PREFIX + ".destBaseDirName";
    private static final String TEST_ROLE_NAME = TEST_PREFIX + ".role";
    private static final String TEST_USER_NAME = TEST_PREFIX + ".user";
    private BundleManagerLocal bundleManager;
    private ResourceManagerLocal resourceManager;
    private SubjectManagerLocal subjectManager;
    private static final boolean ENABLED = true;
    private static final boolean DISABLED = false;
    private TestBundleServerPluginService ps;
    private TestBundlePluginComponent bpc;
    private MasterServerPluginContainer pc;
    private Subject overlord;
    TestServerCommunicationsService agentServiceContainer;

    @Override
    protected void beforeMethod() throws Exception {
        this.agentServiceContainer = this.prepareForTestAgents();
        this.agentServiceContainer.bundleService = new TestAgentClient(null, this.agentServiceContainer);
        this.prepareScheduler();
        this.bpc = new TestBundlePluginComponent();
        this.ps = new TestBundleServerPluginService(this.getTempDir(), this.bpc);
        this.prepareCustomServerPluginService(this.ps);
        this.bundleManager = LookupUtil.getBundleManager();
        this.resourceManager = LookupUtil.getResourceManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.overlord = this.subjectManager.getOverlord();
        this.ps.startMasterPluginContainer();
        this.cleanupDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        this.unprepareForTestAgents();
        try {
            this.ps = null;
            this.cleanupDatabase();
        }
        finally {
            this.unprepareServerPluginService();
            this.unprepareScheduler();
        }
    }

    private void cleanupDatabase() {
        try {
            RoleCriteria roleCriteria = new RoleCriteria();
            roleCriteria.addFilterName(TEST_ROLE_NAME);
            PageList testRoles = LookupUtil.getRoleManager().findRolesByCriteria(this.overlord, roleCriteria);
            for (Role testRole : testRoles) {
                LookupUtil.getRoleManager().deleteRoles(this.overlord, new int[]{testRole.getId()});
            }
            SubjectCriteria subjectCriteria = new SubjectCriteria();
            subjectCriteria.addFilterName(TEST_USER_NAME);
            PageList testSubjects = LookupUtil.getSubjectManager().findSubjectsByCriteria(this.overlord, subjectCriteria);
            for (Subject testSubject : testSubjects) {
                LookupUtil.getSubjectManager().deleteSubjects(this.overlord, new int[]{testSubject.getId()});
            }
            this.getTransactionManager().begin();
            Query q = this.em.createQuery("SELECT bv FROM BundleVersion bv WHERE bv.name LIKE '" + TEST_PREFIX + "%'");
            List doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(BundleVersion.class, (Object)((BundleVersion)removeMe).getId()));
            }
            this.em.flush();
            q = this.em.createQuery("SELECT bf FROM BundleFile bf WHERE bf.packageVersion.generalPackage.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(BundleFile.class, (Object)((BundleFile)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT brdh FROM BundleResourceDeploymentHistory brdh WHERE brdh.resourceDeployment.bundleDeployment.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(BundleResourceDeploymentHistory.class, (Object)((BundleResourceDeploymentHistory)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT brd FROM BundleResourceDeployment brd WHERE brd.bundleDeployment.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(BundleResourceDeployment.class, (Object)((BundleResourceDeployment)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT bd FROM BundleDeployment bd WHERE bd.description LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(BundleDeployment.class, (Object)((BundleDeployment)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT bg FROM BundleGroup bg WHERE bg.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                BundleGroup doomedBundleGroup = (BundleGroup)this.em.find(BundleGroup.class, (Object)((BundleGroup)removeMe).getId());
                doomedBundleGroup.setBundles(new HashSet());
                this.em.remove((Object)doomedBundleGroup);
            }
            q = this.em.createQuery("SELECT b FROM Bundle b WHERE b.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(Bundle.class, (Object)((Bundle)removeMe).getId()));
            }
            this.em.flush();
            q = this.em.createQuery("SELECT pv FROM PackageVersion pv WHERE pv.generalPackage.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(PackageVersion.class, (Object)((PackageVersion)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT p FROM Package p WHERE p.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(Package.class, (Object)((Package)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT pt FROM PackageType pt WHERE pt.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(PackageType.class, (Object)((PackageType)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT bd FROM BundleDestination bd WHERE bd.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(BundleDestination.class, (Object)((BundleDestination)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT r FROM Repo r WHERE r.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(Repo.class, (Object)((Repo)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT rg FROM ResourceGroup rg WHERE rg.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(ResourceGroup.class, (Object)((ResourceGroup)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT r FROM Resource r WHERE r.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                ResourceTreeHelper.deleteResource(this.em, (Resource)this.em.getReference(Resource.class, (Object)((Resource)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT rt FROM ResourceType rt WHERE rt.deleted = false and rt.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(ResourceType.class, (Object)((ResourceType)removeMe).getId()));
            }
            this.em.flush();
            q = this.em.createQuery("SELECT bt FROM BundleType bt WHERE bt.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(BundleType.class, (Object)((BundleType)removeMe).getId()));
            }
            q = this.em.createQuery("SELECT a FROM Agent a WHERE a.name LIKE '" + TEST_PREFIX + "%'");
            doomed = q.getResultList();
            for (Object removeMe : doomed) {
                this.em.remove(this.em.getReference(Agent.class, (Object)((Agent)removeMe).getId()));
            }
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT CLEAN UP TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testCreateBundleVersionFromDistributionFile() throws Exception {
        File tmpDir = FileUtil.createTempDirectory((String)"createBundleFromDistro", (String)".dir", null);
        try {
            BundleVersion[] bvs;
            String bundleFile1 = TEST_PREFIX + "_subdir1/bundle-file-1.txt";
            String bundleFile2 = TEST_PREFIX + "_subdir2/bundle-file-2.txt";
            String bundleFile3 = TEST_PREFIX + "_bundle-file-3.txt";
            this.writeFile(new File(tmpDir, bundleFile1), "first bundle file found inside bundle distro");
            this.writeFile(new File(tmpDir, bundleFile2), "second bundle file found inside bundle distro");
            this.writeFile(new File(tmpDir, bundleFile3), "third bundle file found inside bundle distro");
            String bundleName = TEST_PREFIX + "-create-from-distro";
            String bundleVersion = "1.2.3";
            String bundleDescription = "test bundle desc";
            DeploymentProperties bundleMetadata = new DeploymentProperties(0, bundleName, bundleVersion, bundleDescription);
            ConfigurationDefinition configDef = new ConfigurationDefinition("foo", null);
            int propDefaultValue1 = 998877;
            String propDefaultValue4 = "this.is.the.default";
            String propName1 = "prop1requiredWithDefault";
            String propName2 = "prop2";
            String propName3 = "prop3requiredWithNoDefault";
            String propName4 = "prop4notRequiredWithDefault";
            String propDesc1 = "prop1desc";
            String propDesc2 = "prop2desc";
            String propDesc3 = "prop3desc";
            String propDesc4 = "prop4desc";
            PropertyDefinitionSimple propdef1requiredWithDefault = new PropertyDefinitionSimple(propName1, propDesc1, true, PropertySimpleType.INTEGER);
            PropertyDefinitionSimple propdef2 = new PropertyDefinitionSimple(propName2, propDesc2, false, PropertySimpleType.STRING);
            PropertyDefinitionSimple propdef3requiredWithNoDefault = new PropertyDefinitionSimple(propName3, propDesc3, true, PropertySimpleType.STRING);
            PropertyDefinitionSimple propdef4notRequiredWithDefault = new PropertyDefinitionSimple(propName4, propDesc4, false, PropertySimpleType.STRING);
            propdef1requiredWithDefault.setDefaultValue(String.valueOf(propDefaultValue1));
            propdef4notRequiredWithDefault.setDefaultValue(propDefaultValue4);
            configDef.put((PropertyDefinition)propdef1requiredWithDefault);
            configDef.put((PropertyDefinition)propdef2);
            configDef.put((PropertyDefinition)propdef3requiredWithNoDefault);
            configDef.put((PropertyDefinition)propdef4notRequiredWithDefault);
            HashMap<String, File> bundleFiles = new HashMap<String, File>(3);
            bundleFiles.put(bundleFile1, new File(tmpDir, bundleFile1));
            bundleFiles.put(bundleFile2, new File(tmpDir, bundleFile2));
            bundleFiles.put(bundleFile3, new File(tmpDir, bundleFile3));
            File bundleDistroFile = tmpDir;
            String recipe = "mock recipe";
            BundleType bt1 = this.createBundleType("one");
            this.bpc.parseRecipe_returnValue = new RecipeParseResults(bundleMetadata, configDef, new HashSet(bundleFiles.keySet()));
            this.bpc.processBundleDistributionFile_returnValue = new BundleDistributionInfo(recipe, this.bpc.parseRecipe_returnValue, bundleFiles);
            this.bpc.processBundleDistributionFile_returnValue.setBundleTypeName(bt1.getName());
            BundleVersion bv1 = this.bundleManager.createBundleVersionViaURL(this.overlord, bundleDistroFile.toURI().toURL().toString());
            BundleVersionCriteria criteria = new BundleVersionCriteria();
            criteria.addFilterId(Integer.valueOf(bv1.getId()));
            criteria.fetchBundle(true);
            criteria.fetchConfigurationDefinition(true);
            criteria.fetchBundleFiles(true);
            criteria.fetchTags(true);
            BundleVersion bv2 = (BundleVersion)this.bundleManager.findBundleVersionsByCriteria(this.overlord, criteria).get(0);
            List bv2BundleFiles = bv2.getBundleFiles();
            BundleFileCriteria bfCriteria = new BundleFileCriteria();
            bfCriteria.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
            bfCriteria.fetchPackageVersion(true);
            PageList bfs = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfCriteria);
            bv2BundleFiles.clear();
            bv2BundleFiles.addAll(bfs);
            bv2.setBundleDeployments(new ArrayList());
            for (BundleVersion bv : bvs = new BundleVersion[]{bv1, bv2}) {
                assert (bv.getId() > 0) : bv;
                assert (bv.getBundle().getName().equals(bundleName)) : bv;
                assert (bv.getBundle().getDescription().equals(bundleDescription)) : bv;
                assert (bv.getDescription().equals(bundleDescription)) : "the bundle version desc should be the same as the bundle desc";
                assert (bv.getVersion().equals(bundleVersion)) : bv;
                assert (bv.getBundleFiles().size() == 3) : bv;
                ArrayList<String> bundleFileNames = new ArrayList<String>(3);
                for (BundleFile bf : bv.getBundleFiles()) {
                    bundleFileNames.add(bf.getPackageVersion().getFileName());
                }
                assert (bundleFileNames.contains(bundleFile1)) : bv;
                assert (bundleFileNames.contains(bundleFile2)) : bv;
                assert (bundleFileNames.contains(bundleFile3)) : bv;
                assert (bv.getBundleDeployments().isEmpty()) : bv;
                assert (bv.getConfigurationDefinition().getPropertyDefinitions().size() == 4);
                assert (bv.getConfigurationDefinition().get(propName1) != null);
                assert (bv.getConfigurationDefinition().get(propName1).getDescription().equals(propDesc1));
                assert (bv.getConfigurationDefinition().get(propName1).isRequired());
                assert (bv.getConfigurationDefinition().getPropertyDefinitionSimple(propName1).getType() == PropertySimpleType.INTEGER);
                assert (bv.getConfigurationDefinition().get(propName2) != null);
                assert (bv.getConfigurationDefinition().get(propName2).getDescription().equals(propDesc2));
                assert (!bv.getConfigurationDefinition().get(propName2).isRequired());
                assert (bv.getConfigurationDefinition().getPropertyDefinitionSimple(propName2).getType() == PropertySimpleType.STRING);
                assert (bv.getConfigurationDefinition().get(propName3) != null);
                assert (bv.getConfigurationDefinition().get(propName3).getDescription().equals(propDesc3));
                assert (bv.getConfigurationDefinition().get(propName3).isRequired());
                assert (bv.getConfigurationDefinition().getPropertyDefinitionSimple(propName3).getType() == PropertySimpleType.STRING);
                assert (bv.getConfigurationDefinition().get(propName4) != null);
                assert (bv.getConfigurationDefinition().get(propName4).getDescription().equals(propDesc4));
                assert (!bv.getConfigurationDefinition().get(propName4).isRequired());
                assert (bv.getConfigurationDefinition().getPropertyDefinitionSimple(propName4).getType() == PropertySimpleType.STRING);
                assert (bv.getRecipe().equals(recipe));
                ConfigurationTemplate defaultTemplate = bv.getConfigurationDefinition().getDefaultTemplate();
                Configuration defaultConfig = defaultTemplate.getConfiguration();
                assert (defaultConfig.getProperties().size() == 3);
                PropertySimple prop1 = defaultConfig.getSimple(propName1);
                PropertySimple prop2 = defaultConfig.getSimple(propName2);
                PropertySimple prop3 = defaultConfig.getSimple(propName3);
                PropertySimple prop4 = defaultConfig.getSimple(propName4);
                assert (prop1 != null);
                assert (prop2 == null) : "prop2 was not required and has no default, it should not be in the default template config";
                assert (prop3 != null);
                assert (prop4 != null);
                assert (prop1.getIntegerValue() != null);
                assert (prop1.getIntegerValue() == propDefaultValue1);
                assert (prop3.getStringValue() == null) : "prop3 was required but had no default, its template value should have been null";
                assert (prop4.getStringValue().equals(propDefaultValue4));
            }
        }
        finally {
            FileUtil.purge((File)tmpDir, (boolean)true);
        }
    }

    @Test(enabled=true)
    public void testGetBundleTypes() throws Exception {
        BundleType bt1 = this.createBundleType("one");
        BundleType bt2 = this.createBundleType("two");
        List bts = this.bundleManager.getAllBundleTypes(this.overlord);
        assert (bts.size() >= 2) : "should have at least 2 bundle types";
        ArrayList<String> btNames = new ArrayList<String>();
        for (BundleType bundleType : bts) {
            btNames.add(bundleType.getName());
        }
        assert (btNames.contains(bt1.getName()));
        assert (btNames.contains(bt2.getName()));
    }

    @Test(enabled=true)
    public void testCreateBundle() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
    }

    @Test(enabled=true)
    public void testCreateBundleVersion() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        this.assertNotNull(bv1);
        this.assertEquals("1.0", bv1.getVersion());
        assert (0 == bv1.getVersionOrder());
        BundleVersion bv2 = this.createBundleVersion(b1.getName() + "-2", null, b1);
        this.assertNotNull(bv2);
        this.assertEquals("1.1", bv2.getVersion());
        assert (1 == bv2.getVersionOrder());
    }

    @Test(enabled=true)
    public void testDeleteBundle() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        this.assertNotNull(bv1);
        this.assertEquals("1.0", bv1.getVersion());
        BundleVersion bv2 = this.createBundleVersion(b1.getName() + "-2", null, b1);
        this.assertNotNull(bv2);
        this.assertEquals("1.1", bv2.getVersion());
        this.bundleManager.addBundleFileViaByteArray(this.overlord, bv2.getId(), "testDeleteBundle", "1.0", new Architecture("noarch"), "content".getBytes());
        BundleFileCriteria bfCriteria = new BundleFileCriteria();
        bfCriteria.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
        bfCriteria.fetchPackageVersion(true);
        PageList files = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfCriteria);
        assert (files.size() == 1) : files;
        assert (((BundleFile)files.get(0)).getPackageVersion().getGeneralPackage().getName().equals("testDeleteBundle")) : files;
        this.bundleManager.deleteBundle(this.overlord, b1.getId());
        BundleCriteria bCriteria = new BundleCriteria();
        bCriteria.addFilterId(Integer.valueOf(b1.getId()));
        PageList bResults = this.bundleManager.findBundlesByCriteria(this.overlord, bCriteria);
        assert (bResults.size() == 0);
    }

    @Test(enabled=true)
    public void testDeleteBundleDeployment() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull("Instance of newly created bundle should not be null", b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        this.assertNotNull("Instance of newly created bundle version should not be null", bv1);
        ResourceGroup platformResourceGroup = this.createTestResourceGroup();
        this.assertNotNull("Instance of newly created resource group should not be null", platformResourceGroup);
        BundleDestination dest1 = this.createDestination(b1, "one", "/test", platformResourceGroup);
        this.assertNotNull("Instance of newly created bundle destination should not be null", dest1);
        BundleDeployment deployment1 = this.createDeployment("one", bv1, dest1, ((Configuration.Builder)Configuration.builder().addSimple("bundletest.property", (Object)"bundletest.property value")).build());
        this.assertNotNull("Instance of newly created bundle deployment should not be null", deployment1);
        this.getTransactionManager().begin();
        deployment1.setStatus(BundleDeploymentStatus.SUCCESS);
        this.em.merge((Object)deployment1);
        this.getTransactionManager().commit();
        BundleDeployment deployment2 = this.createDeployment("two", bv1, dest1, ((Configuration.Builder)Configuration.builder().addSimple("bundletest.property", (Object)"bundletest.property value")).build());
        this.assertNotNull("Instance of newly created bundle deployment should not be null", deployment2);
        this.getTransactionManager().begin();
        deployment2.setStatus(BundleDeploymentStatus.SUCCESS);
        deployment2.setReplacedBundleDeploymentId(Integer.valueOf(deployment1.getId()));
        this.em.merge((Object)deployment2);
        this.getTransactionManager().commit();
        BundleDeployment deployment3 = this.createDeployment("three", bv1, dest1, ((Configuration.Builder)Configuration.builder().addSimple("bundletest.property", (Object)"bundletest.property value")).build());
        this.assertNotNull("Instance of newly created bundle deployment should not be null", deployment3);
        this.getTransactionManager().begin();
        deployment3.setStatus(BundleDeploymentStatus.SUCCESS);
        deployment3.setReplacedBundleDeploymentId(Integer.valueOf(deployment2.getId()));
        this.em.merge((Object)deployment3);
        this.getTransactionManager().commit();
        BundleDeploymentCriteria criteria = new BundleDeploymentCriteria();
        criteria.addFilterBundleId(Integer.valueOf(b1.getId()));
        PageList deployments = this.bundleManager.findBundleDeploymentsByCriteria(this.subjectManager.getOverlord(), criteria);
        this.assertNotNull("List of bundle deployments should not be null", deployments);
        this.assertEquals(3, deployments.size());
        this.bundleManager.deleteBundleDeployment(this.subjectManager.getOverlord(), deployment2.getId());
        deployments = this.bundleManager.findBundleDeploymentsByCriteria(this.subjectManager.getOverlord(), criteria);
        this.assertNotNull("List of bundle deployments should not be null", deployments);
        this.assertEquals(2, deployments.size());
        this.assertTrue("When the middle chain was removed the links should be modified correctly. Assume A -> B -> C deployment structure, remove B, this should result in A -> C", ((BundleDeployment)deployments.get(0)).getReplacedBundleDeploymentId() == null ? ((BundleDeployment)deployments.get(1)).getReplacedBundleDeploymentId().intValue() == ((BundleDeployment)deployments.get(0)).getId() : ((BundleDeployment)deployments.get(0)).getReplacedBundleDeploymentId().intValue() == ((BundleDeployment)deployments.get(1)).getId());
        this.bundleManager.deleteBundleDeployment(this.subjectManager.getOverlord(), deployment1.getId());
        deployments = this.bundleManager.findBundleDeploymentsByCriteria(this.subjectManager.getOverlord(), criteria);
        this.assertNotNull("List of bundle deployments should not be null", deployments);
        this.assertEquals("1 bundle deployment should be found, 2 were deleted.", 1, deployments.size());
        this.assertEquals("replacedBundleDeploymentId should be set to null, because all the previous deployments were deleted.", ((BundleDeployment)deployments.get(0)).getReplacedBundleDeploymentId(), null);
        this.bundleManager.deleteBundleDeployment(this.subjectManager.getOverlord(), deployment3.getId());
        deployments = this.bundleManager.findBundleDeploymentsByCriteria(this.subjectManager.getOverlord(), criteria);
        this.assertNotNull("List of bundle deployments should not be null", deployments);
        this.assertEquals("No bundle deployments should be found, all were deleted.", 0, deployments.size());
    }

    @Test(enabled=true)
    public void testDeleteBundleVersion() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        this.assertNotNull(bv1);
        this.assertEquals("1.0", bv1.getVersion());
        BundleVersion bv2 = this.createBundleVersion(b1.getName() + "-2", null, b1);
        this.assertNotNull(bv2);
        this.assertEquals("1.1", bv2.getVersion());
        this.bundleManager.addBundleFileViaByteArray(this.overlord, bv2.getId(), "testDeleteBundleVersion", "1.0", new Architecture("noarch"), "content".getBytes());
        BundleFileCriteria bfCriteria = new BundleFileCriteria();
        bfCriteria.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
        bfCriteria.fetchPackageVersion(true);
        PageList files = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfCriteria);
        assert (files.size() == 1) : files;
        assert (((BundleFile)files.get(0)).getPackageVersion().getGeneralPackage().getName().equals("testDeleteBundleVersion")) : files;
        BundleVersionCriteria bvCriteria = new BundleVersionCriteria();
        BundleCriteria bCriteria = new BundleCriteria();
        this.bundleManager.deleteBundleVersion(this.overlord, bv2.getId(), true);
        bvCriteria.addFilterId(Integer.valueOf(bv2.getId()));
        PageList bvResults = this.bundleManager.findBundleVersionsByCriteria(this.overlord, bvCriteria);
        assert (bvResults.size() == 0);
        bCriteria.addFilterId(Integer.valueOf(b1.getId()));
        PageList bResults = this.bundleManager.findBundlesByCriteria(this.overlord, bCriteria);
        assert (bResults.size() == 1) : "Should not have deleted bundle yet, 1 version still exists";
        this.bundleManager.deleteBundleVersion(this.overlord, bv1.getId(), true);
        bvCriteria.addFilterId(Integer.valueOf(bv1.getId()));
        bvResults = this.bundleManager.findBundleVersionsByCriteria(this.overlord, bvCriteria);
        assert (bvResults.size() == 0);
        bCriteria.addFilterId(Integer.valueOf(b1.getId()));
        bResults = this.bundleManager.findBundlesByCriteria(this.overlord, bCriteria);
        assert (bResults.size() == 0) : "Should have deleted bundle since no versions exists anymore";
        bCriteria = new BundleCriteria();
        PageList composites = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, bCriteria);
        assert (composites.size() == 0);
    }

    @Test(enabled=true)
    public void testCreateBundleVersionOrdering() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleCriteria criteria = new BundleCriteria();
        criteria.addSortName(PageOrdering.ASC);
        PageList results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion() == null);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 0L);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", "1.0", b1);
        this.assertNotNull(bv1);
        this.assertEquals("1.0", bv1.getVersion());
        assert (0 == bv1.getVersionOrder());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("1.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 1L);
        BundleVersion bv2 = this.createBundleVersion(b1.getName() + "-2", "2.0", b1);
        this.assertNotNull(bv2);
        this.assertEquals("2.0", bv2.getVersion());
        assert (1 == bv2.getVersionOrder());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 2L);
        BundleVersion bv3 = this.createBundleVersion(b1.getName() + "-3", "1.5", b1);
        this.assertNotNull(bv3);
        this.assertEquals("1.5", bv3.getVersion());
        assert (1 == bv3.getVersionOrder());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 3L);
        BundleVersionCriteria c = new BundleVersionCriteria();
        c.addFilterId(Integer.valueOf(bv1.getId()));
        PageList bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(1, bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 0);
        c.addFilterId(Integer.valueOf(bv2.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(1, bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 2);
        c.addFilterId(Integer.valueOf(bv3.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(1, bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 1);
        BundleVersion bv4 = this.createBundleVersion(b1.getName() + "-4", "0.5", b1);
        this.assertNotNull(bv4);
        this.assertEquals("0.5", bv4.getVersion());
        c.addFilterId(Integer.valueOf(bv4.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(1, bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 0);
        c.addFilterId(Integer.valueOf(bv1.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(1, bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 1);
        c.addFilterId(Integer.valueOf(bv3.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(1, bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 2);
        c.addFilterId(Integer.valueOf(bv2.getId()));
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(1, bvs.size());
        assert (((BundleVersion)bvs.get(0)).getVersionOrder() == 3);
        Bundle b2 = this.createBundle("two");
        this.assertNotNull(b2);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 4L);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion() == null);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 0L);
        BundleVersion b2_bv1 = this.createBundleVersion(b2.getName() + "-5", "9.1", b2);
        this.assertNotNull(b2_bv1);
        this.assertEquals("9.1", b2_bv1.getVersion());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 4L);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion().equals("9.1"));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 1L);
        criteria.addSortName(PageOrdering.DESC);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 4L);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("9.1"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 1L);
        criteria.addSortName(PageOrdering.ASC);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 4L);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion().equals("9.1"));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 1L);
        this.bundleManager.deleteBundleVersion(this.overlord, bv1.getId(), true);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (results.size() == 2) : results;
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 3L);
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleId().equals(b2.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleName().equals(b2.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getBundleDescription().equals(b2.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getLatestVersion().equals("9.1"));
        assert (((BundleWithLatestVersionComposite)results.get(1)).getVersionsCount() == 1L);
        BundleVersion bv5 = this.createBundleVersion(b1.getName() + "-5", "5.0", b1);
        this.assertNotNull(bv5);
        this.assertEquals("5.0", bv5.getVersion());
        assert (3 == bv5.getVersionOrder());
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("5.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 4L);
        this.bundleManager.deleteBundleVersion(this.overlord, bv5.getId(), true);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 3L);
        this.bundleManager.deleteBundleVersion(this.overlord, bv4.getId(), true);
        results = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(this.overlord, criteria);
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleId().equals(b1.getId()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleName().equals(b1.getName()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getBundleDescription().equals(b1.getDescription()));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getLatestVersion().equals("2.0"));
        assert (((BundleWithLatestVersionComposite)results.get(0)).getVersionsCount() == 2L);
    }

    @Test(enabled=true)
    public void testAddBundleFiles() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        this.assertNotNull(bv1);
        BundleFile bf1 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-bundlefile-1", "1.0", null, "Test Bundle File # 1".getBytes());
        BundleFile bf2 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-bundlefile-2", "1.0", null, "Test Bundle File # 2".getBytes());
    }

    @Test(enabled=true)
    public void testAddBundleFilesToDifferentBundles() throws Exception {
        BundleType bt = this.createBundleType("one");
        Bundle b1 = this.createBundle(this.overlord, "one", bt, null);
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        this.assertNotNull(bv1);
        BundleFile b1f1 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), TEST_PREFIX + "-file1", "1.0", null, "Bundle #1 File # 1".getBytes());
        Bundle b2 = this.createBundle(this.overlord, "two", bt, null);
        this.assertNotNull(b2);
        BundleVersion bv2 = this.createBundleVersion(b2.getName(), "1.0", b2);
        this.assertNotNull(bv2);
        BundleFile b2f1 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv2.getId(), TEST_PREFIX + "-file1", "1.0", null, "Bundle #2 File # 1".getBytes());
        BundleFileCriteria bfc = new BundleFileCriteria();
        bfc.addFilterBundleVersionId(Integer.valueOf(bv1.getId()));
        PageList bundleFiles = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfc);
        assert (bundleFiles.size() == 1) : bundleFiles;
        assert (((BundleFile)bundleFiles.get(0)).getId() == b1f1.getId()) : bundleFiles;
        bfc = new BundleFileCriteria();
        bfc.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
        bundleFiles = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfc);
        assert (bundleFiles.size() == 1) : bundleFiles;
        assert (((BundleFile)bundleFiles.get(0)).getId() == b2f1.getId()) : bundleFiles;
        assert (b1f1.getId() != b2f1.getId()) : "should have been different bundle files";
        assert (b1f1.getPackageVersion().getId() != b2f1.getPackageVersion().getId()) : "should be different PV";
        assert (b1f1.getPackageVersion().getGeneralPackage().getId() != b2f1.getPackageVersion().getGeneralPackage().getId()) : "package IDs should be different";
        assert (!b1f1.getPackageVersion().getGeneralPackage().equals((Object)b2f1.getPackageVersion().getGeneralPackage())) : "should be different packages";
    }

    @Test(enabled=true)
    public void testCreateBundleDeployment() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        this.assertNotNull(bv1);
        ResourceGroup platformResourceGroup = this.createTestResourceGroup();
        this.assertNotNull(platformResourceGroup);
        BundleDestination dest1 = this.createDestination(b1, "one", "/test", platformResourceGroup);
        this.assertNotNull(dest1);
        Configuration config = new Configuration();
        try {
            this.createDeployment("one", bv1, dest1, config);
            this.fail("Bad config was accepted");
        }
        catch (Exception e) {
            // empty catch block
        }
        config.put((Property)new PropertySimple("bundletest.property", (Object)"bundletest.property value"));
        this.assertNotNull(this.createDeployment("one", bv1, dest1, config));
    }

    @Test(enabled=true)
    public void testDeployBundle() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName() + "-1", null, b1);
        this.assertNotNull(bv1);
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("bundletest.property", (Object)"bundletest.property value"));
        ResourceGroup platformResourceGroup = this.createTestResourceGroup();
        this.assertNotNull(platformResourceGroup);
        BundleDestination dest1 = this.createDestination(b1, "one", "/test", platformResourceGroup);
        this.assertNotNull(dest1);
        BundleDeployment bd1 = this.createDeployment("one", bv1, dest1, config);
        this.assertNotNull(bd1);
        this.assertEquals(BundleDeploymentStatus.PENDING, bd1.getStatus());
        BundleDeployment bd1d = this.bundleManager.scheduleBundleDeployment(this.overlord, bd1.getId(), false);
        this.assertNotNull(bd1d);
        this.assertEquals(bd1.getId(), bd1d.getId());
        BundleDeploymentCriteria bdc = new BundleDeploymentCriteria();
        bdc.addFilterId(Integer.valueOf(bd1d.getId()));
        bdc.fetchBundleVersion(true);
        bdc.fetchDestination(true);
        bdc.fetchResourceDeployments(true);
        bdc.fetchTags(true);
        PageList bds = this.bundleManager.findBundleDeploymentsByCriteria(this.overlord, bdc);
        this.assertEquals(1, bds.size());
        bd1d = (BundleDeployment)bds.get(0);
        this.assertEquals(platformResourceGroup, bd1d.getDestination().getGroup());
        this.assertEquals(dest1.getId(), bd1d.getDestination().getId());
        BundleResourceDeploymentCriteria c = new BundleResourceDeploymentCriteria();
        c.addFilterBundleDeploymentId(Integer.valueOf(bd1d.getId()));
        c.fetchBundleDeployment(true);
        c.fetchHistories(true);
        c.fetchResource(true);
        PageList brds = this.bundleManager.findBundleResourceDeploymentsByCriteria(this.overlord, c);
        this.assertEquals(1, brds.size());
        this.assertEquals(1, bd1d.getResourceDeployments().size());
        this.assertEquals(((BundleResourceDeployment)bd1d.getResourceDeployments().get(0)).getId(), ((BundleResourceDeployment)brds.get(0)).getId());
        BundleResourceDeployment brd = (BundleResourceDeployment)brds.get(0);
        this.assertNotNull(brd.getBundleResourceDeploymentHistories());
        int size = brd.getBundleResourceDeploymentHistories().size();
        this.assertTrue(size > 0);
        String auditMessage = "BundleTest-Message";
        this.bundleManager.addBundleResourceDeploymentHistoryInNewTrans(this.overlord, brd.getId(), new BundleResourceDeploymentHistory(this.overlord.getName(), auditMessage, auditMessage, BundleResourceDeploymentHistory.Category.DEPLOY_STEP, BundleResourceDeploymentHistory.Status.SUCCESS, auditMessage, auditMessage));
        brds = this.bundleManager.findBundleResourceDeploymentsByCriteria(this.overlord, c);
        this.assertEquals(1, brds.size());
        this.assertEquals(brd.getId(), ((BundleResourceDeployment)brds.get(0)).getId());
        brd = (BundleResourceDeployment)brds.get(0);
        this.assertNotNull(brd.getBundleResourceDeploymentHistories());
        this.assertTrue(size + 1 == brd.getBundleResourceDeploymentHistories().size());
        BundleResourceDeploymentHistory newHistory = null;
        for (BundleResourceDeploymentHistory h : brd.getBundleResourceDeploymentHistories()) {
            if (!auditMessage.equals(h.getMessage())) continue;
            newHistory = h;
            break;
        }
        this.assertNotNull(newHistory);
        this.assertEquals(auditMessage, newHistory.getAction());
        this.assertEquals(BundleResourceDeploymentHistory.Status.SUCCESS, newHistory.getStatus());
    }

    @Test(enabled=true)
    public void testGetBundleFilenames() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        this.assertNotNull(bv1);
        Set filenames = this.bundleManager.getBundleVersionFilenames(this.overlord, bv1.getId(), true);
        this.assertNotNull(filenames);
        this.assertEquals(202, filenames.size());
        BundleFile bf1 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-bundlefile-1", "1.0", null, "Test Bundle File # 1".getBytes());
        filenames = this.bundleManager.getBundleVersionFilenames(this.overlord, bv1.getId(), true);
        this.assertNotNull(filenames);
        this.assertEquals(201, filenames.size());
        BundleFile bf2 = this.bundleManager.addBundleFileViaByteArray(this.overlord, bv1.getId(), "bundletest-bundlefile-2", "1.0", null, "Test Bundle File # 2".getBytes());
        filenames = this.bundleManager.getBundleVersionFilenames(this.overlord, bv1.getId(), true);
        this.assertNotNull(filenames);
        this.assertEquals(200, filenames.size());
    }

    @Test(enabled=true)
    public void testFindBundlesByCriteria() throws Exception {
        Bundle b1 = this.createBundle("one");
        Bundle b2 = this.createBundle("two");
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        BundleVersion bv2 = this.createBundleVersion(b2.getName(), "1.0", b2);
        BundleCriteria c = new BundleCriteria();
        c.addFilterName(TEST_PREFIX);
        PageList bundles = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        this.assertNotNull(bundles);
        this.assertEquals(2, bundles.size());
        Bundle b = (Bundle)bundles.get(0);
        String name = "one";
        this.assertNotNull(b);
        this.assertTrue(b.getBundleType().getName(), b.getName().contains(name));
        this.assertTrue(b.getBundleType().getName(), b.getBundleType().getName().contains(name));
        try {
            b.getBundleVersions().isEmpty();
            this.fail("Should have thrown LazyInitializationException");
        }
        catch (LazyInitializationException e) {
        }
        catch (Exception e) {
            this.fail("Should have thrown LazyInitializationException");
        }
        b = (Bundle)bundles.get(1);
        name = "two";
        this.assertNotNull(b);
        this.assertTrue(b.getBundleType().getName(), b.getName().contains(name));
        this.assertTrue(b.getBundleType().getName(), b.getBundleType().getName().contains(name));
        c.addFilterId(Integer.valueOf(b.getId()));
        c.addFilterName(b.getName());
        c.addFilterBundleTypeName(b.getBundleType().getName());
        c.fetchBundleVersions(true);
        c.fetchRepo(true);
        bundles = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        this.assertNotNull(bundles);
        this.assertEquals(1, bundles.size());
        b = (Bundle)bundles.get(0);
        this.assertTrue(b.getBundleType().getName(), b.getName().contains(name));
        this.assertTrue(b.getBundleType().getName(), b.getBundleType().getName().contains(name));
        this.assertNotNull(b.getBundleVersions());
        this.assertEquals(1, b.getBundleVersions().size());
        BundleVersion bv = (BundleVersion)b.getBundleVersions().get(0);
        this.assertEquals(bv2, bv);
        this.assertEquals(b, bv.getBundle());
        Repo r = b.getRepo();
        this.assertNotNull(r);
        this.assertEquals(b.getName(), r.getName());
    }

    @Test(enabled=true)
    public void testFindBundlesByCriteriaPaging() throws Exception {
        Object b = null;
        for (int i = 0; i < 9; ++i) {
            this.createBundle("name" + (i + 1));
        }
        Bundle b10 = this.createBundle("name10");
        BundleCriteria c = new BundleCriteria();
        c.addFilterName(TEST_PREFIX);
        c.setPaging(0, 5);
        c.fetchBundleVersions(true);
        c.fetchDestinations(true);
        c.fetchPackageType(true);
        c.fetchRepo(true);
        PageList bs = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        this.assertNotNull(bs);
        this.assertEquals(5, bs.size());
        this.assertFalse(((Bundle)bs.get(0)).equals(bs.get(1)));
        c.addFilterName(TEST_PREFIX);
        c.setPaging(4, 2);
        c.fetchBundleVersions(true);
        c.fetchDestinations(true);
        c.fetchPackageType(true);
        c.fetchRepo(true);
        bs = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        this.assertNotNull(bs);
        this.assertEquals(2, bs.size());
        this.assertEquals(b10, bs.get(1));
        c.addFilterName(TEST_PREFIX);
        c.setCaseSensitive(true);
        c.setPaging(1, 9);
        c.fetchBundleVersions(true);
        c.fetchDestinations(true);
        c.fetchPackageType(true);
        c.fetchRepo(true);
        bs = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        this.assertNotNull(bs);
        this.assertEquals(1, bs.size());
        this.assertEquals(b10, bs.get(0));
    }

    @Test(enabled=true)
    public void testFindAndDeleteBundlesByCriteriaQuery() throws Exception {
        HashMap bundleNames = new HashMap();
        int bundleCount = 50;
        Bundle b01 = this.createBundle("name01");
        for (int i = 1; i < 50; ++i) {
            this.createBundle("name" + String.format("%02d", i + 1));
        }
        BundleCriteria criteria = new BundleCriteria();
        criteria.addFilterName(TEST_PREFIX);
        int pageSize = 10;
        criteria.setPaging(0, 10);
        criteria.addSortName(PageOrdering.DESC);
        CriteriaQueryExecutor<Bundle, BundleCriteria> queryExecutor = new CriteriaQueryExecutor<Bundle, BundleCriteria>(){

            public PageList<Bundle> execute(BundleCriteria criteria) {
                return BundleManagerBeanTest.this.bundleManager.findBundlesByCriteria(BundleManagerBeanTest.this.overlord, criteria);
            }
        };
        CriteriaQuery bundles = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
        ArrayList<Integer> toRemove = new ArrayList<Integer>(bundleNames.size());
        String prevName = null;
        String errMsg = "Results should be sorted by names, something is out of order";
        for (Bundle b : bundles) {
            this.assertTrue(errMsg, null == prevName || prevName.compareTo(b.getName()) > 0);
            prevName = b.getName();
            toRemove.add(b.getId());
            bundleNames.remove(String.valueOf(b.getName()));
        }
        Iterator i$ = toRemove.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            this.bundleManager.deleteBundle(this.overlord, id);
        }
        this.assertEquals("The name should be \"name01\"", b01.getName(), prevName);
        this.assertTrue("Expected bundleNames to be empty. Still " + bundleNames.size() + " bundle(s).", bundleNames.isEmpty());
        criteria = new BundleCriteria();
        criteria.addFilterName(TEST_PREFIX);
        criteria.clearPaging();
        PageList bvs = this.bundleManager.findBundlesByCriteria(this.overlord, criteria);
        this.assertNotNull(bvs);
        this.assertTrue(bvs.isEmpty());
    }

    @Test(enabled=true)
    public void testFindBundleVersionsByCriteria() throws Exception {
        Bundle b1 = this.createBundle("one");
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        BundleVersion bv2 = this.createBundleVersion(b1.getName(), "2.0", b1);
        BundleVersion bv3 = this.createBundleVersion(b1.getName(), "2.1", b1);
        BundleVersionCriteria c = new BundleVersionCriteria();
        c.addFilterName(TEST_PREFIX);
        PageList bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(3, bvs.size());
        this.assertFalse(((BundleVersion)bvs.get(0)).equals(bvs.get(1)));
        this.assertFalse(((BundleVersion)bvs.get(0)).equals(bvs.get(2)));
        this.assertFalse(((BundleVersion)bvs.get(1)).equals(bvs.get(2)));
        this.assertTrue(((BundleVersion)bvs.get(0)).equals(bvs.get(0)));
        this.assertTrue(((BundleVersion)bvs.get(0)).equals((Object)bv2) || ((BundleVersion)bvs.get(1)).equals((Object)bv2) || ((BundleVersion)bvs.get(2)).equals((Object)bv2));
        BundleVersion bvIn = (BundleVersion)bvs.get(1);
        c.addFilterId(Integer.valueOf(bvIn.getId()));
        c.addFilterName(bvIn.getName());
        c.addFilterBundleName("one");
        c.addFilterVersion(bvIn.getVersion());
        c.fetchBundle(true);
        c.fetchBundleDeployments(true);
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(1, bvs.size());
        BundleVersion bvOut = (BundleVersion)bvs.get(0);
        this.assertEquals(bvIn, bvOut);
        this.assertEquals(bvOut.getBundle(), b1);
        this.assertNotNull(bvOut.getBundleDeployments());
        this.assertTrue(bvOut.getBundleDeployments().isEmpty());
    }

    @Test(enabled=true)
    public void testFindBundleVersionsByCriteriaPaging() throws Exception {
        Bundle b1 = this.createBundle("one");
        for (int i = 0; i < 59; ++i) {
            this.createBundleVersion(b1.getName(), "1." + String.format("%02d", i + 1), b1);
        }
        BundleVersion bv60 = this.createBundleVersion(b1.getName(), "1.60", b1);
        BundleVersionCriteria c = new BundleVersionCriteria();
        Object bvOut = null;
        c.addFilterName(TEST_PREFIX);
        c.addSortId(PageOrdering.ASC);
        c.setPaging(0, 10);
        PageList bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(10, bvs.size());
        this.assertFalse(((BundleVersion)bvs.get(0)).equals(bvs.get(1)));
        c.addFilterName(TEST_PREFIX);
        c.setPaging(19, 3);
        bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, c);
        this.assertNotNull(bvs);
        this.assertEquals(3, bvs.size());
        this.assertFalse(((BundleVersion)bvs.get(0)).equals(bvs.get(1)));
        this.assertEquals(bv60, bvs.get(2));
    }

    @Test(enabled=true)
    public void testFindAndDeleteBundleVersionsByCriteriaQuery() throws Exception {
        HashMap<String, BundleVersion> bundleVersionVersions = new HashMap<String, BundleVersion>();
        int bundleVersionCount = 220;
        Bundle bundle = this.createBundle("one");
        for (int i = 0; i < 220; ++i) {
            String version = "1." + String.format("%03d", i + 1);
            BundleVersion bundleVersion = this.createBundleVersion(bundle.getName(), version, bundle);
            bundleVersionVersions.put(version, bundleVersion);
        }
        int pageSize = 20;
        BundleVersionCriteria criteria = new BundleVersionCriteria();
        criteria.addFilterName(TEST_PREFIX);
        criteria.setPaging(0, 20);
        criteria.addSortId(PageOrdering.DESC);
        CriteriaQueryExecutor<BundleVersion, BundleVersionCriteria> queryExecutor = new CriteriaQueryExecutor<BundleVersion, BundleVersionCriteria>(){

            public PageList<BundleVersion> execute(BundleVersionCriteria criteria) {
                return BundleManagerBeanTest.this.bundleManager.findBundleVersionsByCriteria(BundleManagerBeanTest.this.overlord, criteria);
            }
        };
        CriteriaQuery bundleVersions = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
        ArrayList<Integer> toDelete = new ArrayList<Integer>(bundleVersionVersions.size());
        Integer prevId = null;
        String errMsg = "Results should be sorted by id, something is out of order";
        for (BundleVersion bv : bundleVersions) {
            this.assertTrue(errMsg, null == prevId || prevId > bv.getId());
            prevId = bv.getId();
            toDelete.add(bv.getId());
            bundleVersionVersions.remove(String.valueOf(bv.getVersion()));
        }
        Iterator i$ = toDelete.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            this.bundleManager.deleteBundleVersion(this.overlord, id, true);
        }
        this.assertTrue("Expected bundleVersions to be empty. Still " + bundleVersionVersions.size() + " version(s).", bundleVersionVersions.isEmpty());
        this.assertTrue("Expected bundleVersions to be empty. Still " + bundleVersionVersions.size() + " version(s).", bundleVersionVersions.isEmpty());
        criteria = new BundleVersionCriteria();
        criteria.addFilterName(TEST_PREFIX);
        criteria.clearPaging();
        PageList bvs = this.bundleManager.findBundleVersionsByCriteria(this.overlord, criteria);
        this.assertNotNull(bvs);
        this.assertTrue(bvs.isEmpty());
    }

    @Test(enabled=true)
    public void testGetAllBundleVersionFilenames() throws Exception {
        Bundle b1 = this.createBundle("one");
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(b1.getName(), "1.0", b1);
        this.assertNotNull(bv1);
        HashMap files = this.bundleManager.getAllBundleVersionFilenames(this.overlord, bv1.getId());
        this.assertNotNull(files);
        this.assertEquals(202, files.keySet().size());
    }

    @Test(enabled=true)
    public void testCreateBundleAndBundleVersionStrictName1() throws Exception {
        Bundle b1 = this.createBundle("one");
        String name = "on";
        String fullName = TEST_PREFIX + "-bundle-" + "on";
        BundleType type = this.createBundleType("on");
        String recipe = "deploy -f " + TEST_PREFIX + ".zip -d @@ test.path @@";
        BundleVersion bundleVerison = this.bundleManager.createBundleAndBundleVersion(this.overlord, fullName, "description", type.getId(), null, fullName, fullName + "-desc", "3.0", recipe);
        this.assertNotNull(bundleVerison);
        BundleCriteria c = new BundleCriteria();
        c.addFilterName(TEST_PREFIX + "-bundle-one");
        c.setStrict(true);
        PageList bundles1 = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        this.assertNotNull(bundles1);
        this.assertEquals(1, bundles1.size());
        Bundle fetchedBundle1 = (Bundle)bundles1.get(0);
        c = new BundleCriteria();
        c.addFilterName(fullName);
        c.setStrict(true);
        PageList bundles2 = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        this.assertNotNull(bundles2);
        this.assertEquals(1, bundles2.size());
    }

    @Test(enabled=true)
    public void testCreateBundleAndBundleVersionStrictName2() throws Exception {
        String name = "one";
        Bundle bundle = this.createBundle("one");
        String fullName = TEST_PREFIX + "-bundle-" + "one";
        String recipe = "deploy -f " + TEST_PREFIX + ".zip -d @@ test.path @@";
        BundleVersion bundleVerison = this.bundleManager.createBundleAndBundleVersion(this.overlord, fullName, "description", bundle.getBundleType().getId(), null, fullName, fullName + "-desc", "3.0", recipe);
        BundleCriteria c = new BundleCriteria();
        c.addFilterName(fullName);
        c.setStrict(true);
        PageList bundles = this.bundleManager.findBundlesByCriteria(this.overlord, c);
        this.assertNotNull(bundles);
        this.assertEquals(1, bundles.size());
    }

    @Test(enabled=true)
    public void testAuthzBundleGroup() throws Exception {
        Subject subject = this.createNewSubject(TEST_USER_NAME);
        Role role = this.createNewRoleForSubject(subject, TEST_ROLE_NAME);
        subject = this.createSession(subject);
        BundleGroup bundleGroup = new BundleGroup(TEST_BUNDLE_GROUP_NAME);
        bundleGroup.setDescription("test");
        try {
            this.bundleManager.createBundleGroup(subject, bundleGroup);
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        bundleGroup = this.bundleManager.createBundleGroup(subject, bundleGroup);
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        try {
            this.bundleManager.deleteBundleGroups(subject, new int[]{bundleGroup.getId()});
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        BundleGroupCriteria bgCriteria = new BundleGroupCriteria();
        PageList bundleGroups = this.bundleManager.findBundleGroupsByCriteria(subject, bgCriteria);
        this.assertNotNull(bundleGroups);
        assert (bundleGroups.isEmpty()) : "Should not be able to see unassociated bundle group";
        this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        bundleGroups = this.bundleManager.findBundleGroupsByCriteria(subject, bgCriteria);
        this.assertNotNull(bundleGroups);
        this.assertEquals("Should be able to see unassociated bundle group", 1, bundleGroups.size());
        this.bundleManager.deleteBundleGroups(subject, new int[]{bundleGroup.getId()});
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        try {
            this.createBundle(subject, TEST_PREFIX + ".bundle");
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.CREATE_BUNDLES);
        try {
            this.createBundle(subject, TEST_PREFIX + ".bundle");
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.removeRolePermissions(role, Permission.CREATE_BUNDLES);
        this.addRolePermissions(role, Permission.VIEW_BUNDLES);
        try {
            this.createBundle(subject, TEST_PREFIX + ".bundle");
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.CREATE_BUNDLES);
        Bundle bundle = this.createBundle(subject, TEST_PREFIX + ".bundle");
        this.removeRolePermissions(role, Permission.CREATE_BUNDLES, Permission.VIEW_BUNDLES);
        BundleCriteria bCriteria = new BundleCriteria();
        PageList bundles = this.bundleManager.findBundlesByCriteria(subject, bCriteria);
        this.assertNotNull(bundles);
        assert (bundles.isEmpty()) : "Should not be able to see unassigned bundle";
        this.addRolePermissions(role, Permission.VIEW_BUNDLES);
        bundles = this.bundleManager.findBundlesByCriteria(subject, bCriteria);
        this.assertNotNull(bundles);
        this.assertEquals("Should be able to see unassigned bundle", 1, bundles.size());
        this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        bundleGroup = new BundleGroup(TEST_BUNDLE_GROUP_NAME);
        bundleGroup.setDescription("test");
        bundleGroup = this.bundleManager.createBundleGroup(subject, bundleGroup);
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        try {
            this.bundleManager.assignBundlesToBundleGroups(subject, new int[]{bundleGroup.getId()}, new int[]{bundle.getId()});
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        this.bundleManager.assignBundlesToBundleGroups(subject, new int[]{bundleGroup.getId()}, new int[]{bundle.getId()});
        this.bundleManager.unassignBundlesFromBundleGroups(subject, new int[]{bundleGroup.getId()}, new int[]{bundle.getId()});
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        this.addRolePermissions(role, Permission.CREATE_BUNDLES);
        this.bundleManager.assignBundlesToBundleGroups(subject, new int[]{bundleGroup.getId()}, new int[]{bundle.getId()});
        try {
            this.bundleManager.unassignBundlesFromBundleGroups(subject, new int[]{bundleGroup.getId()}, new int[]{bundle.getId()});
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.DELETE_BUNDLES);
        this.bundleManager.unassignBundlesFromBundleGroups(subject, new int[]{bundleGroup.getId()}, new int[]{bundle.getId()});
        this.removeRolePermissions(role, Permission.DELETE_BUNDLES);
        this.removeRolePermissions(role, Permission.VIEW_BUNDLES);
        try {
            this.bundleManager.assignBundlesToBundleGroups(subject, new int[]{bundleGroup.getId()}, new int[]{bundle.getId()});
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.VIEW_BUNDLES);
        this.bundleManager.assignBundlesToBundleGroups(subject, new int[]{bundleGroup.getId()}, new int[]{bundle.getId()});
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        this.removeRolePermissions(role, Permission.VIEW_BUNDLES);
        bundles = this.bundleManager.findBundlesByCriteria(subject, bCriteria);
        this.assertNotNull(bundles);
        assert (bundles.isEmpty()) : "Should not be able to see assigned bundle";
        this.addRoleBundleGroup(role, bundleGroup);
        bundles = this.bundleManager.findBundlesByCriteria(subject, bCriteria);
        this.assertNotNull(bundles);
        this.assertEquals("Should be able to see assigned bundle", 1, bundles.size());
        bCriteria.addFilterBundleGroupIds(new Integer[]{87678});
        bCriteria.fetchBundleGroups(true);
        bundles = this.bundleManager.findBundlesByCriteria(subject, bCriteria);
        this.assertNotNull(bundles);
        assert (bundles.isEmpty()) : "Should not have found anything";
        bCriteria.addFilterBundleGroupIds(new Integer[]{bundleGroup.getId()});
        bCriteria.fetchBundleGroups(true);
        bundles = this.bundleManager.findBundlesByCriteria(subject, bCriteria);
        this.assertNotNull(bundles);
        this.assertEquals("Should be able to see assigned bundle", 1, bundles.size());
        this.assertNotNull(((Bundle)bundles.get(0)).getBundleGroups());
        this.assertEquals("Should have fetched bundlegroup", 1, ((Bundle)bundles.get(0)).getBundleGroups().size());
        this.assertEquals("Should have fetched expected bundlegroup", bundleGroup, ((Bundle)bundles.get(0)).getBundleGroups().iterator().next());
        bgCriteria.addFilterId(Integer.valueOf(87678));
        bgCriteria.addFilterBundleIds(new Integer[]{87678});
        bgCriteria.addFilterRoleIds(new Integer[]{87678});
        bgCriteria.fetchBundles(true);
        bgCriteria.fetchRoles(true);
        bundleGroups = this.bundleManager.findBundleGroupsByCriteria(subject, bgCriteria);
        this.assertNotNull(bundleGroups);
        assert (bundleGroups.isEmpty()) : "Should not have found anything";
        bgCriteria.addFilterId(Integer.valueOf(bundleGroup.getId()));
        bundleGroups = this.bundleManager.findBundleGroupsByCriteria(subject, bgCriteria);
        this.assertNotNull(bundleGroups);
        assert (bundleGroups.isEmpty()) : "Should not have found anything";
        bgCriteria.addFilterBundleIds(new Integer[]{bundle.getId()});
        bundleGroups = this.bundleManager.findBundleGroupsByCriteria(subject, bgCriteria);
        this.assertNotNull(bundleGroups);
        assert (bundleGroups.isEmpty()) : "Should not have found anything";
        bgCriteria.addFilterRoleIds(new Integer[]{role.getId()});
        bundleGroups = this.bundleManager.findBundleGroupsByCriteria(subject, bgCriteria);
        this.assertNotNull(bundleGroups);
        this.assertEquals("Should be able to see assigned bundle", 1, bundleGroups.size());
        this.assertNotNull(((BundleGroup)bundleGroups.get(0)).getBundles());
        this.assertEquals("Should have fetched bundle in bundle group", 1, ((BundleGroup)bundleGroups.get(0)).getBundles().size());
        this.assertEquals("Should have fetched bundle in bundle group", bundle, ((BundleGroup)bundleGroups.get(0)).getBundles().iterator().next());
        this.assertNotNull(((BundleGroup)bundleGroups.get(0)).getRoles());
        this.assertEquals("Should have fetched role for bundle group", 1, ((BundleGroup)bundleGroups.get(0)).getRoles().size());
        this.assertEquals("Should have fetched role for bundle group", role, ((BundleGroup)bundleGroups.get(0)).getRoles().iterator().next());
    }

    @Test(enabled=true)
    public void testAuthzCreateBundleVersion() throws Exception {
        BundleVersion bv1;
        Subject subject = this.createNewSubject(TEST_USER_NAME);
        Role role = this.createNewRoleForSubject(subject, TEST_ROLE_NAME);
        subject = this.createSession(subject);
        this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        BundleGroup bundleGroup1 = new BundleGroup(TEST_BUNDLE_GROUP_NAME + "_1");
        bundleGroup1.setDescription("bg-1");
        bundleGroup1 = this.bundleManager.createBundleGroup(subject, bundleGroup1);
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        this.addRoleBundleGroup(role, bundleGroup1);
        try {
            this.createBundle(subject, TEST_PREFIX + ".bundle", bundleGroup1.getId());
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.CREATE_BUNDLES_IN_GROUP);
        Bundle bundle = this.createBundle(subject, TEST_PREFIX + ".bundle", bundleGroup1.getId());
        this.removeRolePermissions(role, Permission.CREATE_BUNDLES_IN_GROUP);
        try {
            bv1 = this.createBundleVersion(subject, bundle.getName() + "-1", null, bundle);
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.CREATE_BUNDLES_IN_GROUP);
        bv1 = this.createBundleVersion(subject, bundle.getName() + "-1", null, bundle);
        this.assertNotNull(bv1);
        this.assertEquals("1.0", bv1.getVersion());
        assert (0 == bv1.getVersionOrder());
        Role role2 = this.createNewRoleForSubject(subject, TEST_ROLE_NAME + "_2");
        this.addRolePermissions(role2, Permission.CREATE_BUNDLES_IN_GROUP);
        this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        BundleGroup bundleGroup2 = new BundleGroup(TEST_BUNDLE_GROUP_NAME + "_2");
        bundleGroup2.setDescription("bg-2");
        bundleGroup2 = this.bundleManager.createBundleGroup(subject, bundleGroup2);
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        try {
            this.createBundle(subject, TEST_PREFIX + ".bundle", bundleGroup2.getId());
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        try {
            this.bundleManager.assignBundlesToBundleGroups(subject, new int[]{bundleGroup2.getId()}, new int[]{bundle.getId()});
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRoleBundleGroup(role2, bundleGroup2);
        this.removeRolePermissions(role2, Permission.CREATE_BUNDLES_IN_GROUP);
        try {
            this.bundleManager.assignBundlesToBundleGroups(subject, new int[]{bundleGroup2.getId()}, new int[]{bundle.getId()});
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role2, Permission.ASSIGN_BUNDLES_TO_GROUP);
        this.bundleManager.assignBundlesToBundleGroups(subject, new int[]{bundleGroup2.getId()}, new int[]{bundle.getId()});
        BundleCriteria bundleCriteria = new BundleCriteria();
        bundleCriteria.addFilterBundleGroupIds(new Integer[]{bundleGroup1.getId(), bundleGroup2.getId()});
        PageList bundles = this.bundleManager.findBundlesByCriteria(subject, bundleCriteria);
        this.assertNotNull(bundles);
        this.assertEquals("Should be able to see assigned bundle", 1, bundles.size());
        this.assertEquals("Should have fetched bundle", bundle, bundles.get(0));
        BundleVersionCriteria bvCriteria = new BundleVersionCriteria();
        bvCriteria.addFilterBundleId(Integer.valueOf(bundle.getId()));
        PageList bundleVersions = this.bundleManager.findBundleVersionsByCriteria(subject, bvCriteria);
        this.assertNotNull(bundleVersions);
        this.assertEquals("Should be able to see assigned bundle bundleversion", 1, bundleVersions.size());
        this.assertEquals("Should have fetched bundleversion", bv1, bundleVersions.get(0));
        try {
            this.bundleManager.unassignBundlesFromBundleGroups(subject, new int[]{bundleGroup2.getId()}, new int[]{bundle.getId()});
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.UNASSIGN_BUNDLES_FROM_GROUP);
        this.addRolePermissions(role2, Permission.UNASSIGN_BUNDLES_FROM_GROUP);
        this.bundleManager.unassignBundlesFromBundleGroups(subject, new int[]{bundleGroup1.getId()}, new int[]{bundle.getId()});
        this.bundleManager.unassignBundlesFromBundleGroups(subject, new int[]{bundleGroup2.getId()}, new int[]{bundle.getId()});
        bundles = this.bundleManager.findBundlesByCriteria(subject, bundleCriteria);
        this.assertNotNull(bundles);
        this.assertEquals("Should not be able to see unassigned bundle", 0, bundles.size());
        bundleVersions = this.bundleManager.findBundleVersionsByCriteria(subject, bvCriteria);
        this.assertNotNull(bundleVersions);
        this.assertEquals("Should not be able to see unassigned bundle bundleversion", 0, bundleVersions.size());
        this.addRolePermissions(role, Permission.VIEW_BUNDLES);
        bundleCriteria.addFilterBundleGroupIds((Integer[])null);
        bundles = this.bundleManager.findBundlesByCriteria(subject, bundleCriteria);
        this.assertNotNull(bundles);
        this.assertEquals("Should be able to see unassigned bundle", 1, bundles.size());
        this.assertEquals("Should have fetched bundle", bundle, bundles.get(0));
        bundleVersions = this.bundleManager.findBundleVersionsByCriteria(subject, bvCriteria);
        this.assertNotNull(bundleVersions);
        this.assertEquals("Should be able to see unassigned bundle bundleversion", 1, bundleVersions.size());
        this.assertEquals("Should have fetched bundleversion", bv1, bundleVersions.get(0));
    }

    @Test(enabled=true)
    public void testAuthzDeleteBundleVersion() throws Exception {
        Subject subject = this.createNewSubject(TEST_USER_NAME);
        Role role = this.createNewRoleForSubject(subject, TEST_ROLE_NAME);
        subject = this.createSession(subject);
        this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        BundleGroup bundleGroup1 = new BundleGroup(TEST_BUNDLE_GROUP_NAME + "_1");
        bundleGroup1.setDescription("bg-1");
        bundleGroup1 = this.bundleManager.createBundleGroup(subject, bundleGroup1);
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        this.addRoleBundleGroup(role, bundleGroup1);
        this.addRolePermissions(role, Permission.CREATE_BUNDLES_IN_GROUP);
        Bundle bundle = this.createBundle(subject, TEST_PREFIX + ".bundle", bundleGroup1.getId());
        this.addRolePermissions(role, Permission.DELETE_BUNDLES);
        this.deleteBundleVersion(subject, bundle);
        bundle = this.createBundle(subject, TEST_PREFIX + ".bundle", bundleGroup1.getId());
        this.removeRolePermissions(role, Permission.DELETE_BUNDLES);
        this.addRolePermissions(role, Permission.DELETE_BUNDLES_FROM_GROUP);
        this.deleteBundleVersion(subject, bundle);
        bundle = this.createBundle(subject, TEST_PREFIX + ".bundle", bundleGroup1.getId());
        this.removeRolePermissions(role, Permission.DELETE_BUNDLES_FROM_GROUP);
        try {
            this.deleteBundleVersion(subject, bundle);
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
    }

    @Test(enabled=true)
    public void testAuthzBundleDest() throws Exception {
        BundleDestination dest1;
        ResourceGroup platformResourceGroup;
        BundleVersion bv1;
        Bundle b1;
        Role role;
        Subject subject;
        block8: {
            subject = this.createNewSubject(TEST_USER_NAME);
            role = this.createNewRoleForSubject(subject, TEST_ROLE_NAME);
            subject = this.createSession(subject);
            this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
            BundleGroup bundleGroup = new BundleGroup(TEST_BUNDLE_GROUP_NAME);
            bundleGroup.setDescription("bg");
            bundleGroup = this.bundleManager.createBundleGroup(subject, bundleGroup);
            this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
            this.addRoleBundleGroup(role, bundleGroup);
            this.addRolePermissions(role, Permission.CREATE_BUNDLES_IN_GROUP);
            b1 = this.createBundle(subject, "one", bundleGroup.getId());
            this.assertNotNull(b1);
            bv1 = this.createBundleVersion(subject, b1.getName() + "-1", null, b1);
            this.assertNotNull(bv1);
            platformResourceGroup = this.createTestResourceGroup();
            this.assertNotNull(platformResourceGroup);
            try {
                dest1 = this.createDestination(subject, b1, "one", "/test", platformResourceGroup);
                this.fail("Should have thrown IllegalArgumentException");
            }
            catch (EJBException e) {
                if ($assertionsDisabled || e.getCause() instanceof IllegalArgumentException && e.getCause().getMessage().contains("Invalid groupId")) break block8;
                throw new AssertionError((Object)"Should have not had group visibility");
            }
        }
        LookupUtil.getRoleManager().addResourceGroupsToRole(this.overlord, role.getId(), new int[]{platformResourceGroup.getId()});
        try {
            dest1 = this.createDestination(subject, b1, "one", "/test", platformResourceGroup);
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.DEPLOY_BUNDLES);
        dest1 = this.createDestination(subject, b1, "one", "/test", platformResourceGroup);
        this.assertNotNull(dest1);
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("bundletest.property", (Object)"bundletest.property value"));
        BundleDeployment bd1 = this.createDeployment(subject, "one", bv1, dest1, config);
        this.assertNotNull(bd1);
        this.removeRolePermissions(role, Permission.DEPLOY_BUNDLES);
        this.addRolePermissions(role, Permission.DEPLOY_BUNDLES_TO_GROUP);
        BundleDestination dest2 = this.createDestination(subject, b1, "two", "/test2", platformResourceGroup);
        this.assertNotNull(dest2);
        Configuration config2 = new Configuration();
        config2.put((Property)new PropertySimple("bundletest.property", (Object)"bundletest.property value"));
        BundleDeployment bd2 = this.createDeployment(subject, "two", bv1, dest2, config2);
        this.assertNotNull(bd1);
        this.removeRolePermissions(role, Permission.DEPLOY_BUNDLES_TO_GROUP);
        try {
            this.bundleManager.deleteBundleDeployment(subject, bd2.getId());
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.DEPLOY_BUNDLES);
        this.bundleManager.deleteBundleDeployment(subject, bd2.getId());
        this.removeRolePermissions(role, Permission.DEPLOY_BUNDLES);
        try {
            this.bundleManager.deleteBundleDestination(subject, dest2.getId());
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, Permission.DEPLOY_BUNDLES_TO_GROUP);
        this.bundleManager.deleteBundleDestination(subject, dest2.getId());
    }

    @Test(enabled=true)
    public void testAuthzBundleDeploy() throws Exception {
        Subject subject = this.createNewSubject(TEST_USER_NAME);
        Role role = this.createNewRoleForSubject(subject, TEST_ROLE_NAME);
        subject = this.createSession(subject);
        this.addRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        BundleGroup bundleGroup = new BundleGroup(TEST_BUNDLE_GROUP_NAME);
        bundleGroup.setDescription("bg");
        bundleGroup = this.bundleManager.createBundleGroup(subject, bundleGroup);
        this.removeRolePermissions(role, Permission.MANAGE_BUNDLE_GROUPS);
        this.addRoleBundleGroup(role, bundleGroup);
        this.addRolePermissions(role, Permission.CREATE_BUNDLES_IN_GROUP);
        Bundle b1 = this.createBundle(subject, "one", bundleGroup.getId());
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(subject, b1.getName() + "-1", null, b1);
        this.assertNotNull(bv1);
        ResourceGroup platformResourceGroup = this.createTestResourceGroup();
        this.assertNotNull(platformResourceGroup);
        LookupUtil.getRoleManager().addResourceGroupsToRole(this.overlord, role.getId(), new int[]{platformResourceGroup.getId()});
        this.addRolePermissions(role, Permission.DEPLOY_BUNDLES);
        BundleDestination dest1 = this.createDestination(subject, b1, "one", "/test", platformResourceGroup);
        this.assertNotNull(dest1);
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("bundletest.property", (Object)"bundletest.property value"));
        BundleDeployment bd1 = this.createDeployment(subject, "one", bv1, dest1, config);
        this.assertNotNull(bd1);
        this.removeRolePermissions(role, Permission.DEPLOY_BUNDLES);
        try {
            BundleDeployment bd1d = this.bundleManager.scheduleBundleDeployment(subject, bd1.getId(), false);
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.testAuthzBundleDeployInternal(subject, role, bd1, dest1, platformResourceGroup, Permission.DEPLOY_BUNDLES);
        this.testAuthzBundleDeployInternal(subject, role, bd1, dest1, platformResourceGroup, Permission.DEPLOY_BUNDLES_TO_GROUP);
    }

    private void testAuthzBundleDeployInternal(Subject subject, Role role, BundleDeployment bd1, BundleDestination dest1, ResourceGroup platformResourceGroup, Permission permission) throws Exception {
        this.addRolePermissions(role, permission);
        BundleDeployment bd1d = this.bundleManager.scheduleBundleDeployment(subject, bd1.getId(), false);
        this.assertNotNull(bd1d);
        this.assertEquals(bd1.getId(), bd1d.getId());
        BundleDeploymentCriteria bdc = new BundleDeploymentCriteria();
        bdc.addFilterId(Integer.valueOf(bd1d.getId()));
        bdc.fetchBundleVersion(true);
        bdc.fetchDestination(true);
        bdc.fetchResourceDeployments(true);
        bdc.fetchTags(true);
        PageList bds = this.bundleManager.findBundleDeploymentsByCriteria(subject, bdc);
        this.assertEquals(1, bds.size());
        bd1d = (BundleDeployment)bds.get(0);
        this.assertEquals(platformResourceGroup, bd1d.getDestination().getGroup());
        this.assertEquals(dest1.getId(), bd1d.getDestination().getId());
        BundleResourceDeploymentCriteria c = new BundleResourceDeploymentCriteria();
        c.addFilterBundleDeploymentId(Integer.valueOf(bd1d.getId()));
        c.fetchBundleDeployment(true);
        c.fetchHistories(true);
        c.fetchResource(true);
        PageList brds = this.bundleManager.findBundleResourceDeploymentsByCriteria(subject, c);
        this.assertEquals(1, brds.size());
        this.assertEquals(1, bd1d.getResourceDeployments().size());
        this.assertEquals(((BundleResourceDeployment)bd1d.getResourceDeployments().get(0)).getId(), ((BundleResourceDeployment)brds.get(0)).getId());
        BundleResourceDeployment brd = (BundleResourceDeployment)brds.get(0);
        this.assertNotNull(brd.getBundleResourceDeploymentHistories());
        int size = brd.getBundleResourceDeploymentHistories().size();
        this.assertTrue(size > 0);
        String auditMessage = "BundleTest-Message";
        this.bundleManager.addBundleResourceDeploymentHistoryInNewTrans(this.overlord, brd.getId(), new BundleResourceDeploymentHistory(this.overlord.getName(), auditMessage, auditMessage, BundleResourceDeploymentHistory.Category.DEPLOY_STEP, BundleResourceDeploymentHistory.Status.SUCCESS, auditMessage, auditMessage));
        brds = this.bundleManager.findBundleResourceDeploymentsByCriteria(subject, c);
        this.assertEquals(1, brds.size());
        this.assertEquals(brd.getId(), ((BundleResourceDeployment)brds.get(0)).getId());
        brd = (BundleResourceDeployment)brds.get(0);
        this.assertNotNull(brd.getBundleResourceDeploymentHistories());
        this.assertTrue(size + 1 == brd.getBundleResourceDeploymentHistories().size());
        BundleResourceDeploymentHistory newHistory = null;
        for (BundleResourceDeploymentHistory h : brd.getBundleResourceDeploymentHistories()) {
            if (!auditMessage.equals(h.getMessage())) continue;
            newHistory = h;
            break;
        }
        this.assertNotNull(newHistory);
        this.assertEquals(auditMessage, newHistory.getAction());
        this.assertEquals(BundleResourceDeploymentHistory.Status.SUCCESS, newHistory.getStatus());
        this.removeRolePermissions(role, permission);
        try {
            this.bundleManager.purgeBundleDestination(subject, dest1.getId());
            this.fail("Should have thrown PermissionException");
        }
        catch (PermissionException e) {
            // empty catch block
        }
        this.addRolePermissions(role, permission);
        this.bundleManager.purgeBundleDestination(subject, dest1.getId());
        this.removeRolePermissions(role, permission);
    }

    private void deleteBundleVersion(Subject subject, Bundle b1) throws Exception {
        this.assertNotNull(b1);
        BundleVersion bv1 = this.createBundleVersion(subject, b1.getName() + "-1", null, b1);
        this.assertNotNull(bv1);
        this.assertEquals("1.0", bv1.getVersion());
        BundleVersion bv2 = this.createBundleVersion(subject, b1.getName() + "-2", null, b1);
        this.assertNotNull(bv2);
        this.assertEquals("1.1", bv2.getVersion());
        this.bundleManager.addBundleFileViaByteArray(subject, bv2.getId(), "testDeleteBundleVersion", "1.0", new Architecture("noarch"), "content".getBytes());
        BundleFileCriteria bfCriteria = new BundleFileCriteria();
        bfCriteria.addFilterBundleVersionId(Integer.valueOf(bv2.getId()));
        bfCriteria.fetchPackageVersion(true);
        PageList files = this.bundleManager.findBundleFilesByCriteria(this.overlord, bfCriteria);
        assert (files.size() == 1) : files;
        assert (((BundleFile)files.get(0)).getPackageVersion().getGeneralPackage().getName().equals("testDeleteBundleVersion")) : files;
        BundleVersionCriteria bvCriteria = new BundleVersionCriteria();
        BundleCriteria bCriteria = new BundleCriteria();
        this.bundleManager.deleteBundleVersion(subject, bv2.getId(), true);
        bvCriteria.addFilterId(Integer.valueOf(bv2.getId()));
        PageList bvResults = this.bundleManager.findBundleVersionsByCriteria(subject, bvCriteria);
        assert (bvResults.size() == 0);
        bCriteria.addFilterId(Integer.valueOf(b1.getId()));
        PageList bResults = this.bundleManager.findBundlesByCriteria(subject, bCriteria);
        assert (bResults.size() == 1) : "Should not have deleted bundle yet, 1 version still exists";
        this.bundleManager.deleteBundleVersion(subject, bv1.getId(), true);
        bvCriteria.addFilterId(Integer.valueOf(bv1.getId()));
        bvResults = this.bundleManager.findBundleVersionsByCriteria(subject, bvCriteria);
        assert (bvResults.size() == 0);
        bCriteria.addFilterId(Integer.valueOf(b1.getId()));
        bResults = this.bundleManager.findBundlesByCriteria(subject, bCriteria);
        assert (bResults.size() == 0) : "Should have deleted bundle since no versions exists anymore";
        bCriteria = new BundleCriteria();
        PageList composites = this.bundleManager.findBundlesWithLatestVersionCompositesByCriteria(subject, bCriteria);
        assert (composites.size() == 0);
    }

    private Subject createNewSubject(String subjectName) throws Exception {
        Subject newSubject = new Subject();
        newSubject.setName(subjectName);
        newSubject.setFactive(true);
        newSubject.setFsystem(false);
        return LookupUtil.getSubjectManager().createSubject(this.overlord, newSubject);
    }

    private Role createNewRoleForSubject(Subject subject, String roleName) throws Exception {
        Role newRole = new Role(roleName);
        newRole.setFsystem(Boolean.valueOf(false));
        newRole.addSubject(subject);
        return LookupUtil.getRoleManager().createRole(this.overlord, newRole);
    }

    private void addRolePermissions(Role role, Permission ... permissions) throws Exception {
        for (Permission p : permissions) {
            role.getPermissions().add(p);
        }
        LookupUtil.getRoleManager().setPermissions(this.overlord, Integer.valueOf(role.getId()), role.getPermissions());
    }

    private void removeRolePermissions(Role role, Permission ... permissions) throws Exception {
        for (Permission p : permissions) {
            role.getPermissions().remove(p);
        }
        LookupUtil.getRoleManager().setPermissions(this.overlord, Integer.valueOf(role.getId()), role.getPermissions());
    }

    private void addRoleBundleGroup(Role role, BundleGroup bundleGroup) throws Exception {
        int[] ids = new int[]{bundleGroup.getId()};
        LookupUtil.getRoleManager().addBundleGroupsToRole(this.overlord, role.getId(), ids);
    }

    private void removeRoleBundleGroup(Role role, BundleGroup bundleGroup) throws Exception {
        int[] ids = new int[]{bundleGroup.getId()};
        LookupUtil.getRoleManager().removeBundleGroupsFromRole(this.overlord, role.getId(), ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleType createBundleType(String name) throws Exception {
        String fullName = TEST_PREFIX + "-type-" + name;
        BundleType bt = null;
        this.getTransactionManager().begin();
        try {
            Query q = this.em.createQuery("SELECT bt FROM BundleType bt WHERE bt.name = '" + fullName + "'");
            bt = (BundleType)q.getSingleResult();
        }
        catch (Throwable t) {
        }
        finally {
            this.getTransactionManager().commit();
        }
        if (null == bt) {
            ResourceType rt = this.createResourceTypeForBundleType(name);
            bt = this.bundleManager.createBundleType(this.overlord, fullName, rt.getId());
        }
        assert (bt.getId() > 0);
        assert (bt.getName().endsWith(fullName));
        return bt;
    }

    private Bundle createBundle(String name) throws Exception {
        return this.createBundle(this.overlord, name);
    }

    private Bundle createBundle(Subject subject, String name) throws Exception {
        return this.createBundle(subject, name, null);
    }

    private Bundle createBundle(Subject subject, String name, int bundleGroupId) throws Exception {
        return this.createBundle(subject, name, new int[]{bundleGroupId});
    }

    private Bundle createBundle(Subject subject, String name, int[] bundleGroupIds) throws Exception {
        BundleType bt = this.createBundleType(name);
        return this.createBundle(subject, name, bt, bundleGroupIds);
    }

    private Bundle createBundle(Subject subject, String name, BundleType bt, int[] bundleGroupIds) throws Exception {
        String fullName = TEST_PREFIX + "-bundle-" + name;
        Bundle b = this.bundleManager.createBundle(subject, fullName, fullName + "-desc", bt.getId(), bundleGroupIds);
        assert (b.getId() > 0);
        assert (b.getName().endsWith(fullName));
        return b;
    }

    private BundleVersion createBundleVersion(String name, String version, Bundle bundle) throws Exception {
        return this.createBundleVersion(this.overlord, name, version, bundle);
    }

    private BundleVersion createBundleVersion(Subject subject, String name, String version, Bundle bundle) throws Exception {
        String fullName = TEST_PREFIX + "-bundleversion-" + version + "-" + name;
        String recipe = "deploy -f " + TEST_PREFIX + ".zip -d @@ test.path @@";
        BundleVersion bv = this.bundleManager.createBundleVersion(subject, bundle.getId(), fullName, fullName + "-desc", version, recipe);
        assert (bv.getId() > 0);
        assert (bv.getName().endsWith(fullName));
        return bv;
    }

    private BundleDestination createDestination(Bundle bundle, String name, String deployDir, ResourceGroup group) throws Exception {
        return this.createDestination(this.overlord, bundle, name, deployDir, group);
    }

    private BundleDestination createDestination(Subject subject, Bundle bundle, String name, String deployDir, ResourceGroup group) throws Exception {
        String fullName = TEST_PREFIX + "-bundledestination-" + name;
        BundleDestination bd = this.bundleManager.createBundleDestination(subject, bundle.getId(), fullName, fullName, TEST_DESTBASEDIR_NAME, deployDir, Integer.valueOf(group.getId()));
        assert (bd.getId() > 0);
        assert (bd.getName().endsWith(fullName));
        assert (bd.getDestinationBaseDirectoryName().equals(TEST_DESTBASEDIR_NAME));
        return bd;
    }

    private BundleDeployment createDeployment(String name, BundleVersion bv, BundleDestination dest, Configuration config) throws Exception {
        return this.createDeployment(this.overlord, name, bv, dest, config);
    }

    private BundleDeployment createDeployment(Subject subject, String name, BundleVersion bv, BundleDestination dest, Configuration config) throws Exception {
        String fullName = TEST_PREFIX + "-bundledeployment-" + name;
        BundleDeployment bd = this.bundleManager.createBundleDeployment(subject, bv.getId(), dest.getId(), fullName, config);
        assert (bd.getId() > 0);
        assert (bd.getDescription().endsWith(fullName));
        return bd;
    }

    private ResourceType createResourceTypeForBundleType(String name) throws Exception {
        String fullName = TEST_PREFIX + "-resourcetype-" + name;
        ResourceType rt = new ResourceType(fullName, "BundleManagerBeanTest", ResourceCategory.PLATFORM, null);
        TransactionManager txMgr = this.getTransactionManager();
        txMgr.begin();
        this.em.persist((Object)rt);
        txMgr.commit();
        return rt;
    }

    private ResourceGroup createTestResourceGroup() throws Exception {
        this.getTransactionManager().begin();
        ResourceGroup resourceGroup = null;
        try {
            ResourceType resourceType = new ResourceType(TEST_PREFIX + "-platform-" + System.currentTimeMillis(), "test", ResourceCategory.PLATFORM, null);
            ConfigurationDefinition pcDef = new ConfigurationDefinition(TEST_PREFIX + "-testdef", "bundle test");
            PropertyDefinitionSimple propDef = new PropertyDefinitionSimple(TEST_BUNDLE_DESTBASEDIR_PROP, "", true, PropertySimpleType.STRING);
            propDef.setDisplayName(TEST_BUNDLE_DESTBASEDIR_PROP);
            pcDef.put((PropertyDefinition)propDef);
            this.em.persist((Object)pcDef);
            ResourceTypeBundleConfiguration rtbc = new ResourceTypeBundleConfiguration(new Configuration());
            rtbc.addBundleDestinationBaseDirectory(TEST_DESTBASEDIR_NAME, ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration.name(), TEST_BUNDLE_DESTBASEDIR_PROP, null);
            resourceType.setResourceTypeBundleConfiguration(rtbc);
            resourceType.setPluginConfigurationDefinition(pcDef);
            this.em.persist((Object)resourceType);
            rtbc = resourceType.getResourceTypeBundleConfiguration();
            assert (rtbc != null);
            assert (rtbc.getBundleDestinationBaseDirectories().size() == 1);
            ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory bdbd = (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory)rtbc.getBundleDestinationBaseDirectories().iterator().next();
            assert (bdbd.getName().equals(TEST_DESTBASEDIR_NAME));
            assert (bdbd.getValueContext() == ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration);
            assert (bdbd.getValueName().equals(TEST_BUNDLE_DESTBASEDIR_PROP));
            Agent agent = new Agent(TEST_PREFIX + "-testagent", "testaddress", 1, "", "testtoken");
            this.em.persist((Object)agent);
            this.em.flush();
            Configuration rc = new Configuration();
            rc.put((Property)new PropertySimple(TEST_BUNDLE_DESTBASEDIR_PROP, (Object)TEST_BUNDLE_DESTBASEDIR_PROP_VALUE));
            this.em.persist((Object)rc);
            Resource resource = new Resource("reskey" + System.currentTimeMillis(), TEST_PREFIX + "-resname", resourceType);
            resource.setUuid("" + System.currentTimeMillis());
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            resource.setAgent(agent);
            resource.setResourceConfiguration(rc);
            this.em.persist((Object)resource);
            resourceGroup = new ResourceGroup(TEST_PREFIX + "-group-" + System.currentTimeMillis());
            resourceGroup.addExplicitResource(resource);
            resourceGroup.addImplicitResource(resource);
            resourceGroup.setResourceType(resourceType);
            this.em.persist((Object)resourceGroup);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT PREPARE TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return resourceGroup;
    }

    private String readFile(File file) throws Exception {
        return new String(StreamUtil.slurp((InputStream)new FileInputStream(file)));
    }

    private void writeFile(File file, String content) throws Exception {
        file.getParentFile().mkdirs();
        StreamUtil.copy((InputStream)new ByteArrayInputStream(content.getBytes()), (OutputStream)new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createZip(File destDir, String zipName, String[] entryNames, String[] contents) throws Exception {
        FileOutputStream stream = null;
        ZipOutputStream out = null;
        try {
            destDir.mkdirs();
            File zipFile = new File(destDir, zipName);
            stream = new FileOutputStream(zipFile);
            out = new ZipOutputStream(stream);
            assert (contents.length == entryNames.length);
            for (int i = 0; i < contents.length; ++i) {
                ZipEntry zipAdd = new ZipEntry(entryNames[i]);
                zipAdd.setTime(System.currentTimeMillis());
                out.putNextEntry(zipAdd);
                out.write(contents[i].getBytes());
            }
            File file = zipFile;
            return file;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }
}

