/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.bundle.BundleDistributionInfo;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.bundle.TestBundleServerPluginServiceMBean;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.ServerPluginService;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.content.PackageTypeServerPluginContainer;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

public class TestBundleServerPluginService
extends ServerPluginService
implements TestBundleServerPluginServiceMBean {
    public TestMasterServerPluginContainer master;
    public TestBundleServerPluginContainer bundlePC;
    public MasterServerPluginContainerConfiguration masterConfig;
    private BundleServerPluginFacet bundlePlugin;

    public TestBundleServerPluginService(File tmpdir, BundleServerPluginFacet bundlePlugin) {
        this.masterConfig = new MasterServerPluginContainerConfiguration(tmpdir, tmpdir, tmpdir, null);
        this.bundlePlugin = bundlePlugin;
    }

    public MasterServerPluginContainer createMasterPluginContainer() {
        this.master = new TestMasterServerPluginContainer();
        this.master.initialize(this.masterConfig);
        return this.master;
    }

    class TestBundlePluginManager
    extends BundleServerPluginManager {
        public final Map<String, ServerPluginComponent> components;

        public TestBundlePluginManager(TestBundleServerPluginContainer pc) {
            super((BundleServerPluginContainer)pc);
            this.components = new HashMap<String, ServerPluginComponent>();
        }

        protected ServerPlugin getPlugin(ServerPluginEnvironment env) {
            try {
                Configuration pluginConfig = null;
                Configuration scheduledJobsConfig = null;
                ServerPluginDescriptorType pluginDescriptor = env.getPluginDescriptor();
                ConfigurationDefinition configDef = ServerPluginDescriptorMetadataParser.getPluginConfigurationDefinition((ServerPluginDescriptorType)pluginDescriptor);
                if (configDef != null) {
                    pluginConfig = configDef.getDefaultTemplate().createConfiguration();
                }
                if ((configDef = ServerPluginDescriptorMetadataParser.getScheduledJobsDefinition((ServerPluginDescriptorType)pluginDescriptor)) != null) {
                    scheduledJobsConfig = configDef.getDefaultTemplate().createConfiguration();
                }
                File pluginFile = new File(env.getPluginUrl().toURI());
                ServerPlugin plugin = new ServerPlugin(0, env.getPluginKey().getPluginName(), pluginFile.getName(), pluginDescriptor.getDisplayName(), true, PluginStatusType.INSTALLED, pluginDescriptor.getDescription(), "", MessageDigestGenerator.getDigestString((File)pluginFile), pluginDescriptor.getVersion(), pluginDescriptor.getVersion(), pluginConfig, scheduledJobsConfig, new ServerPluginType(pluginDescriptor).stringify(), System.currentTimeMillis(), System.currentTimeMillis());
                return plugin;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected ServerPluginComponent createServerPluginComponent(ServerPluginEnvironment environment) throws Exception {
            ServerPluginComponent component = super.createServerPluginComponent(environment);
            this.components.put(environment.getPluginKey().getPluginName(), component);
            return component;
        }

        public RecipeParseResults parseRecipe(String bundleTypeName, String recipe) throws Exception {
            return TestBundleServerPluginService.this.bundlePlugin.parseRecipe(recipe);
        }

        public BundleDistributionInfo processBundleDistributionFile(File distributionFile) throws Exception {
            return TestBundleServerPluginService.this.bundlePlugin.processBundleDistributionFile(distributionFile);
        }
    }

    public class TestContentServerPluginContainer
    extends ContentServerPluginContainer {
        public TestContentServerPluginContainer(MasterServerPluginContainer master) {
            super(master);
        }

        protected ServerPluginManager createPluginManager() {
            ContentServerPluginManager pm = new ContentServerPluginManager((ContentServerPluginContainer)this);
            return pm;
        }
    }

    public class TestBundleServerPluginContainer
    extends BundleServerPluginContainer {
        public TestBundleServerPluginContainer(MasterServerPluginContainer master) {
            super(master);
        }

        protected ServerPluginManager createPluginManager() {
            TestBundlePluginManager pm = new TestBundlePluginManager(this);
            return pm;
        }
    }

    class TestMasterServerPluginContainer
    extends MasterServerPluginContainer {
        TestMasterServerPluginContainer() {
        }

        protected List<AbstractTypeServerPluginContainer> createPluginContainers() {
            ArrayList<AbstractTypeServerPluginContainer> pcs = new ArrayList<AbstractTypeServerPluginContainer>(1);
            TestBundleServerPluginService.this.bundlePC = new TestBundleServerPluginContainer(this);
            pcs.add((AbstractTypeServerPluginContainer)TestBundleServerPluginService.this.bundlePC);
            pcs.add((AbstractTypeServerPluginContainer)new TestContentServerPluginContainer(this));
            pcs.add((AbstractTypeServerPluginContainer)new PackageTypeServerPluginContainer((MasterServerPluginContainer)this));
            return pcs;
        }

        protected ClassLoader createRootServerPluginClassLoader() {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }

        protected Map<URL, ? extends ServerPluginDescriptorType> preloadAllPlugins() throws Exception {
            File pluginDir = this.getConfiguration().getPluginDirectory();
            if (pluginDir == null || pluginDir.listFiles() == null || pluginDir.listFiles().length == 0) {
                return new HashMap();
            }
            return super.preloadAllPlugins();
        }

        protected List<PluginKey> getDisabledPluginKeys() {
            return new ArrayList<PluginKey>();
        }
    }
}

