/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.HashSet;
import java.util.UUID;
import javax.ejb.EJB;
import javax.persistence.Query;
import javax.transaction.Transaction;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.criteria.StorageNodeCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.testng.annotations.Test;

@Test
public class StorageNodeManagerBeanTest
extends AbstractEJB3Test {
    @EJB
    private StorageNodeManagerLocal nodeManager;
    @EJB
    private ResourceTypeManagerLocal typeManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    private static final String TEST_PREFIX = "test-";

    @Test(groups={"integration.ejb3"})
    public void testStorageNodeCriteriaFinder() throws Exception {
        int storageNodeCount = 42;
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                HashSet<String> nodeAddresses = new HashSet<String>(42);
                String prefix = "storage_node";
                StorageNode lastOne = null;
                StorageNode firstOne = null;
                for (int i = 0; i < 42; ++i) {
                    String address = "storage_node" + String.format(" %03d", i + 1) + ".domain.com";
                    StorageNode node = new StorageNode();
                    node.setAddress(address);
                    node.setOperationMode(StorageNode.OperationMode.NORMAL);
                    node.setCqlPort(9142 + i);
                    if (i == 0) {
                        firstOne = node;
                    } else if (i == 41) {
                        lastOne = node;
                    }
                    StorageNodeManagerBeanTest.this.em.persist((Object)node);
                    nodeAddresses.add(address);
                    StorageNodeManagerBeanTest.this.em.flush();
                }
                StorageNodeManagerBeanTest.this.em.flush();
                StorageNodeManagerBeanTest.this.assertTrue("The number of created storage nodes should be 42. Was: " + nodeAddresses.size(), 42 == nodeAddresses.size());
                StorageNodeCriteria criteria = new StorageNodeCriteria();
                criteria.addFilterAddress("storage_node");
                criteria.addSortAddress(PageOrdering.DESC);
                PageList list = StorageNodeManagerBeanTest.this.nodeManager.findStorageNodesByCriteria(StorageNodeManagerBeanTest.this.subjectManager.getOverlord(), criteria);
                StorageNodeManagerBeanTest.this.assertTrue("The number of found storage nodes should be 42. Was: " + list.size(), 42 == list.size());
                StorageNodeManagerBeanTest.this.assertTrue("The first storage node [" + firstOne + "] should be same as the last one in the list [ " + list.get(list.size() - 1) + "]", firstOne.equals(list.get(list.size() - 1)));
                StorageNodeManagerBeanTest.this.assertTrue("The last storage node [" + lastOne + "] should be same as the first one in the list [ " + list.get(0) + "]", lastOne.equals(list.get(0)));
                String prevAddress = null;
                for (StorageNode s : list) {
                    assert (null == prevAddress || s.getAddress().compareTo(prevAddress) < 0) : "Results should besorted by address DESC, something is out of order";
                    prevAddress = s.getAddress();
                    nodeAddresses.remove(s.getAddress());
                }
                StorageNodeManagerBeanTest.this.assertTrue("Expected resourceNames to be empty. Still " + nodeAddresses.size() + " name(s).", nodeAddresses.size() == 0);
            }
        });
    }

    private void cleanDatabase() throws Exception {
        Transaction runningTransaction = this.getTransactionManager().suspend();
        this.getTransactionManager().begin();
        Query query = this.getEntityManager().createQuery("DELETE FROM StorageNode s WHERE s.address LIKE (:prefix || '%')").setParameter("prefix", (Object)TEST_PREFIX);
        query.executeUpdate();
        query = this.getEntityManager().createQuery("DELETE FROM Availability");
        query.executeUpdate();
        query = this.getEntityManager().createQuery("DELETE FROM Resource r WHERE r.resourceKey LIKE (:prefix || '%')").setParameter("prefix", (Object)TEST_PREFIX);
        query.executeUpdate();
        query = this.getEntityManager().createQuery("DELETE FROM ResourceType rt WHERE rt.name = :name").setParameter("name", (Object)"Cassandra Daemon");
        query.executeUpdate();
        this.getTransactionManager().commit();
        this.getTransactionManager().resume(runningTransaction);
    }

    private ResourceType createResourceType() throws Exception {
        ResourceType resourceType = new ResourceType("RHQ Storage Node", "RHQStorage", ResourceCategory.SERVER, null);
        ConfigurationDefinition pluginConfigurationDefinition = new ConfigurationDefinition("config", null);
        pluginConfigurationDefinition.put((PropertyDefinition)new PropertyDefinitionSimple("host", null, true, PropertySimpleType.STRING));
        resourceType.setPluginConfigurationDefinition(pluginConfigurationDefinition);
        this.getEntityManager().persist((Object)resourceType);
        return resourceType;
    }

    private Resource createResource(ResourceType resourceType, String host) throws Exception {
        Resource resource = new Resource("test-CassandraDaemon", "test-CassandraDaemon", resourceType);
        resource.setUuid(UUID.randomUUID().toString());
        resource.getPluginConfiguration().setSimpleValue("host", host);
        this.getEntityManager().persist((Object)resource);
        this.getEntityManager().flush();
        return resource;
    }
}

