/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.HashSet;
import java.util.TreeSet;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.criteria.ServerCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.cloud.TopologyManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test
public class TopologyManagerBeanTest
extends AbstractEJB3Test {
    private TopologyManagerLocal topologyManager;
    private Subject overlord;

    @Override
    protected void beforeMethod() throws Exception {
        this.topologyManager = LookupUtil.getTopologyManager();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
    }

    @Test(groups={"integration.ejb3"})
    public void testParsingCriteriaQueryResults1() throws Exception {
        int serverCount = 208;
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                HashSet<String> serverNames = new HashSet<String>(208);
                serverNames.add("rhq-test-server");
                String prefix = "server";
                for (int i = 0; i < 207; ++i) {
                    String name = "server" + String.format(" %03d", i + 1);
                    Server server = new Server();
                    server.setName(name);
                    server.setOperationMode(Server.OperationMode.NORMAL);
                    server.setAddress("address" + i);
                    server.setPort(7080 + i);
                    server.setSecurePort(7443 + i);
                    TopologyManagerBeanTest.this.em.persist((Object)server);
                    serverNames.add(name);
                    TopologyManagerBeanTest.this.em.flush();
                }
                TopologyManagerBeanTest.this.em.flush();
                TopologyManagerBeanTest.this.assertTrue("The number of created servers should be 208. Was: " + serverNames.size(), 208 == serverNames.size());
                int pageSize = 42;
                ServerCriteria criteria = new ServerCriteria();
                criteria.addFilterName("server");
                criteria.addSortName(PageOrdering.DESC);
                criteria.setPaging(0, 42);
                CriteriaQueryExecutor<Server, ServerCriteria> queryExecutor = new CriteriaQueryExecutor<Server, ServerCriteria>(){

                    public PageList<Server> execute(ServerCriteria criteria) {
                        return TopologyManagerBeanTest.this.topologyManager.findServersByCriteria(TopologyManagerBeanTest.this.overlord, criteria);
                    }
                };
                CriteriaQuery servers = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
                String prevName = null;
                int actualCount = 0;
                for (Server s : servers) {
                    assert (null == prevName || s.getName().compareTo(prevName) < 0 || s.getName().equals("rhq-test-server")) : "Results should be sorted by name DESC, something is out of order";
                    prevName = s.getName();
                    ++actualCount;
                    serverNames.remove(s.getName());
                }
                TopologyManagerBeanTest.this.assertTrue("Expected resourceNames to be empty. Still " + serverNames.size() + " name(s).", serverNames.size() == 0);
                TopologyManagerBeanTest.this.assertTrue("Expected 208 to be parsed, but there were parsed " + actualCount + " servers", actualCount == 208);
            }
        });
    }

    @Test(groups={"integration.ejb3"})
    public void testParsingCriteriaQueryResults2() throws Exception {
        int serverCount = 307;
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                HashSet<String> serverNames = new HashSet<String>(307);
                serverNames.add("rhq-test-server");
                String prefix = "server";
                int shouldBeFoundCount = 1;
                for (int i = 0; i < 306; ++i) {
                    String name = "server" + String.format(" %03d", i + 1);
                    Server server = new Server();
                    server.setName(name);
                    switch (i % 5) {
                        case 0: 
                        case 1: {
                            server.setOperationMode(Server.OperationMode.NORMAL);
                            break;
                        }
                        case 2: {
                            server.setOperationMode(Server.OperationMode.MAINTENANCE);
                            ++shouldBeFoundCount;
                            serverNames.add(name);
                            break;
                        }
                        case 3: {
                            server.setOperationMode(Server.OperationMode.DOWN);
                            ++shouldBeFoundCount;
                            serverNames.add(name);
                            break;
                        }
                        case 4: {
                            server.setOperationMode(Server.OperationMode.INSTALLED);
                            ++shouldBeFoundCount;
                            serverNames.add(name);
                        }
                    }
                    server.setAddress("address" + i);
                    server.setPort(7080 + i);
                    server.setSecurePort(7443 + i);
                    TopologyManagerBeanTest.this.em.persist((Object)server);
                    TopologyManagerBeanTest.this.em.flush();
                }
                TopologyManagerBeanTest.this.em.flush();
                int pageSize = 24;
                ServerCriteria criteria = new ServerCriteria();
                criteria.addFilterName("server");
                criteria.addFilterOperationMode(new Server.OperationMode[]{Server.OperationMode.MAINTENANCE, Server.OperationMode.DOWN, Server.OperationMode.INSTALLED});
                criteria.addSortName(PageOrdering.DESC);
                criteria.setPaging(0, 24);
                CriteriaQueryExecutor<Server, ServerCriteria> queryExecutor = new CriteriaQueryExecutor<Server, ServerCriteria>(){

                    public PageList<Server> execute(ServerCriteria criteria) {
                        return TopologyManagerBeanTest.this.topologyManager.findServersByCriteria(TopologyManagerBeanTest.this.overlord, criteria);
                    }
                };
                CriteriaQuery servers = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
                String prevName = null;
                int actualCount = 0;
                for (Server s : servers) {
                    assert (null == prevName || s.getName().compareTo(prevName) < 0 || s.getName().equals("rhq-test-server")) : "Results should be sorted by name DESC, something is out of order";
                    prevName = s.getName();
                    ++actualCount;
                    if (!serverNames.contains(prevName)) {
                        TopologyManagerBeanTest.this.fail("Following server entity shouldn't be here: " + s);
                    }
                    serverNames.remove(s.getName());
                }
                TopologyManagerBeanTest.this.assertTrue("Expected resourceNames to be empty. Still " + serverNames.size() + " name(s).", serverNames.size() == 0);
                TopologyManagerBeanTest.this.assertTrue("Expected " + shouldBeFoundCount + " to be parsed, but there were parsed " + actualCount + " servers", actualCount == shouldBeFoundCount);
            }
        });
    }

    @Test(groups={"integration.ejb3"})
    public void testParsingCriteriaQueryResultsStrict() throws Exception {
        int serverCount = 10;
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                HashSet<String> serverNames = new HashSet<String>(10);
                String namePrefix = "server";
                String addressPrefix = "address";
                int shouldBeFoundCount = 1;
                serverNames.add("server 007");
                for (int i = 0; i < 10; ++i) {
                    String name = "server" + String.format(" %03d", i + 1);
                    Server server = new Server();
                    server.setName(name);
                    server.setOperationMode(Server.OperationMode.NORMAL);
                    server.setAddress("address" + i);
                    server.setPort(7080);
                    server.setSecurePort(7443);
                    TopologyManagerBeanTest.this.em.persist((Object)server);
                    TopologyManagerBeanTest.this.em.flush();
                }
                TopologyManagerBeanTest.this.em.flush();
                int pageSize = 2;
                boolean startPage = false;
                ServerCriteria criteria = new ServerCriteria();
                criteria.addFilterName("server 007");
                criteria.setStrict(true);
                criteria.setPaging(0, 2);
                CriteriaQueryExecutor<Server, ServerCriteria> queryExecutor = new CriteriaQueryExecutor<Server, ServerCriteria>(){

                    public PageList<Server> execute(ServerCriteria criteria) {
                        return TopologyManagerBeanTest.this.topologyManager.findServersByCriteria(TopologyManagerBeanTest.this.overlord, criteria);
                    }
                };
                CriteriaQuery servers = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
                String prevName = null;
                int actualCount = 0;
                for (Server s : servers) {
                    assert (null == prevName || s.getName().compareTo(prevName) < 0) : "Results should be sorted by name DESC, something is out of order";
                    prevName = s.getName();
                    ++actualCount;
                    serverNames.remove(s.getName());
                }
                TopologyManagerBeanTest.this.assertTrue("Expected resourceNames to be empty. Still " + serverNames.size() + " name(s).", serverNames.size() == 0);
                TopologyManagerBeanTest.this.assertTrue("Expected " + shouldBeFoundCount + " to be parsed, but there were parsed " + actualCount + " servers", actualCount == shouldBeFoundCount);
            }
        });
    }

    @Test(groups={"integration.ejb3"})
    public void testParsingAllCriteriaQueryResults1() throws Exception {
        int startPage = 0;
        int pageSize = 3;
        int serverCount = 605;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults2() throws Exception {
        int startPage = 1;
        int pageSize = 3;
        int serverCount = 605;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults3() throws Exception {
        int startPage = 2;
        int pageSize = 3;
        int serverCount = 609;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults4() throws Exception {
        int startPage = 3;
        int pageSize = 7;
        int serverCount = 800;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults5() throws Exception {
        int startPage = 4;
        int pageSize = 2;
        int serverCount = 444;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults6() throws Exception {
        int startPage = 5;
        int pageSize = 3;
        int serverCount = 605;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults7() throws Exception {
        int startPage = 1;
        int pageSize = 5;
        int serverCount = 934;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults8() throws Exception {
        int startPage = 4;
        int pageSize = 7;
        int serverCount = 1234;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults9() throws Exception {
        int startPage = 2;
        int pageSize = 1;
        int serverCount = 109;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"}, enabled=true)
    public void testParsingAllCriteriaQueryResults10() throws Exception {
        int startPage = 0;
        int pageSize = 11;
        int serverCount = 999;
        this.testParsingHelperStartingPageEqualTo(startPage, pageSize, serverCount);
    }

    @Test(groups={"integration.ejb3"})
    public void testFindNonExistentServer() throws Exception {
        int serverCount = 5;
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                String namePrefix = "server";
                String addressPrefix = "address";
                for (int i = 0; i < 5; ++i) {
                    String name = "server" + String.format(" %03d", i + 1);
                    Server server = new Server();
                    server.setName(name);
                    server.setOperationMode(Server.OperationMode.NORMAL);
                    server.setAddress("address" + i);
                    server.setPort(7080);
                    server.setSecurePort(7443);
                    TopologyManagerBeanTest.this.em.persist((Object)server);
                    TopologyManagerBeanTest.this.em.flush();
                }
                TopologyManagerBeanTest.this.em.flush();
                ServerCriteria criteria = new ServerCriteria();
                criteria.addFilterName("very unlikely name of a server");
                criteria.setStrict(true);
                PageList servers = TopologyManagerBeanTest.this.topologyManager.findServersByCriteria(TopologyManagerBeanTest.this.overlord, criteria);
                TopologyManagerBeanTest.this.assertNotNull("The result of topologyManager.findServersByCriteria() is null", servers);
                TopologyManagerBeanTest.this.assertTrue("Some servers have been found, even if they shouldn't", servers.isEmpty());
                criteria = new ServerCriteria();
                criteria.addFilterSecurePort(Integer.valueOf(1000));
                servers = TopologyManagerBeanTest.this.topologyManager.findServersByCriteria(TopologyManagerBeanTest.this.overlord, criteria);
                TopologyManagerBeanTest.this.assertNotNull("The result of topologyManager.findServersByCriteria() is null", servers);
                TopologyManagerBeanTest.this.assertTrue("Some servers have been found, even if they shouldn't", servers.isEmpty());
                criteria = new ServerCriteria();
                criteria.addFilterAffinityGroupId(Integer.valueOf(0x3FFFFFFF));
                servers = TopologyManagerBeanTest.this.topologyManager.findServersByCriteria(TopologyManagerBeanTest.this.overlord, criteria);
                TopologyManagerBeanTest.this.assertNotNull("The result of topologyManager.findServersByCriteria() is null", servers);
                TopologyManagerBeanTest.this.assertTrue("Some servers have been found, even if they shouldn't", servers.isEmpty());
            }
        });
    }

    private void testParsingHelperStartingPageEqualTo(final int startPage, final int pageSize, final int serverCount) throws Exception {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                TreeSet<String> serverNames = new TreeSet<String>();
                String namePrefix = "server";
                String addressPrefix = "address";
                int shouldBeFoundCount = 0;
                int shouldBeSkipped = pageSize * startPage;
                for (int i = 0; i < serverCount; ++i) {
                    String name = "server" + String.format(" %03d", i + 1);
                    Server server = new Server();
                    server.setName(name);
                    switch (i % 2) {
                        case 0: {
                            server.setOperationMode(Server.OperationMode.NORMAL);
                            break;
                        }
                        case 1: {
                            server.setOperationMode(Server.OperationMode.MAINTENANCE);
                            if (i % 20 != 9) break;
                            ++shouldBeFoundCount;
                            serverNames.add(name);
                        }
                    }
                    server.setAddress("address" + i);
                    server.setPort(7080 + i % 20);
                    server.setSecurePort(7443 + i % 20);
                    TopologyManagerBeanTest.this.em.persist((Object)server);
                    TopologyManagerBeanTest.this.em.flush();
                }
                TopologyManagerBeanTest.this.em.flush();
                if (shouldBeSkipped > 0) {
                    String[] serverNamesArray = serverNames.toArray(new String[serverNames.size()]);
                    for (int i = 0; i < shouldBeSkipped; ++i) {
                        serverNames.remove(serverNamesArray[serverNamesArray.length - i - 1]);
                    }
                    shouldBeFoundCount -= shouldBeSkipped;
                }
                ServerCriteria criteria = new ServerCriteria();
                criteria.addFilterOperationMode(new Server.OperationMode[]{Server.OperationMode.MAINTENANCE});
                criteria.addFilterPort(Integer.valueOf(7089));
                criteria.addFilterSecurePort(Integer.valueOf(7452));
                criteria.addFilterName("server");
                criteria.addFilterAddress("address");
                criteria.addSortName(PageOrdering.DESC);
                criteria.setPaging(startPage, pageSize);
                CriteriaQueryExecutor<Server, ServerCriteria> queryExecutor = new CriteriaQueryExecutor<Server, ServerCriteria>(){

                    public PageList<Server> execute(ServerCriteria criteria) {
                        return TopologyManagerBeanTest.this.topologyManager.findServersByCriteria(TopologyManagerBeanTest.this.overlord, criteria);
                    }
                };
                CriteriaQuery servers = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
                String prevName = null;
                int actualCount = 0;
                for (Server s : servers) {
                    assert (null == prevName || s.getName().compareTo(prevName) < 0) : "Results should be sorted by name DESC, something is out of order";
                    prevName = s.getName();
                    ++actualCount;
                    serverNames.remove(s.getName());
                }
                TopologyManagerBeanTest.this.assertTrue("Expected resourceNames to be empty. Still " + serverNames.size() + " name(s).", serverNames.size() == 0);
                TopologyManagerBeanTest.this.assertTrue("Expected " + shouldBeFoundCount + " to be parsed, but there were parsed " + actualCount + " servers", actualCount == shouldBeFoundCount);
            }
        });
    }
}

