/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.configuration.ConfigurationServerServiceImpl;
import org.rhq.enterprise.server.test.LargeGroupTestBase;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

@Test
public class LargeGroupResourceConfigurationTest
extends LargeGroupTestBase {
    private LargeGroupTestBase.LargeGroupEnvironment env;
    private CountDownLatch latch;

    @Override
    protected void setupMockAgentServices(TestServerCommunicationsService agentServiceContainer) {
        TestServices testServices = new TestServices();
        agentServiceContainer.configurationService = testServices;
    }

    @Override
    protected void beforeMethod() throws Exception {
        super.beforeMethod();
        this.env = this.createLargeGroupWithNormalUserRoleAccess(1010, Permission.CONFIGURE_READ, Permission.CONFIGURE_WRITE);
        SessionTestHelper.simulateLogin(this.env.normalSubject);
    }

    @Override
    protected void afterMethod() throws Exception {
        this.tearDownLargeGroupWithNormalUserRoleAccess(this.env);
        SessionTestHelper.simulateLogout(this.env.normalSubject);
        super.beforeMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupResourceConfigurationUpdate() throws Exception {
        int memberCount = this.env.platformResource.getChildResources().size();
        System.out.println("Getting resource config for group [#members=" + memberCount + "]");
        long start = System.currentTimeMillis();
        Map existingMap = this.configurationManager.getResourceConfigurationsForCompatibleGroup(this.env.normalSubject, this.env.compatibleGroup.getId());
        long duration = System.currentTimeMillis() - start;
        System.out.println("Took [" + duration + "]ms to get resource config for group [#members=" + memberCount + "]");
        assert (existingMap.size() == memberCount) : "did not get back the amount of configs [" + existingMap.size() + "] we expected [" + memberCount + "]";
        for (Map.Entry entry : existingMap.entrySet()) {
            Integer resourceId = (Integer)entry.getKey();
            Configuration config = (Configuration)entry.getValue();
            assert ("LargeGroupTest rc property one".equals(config.getSimpleValue("LargeGroupTest rc prop1", null))) : "bad resource config for " + resourceId + "=" + config.toString(true);
            assert (resourceId.toString().equals(config.getSimpleValue("LargeGroupTest rc prop2", null))) : "bad resource config for " + resourceId + "=" + config.toString(true);
            config.getSimple("LargeGroupTest rc prop2").setStringValue("UPDATE" + resourceId);
        }
        System.out.println("Scheduling a group resource config update.");
        this.latch = new CountDownLatch(memberCount);
        int groupUpdateId = this.configurationManager.scheduleGroupResourceConfigurationUpdate(this.env.normalSubject, this.env.compatibleGroup.getId(), existingMap);
        System.out.print("Waiting for mock agents");
        assert (this.latch.await(5L, TimeUnit.MINUTES)) : "agents should not have taken this long";
        System.out.println(" Mock agents are done.");
        System.out.print("Waiting for group resource config update to be finished...");
        ConfigurationUpdateStatus status = this.getGroupResourceConfigurationStatus(this.env.compatibleGroup.getId());
        boolean inprogress = status == ConfigurationUpdateStatus.INPROGRESS;
        for (int i = 0; i < 20 && inprogress; ++i) {
            Thread.sleep(3000L);
            status = this.getGroupResourceConfigurationStatus(this.env.compatibleGroup.getId());
            inprogress = status == ConfigurationUpdateStatus.INPROGRESS;
        }
        assert (!inprogress) : "group resource configuration update is still inprogress - this is taking too long";
        System.out.println(" Done. Status=" + (status != null ? status.name() : "????null????"));
        assert (status == ConfigurationUpdateStatus.SUCCESS) : "should have finished in the success status";
        System.out.println("Getting updated resource config for group [#members=" + memberCount + "]");
        start = System.currentTimeMillis();
        existingMap = this.configurationManager.getResourceConfigurationsForCompatibleGroup(this.env.normalSubject, this.env.compatibleGroup.getId());
        duration = System.currentTimeMillis() - start;
        System.out.println("Took [" + duration + "]ms to get updated resource config for group [#members=" + memberCount + "]");
        assert (existingMap.size() == memberCount) : "did not get back the amount of configs [" + existingMap.size() + "] we expected [" + memberCount + "]";
        for (Map.Entry entry : existingMap.entrySet()) {
            Integer resourceId = (Integer)entry.getKey();
            Configuration config = (Configuration)entry.getValue();
            assert ("LargeGroupTest rc property one".equals(config.getSimpleValue("LargeGroupTest rc prop1", null))) : "bad resource config for " + resourceId + "=" + config.toString(true);
            assert (("UPDATE" + resourceId.toString()).equals(config.getSimpleValue("LargeGroupTest rc prop2", null))) : "bad resource config for " + resourceId + "=" + config.toString(true);
        }
        System.out.println("Attempting unauthz access");
        SessionTestHelper.simulateLogin(this.env.unauthzSubject);
        start = System.currentTimeMillis();
        try {
            this.configurationManager.getResourceConfigurationsForCompatibleGroup(this.env.unauthzSubject, this.env.compatibleGroup.getId());
            assert (false) : "should have failed - unauthz user not allowed to get resource configuration";
        }
        catch (PermissionException expected) {
        }
        finally {
            duration = System.currentTimeMillis() - start;
            SessionTestHelper.simulateLogout(this.env.unauthzSubject);
        }
        System.out.println("Took [" + duration + "]ms to attempt unauthz access");
    }

    private class TestServices
    implements ConfigurationAgentService {
        private HashMap<Integer, Configuration> configs = new HashMap();

        private TestServices() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateResourceConfiguration(ConfigurationUpdateRequest request) {
            try {
                HashMap<Integer, Configuration> hashMap = this.configs;
                synchronized (hashMap) {
                    this.configs.put(request.getResourceId(), request.getConfiguration());
                }
                ConfigurationUpdateResponse response = new ConfigurationUpdateResponse(request.getConfigurationUpdateId(), request.getConfiguration(), ConfigurationUpdateStatus.SUCCESS, null);
                ConfigurationServerServiceImpl server = new ConfigurationServerServiceImpl();
                server.completeConfigurationUpdate(response);
            }
            finally {
                LargeGroupResourceConfigurationTest.this.latch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Configuration loadResourceConfiguration(int resourceId) throws PluginContainerException {
            HashMap<Integer, Configuration> hashMap = this.configs;
            synchronized (hashMap) {
                Integer id = resourceId;
                if (this.configs.containsKey(id)) {
                    return this.configs.get(id);
                }
                Configuration config = new Configuration();
                config.put((Property)new PropertySimple("LargeGroupTest rc prop1", (Object)"LargeGroupTest rc property one"));
                config.put((Property)new PropertySimple("LargeGroupTest rc prop2", (Object)resourceId));
                this.configs.put(id, config);
                return config;
            }
        }

        public ConfigurationUpdateResponse executeUpdateResourceConfigurationImmediately(ConfigurationUpdateRequest request) throws PluginContainerException {
            return null;
        }

        public Configuration merge(Configuration configuration, int resourceId, boolean fromStructured) throws PluginContainerException {
            return null;
        }

        public Configuration validate(Configuration configuration, int resourceId, boolean isStructured) throws PluginContainerException {
            return null;
        }
    }
}

