/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.metadata.test;

import java.util.List;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.enterprise.server.content.metadata.test.TestBase;
import org.testng.annotations.Test;

@Test
public class ContentSourcePluginHandlingTest
extends TestBase {
    @Override
    protected void afterMethod() throws Exception {
        this.getTransactionManager().begin();
        List list = this.em.createQuery("select c from ContentSourceType c where c.name like 'testCSPHT%'").getResultList();
        for (ContentSourceType doomed : list) {
            this.em.remove((Object)doomed);
        }
        this.getTransactionManager().commit();
        super.afterMethod();
    }

    public void testUpdateContentSourceTypes() throws Throwable {
        try {
            this.registerPlugin("./test/metadata/content-source-update-v1.xml");
            ContentSourceType type1 = this.getContentSourceType("testCSPHT1");
            ContentSourceType type2 = this.getContentSourceType("testCSPHT2");
            ContentSourceType type3 = this.getContentSourceType("testCSPHT3");
            ContentSourceType type4 = this.getContentSourceType("testCSPHT4");
            assert (type1 != null);
            assert (type2 != null);
            assert (type3 == null);
            assert (type4 != null);
            assert (type1.getId() > 0);
            assert (type1.getName().equals("testCSPHT1"));
            assert (type1.getDisplayName().equals("displayName1"));
            assert (type1.getDescription().equals("description1"));
            assert (type1.getContentSourceApiClass().equals("org.abc.ApiClass1"));
            ConfigurationDefinition def = type1.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 1);
            assert (def.getPropertyDefinitionSimple("prop1").getType() == PropertySimpleType.DIRECTORY);
            assert (def.getPropertyDefinitionSimple("prop1").isRequired());
            assert (type2.getId() > 0);
            assert (type2.getName().equals("testCSPHT2"));
            assert (type2.getDisplayName().equals("displayName2"));
            assert (type2.getDescription().equals("description2"));
            assert (type2.getContentSourceApiClass().equals("org.abc.ApiClass2"));
            def = type2.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 1);
            assert (def.getPropertyDefinitionSimple("prop2").getType() == PropertySimpleType.INTEGER);
            assert (!def.getPropertyDefinitionSimple("prop2").isRequired());
            assert (type4.getId() > 0);
            assert (type4.getName().equals("testCSPHT4"));
            assert (type4.getDisplayName().equals("displayName4"));
            assert (type4.getDescription().equals("description4"));
            assert (type4.getContentSourceApiClass().equals("org.abc.ApiClass4"));
            def = type4.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 1);
            assert (def.getPropertyDefinitionSimple("prop4").getType() == PropertySimpleType.FILE);
            assert (!def.getPropertyDefinitionSimple("prop4").isRequired());
            this.registerPlugin("./test/metadata/content-source-update-v2.xml");
            this.getEntityManager().clear();
            type1 = this.getContentSourceType("testCSPHT1");
            type2 = this.getContentSourceType("testCSPHT2");
            type3 = this.getContentSourceType("testCSPHT3");
            type4 = this.getContentSourceType("testCSPHT4");
            assert (type1 != null);
            assert (type2 == null);
            assert (type3 != null);
            assert (type4 != null);
            assert (type1.getId() > 0);
            assert (type1.getName().equals("testCSPHT1"));
            assert (type1.getDisplayName().equals("displayName1"));
            assert (type1.getDescription().equals("description1"));
            assert (type1.getContentSourceApiClass().equals("org.abc.ApiClass1"));
            def = type1.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 1);
            assert (def.getPropertyDefinitionSimple("prop1").getType() == PropertySimpleType.DIRECTORY);
            assert (def.getPropertyDefinitionSimple("prop1").isRequired());
            assert (type3.getId() > 0);
            assert (type3.getName().equals("testCSPHT3"));
            assert (type3.getDisplayName().equals("displayName3"));
            assert (type3.getDescription().equals("description3"));
            assert (type3.getContentSourceApiClass().equals("org.abc.ApiClass3"));
            def = type3.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 1);
            assert (def.getPropertyDefinitionSimple("prop3").getType() == PropertySimpleType.STRING);
            assert (def.getPropertyDefinitionSimple("prop3").isRequired());
            assert (type4.getId() > 0);
            assert (type4.getName().equals("testCSPHT4"));
            assert (type4.getDisplayName().equals("displayName4changed"));
            assert (type4.getDescription().equals("description4changed"));
            assert (type4.getContentSourceApiClass().equals("org.abc.ApiClass4changed"));
            def = type4.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 2);
            assert (def.getPropertyDefinitionSimple("prop4_1").getType() == PropertySimpleType.INTEGER);
            assert (!def.getPropertyDefinitionSimple("prop4_1").isRequired());
            assert (def.getPropertyDefinitionSimple("prop4_2").getType() == PropertySimpleType.BOOLEAN);
            assert (!def.getPropertyDefinitionSimple("prop4_2").isRequired());
            this.registerPlugin("./test/metadata/content-source-update-v1.xml");
            type1 = this.getContentSourceType("testCSPHT1");
            type2 = this.getContentSourceType("testCSPHT2");
            type3 = this.getContentSourceType("testCSPHT3");
            type4 = this.getContentSourceType("testCSPHT4");
            assert (type1 != null);
            assert (type2 != null);
            assert (type3 == null);
            assert (type4 != null);
            assert (type1.getId() > 0);
            assert (type1.getName().equals("testCSPHT1"));
            assert (type1.getDisplayName().equals("displayName1"));
            assert (type1.getDescription().equals("description1"));
            assert (type1.getContentSourceApiClass().equals("org.abc.ApiClass1"));
            def = type1.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 1);
            assert (def.getPropertyDefinitionSimple("prop1").getType() == PropertySimpleType.DIRECTORY);
            assert (def.getPropertyDefinitionSimple("prop1").isRequired());
            assert (type2.getId() > 0);
            assert (type2.getName().equals("testCSPHT2"));
            assert (type2.getDisplayName().equals("displayName2"));
            assert (type2.getDescription().equals("description2"));
            assert (type2.getContentSourceApiClass().equals("org.abc.ApiClass2"));
            def = type2.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 1);
            assert (def.getPropertyDefinitionSimple("prop2").getType() == PropertySimpleType.INTEGER);
            assert (!def.getPropertyDefinitionSimple("prop2").isRequired());
            assert (type4.getId() > 0);
            assert (type4.getName().equals("testCSPHT4"));
            assert (type4.getDisplayName().equals("displayName4"));
            assert (type4.getDescription().equals("description4"));
            assert (type4.getContentSourceApiClass().equals("org.abc.ApiClass4"));
            def = type4.getContentSourceConfigurationDefinition();
            assert (def.getPropertyDefinitions().size() == 1);
            assert (def.getPropertyDefinitionSimple("prop4").getType() == PropertySimpleType.FILE);
            assert (!def.getPropertyDefinitionSimple("prop4").isRequired());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }
}

