/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.AdvisoryCVE;
import org.rhq.core.domain.content.AdvisoryPackage;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.CVE;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.content.AdvisoryManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class AdvisoryManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLED = true;
    private AdvisoryManagerLocal advManager;
    private Subject overlord;
    private PackageType packageType1;

    @Override
    protected void beforeMethod() throws Exception {
        TransactionManager tx = this.getTransactionManager();
        tx.begin();
        this.advManager = LookupUtil.getAdvisoryManagerLocal();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
    }

    @Override
    protected void afterMethod() throws Exception {
        TransactionManager tx = this.getTransactionManager();
        if (tx != null) {
            tx.rollback();
        }
    }

    @Test(enabled=true)
    public void createDeleteAdvisory() throws Exception {
        String advisory = "RHBA-2009:1202-3";
        String advisoryType = "BugFix Advisory";
        String synopsis = "synopsis to test advisory creation";
        int id1 = this.advManager.createAdvisory(this.overlord, advisory, advisoryType, synopsis).getId();
        Advisory advobject = this.advManager.getAdvisoryByName(advisory);
        assert (advobject != null);
        assert (id1 == advobject.getId());
        this.advManager.deleteAdvisoryByAdvId(this.overlord, advobject.getId());
        advobject = this.advManager.getAdvisoryByName(advobject.getAdvisory());
        assert (advobject == null);
    }

    @Test(enabled=true)
    public void getCVEFromAdvisoryTest() throws Exception {
        EntityManager entityManager = this.getEntityManager();
        String advisory = "RHBA-2009:1202-4";
        String advisoryType = "BugFix Advisory";
        String synopsis = "synopsis to test advisory creation";
        Advisory advobject = new Advisory(advisory, advisoryType, synopsis);
        entityManager.persist((Object)advobject);
        int id1 = advobject.getId();
        entityManager.flush();
        CVE cve = this.advManager.createCVE(this.overlord, "CAN-2009:1203");
        AdvisoryCVE advisory_cve = this.advManager.createAdvisoryCVE(this.overlord, advobject, cve);
        PageList cvelist = this.advManager.getAdvisoryCVEByAdvId(this.overlord, id1, PageControl.getUnlimitedInstance());
        assert (cvelist != null);
        assert (cvelist.size() != 0);
        this.advManager.deleteAdvisoryCVE(this.overlord, id1);
        this.advManager.deleteCVE(this.overlord, cve.getId());
        this.advManager.deleteAdvisoryByAdvId(this.overlord, advobject.getId());
        advobject = this.advManager.getAdvisoryByName(advobject.getAdvisory());
        assert (advobject == null);
    }

    @Test(enabled=true)
    public void getPackagesForAdvisoryTest() throws Exception {
        EntityManager em = this.getEntityManager();
        String advisory = "RHBA-2009:1202-4";
        String advisoryType = "BugFix Advisory";
        String synopsis = "synopsis to test advisory creation";
        Advisory advobject = this.advManager.createAdvisory(this.overlord, advisory, advisoryType, synopsis);
        int id1 = advobject.getId();
        ResourceType resourceType1 = new ResourceType("platform-" + System.currentTimeMillis(), "TestPlugin", ResourceCategory.PLATFORM, null);
        em.persist((Object)resourceType1);
        em.flush();
        Architecture architecture1 = (Architecture)em.find(Architecture.class, (Object)1);
        this.packageType1 = new PackageType();
        this.packageType1.setName("package1-" + System.currentTimeMillis());
        this.packageType1.setDescription("");
        this.packageType1.setCategory(PackageCategory.DEPLOYABLE);
        this.packageType1.setDisplayName("TestResourcePackage");
        this.packageType1.setCreationData(true);
        this.packageType1.setResourceType(resourceType1);
        em.persist((Object)this.packageType1);
        em.flush();
        Package package1 = new Package("Package1", this.packageType1);
        package1.addVersion(new PackageVersion(package1, "1.0.0", architecture1));
        package1.addVersion(new PackageVersion(package1, "2.0.0", architecture1));
        em.persist((Object)package1);
        em.flush();
        AdvisoryPackage ap = this.advManager.createAdvisoryPackage(this.overlord, advobject, (PackageVersion)package1.getVersions().get(0));
        PageList pkglist = this.advManager.findPackageByAdvisory(this.overlord, id1, PageControl.getUnlimitedInstance());
        assert (pkglist != null);
        assert (pkglist.size() != 0);
    }
}

