/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.persistence.Query;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.content.ContentAgentService;
import org.rhq.core.clientapi.server.content.ContentDiscoveryReport;
import org.rhq.core.clientapi.server.content.DeletePackagesRequest;
import org.rhq.core.clientapi.server.content.DeployPackagesRequest;
import org.rhq.core.clientapi.server.content.RetrievePackageBitsRequest;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.ContentRequestStatus;
import org.rhq.core.domain.content.ContentRequestType;
import org.rhq.core.domain.content.ContentServiceRequest;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.content.InstalledPackageHistoryStatus;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageInstallationStep;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemoveIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;

@Test
public class ContentManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean ENABLE_TESTS = false;
    private static final Object responseLock = new Object();
    private ContentManagerLocal contentManager;
    private SubjectManagerLocal subjectManager;
    private MockContentAgentService contentAgentService = new MockContentAgentService();
    private PackageType packageType1;
    private PackageType packageType2;
    private PackageType packageType3;
    private PackageType packageType4;
    private Package package1;
    private Package package2;
    private Package package3;
    private Package package4;
    private Package package5;
    private InstalledPackage installedPackage1;
    private InstalledPackage installedPackage2;
    private Architecture architecture1;
    private Architecture architecture2;
    private List<DeployPackageStep> stepResults;
    private ResourceType resourceType1;
    private Resource resource1;

    protected void beforeClass() throws Exception {
        this.contentManager = LookupUtil.getContentManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.populateResponseSteps();
    }

    @Override
    protected void beforeMethod() throws Exception {
        this.beforeClass();
        this.setupTestEnvironment();
    }

    @Override
    protected void afterMethod() throws Exception {
        this.tearDownTestEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testPersistSafely() throws Throwable {
        String pkgName = "testPersistSafelyPackage";
        String pvName = "testPersistSafelyPackageVersion version";
        PackageType pkgType = this.packageType1;
        Architecture arch = this.architecture1;
        Package pkgPojo = new Package("testPersistSafelyPackage", pkgType);
        PackageVersion pvPojo = new PackageVersion(pkgPojo, "testPersistSafelyPackageVersion version", arch);
        Configuration configPojo = new Configuration();
        configPojo.put((Property)new PropertySimple("one", (Object)"two"));
        pvPojo.setExtraProperties(configPojo);
        Package persistedPkg = null;
        PackageVersion persistedPV = null;
        try {
            Package pkg = new Package("testPersistSafelyPackage", pkgType);
            PackageVersion pv = new PackageVersion(pkg, "testPersistSafelyPackageVersion version", arch);
            pv.setExtraProperties(configPojo);
            persistedPkg = this.contentManager.persistOrMergePackageSafely(pkg);
            assert (persistedPkg != null);
            assert (persistedPkg.getId() > 0);
            assert (persistedPkg.equals((Object)pkgPojo)) : "not equal: " + persistedPkg + "<>" + pkgPojo;
            persistedPV = this.contentManager.persistOrMergePackageVersionSafely(pv);
            assert (persistedPV != null);
            assert (persistedPV.getId() > 0);
            assert (persistedPV.equals((Object)pvPojo)) : "not equal: " + persistedPV + "<>" + pvPojo;
            assert (persistedPV.getExtraProperties() != null);
            assert (persistedPV.getExtraProperties().getId() > 0);
            assert (persistedPV.getExtraProperties().getSimple("one").getStringValue().equals("two"));
            int pkgId = persistedPkg.getId();
            int pvId = persistedPV.getId();
            int configId = persistedPV.getExtraProperties().getId();
            int propId = persistedPV.getExtraProperties().getSimple("one").getId();
            pkg = new Package("testPersistSafelyPackage", pkgType);
            pv = new PackageVersion(pkg, "testPersistSafelyPackageVersion version", arch);
            pv.setExtraProperties(configPojo);
            persistedPkg = this.contentManager.persistOrMergePackageSafely(pkg);
            assert (persistedPkg != null);
            assert (persistedPkg.getId() > 0);
            assert (persistedPkg.equals((Object)pkgPojo)) : "not equal: " + persistedPkg + "<>" + pkgPojo;
            persistedPV = this.contentManager.persistOrMergePackageVersionSafely(pv);
            assert (persistedPV != null);
            assert (persistedPV.getId() > 0);
            assert (persistedPV.equals((Object)pvPojo)) : "not equal: " + persistedPV + "<>" + pvPojo;
            assert (persistedPV.getExtraProperties() != null);
            assert (persistedPV.getExtraProperties().getId() > 0);
            assert (persistedPV.getExtraProperties().getSimple("one").getStringValue().equals("two"));
            assert (pkgId == persistedPkg.getId());
            assert (pvId == persistedPV.getId());
            assert (configId == persistedPV.getExtraProperties().getId());
            assert (propId == persistedPV.getExtraProperties().getSimple("one").getId());
            pkg = new Package("testPersistSafelyPackage", pkgType);
            pv = new PackageVersion(pkg, "testPersistSafelyPackageVersion version", arch);
            pv.setExtraProperties(configPojo);
            pkg.setId(persistedPkg.getId());
            pv.setId(persistedPV.getId());
            persistedPkg = this.contentManager.persistOrMergePackageSafely(pkg);
            assert (persistedPkg != null);
            assert (persistedPkg.getId() > 0);
            assert (persistedPkg.equals((Object)pkgPojo)) : "not equal: " + persistedPkg + "<>" + pkgPojo;
            persistedPV = this.contentManager.persistOrMergePackageVersionSafely(pv);
            assert (persistedPV != null);
            assert (persistedPV.getId() > 0);
            assert (persistedPV.equals((Object)pvPojo)) : "not equal: " + persistedPV + "<>" + pvPojo;
            assert (persistedPV.getExtraProperties() != null);
            assert (persistedPV.getExtraProperties().getId() > 0);
            assert (persistedPV.getExtraProperties().getSimple("one").getStringValue().equals("two"));
            assert (pkgId == persistedPkg.getId());
            assert (pvId == persistedPV.getId());
            assert (configId == persistedPV.getExtraProperties().getId());
            assert (propId == persistedPV.getExtraProperties().getSimple("one").getId());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            this.getTransactionManager().begin();
            try {
                if (persistedPV != null && persistedPV.getId() > 0) {
                    persistedPV = (PackageVersion)this.em.find(PackageVersion.class, (Object)persistedPV.getId());
                    this.em.remove((Object)persistedPV);
                }
                if (persistedPkg != null && persistedPkg.getId() > 0) {
                    persistedPkg = (Package)this.em.find(Package.class, (Object)persistedPkg.getId());
                    this.em.remove((Object)persistedPkg);
                }
            }
            finally {
                this.getTransactionManager().commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testInventoryMerge() throws Exception {
        ContentDiscoveryReport report = new ContentDiscoveryReport();
        report.setResourceId(this.resource1.getId());
        PackageDetailsKey key1 = new PackageDetailsKey(this.package1.getName(), "2.0.0", this.package1.getPackageType().getName(), this.architecture1.getName());
        ResourcePackageDetails package1 = new ResourcePackageDetails(key1);
        report.addDeployedPackage(package1);
        PackageDetailsKey key2 = new PackageDetailsKey(this.package2.getName(), "3.0.0", this.package2.getPackageType().getName(), this.architecture1.getName());
        ResourcePackageDetails package2 = new ResourcePackageDetails(key2);
        report.addDeployedPackage(package2);
        PackageDetailsKey key3 = new PackageDetailsKey(this.package3.getName(), "1.0.0", this.package3.getPackageType().getName(), this.architecture2.getName());
        ResourcePackageDetails package3 = new ResourcePackageDetails(key3);
        report.addDeployedPackage(package3);
        PackageDetailsKey key4 = new PackageDetailsKey("PackageX", "1.0.0", this.packageType4.getName(), this.architecture1.getName());
        ResourcePackageDetails package4 = new ResourcePackageDetails(key4);
        package4.setClassification("Package X1 Category");
        package4.setDisplayName("Package X1 Display Name");
        package4.setDisplayVersion("Package X1 Display Version");
        package4.setFileCreatedDate(Long.valueOf(System.currentTimeMillis()));
        package4.setFileName("package4.tar.gz");
        package4.setFileSize(Long.valueOf(1000L));
        package4.setLicenseName("GPL");
        package4.setLicenseVersion("2");
        package4.setLongDescription("Package X1 Long Description");
        package4.setMD5("7bf1adec93fdb899aeca248a38603d58");
        package4.setSHA256("935f051cab5240b979bba87ce58183d50f592a962202ca683f12a7966414fe6c");
        package4.setShortDescription("Package X1 Short Description");
        String package4Metadata = "Package X1 Metadata";
        package4.setMetadata(package4Metadata.getBytes());
        Configuration package4DeploymentConfiguration = new Configuration();
        package4DeploymentConfiguration.put((Property)new PropertySimple("property1", (Object)"value1"));
        package4.setDeploymentTimeConfiguration(package4DeploymentConfiguration);
        Configuration package4ExtraProperties = new Configuration();
        package4ExtraProperties.put((Property)new PropertySimple("property2", (Object)"value2"));
        package4.setExtraProperties(package4ExtraProperties);
        report.addDeployedPackage(package4);
        PackageDetailsKey key5 = new PackageDetailsKey("Package4", "2.0.0", this.package4.getPackageType().getName(), this.architecture1.getName());
        ResourcePackageDetails package5 = new ResourcePackageDetails(key5);
        report.addDeployedPackage(package5);
        for (int ii = 0; ii < 2; ++ii) {
            this.contentManager.mergeDiscoveredPackages(report);
            this.getTransactionManager().begin();
            try {
                Query installedPackageQuery = this.em.createNamedQuery("InstalledPackage.findByResourceId");
                installedPackageQuery.setParameter("resourceId", (Object)this.resource1.getId());
                List installedPackages = installedPackageQuery.getResultList();
                assert (installedPackages.size() == 5) : "Incorrect number of packages discovered. Expected 5, Found " + installedPackages.size();
                Query packageXQuery = this.em.createNamedQuery("Package.findByNameAndPkgTypeId");
                packageXQuery.setParameter("name", (Object)"PackageX");
                packageXQuery.setParameter("packageTypeId", (Object)this.packageType4.getId());
                Package packageX = (Package)packageXQuery.getSingleResult();
                assert (packageX.getName().equals("PackageX")) : "Package name not specified on created package";
                assert (packageX.getPackageType().equals((Object)this.packageType4)) : "Package type incorrect on created package. Expected: " + this.packageType4 + ", Found: " + packageX.getPackageType();
                Query packageVersionQuery = this.em.createNamedQuery("PackageVersion.findByPackageId");
                packageVersionQuery.setParameter("packageId", (Object)packageX.getId());
                List packageVersions = packageVersionQuery.getResultList();
                assert (packageVersions.size() == 1) : "Incorrect number of versions for package. Expected: 1, Found: " + packageVersions.size();
                PackageVersion packageVersionX = (PackageVersion)packageVersions.get(0);
                assert (packageVersionX.getArchitecture().equals((Object)this.architecture1)) : "Incorrect architecture on package version. Expected: " + this.architecture1 + ", Found: " + packageVersionX.getArchitecture();
                assert (packageVersionX.getDisplayName().equals(package4.getDisplayName())) : "Incorrect display name on package version. Expected: " + package4.getDisplayName() + ", Found: " + packageVersionX.getDisplayName();
                assert (packageVersionX.getDisplayVersion().equals(package4.getDisplayVersion())) : "Incorrect display version on package version. Expected: " + package4.getDisplayVersion() + ", Found: " + packageVersionX.getDisplayVersion();
                assert (packageVersionX.getFileName().equals(package4.getFileName())) : "Incorrect file name on package version. Expected: " + package4.getFileName() + ", Found: " + packageVersionX.getFileName();
                assert (packageVersionX.getFileSize().equals(package4.getFileSize())) : "Incorrect file size on package version. Expected: " + package4.getFileSize() + ", Found: " + packageVersionX.getFileSize();
                assert (packageVersionX.getLicenseName().equals(package4.getLicenseName())) : "Incorrect license name on package version. Expected: " + package4.getLicenseName() + ", Found: " + packageVersionX.getLicenseName();
                assert (packageVersionX.getLicenseVersion().equals(package4.getLicenseVersion())) : "Incorrect license version on package version. Expected: " + package4.getLicenseVersion() + ", Found: " + packageVersionX.getLicenseVersion();
                assert (packageVersionX.getLongDescription().equals(package4.getLongDescription())) : "Incorrect long description on package version. Expected: " + package4.getLongDescription() + ", Found: " + packageVersionX.getLongDescription();
                assert (packageVersionX.getMD5().equals(package4.getMD5())) : "Incorrect MD5 on package version. Expected: " + package4.getMD5() + ", Found: " + packageVersionX.getMD5();
                assert (Arrays.equals(packageVersionX.getMetadata(), package4.getMetadata())) : "Incorrect metadata on package version.";
                assert (packageVersionX.getPackageBits() == null) : "Non-null package bits specified for package version: " + packageVersionX.getPackageBits();
                assert (packageVersionX.getSHA256().equals(package4.getSHA256())) : "Incorrect SHA256 for package version. Expected: " + package4.getSHA256() + ", Found: " + packageVersionX.getSHA256();
                assert (packageVersionX.getShortDescription().equals(package4.getShortDescription())) : "Incorrect short description. Expected: " + package4.getShortDescription() + ", Found: " + packageVersionX.getShortDescription();
                assert (packageVersionX.getVersion().equals(package4.getVersion())) : "Incorrect version. Expected: " + package4.getVersion() + ", Found: " + packageVersionX.getVersion();
                Configuration extraProperties = packageVersionX.getExtraProperties();
                assert (extraProperties != null) : "Package version extra properties not persisted.";
                assert (extraProperties.getSimple("property2") != null) : "Properties inside of extra properties were missing";
                assert (extraProperties.getSimple("property2").getStringValue().equals("value2")) : "Incorrect value of property2";
                Query packageXInstalledPackageQuery = this.em.createNamedQuery("InstalledPackage.findByResourceIdAndPackageVersionId");
                packageXInstalledPackageQuery.setParameter("resourceId", (Object)this.resource1.getId());
                packageXInstalledPackageQuery.setParameter("packageVersionId", (Object)packageVersionX.getId());
                InstalledPackage packageXInstalledPackage = (InstalledPackage)packageXInstalledPackageQuery.getSingleResult();
                if ($assertionsDisabled || packageXInstalledPackage != null) continue;
                throw new AssertionError();
            }
            finally {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSuccessfulDeployPackages() throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        HashSet<ResourcePackageDetails> installUs = new HashSet<ResourcePackageDetails>(2);
        PackageVersion packageVersion1 = (PackageVersion)this.package1.getVersions().get(0);
        Configuration deploymentConfiguration1 = new Configuration();
        deploymentConfiguration1.put((Property)new PropertySimple("property1", (Object)"value1"));
        PackageDetailsKey key1 = new PackageDetailsKey(this.package1.getName(), packageVersion1.getVersion(), this.package1.getPackageType().getName(), packageVersion1.getArchitecture().getName());
        ResourcePackageDetails packageDetails1 = new ResourcePackageDetails(key1);
        packageDetails1.setDeploymentTimeConfiguration(deploymentConfiguration1);
        installUs.add(packageDetails1);
        PackageVersion packageVersion2 = (PackageVersion)this.package2.getVersions().get(0);
        PackageDetailsKey key2 = new PackageDetailsKey(this.package2.getName(), packageVersion2.getVersion(), this.package2.getPackageType().getName(), packageVersion2.getArchitecture().getName());
        ResourcePackageDetails packageDetails2 = new ResourcePackageDetails(key2);
        installUs.add(packageDetails2);
        this.contentAgentService.setResponseReturnStatus(ContentResponseResult.SUCCESS);
        this.contentAgentService.setThrowError(false);
        this.contentAgentService.setReturnIndividualResponses(true);
        String notes = "Test package deployment";
        Object object = responseLock;
        synchronized (object) {
            this.contentManager.deployPackages(overlord, this.resource1.getId(), installUs, notes);
            this.getTransactionManager().begin();
            try {
                Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
                query.setParameter("resourceId", (Object)this.resource1.getId());
                List results = query.getResultList();
                assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
                ContentServiceRequest request = (ContentServiceRequest)results.get(0);
                assert (request.getContentRequestType() == ContentRequestType.DEPLOY) : "Request type incorrect. Expected: DEPLOY, Found: " + request.getContentRequestType();
                assert (request.getStatus() == ContentRequestStatus.IN_PROGRESS) : "Request status incorrect. Expected: IN_PROGRESS, Found: " + request.getStatus();
                assert (request.getInstalledPackageHistory().size() == 2) : "Incorrect number of installed packages attached to request. Expected: 2, Found: " + request.getInstalledPackageHistory().size();
                assert (request.getNotes() != null) : "Null notes found";
                assert (request.getNotes().equals(notes)) : "Incorrect notes found: " + request.getNotes();
                Set history = request.getInstalledPackageHistory();
                assert (history.size() == 2) : "Incorrect number of history entries on request. Expected: 2, Found: " + history.size();
                for (InstalledPackageHistory historyEntry : history) {
                    assert (historyEntry.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect state on history entity. Expected: BEING_INSTALLED, Found: " + historyEntry.getStatus();
                }
                query = this.em.createNamedQuery("InstalledPackage.findByResourceIdAndPackageVersionId");
                query.setParameter("resourceId", (Object)this.resource1.getId());
                query.setParameter("packageVersionId", (Object)packageVersion1.getId());
                results = query.getResultList();
                assert (results.size() == 0) : "Incorrect number of installed packages for package 1, version 2. Expected: 0, Found: " + results.size();
                query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
                query.setParameter("contentServiceRequestId", (Object)request.getId());
                query.setParameter("packageVersionId", (Object)packageVersion1.getId());
                results = query.getResultList();
                assert (results.size() == 1) : "Incorrect number of audit trail entries. Expected: 1, Found: " + results.size();
                InstalledPackageHistory historyEntity = (InstalledPackageHistory)results.get(0);
                assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on first entity. Expected: BEING_INSTALLED, Found: " + historyEntity.getStatus();
                query = this.em.createNamedQuery("InstalledPackage.findByResourceIdAndPackageVersionId");
                query.setParameter("resourceId", (Object)this.resource1.getId());
                query.setParameter("packageVersionId", (Object)packageVersion2.getId());
                results = query.getResultList();
                assert (results.size() == 0) : "Incorrect number of installed packages for package 2, version 1. Expected: 0, Found: " + results.size();
                query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
                query.setParameter("contentServiceRequestId", (Object)request.getId());
                query.setParameter("packageVersionId", (Object)packageVersion2.getId());
                results = query.getResultList();
                assert (results.size() == 1) : "Incorrect number of audit trail entries. Expected: 1, Found: " + results.size();
                historyEntity = (InstalledPackageHistory)results.get(0);
                assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on second entity. Expected: BEING_INSTALLED, Found: " + historyEntity.getStatus();
            }
            finally {
                responseLock.notifyAll();
                this.getTransactionManager().rollback();
            }
        }
        Thread.sleep(1000L);
        this.getTransactionManager().begin();
        try {
            Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            List results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
            ContentServiceRequest request = (ContentServiceRequest)results.get(0);
            assert (request.getStatus() == ContentRequestStatus.SUCCESS) : "Request status incorrect. Expected: SUCCESS, Found: " + request.getStatus();
            Set history = request.getInstalledPackageHistory();
            assert (history.size() == 4) : "Incorrect number of history entries on request. Expected: 4, Found: " + history.size();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            query.setParameter("packageVersionId", (Object)packageVersion1.getId());
            results = query.getResultList();
            assert (results.size() == 2) : "Incorrect number of history entries. Expected: 2, Found: " + results.size();
            InstalledPackageHistory historyEntity = (InstalledPackageHistory)results.get(0);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.INSTALLED) : "Incorrect status on first entity. Expected: INSTALLED, Found: " + historyEntity.getStatus();
            historyEntity = (InstalledPackageHistory)results.get(1);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on first entity. Expected: BEING_INSTALLED, Found: " + historyEntity.getStatus();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            query.setParameter("packageVersionId", (Object)packageVersion2.getId());
            results = query.getResultList();
            assert (results.size() == 2) : "Incorrect number of history entries. Expected: 2, Found: " + results.size();
            historyEntity = (InstalledPackageHistory)results.get(0);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.INSTALLED) : "Incorrect status on first entity. Expected: INSTALLED, Found: " + historyEntity.getStatus();
            historyEntity = (InstalledPackageHistory)results.get(1);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on first entity. Expected: BEING_INSTALLED, Found: " + historyEntity.getStatus();
            PackageVersionCriteria criteria = new PackageVersionCriteria();
            criteria.addFilterResourceId(Integer.valueOf(this.resource1.getId()));
            PageList pageList = this.contentManager.findPackageVersionsByCriteria(overlord, criteria);
            this.assertNotNull(pageList);
            ArrayList pvs = pageList.getValues();
            this.assertEquals(2, pvs.size());
            PackageVersion pv0 = (PackageVersion)pvs.get(0);
            criteria.addFilterPackageTypeId(Integer.valueOf(pv0.getGeneralPackage().getPackageType().getId()));
            pageList = this.contentManager.findPackageVersionsByCriteria(overlord, criteria);
            this.assertNotNull(pageList);
            pvs = pageList.getValues();
            this.assertEquals(1, pvs.size());
            this.assertEquals(pv0.getId(), ((PackageVersion)pvs.get(0)).getId());
            criteria.addFilterRepoId(Integer.valueOf(38465));
            pageList = this.contentManager.findPackageVersionsByCriteria(overlord, criteria);
            this.assertNotNull(pageList);
            pvs = pageList.getValues();
            this.assertEquals(0, pvs.size());
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testDeployWithSteps() throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        HashSet<ResourcePackageDetails> installUs = new HashSet<ResourcePackageDetails>(2);
        PackageVersion packageVersion1 = (PackageVersion)this.package1.getVersions().get(0);
        Configuration deploymentConfiguration1 = new Configuration();
        deploymentConfiguration1.put((Property)new PropertySimple("property1", (Object)"value1"));
        PackageDetailsKey key1 = new PackageDetailsKey(this.package1.getName(), packageVersion1.getVersion(), this.package1.getPackageType().getName(), packageVersion1.getArchitecture().getName());
        ResourcePackageDetails packageDetails1 = new ResourcePackageDetails(key1);
        packageDetails1.setDeploymentTimeConfiguration(deploymentConfiguration1);
        installUs.add(packageDetails1);
        this.contentAgentService.setResponseReturnStatus(ContentResponseResult.SUCCESS);
        this.contentAgentService.setThrowError(false);
        this.contentAgentService.setReturnIndividualResponses(true);
        this.contentAgentService.setDeployPackageSteps(this.stepResults);
        String notes = "Test deploy notes";
        Object object = responseLock;
        synchronized (object) {
            this.contentManager.deployPackages(overlord, this.resource1.getId(), installUs, notes);
            this.getTransactionManager().begin();
            try {
                Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
                query.setParameter("resourceId", (Object)this.resource1.getId());
                List results = query.getResultList();
                assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
                ContentServiceRequest request = (ContentServiceRequest)results.get(0);
                assert (request.getContentRequestType() == ContentRequestType.DEPLOY) : "Request type incorrect. Expected: DEPLOY, Found: " + request.getContentRequestType();
                assert (request.getStatus() == ContentRequestStatus.IN_PROGRESS) : "Request status incorrect. Expected: IN_PROGRESS, Found: " + request.getStatus();
                assert (request.getInstalledPackageHistory().size() == 1) : "Incorrect number of installed packages attached to request. Expected: 1, Found: " + request.getInstalledPackageHistory().size();
                assert (request.getNotes() != null) : "Null notes found";
                assert (request.getNotes().equals(notes)) : "Incorrect notes found: " + request.getNotes();
                Set history = request.getInstalledPackageHistory();
                assert (history.size() == 1) : "Incorrect number of history entries on request. Expected: 2, Found: " + history.size();
                for (InstalledPackageHistory historyEntry : history) {
                    assert (historyEntry.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect state on history entity. Expected: BEING_INSTALLED, Found: " + historyEntry.getStatus();
                }
            }
            finally {
                responseLock.notifyAll();
                this.getTransactionManager().rollback();
            }
        }
        Thread.sleep(1000L);
        this.getTransactionManager().begin();
        try {
            Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            List results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
            ContentServiceRequest request = (ContentServiceRequest)results.get(0);
            assert (request.getStatus() == ContentRequestStatus.SUCCESS) : "Request status incorrect. Expected: SUCCESS, Found: " + request.getStatus();
            Set history = request.getInstalledPackageHistory();
            assert (history.size() == 2) : "Incorrect number of history entries on request. Expected: 2, Found: " + history.size();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            query.setParameter("packageVersionId", (Object)packageVersion1.getId());
            results = query.getResultList();
            assert (results.size() == 2) : "Incorrect number of history entries. Expected: 2, Found: " + results.size();
            InstalledPackageHistory historyEntity = (InstalledPackageHistory)results.get(0);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.INSTALLED) : "Incorrect status on first entity. Expected: INSTALLED, Found: " + historyEntity.getStatus();
            List installationSteps = historyEntity.getInstallationSteps();
            assert (installationSteps != null) : "Installation steps were null";
            assert (installationSteps.size() == 3) : "Incorrect number of installation steps. Expected: 3, Found: " + installationSteps.size();
            PackageInstallationStep step = (PackageInstallationStep)installationSteps.get(0);
            assert (step.getOrder() == 0) : "Incorrect order applied for step";
            assert (step.getDescription() != null) : "Description not saved";
            assert (step.getResult() == ContentResponseResult.SUCCESS) : "Incorrect status on step. Expected: SUCCESS, Found: " + step.getResult();
            assert (step.getErrorMessage() == null) : "Error message found on successful step";
            assert (step.getInstalledPackageHistory() != null) : "Relationship to packge history isn't established";
            step = (PackageInstallationStep)installationSteps.get(1);
            assert (step.getOrder() == 1) : "Incorrect order applied for step";
            assert (step.getDescription() != null) : "Description not saved";
            assert (step.getResult() == ContentResponseResult.NOT_PERFORMED) : "Incorrect status on step. Expected: NOT_PERFORMED, Found: " + step.getResult();
            assert (step.getErrorMessage() == null) : "Error message found on skipped step";
            assert (step.getInstalledPackageHistory() != null) : "Relationship to packge history isn't established";
            step = (PackageInstallationStep)installationSteps.get(2);
            assert (step.getOrder() == 2) : "Incorrect order applied for step";
            assert (step.getDescription() != null) : "Description not saved";
            assert (step.getResult() == ContentResponseResult.FAILURE) : "Incorrect status on step. Expected: FAILURE, Found: " + step.getResult();
            assert (step.getErrorMessage() != null) : "Null error message found on error step";
            assert (step.getInstalledPackageHistory() != null) : "Relationship to packge history isn't established";
            historyEntity = (InstalledPackageHistory)results.get(1);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on first entity. Expected: BEING_INSTALLED, Found: " + historyEntity.getStatus();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testFailedDeployPackages() throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        HashSet<ResourcePackageDetails> installUs = new HashSet<ResourcePackageDetails>(1);
        Configuration deploymentConfiguration1 = new Configuration();
        deploymentConfiguration1.put((Property)new PropertySimple("property1", (Object)"value1"));
        PackageVersion packageVersion1 = (PackageVersion)this.package1.getVersions().get(1);
        PackageDetailsKey key1 = new PackageDetailsKey(this.package1.getName(), packageVersion1.getVersion(), this.package1.getPackageType().getName(), packageVersion1.getArchitecture().getName());
        ResourcePackageDetails packageDetails1 = new ResourcePackageDetails(key1);
        packageDetails1.setDeploymentTimeConfiguration(deploymentConfiguration1);
        installUs.add(packageDetails1);
        this.contentAgentService.setResponseReturnStatus(ContentResponseResult.FAILURE);
        this.contentAgentService.setThrowError(false);
        this.contentAgentService.setReturnIndividualResponses(true);
        String notes = "Test deploy notes";
        this.contentManager.deployPackages(overlord, this.resource1.getId(), installUs, notes);
        Thread.sleep(1000L);
        this.getTransactionManager().begin();
        try {
            Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            List results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
            ContentServiceRequest request = (ContentServiceRequest)results.get(0);
            assert (request.getStatus() == ContentRequestStatus.FAILURE) : "Request status incorrect. Expected: IN_PROGRESS, Found: " + request.getStatus();
            assert (request.getNotes() != null) : "Null notes found";
            assert (request.getNotes().equals(notes)) : "Incorrect notes found: " + request.getNotes();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            query.setParameter("packageVersionId", (Object)packageVersion1.getId());
            results = query.getResultList();
            assert (results.size() == 2) : "Incorrect number of history entries. Expected: 2, Found: " + results.size();
            InstalledPackageHistory historyEntity = (InstalledPackageHistory)results.get(0);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.FAILED) : "Incorrect status on first entity. Expected: FAILED, Found: " + historyEntity.getStatus();
            historyEntity = (InstalledPackageHistory)results.get(1);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on first entity. Expected: BEING_INSTALLED, Found: " + historyEntity.getStatus();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testDeployPackageFailToContactAgent() throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        HashSet<ResourcePackageDetails> installUs = new HashSet<ResourcePackageDetails>(1);
        Configuration deploymentConfiguration1 = new Configuration();
        deploymentConfiguration1.put((Property)new PropertySimple("property1", (Object)"value1"));
        PackageVersion packageVersion1 = (PackageVersion)this.package1.getVersions().get(1);
        PackageDetailsKey key1 = new PackageDetailsKey(this.package1.getName(), packageVersion1.getVersion(), this.package1.getPackageType().getName(), packageVersion1.getArchitecture().getName());
        ResourcePackageDetails packageDetails1 = new ResourcePackageDetails(key1);
        packageDetails1.setDeploymentTimeConfiguration(deploymentConfiguration1);
        installUs.add(packageDetails1);
        this.contentAgentService.setResponseReturnStatus(ContentResponseResult.FAILURE);
        this.contentAgentService.setThrowError(true);
        this.contentAgentService.setReturnIndividualResponses(false);
        String notes = "Test deploy notes";
        try {
            this.contentManager.deployPackages(overlord, this.resource1.getId(), installUs, notes);
            assert (false) : "No exception thrown from deploy call";
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getTransactionManager().begin();
        try {
            Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            List results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
            ContentServiceRequest request = (ContentServiceRequest)results.get(0);
            assert (request.getStatus() == ContentRequestStatus.FAILURE) : "Request status incorrect. Expected: IN_PROGRESS, Found: " + request.getStatus();
            assert (request.getNotes() != null) : "Null notes found";
            assert (request.getNotes().equals(notes)) : "Incorrect notes found: " + request.getNotes();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            query.setParameter("packageVersionId", (Object)packageVersion1.getId());
            results = query.getResultList();
            assert (results.size() == 2) : "Incorrect number of history entries. Expected: 2, Found: " + results.size();
            InstalledPackageHistory historyEntity = (InstalledPackageHistory)results.get(0);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.FAILED) : "Incorrect status on first entity. Expected: FAILED, Found: " + historyEntity.getStatus();
            historyEntity = (InstalledPackageHistory)results.get(1);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on first entity. Expected: BEING_INSTALLED, Found: " + historyEntity.getStatus();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testDeployPackagesNoIndividualResponses() throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        HashSet<ResourcePackageDetails> installUs = new HashSet<ResourcePackageDetails>(1);
        Configuration deploymentConfiguration1 = new Configuration();
        deploymentConfiguration1.put((Property)new PropertySimple("property1", (Object)"value1"));
        PackageVersion packageVersion1 = (PackageVersion)this.package1.getVersions().get(1);
        PackageDetailsKey key1 = new PackageDetailsKey(this.package1.getName(), packageVersion1.getVersion(), this.package1.getPackageType().getName(), packageVersion1.getArchitecture().getName());
        ResourcePackageDetails packageDetails1 = new ResourcePackageDetails(key1);
        packageDetails1.setDeploymentTimeConfiguration(deploymentConfiguration1);
        installUs.add(packageDetails1);
        this.contentAgentService.setResponseReturnStatus(ContentResponseResult.FAILURE);
        this.contentAgentService.setThrowError(false);
        this.contentAgentService.setReturnIndividualResponses(false);
        String notes = "Test deploy notes";
        this.contentManager.deployPackages(overlord, this.resource1.getId(), installUs, notes);
        Thread.sleep(1000L);
        this.getTransactionManager().begin();
        try {
            Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            List results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
            ContentServiceRequest request = (ContentServiceRequest)results.get(0);
            assert (request.getStatus() == ContentRequestStatus.FAILURE) : "Request status incorrect. Expected: FAILURE, Found: " + request.getStatus();
            assert (request.getNotes() != null) : "Null notes found";
            assert (request.getNotes().equals(notes)) : "Incorrect notes found: " + request.getNotes();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            query.setParameter("packageVersionId", (Object)packageVersion1.getId());
            results = query.getResultList();
            assert (results.size() == 2) : "Incorrect number of history entries. Expected: 2, Found: " + results.size();
            InstalledPackageHistory historyEntity = (InstalledPackageHistory)results.get(0);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.FAILED) : "Incorrect status on first entity. Expected: FAILED, Found: " + historyEntity.getStatus();
            historyEntity = (InstalledPackageHistory)results.get(1);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on first entity. Expected: BEING_INSTALLED, Found: " + historyEntity.getStatus();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testLoadDependencies() throws Exception {
        ContentServiceRequest request;
        HashSet<PackageDetailsKey> loadUs;
        block10: {
            loadUs = new HashSet<PackageDetailsKey>(3);
            PackageVersion packageVersion1 = (PackageVersion)this.package1.getVersions().get(1);
            PackageDetailsKey packageKey1 = new PackageDetailsKey(this.package1.getName(), packageVersion1.getVersion(), this.package1.getPackageType().getName(), packageVersion1.getArchitecture().getName());
            loadUs.add(packageKey1);
            PackageVersion packageVersion2 = (PackageVersion)this.package2.getVersions().get(1);
            PackageDetailsKey packageKey2 = new PackageDetailsKey(this.package2.getName(), packageVersion2.getVersion(), this.package2.getPackageType().getName(), packageVersion2.getArchitecture().getName());
            loadUs.add(packageKey2);
            PackageDetailsKey packageKey3 = new PackageDetailsKey("foo", "1.0.0", "fooType", "fooArch");
            loadUs.add(packageKey3);
            this.getTransactionManager().begin();
            request = null;
            try {
                this.resource1 = (Resource)this.em.find(Resource.class, (Object)this.resource1.getId());
                Subject overlord = this.subjectManager.getOverlord();
                PackageVersion packageVersion = (PackageVersion)this.em.find(PackageVersion.class, (Object)((PackageVersion)this.package3.getVersions().get(0)).getId());
                request = new ContentServiceRequest(this.resource1, overlord.getName(), ContentRequestType.DEPLOY);
                InstalledPackageHistory originalRequestedPackage = new InstalledPackageHistory();
                originalRequestedPackage.setContentServiceRequest(request);
                originalRequestedPackage.setPackageVersion(packageVersion);
                originalRequestedPackage.setStatus(InstalledPackageHistoryStatus.BEING_INSTALLED);
                originalRequestedPackage.setTimestamp(Long.valueOf(System.currentTimeMillis()));
                originalRequestedPackage.setResource(this.resource1);
                request.addInstalledPackageHistory(originalRequestedPackage);
                this.em.persist((Object)request);
                this.getTransactionManager().commit();
            }
            catch (Throwable t) {
                this.getTransactionManager().rollback();
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)("Error during setup: " + t));
            }
        }
        this.contentManager.loadDependencies(request.getId(), loadUs);
        this.getTransactionManager().begin();
        try {
            Query query = this.em.createNamedQuery("ContentServiceRequest.findById");
            query.setParameter("id", (Object)request.getId());
            List resultList = query.getResultList();
            assert (resultList.size() == 1) : "Incorrect number of requests loaded. Expected: 1, Found: " + resultList.size();
            request = (ContentServiceRequest)resultList.get(0);
            assert (request.getInstalledPackageHistory().size() == 3) : "Incorrect number of being installed packages on request. Expected: 3, Found: " + resultList.size();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            List historyEntries = query.getResultList();
            for (InstalledPackageHistory historyEntry : historyEntries) {
                assert (historyEntry.getContentServiceRequest().equals((Object)request)) : "ContentServiceRequest relationship not set up correctly for package history";
                assert (historyEntry.getStatus() == InstalledPackageHistoryStatus.BEING_INSTALLED) : "Incorrect status on installed package history. Expected: BEING_INSTALLED, Found: " + historyEntry.getStatus();
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testSuccessfullyDeletePackages() throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        int[] deleteUs = new int[]{this.installedPackage1.getId()};
        this.contentAgentService.setResponseReturnStatus(ContentResponseResult.SUCCESS);
        this.contentAgentService.setThrowError(false);
        this.contentAgentService.setReturnIndividualResponses(true);
        String notes = "Test delete notes";
        Object object = responseLock;
        synchronized (object) {
            this.contentManager.deletePackages(overlord, this.resource1.getId(), deleteUs, notes);
            this.getTransactionManager().begin();
            try {
                Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
                query.setParameter("resourceId", (Object)this.resource1.getId());
                List results = query.getResultList();
                assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
                ContentServiceRequest request = (ContentServiceRequest)results.get(0);
                assert (request.getStatus() == ContentRequestStatus.IN_PROGRESS) : "Request status incorrect. Expected: IN_PROGRESS, Found: " + request.getStatus();
                assert (request.getNotes() != null) : "Null notes found";
                assert (request.getNotes().equals(notes)) : "Incorrect notes found: " + request.getNotes();
                Set history = request.getInstalledPackageHistory();
                assert (history.size() == 1) : "Incorrect number of history entries on request. Expected: 1, Found: " + history.size();
                for (InstalledPackageHistory historyEntry : history) {
                    assert (historyEntry.getStatus() == InstalledPackageHistoryStatus.BEING_DELETED) : "Incorrect state on history entity. Expected: BEING_DELETED, Found: " + historyEntry.getStatus();
                }
            }
            finally {
                this.getTransactionManager().rollback();
            }
        }
        Thread.sleep(1000L);
        this.getTransactionManager().begin();
        try {
            Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            List results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
            ContentServiceRequest request = (ContentServiceRequest)results.get(0);
            assert (request.getStatus() == ContentRequestStatus.SUCCESS) : "Request status incorrect. Expected: SUCCESS, Found: " + request.getStatus();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            query.setParameter("packageVersionId", (Object)this.installedPackage1.getPackageVersion().getId());
            results = query.getResultList();
            assert (results.size() == 2) : "Incorrect number of history entries. Expected: 2, Found: " + results.size();
            InstalledPackageHistory historyEntity = (InstalledPackageHistory)results.get(0);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.DELETED) : "Incorrect status on first entity. Expected: DELETED, Found: " + historyEntity.getStatus();
            historyEntity = (InstalledPackageHistory)results.get(1);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_DELETED) : "Incorrect status on first entity. Expected: BEING_DELETED, Found: " + historyEntity.getStatus();
            query = this.em.createNamedQuery("InstalledPackage.findByResourceIdAndPackageVersionId");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            query.setParameter("packageVersionId", (Object)this.installedPackage1.getPackageVersion().getId());
            results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of installed packages for package 1, version 2. Expected: 0, Found: " + results.size();
            query = this.em.createNamedQuery("InstalledPackage.findByResourceIdAndPackageVersionId");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            query.setParameter("packageVersionId", (Object)((PackageVersion)this.package5.getVersions().get(0)).getId());
            results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of installed packages for package 2, version 1. Expected: 1, Found: " + results.size();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testDeletePackagesNoIndividualResponses() throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        int[] deleteUs = new int[]{this.installedPackage1.getId()};
        this.contentAgentService.setResponseReturnStatus(ContentResponseResult.FAILURE);
        this.contentAgentService.setThrowError(false);
        this.contentAgentService.setReturnIndividualResponses(false);
        String notes = "Test delete notes";
        Object object = responseLock;
        synchronized (object) {
            this.contentManager.deletePackages(overlord, this.resource1.getId(), deleteUs, notes);
            this.getTransactionManager().begin();
            try {
                Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
                query.setParameter("resourceId", (Object)this.resource1.getId());
                List results = query.getResultList();
                assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
                ContentServiceRequest request = (ContentServiceRequest)results.get(0);
                assert (request.getStatus() == ContentRequestStatus.IN_PROGRESS) : "Request status incorrect. Expected: IN_PROGRESS, Found: " + request.getStatus();
                assert (request.getNotes() != null) : "Null notes found";
                assert (request.getNotes().equals(notes)) : "Incorrect notes found: " + request.getNotes();
                Set history = request.getInstalledPackageHistory();
                assert (history.size() == 1) : "Incorrect number of history entries on request. Expected: 1, Found: " + history.size();
                for (InstalledPackageHistory historyEntry : history) {
                    assert (historyEntry.getStatus() == InstalledPackageHistoryStatus.BEING_DELETED) : "Incorrect state on history entity. Expected: BEING_DELETED, Found: " + historyEntry.getStatus();
                }
            }
            finally {
                this.getTransactionManager().rollback();
            }
        }
        Thread.sleep(1000L);
        this.getTransactionManager().begin();
        try {
            Query query = this.em.createNamedQuery("ContentServiceRequest.findByResource");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            List results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of content service requests. Expected: 1, Found: " + results.size();
            ContentServiceRequest request = (ContentServiceRequest)results.get(0);
            assert (request.getStatus() == ContentRequestStatus.FAILURE) : "Request status incorrect. Expected: FAILURE, Found: " + request.getStatus();
            query = this.em.createNamedQuery("InstalledPackageHistory.findByCsrIdAndPkgVerId");
            query.setParameter("contentServiceRequestId", (Object)request.getId());
            query.setParameter("packageVersionId", (Object)this.installedPackage1.getPackageVersion().getId());
            results = query.getResultList();
            assert (results.size() == 2) : "Incorrect number of history entries. Expected: 2, Found: " + results.size();
            InstalledPackageHistory historyEntity = (InstalledPackageHistory)results.get(0);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.FAILED) : "Incorrect status on first entity. Expected: FAILED, Found: " + historyEntity.getStatus();
            historyEntity = (InstalledPackageHistory)results.get(1);
            assert (historyEntity.getStatus() == InstalledPackageHistoryStatus.BEING_DELETED) : "Incorrect status on first entity. Expected: BEING_DELETED, Found: " + historyEntity.getStatus();
            query = this.em.createNamedQuery("InstalledPackage.findByResourceIdAndPackageVersionId");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            query.setParameter("packageVersionId", (Object)this.installedPackage1.getPackageVersion().getId());
            results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of installed packages for package 1, version 2. Expected: 0, Found: " + results.size();
            query = this.em.createNamedQuery("InstalledPackage.findByResourceIdAndPackageVersionId");
            query.setParameter("resourceId", (Object)this.resource1.getId());
            query.setParameter("packageVersionId", (Object)((PackageVersion)this.package5.getVersions().get(0)).getId());
            results = query.getResultList();
            assert (results.size() == 1) : "Incorrect number of installed packages for package 2, version 1. Expected: 1, Found: " + results.size();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    private void setupTestEnvironment() throws Exception {
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        agentServiceContainer.contentService = this.contentAgentService;
        this.getTransactionManager().begin();
        try {
            this.architecture1 = (Architecture)this.em.find(Architecture.class, (Object)1);
            this.architecture2 = (Architecture)this.em.find(Architecture.class, (Object)2);
            this.resourceType1 = new ResourceType("resourcetype-" + System.currentTimeMillis(), "TestPlugin", ResourceCategory.PLATFORM, null);
            this.em.persist((Object)this.resourceType1);
            this.packageType1 = new PackageType();
            this.packageType1.setName("package1-" + System.currentTimeMillis());
            this.packageType1.setDescription("");
            this.packageType1.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType1.setDisplayName("TestResourcePackage");
            this.packageType1.setCreationData(true);
            this.packageType1.setResourceType(this.resourceType1);
            this.em.persist((Object)this.packageType1);
            this.packageType2 = new PackageType();
            this.packageType2.setName("package2-" + System.currentTimeMillis());
            this.packageType2.setDescription("");
            this.packageType2.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType2.setDisplayName("TestResourcePackage2");
            this.packageType2.setCreationData(true);
            this.packageType2.setResourceType(this.resourceType1);
            this.em.persist((Object)this.packageType2);
            this.packageType3 = new PackageType();
            this.packageType3.setName("package3-" + System.currentTimeMillis());
            this.packageType3.setDescription("");
            this.packageType3.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType3.setDisplayName("TestResourcePackage3");
            this.packageType3.setCreationData(true);
            this.packageType3.setResourceType(this.resourceType1);
            this.em.persist((Object)this.packageType3);
            this.packageType4 = new PackageType();
            this.packageType4.setName("package4-" + System.currentTimeMillis());
            this.packageType4.setDescription("");
            this.packageType4.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType4.setDisplayName("TestResourcePackage4");
            this.packageType4.setCreationData(true);
            this.packageType4.setResourceType(this.resourceType1);
            this.em.persist((Object)this.packageType4);
            this.resourceType1.addPackageType(this.packageType1);
            this.resourceType1.addPackageType(this.packageType2);
            this.resourceType1.addPackageType(this.packageType3);
            this.package1 = new Package("Package1", this.packageType1);
            this.package1.addVersion(new PackageVersion(this.package1, "1.0.0", this.architecture1));
            this.package1.addVersion(new PackageVersion(this.package1, "2.0.0", this.architecture1));
            this.em.persist((Object)this.package1);
            this.package2 = new Package("Package2", this.packageType2);
            this.package2.addVersion(new PackageVersion(this.package2, "1.0.0", this.architecture1));
            this.package2.addVersion(new PackageVersion(this.package2, "2.0.0", this.architecture1));
            this.em.persist((Object)this.package2);
            this.package3 = new Package("Package3", this.packageType3);
            this.package3.addVersion(new PackageVersion(this.package3, "1.0.0", this.architecture1));
            this.em.persist((Object)this.package3);
            this.package4 = new Package("Package4", this.packageType4);
            PackageVersion package4Installed = new PackageVersion(this.package4, "1.0.0", this.architecture1);
            this.package4.addVersion(package4Installed);
            this.package4.addVersion(new PackageVersion(this.package4, "2.0.0", this.architecture1));
            this.em.persist((Object)this.package4);
            this.package5 = new Package("Package5", this.packageType3);
            PackageVersion package5Installed = new PackageVersion(this.package5, "1.0.0", this.architecture1);
            this.package5.addVersion(package5Installed);
            this.em.persist((Object)this.package5);
            this.resource1 = new Resource("parent" + System.currentTimeMillis(), "name", this.resourceType1);
            this.resource1.setUuid("" + new Random().nextInt());
            this.em.persist((Object)this.resource1);
            this.installedPackage1 = new InstalledPackage();
            this.installedPackage1.setResource(this.resource1);
            this.installedPackage1.setPackageVersion(package4Installed);
            this.resource1.addInstalledPackage(this.installedPackage1);
            this.installedPackage2 = new InstalledPackage();
            this.installedPackage2.setResource(this.resource1);
            this.installedPackage2.setPackageVersion(package5Installed);
            this.resource1.addInstalledPackage(this.installedPackage2);
            this.installedPackage1.setResource(this.resource1);
            this.installedPackage2.setResource(this.resource1);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransactionManager().rollback();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDownTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        try {
            try {
                this.resource1 = (Resource)this.em.find(Resource.class, (Object)this.resource1.getId());
                for (InstalledPackage ip : this.resource1.getInstalledPackages()) {
                    this.em.remove((Object)ip);
                }
                for (InstalledPackageHistory history : this.resource1.getInstalledPackageHistory()) {
                    this.em.remove((Object)history);
                }
                for (ContentServiceRequest request : this.resource1.getContentServiceRequests()) {
                    this.em.remove((Object)request);
                }
                this.package1 = (Package)this.em.find(Package.class, (Object)this.package1.getId());
                this.em.remove((Object)this.package1);
                this.package2 = (Package)this.em.find(Package.class, (Object)this.package2.getId());
                this.em.remove((Object)this.package2);
                this.package3 = (Package)this.em.find(Package.class, (Object)this.package3.getId());
                this.em.remove((Object)this.package3);
                this.package4 = (Package)this.em.find(Package.class, (Object)this.package4.getId());
                this.em.remove((Object)this.package4);
                this.package5 = (Package)this.em.find(Package.class, (Object)this.package5.getId());
                this.em.remove((Object)this.package5);
                this.packageType1 = (PackageType)this.em.find(PackageType.class, (Object)this.packageType1.getId());
                this.em.remove((Object)this.packageType1);
                this.packageType2 = (PackageType)this.em.find(PackageType.class, (Object)this.packageType2.getId());
                this.em.remove((Object)this.packageType2);
                this.packageType3 = (PackageType)this.em.find(PackageType.class, (Object)this.packageType3.getId());
                this.em.remove((Object)this.packageType3);
                this.packageType4 = (PackageType)this.em.find(PackageType.class, (Object)this.packageType4.getId());
                this.em.remove((Object)this.packageType4);
                ResourceTreeHelper.deleteResource(this.em, this.resource1);
                this.resourceType1 = (ResourceType)this.em.find(ResourceType.class, (Object)this.resourceType1.getId());
                this.em.remove((Object)this.resourceType1);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getTransactionManager().rollback();
                throw e;
            }
        }
        finally {
            this.unprepareForTestAgents();
        }
    }

    private void populateResponseSteps() {
        this.stepResults = new ArrayList<DeployPackageStep>(3);
        DeployPackageStep step1 = new DeployPackageStep("Step1", "First step");
        step1.setStepResult(ContentResponseResult.SUCCESS);
        DeployPackageStep step2 = new DeployPackageStep("Step2", "Second step");
        step2.setStepResult(ContentResponseResult.NOT_PERFORMED);
        DeployPackageStep step3 = new DeployPackageStep("Step3", "Third step");
        step3.setStepResult(ContentResponseResult.FAILURE);
        step3.setStepErrorMessage("Error executing the third step");
        this.stepResults.add(step1);
        this.stepResults.add(step2);
        this.stepResults.add(step3);
    }

    private class MockContentAgentService
    implements ContentAgentService {
        private ContentResponseResult responseReturnStatus;
        private boolean throwError;
        private boolean returnIndividualResponses = true;
        private List<DeployPackageStep> deployPackageSteps;

        private MockContentAgentService() {
        }

        public void setResponseReturnStatus(ContentResponseResult responseReturnStatus) {
            this.responseReturnStatus = responseReturnStatus;
        }

        public void setThrowError(boolean throwError) {
            this.throwError = throwError;
        }

        public void setDeployPackageSteps(List<DeployPackageStep> deployPackageSteps) {
            this.deployPackageSteps = deployPackageSteps;
        }

        public void setReturnIndividualResponses(boolean returnIndividualResponses) {
            this.returnIndividualResponses = returnIndividualResponses;
        }

        public Set<ResourcePackageDetails> getLastDiscoveredResourcePackages(int resourceId) {
            return null;
        }

        public ContentDiscoveryReport executeResourcePackageDiscoveryImmediately(int resourceId, String packageTypeName) throws PluginContainerException {
            return null;
        }

        public List<DeployPackageStep> translateInstallationSteps(int resourceId, ResourcePackageDetails packageDetails) {
            return null;
        }

        public void deployPackages(final DeployPackagesRequest request) {
            if (this.throwError) {
                throw new RuntimeException("Mock exception - This is expected");
            }
            Runnable responseRunner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = responseLock;
                    synchronized (object) {
                        DeployPackagesResponse response = new DeployPackagesResponse(MockContentAgentService.this.responseReturnStatus);
                        response.setRequestId(request.getRequestId());
                        if (MockContentAgentService.this.returnIndividualResponses) {
                            for (ResourcePackageDetails packageDetails : request.getPackages()) {
                                DeployIndividualPackageResponse individualResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), MockContentAgentService.this.responseReturnStatus);
                                individualResponse.setDeploymentSteps(MockContentAgentService.this.deployPackageSteps);
                                response.addPackageResponse(individualResponse);
                            }
                        }
                        ContentManagerBeanTest.this.contentManager.completeDeployPackageRequest(response);
                    }
                }
            };
            Thread runner = new Thread(responseRunner);
            runner.start();
        }

        public void deletePackages(final DeletePackagesRequest request) {
            if (this.throwError) {
                throw new RuntimeException("Mock exception - This is expected");
            }
            Runnable responseRunner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = responseLock;
                    synchronized (object) {
                        RemovePackagesResponse response = new RemovePackagesResponse(MockContentAgentService.this.responseReturnStatus);
                        response.setRequestId(request.getRequestId());
                        if (MockContentAgentService.this.returnIndividualResponses) {
                            for (ResourcePackageDetails packageDetails : request.getPackages()) {
                                RemoveIndividualPackageResponse individualResponse = new RemoveIndividualPackageResponse(packageDetails.getKey(), MockContentAgentService.this.responseReturnStatus);
                                response.addPackageResponse(individualResponse);
                            }
                        }
                        ContentManagerBeanTest.this.contentManager.completeDeletePackageRequest(response);
                    }
                }
            };
            Thread runner = new Thread(responseRunner);
            runner.start();
        }

        public void retrievePackageBits(RetrievePackageBitsRequest request) {
        }
    }
}

