/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.persistence.Query;
import org.apache.commons.lang.RandomStringUtils;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceSyncResults;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.ContentSyncStatus;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.TestContentServerPluginService;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.testng.annotations.Test;

public class ContentSourceManagerBeanTest
extends AbstractEJB3Test {
    private static final boolean TESTS_ENABLED = true;
    private ContentSourceManagerLocal contentSourceManager;
    private ContentSourceMetadataManagerLocal contentSourceMetadataManager;
    private RepoManagerLocal repoManager;
    private Subject overlord;
    private PackageType packageType1;
    private PackageType packageType2;
    private PackageType packageType3;
    private PackageType packageType4;
    private Package package1;
    private Package package2;
    private Package package3;
    private Package package4;
    private Package package5;
    private InstalledPackage installedPackage1;
    private InstalledPackage installedPackage2;
    private Architecture architecture1;
    private ResourceType resourceType1;
    private Resource resource1;

    protected void beforeClass() throws Exception {
        this.contentSourceManager = LookupUtil.getContentSourceManager();
        this.contentSourceMetadataManager = LookupUtil.getContentSourceMetadataManager();
        this.repoManager = LookupUtil.getRepoManagerLocal();
        this.cleanupPreviousTestRuns();
    }

    @Override
    protected void beforeMethod() throws Exception {
        this.beforeClass();
        this.setupTestEnvironment();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.prepareScheduler();
        TestContentServerPluginService pluginService = new TestContentServerPluginService(this);
    }

    @Override
    protected void afterMethod() throws Exception {
        this.tearDownTestEnvironment();
        this.unprepareServerPluginService();
        this.unprepareScheduler();
        this.cleanupPreviousTestRuns();
    }

    @Test(enabled=true)
    public void testGetSyncResultsList() throws Throwable {
        this.getTransactionManager().begin();
        try {
            ContentSourceType type = new ContentSourceType("testGetSyncResultsListCST");
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            ContentSource contentSource = new ContentSource("testGetSyncResultsListCS", type);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            PageList list = this.contentSourceManager.getContentSourceSyncResults(this.overlord, contentSource.getId(), PageControl.getUnlimitedInstance());
            assert (list.size() == 0) : "-->" + list;
            ContentSourceSyncResults results = new ContentSourceSyncResults(contentSource);
            results = this.contentSourceManager.persistContentSourceSyncResults(results);
            assert (results != null);
            list = this.contentSourceManager.getContentSourceSyncResults(this.overlord, contentSource.getId(), PageControl.getUnlimitedInstance());
            assert (list.size() == 1) : "-->" + list;
            assert (((ContentSourceSyncResults)list.get(0)).getId() == results.getId()) : "-->" + list;
            ContentSourceSyncResults another = new ContentSourceSyncResults(contentSource);
            another = this.contentSourceManager.persistContentSourceSyncResults(another);
            assert (another == null) : "Not allowed to have two INPROGRESS results persisted";
            list = this.contentSourceManager.getContentSourceSyncResults(this.overlord, contentSource.getId(), PageControl.getUnlimitedInstance());
            assert (list.size() == 1) : "-->" + list;
            assert (((ContentSourceSyncResults)list.get(0)).getId() == results.getId()) : "-->" + list;
            another = new ContentSourceSyncResults(contentSource);
            another.setStatus(ContentSyncStatus.FAILURE);
            another.setEndTime(Long.valueOf(System.currentTimeMillis()));
            another = this.contentSourceManager.persistContentSourceSyncResults(another);
            assert (another != null) : "Allowed to have two results persisted if only one is INPROGRESS";
            list = this.contentSourceManager.getContentSourceSyncResults(this.overlord, contentSource.getId(), PageControl.getUnlimitedInstance());
            assert (list.size() == 2) : "-->" + list;
            assert (((ContentSourceSyncResults)list.get(0)).getId() == another.getId()) : "-->" + list;
            assert (((ContentSourceSyncResults)list.get(1)).getId() == results.getId()) : "-->" + list;
            this.contentSourceManager.deleteContentSource(this.overlord, contentSource.getId());
            list = this.contentSourceManager.getContentSourceSyncResults(this.overlord, contentSource.getId(), PageControl.getUnlimitedInstance());
            assert (list.size() == 0) : "-->" + list;
            this.contentSourceMetadataManager.registerTypes(new HashSet());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testMergeSyncReport() throws Exception {
        int repoId = 0;
        int contentSourceId = 0;
        try {
            ContentSourceType type = new ContentSourceType("testMergeSyncReportCST");
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            type = this.contentSourceManager.getContentSourceType(type.getName());
            assert (type != null);
            assert (type.getId() > 0);
            ContentSource contentSource = new ContentSource("testMergeSyncReportCS", type);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            assert (contentSource != null);
            contentSourceId = contentSource.getId();
            assert (contentSourceId > 0);
            Repo repo = new Repo("testRepo");
            repo = this.repoManager.createRepo(this.overlord, repo);
            repoId = repo.getId();
            PackageSyncReport report = new PackageSyncReport();
            ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey("testCreateContentSourceFoo", "testCreateContentSourceVer", this.packageType1.getName(), this.architecture1.getName(), this.resourceType1.getName(), this.resourceType1.getPlugin());
            ContentProviderPackageDetails details = new ContentProviderPackageDetails(key);
            details.setLocation("dummy-location");
            details.setMetadata("dummy-metadata".getBytes());
            details.addResourceVersion("1.0.0");
            details.addResourceVersion("2.0.0");
            report.addNewPackage(details);
            HashMap previous = new HashMap();
            RepoSyncResults results = new RepoSyncResults(repo);
            results = this.repoManager.persistRepoSyncResults(results);
            assert (results != null);
            results = this.contentSourceManager.mergePackageSyncReport(contentSource, repo, report, previous, results);
            assert (results != null);
            this.getTransactionManager().begin();
            try {
                this.resourceType1 = (ResourceType)this.em.find(ResourceType.class, (Object)this.resourceType1.getId());
                Query productVersionQuery = this.em.createNamedQuery("ProductVersion.findByResourceTypeAndVersion");
                productVersionQuery.setParameter("resourceType", (Object)this.resourceType1);
                productVersionQuery.setParameter("version", (Object)"1.0.0");
                List productVersionList = productVersionQuery.getResultList();
                assert (productVersionList.size() > 0) : "Could not find product version for 1.0.0";
                productVersionQuery = this.em.createNamedQuery("ProductVersion.findByResourceTypeAndVersion");
                productVersionQuery.setParameter("resourceType", (Object)this.resourceType1);
                productVersionQuery.setParameter("version", (Object)"2.0.0");
                productVersionList = productVersionQuery.getResultList();
                assert (productVersionList.size() > 0) : "Could not find product version for 2.0.0";
            }
            finally {
                this.getTransactionManager().rollback();
            }
            PageControl pc = PageControl.getUnlimitedInstance();
            PageList metadataList = this.contentSourceManager.getPackageVersionMetadata(this.resource1.getId(), pc);
            assert (metadataList != null);
            assert (metadataList.size() == 0) : "-->" + metadataList;
            String metadataMd5 = this.contentSourceManager.getResourceSubscriptionMD5(this.resource1.getId());
            assert (metadataMd5 != null);
            assert (metadataMd5.length() == 32) : "-->" + metadataMd5;
            assert (metadataMd5.equals("d41d8cd98f00b204e9800998ecf8427e")) : "-->" + metadataMd5;
            metadataMd5 = this.contentSourceManager.getResourceSubscriptionMD5(Integer.MIN_VALUE);
            assert (metadataMd5 != null);
            assert (metadataMd5.length() == 32) : "-->" + metadataMd5;
            assert (metadataMd5.equals("d41d8cd98f00b204e9800998ecf8427e")) : "-->" + metadataMd5;
            this.repoManager.addContentSourcesToRepo(this.overlord, repoId, new int[]{contentSourceId});
            pc = PageControl.getUnlimitedInstance();
            PageList inRepo = this.repoManager.findPackageVersionsInRepo(this.overlord, repoId, pc);
            pc = PageControl.getUnlimitedInstance();
            PageList inContentSources = this.contentSourceManager.getPackageVersionsFromContentSources(this.overlord, new int[]{contentSourceId}, pc);
            PageList inContentSource = this.contentSourceManager.getPackageVersionsFromContentSource(this.overlord, contentSourceId, pc);
            assert (inRepo != null);
            assert (inContentSources != null);
            assert (inContentSource != null);
            assert (inRepo.size() == 1) : inRepo;
            assert (inContentSources.size() == 1) : inContentSources;
            assert (inContentSource.size() == 1) : inContentSource;
            pc = PageControl.getUnlimitedInstance();
            PageList unloaded = this.contentSourceManager.getUnloadedPackageVersionsFromContentSourceInRepo(this.overlord, contentSourceId, repoId, pc);
            assert (unloaded != null);
            assert (unloaded.size() == 1);
            long pvccount = this.repoManager.getPackageVersionCountFromRepo(this.overlord, repo.getId());
            assert (pvccount == 1L) : "-->" + pvccount;
            long pvcscount = this.contentSourceManager.getPackageVersionCountFromContentSource(this.overlord, contentSourceId);
            assert (pvcscount == 1L) : "-->" + pvcscount;
            this.repoManager.subscribeResourceToRepos(this.overlord, this.resource1.getId(), new int[]{repoId});
            pc = PageControl.getUnlimitedInstance();
            metadataList = this.contentSourceManager.getPackageVersionMetadata(this.resource1.getId(), pc);
            assert (metadataList != null);
            assert (metadataList.size() == 1) : "-->" + metadataList;
            metadataMd5 = this.contentSourceManager.getResourceSubscriptionMD5(this.resource1.getId());
            assert (metadataMd5 != null);
            assert (metadataMd5.length() == 32) : "-->" + metadataMd5;
            repo = this.repoManager.getRepo(this.overlord, repoId);
            long modifiedTimestamp = repo.getLastModifiedDate();
            Date modifiedDate = new Date(modifiedTimestamp);
            String datehash = Integer.toString(modifiedDate.hashCode());
            assert (metadataMd5.equals(MessageDigestGenerator.getDigestString((String)datehash))) : "-->" + metadataMd5;
            this.repoManager.unsubscribeResourceFromRepos(this.overlord, this.resource1.getId(), new int[]{repoId});
            pc = PageControl.getUnlimitedInstance();
            metadataList = this.contentSourceManager.getPackageVersionMetadata(this.resource1.getId(), pc);
            assert (metadataList != null);
            assert (metadataList.size() == 0) : "-->" + metadataList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (repoId != 0) {
                    this.repoManager.deleteRepo(this.overlord, repoId);
                }
                if (contentSourceId != 0) {
                    this.contentSourceManager.deleteContentSource(this.overlord, contentSourceId);
                }
                this.contentSourceMetadataManager.registerTypes(new HashSet());
            }
            catch (Throwable t) {}
        }
    }

    @Test(enabled=true)
    public void testMergeSyncReportAddRemoveUpdate() throws Exception {
        PageControl pc = PageControl.getUnlimitedInstance();
        int contentSourceId = 0;
        int repoId = 0;
        try {
            ContentSourceType type = new ContentSourceType("testMergeSyncReportAMUCST");
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            ContentSource contentSource = new ContentSource("testMergeSyncReportAMUCS", type);
            contentSource.setLazyLoad(true);
            contentSource.setDownloadMode(DownloadMode.DATABASE);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            contentSourceId = contentSource.getId();
            assert (contentSourceId > 0);
            Repo repo = new Repo("testRepo");
            repo = this.repoManager.createRepo(this.overlord, repo);
            repoId = repo.getId();
            PageList inCS = this.contentSourceManager.getPackageVersionsFromContentSource(this.overlord, contentSourceId, pc);
            assert (inCS != null);
            assert (inCS.size() == 0) : inCS;
            RepoSyncResults results = new RepoSyncResults(repo);
            results = this.repoManager.persistRepoSyncResults(results);
            assert (results != null);
            PackageSyncReport report = new PackageSyncReport();
            ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey("testARUFoo", "testARUVer", this.packageType1.getName(), this.architecture1.getName(), this.resourceType1.getName(), this.resourceType1.getPlugin());
            ContentProviderPackageDetails details = new ContentProviderPackageDetails(key);
            details.setLocation("dummy-location-aru");
            details.setFileSize(Long.valueOf(1234L));
            report.addNewPackage(details);
            HashMap<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous = new HashMap<ContentProviderPackageDetailsKey, PackageVersionContentSource>();
            results = this.contentSourceManager.mergePackageSyncReport(contentSource, repo, report, previous, results);
            assert (results != null);
            inCS = this.contentSourceManager.getPackageVersionsFromContentSource(this.overlord, contentSourceId, pc);
            assert (inCS != null);
            assert (inCS.size() == 1) : inCS;
            PageList unloaded = this.contentSourceManager.getUnloadedPackageVersionsFromContentSourceInRepo(this.overlord, contentSourceId, repoId, pc);
            assert (unloaded != null);
            assert (unloaded.size() == 1);
            long pvcscount = this.contentSourceManager.getPackageVersionCountFromContentSource(this.overlord, contentSourceId);
            assert (pvcscount == 1L) : "-->" + pvcscount;
            PackageVersionContentSource addedPVCS = (PackageVersionContentSource)unloaded.get(0);
            assert (addedPVCS.getPackageVersionContentSourcePK().getPackageVersion().getFileSize() == 1234L);
            previous.put(key, addedPVCS);
            System.out.println("content source merge ADD works!");
            report = new PackageSyncReport();
            details.setFileSize(Long.valueOf(9999L));
            report.addUpdatedPackage(details);
            results = this.contentSourceManager.mergePackageSyncReport(contentSource, repo, report, previous, results);
            assert (results != null);
            inCS = this.contentSourceManager.getPackageVersionsFromContentSource(this.overlord, contentSourceId, pc);
            assert (inCS != null);
            assert (inCS.size() == 1) : inCS;
            unloaded = this.contentSourceManager.getUnloadedPackageVersionsFromContentSourceInRepo(this.overlord, contentSourceId, repoId, pc);
            assert (unloaded != null);
            assert (unloaded.size() == 1);
            assert (((PackageVersionContentSource)unloaded.get(0)).getPackageVersionContentSourcePK().getPackageVersion().getFileSize() == 9999L);
            System.out.println("content source merge UPDATE works!");
            report = new PackageSyncReport();
            report.addDeletePackage(details);
            results = this.contentSourceManager.mergePackageSyncReport(contentSource, repo, report, previous, results);
            assert (results != null);
            inCS = this.contentSourceManager.getPackageVersionsFromContentSource(this.overlord, contentSourceId, pc);
            assert (inCS != null);
            assert (inCS.size() == 0) : inCS;
            pvcscount = this.contentSourceManager.getPackageVersionCountFromContentSource(this.overlord, contentSourceId);
            assert (pvcscount == 0L) : "-->" + pvcscount;
            System.out.println("content source merge REMOVE works!");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (repoId != 0) {
                    this.repoManager.deleteRepo(this.overlord, repoId);
                }
                if (contentSourceId != 0) {
                    this.contentSourceManager.deleteContentSource(this.overlord, contentSourceId);
                }
                this.contentSourceMetadataManager.registerTypes(new HashSet());
            }
            catch (Throwable t) {}
        }
    }

    @Test(enabled=true)
    public void testMergeSyncReportAddRemoveUpdateWithRepo() throws Exception {
        PageControl pc = PageControl.getUnlimitedInstance();
        int contentSourceId = 0;
        int repoId = 0;
        try {
            ContentSourceType type = new ContentSourceType("testMergeSyncReportAMU2CST");
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            ContentSource contentSource = new ContentSource("testMergeSyncReportAMU2CS", type);
            contentSource.setLazyLoad(true);
            contentSource.setDownloadMode(DownloadMode.DATABASE);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            contentSourceId = contentSource.getId();
            assert (contentSourceId > 0);
            Repo repo = new Repo("testMergeSyncReportAMU2Ch");
            repo = this.repoManager.createRepo(this.overlord, repo);
            repoId = repo.getId();
            assert (repoId > 0);
            this.repoManager.addContentSourcesToRepo(this.overlord, repoId, new int[]{contentSourceId});
            assert (0L == this.contentSourceManager.getPackageVersionCountFromContentSource(this.overlord, contentSourceId));
            assert (0L == this.repoManager.getPackageVersionCountFromRepo(this.overlord, repoId));
            RepoSyncResults results = new RepoSyncResults(repo);
            results = this.repoManager.persistRepoSyncResults(results);
            assert (results != null);
            PackageSyncReport report = new PackageSyncReport();
            ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey("testARU2Foo", "testARU2Ver", this.packageType1.getName(), this.architecture1.getName(), this.resourceType1.getName(), this.resourceType1.getPlugin());
            ContentProviderPackageDetails details = new ContentProviderPackageDetails(key);
            details.setLocation("dummy-location-aru");
            report.addNewPackage(details);
            HashMap<ContentProviderPackageDetailsKey, PackageVersionContentSource> previous = new HashMap<ContentProviderPackageDetailsKey, PackageVersionContentSource>();
            results = this.contentSourceManager.mergePackageSyncReport(contentSource, repo, report, previous, results);
            assert (results != null);
            PageList unloaded = this.contentSourceManager.getUnloadedPackageVersionsFromContentSourceInRepo(this.overlord, contentSourceId, repoId, pc);
            assert (unloaded != null);
            assert (unloaded.size() == 1);
            assert (1L == this.contentSourceManager.getPackageVersionCountFromContentSource(this.overlord, contentSourceId));
            assert (1L == this.repoManager.getPackageVersionCountFromRepo(this.overlord, repoId));
            PackageVersionContentSource addedPVCS = (PackageVersionContentSource)unloaded.get(0);
            previous.put(key, addedPVCS);
            report = new PackageSyncReport();
            report.addDeletePackage(details);
            results = this.contentSourceManager.mergePackageSyncReport(contentSource, repo, report, previous, results);
            assert (results != null);
            assert (0L == this.contentSourceManager.getPackageVersionCountFromContentSource(this.overlord, contentSourceId));
            long pvCountFromRepo = this.repoManager.getPackageVersionCountFromRepo(this.overlord, repoId);
            assert (0L == pvCountFromRepo) : "Expected: 0, Found: " + pvCountFromRepo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (repoId != 0) {
                    this.repoManager.deleteRepo(this.overlord, repoId);
                }
                if (contentSourceId != 0) {
                    this.contentSourceManager.deleteContentSource(this.overlord, contentSourceId);
                }
                this.contentSourceMetadataManager.registerTypes(new HashSet());
            }
            catch (Throwable t) {}
        }
    }

    @Test(enabled=true)
    public void testDeleteContentSource() throws Exception {
        PageControl pc = PageControl.getUnlimitedInstance();
        try {
            ContentSourceType type = null;
            ContentSource contentSource = null;
            int csTypeCount = this.contentSourceManager.getAllContentSourceTypes().size();
            PageList csList = this.contentSourceManager.getAllContentSources(this.overlord, pc);
            int csCount = this.contentSourceManager.getAllContentSources(this.overlord, pc).size();
            type = new ContentSourceType("testDel-" + RandomStringUtils.randomAlphanumeric((int)6));
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            type = this.contentSourceManager.getContentSourceType(type.getName());
            assert (type != null);
            assert (type.getId() > 0);
            assert (csTypeCount + 1 == this.contentSourceManager.getAllContentSourceTypes().size());
            contentSource = new ContentSource("testDel-" + RandomStringUtils.randomAlphanumeric((int)6), type);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            assert (contentSource != null);
            int contentSourceId = contentSource.getId();
            assert (contentSourceId > 0);
            assert (csCount + 1 == this.contentSourceManager.getAllContentSources(this.overlord, pc).size());
            Repo repo = new Repo("testDel-" + RandomStringUtils.randomAlphanumeric((int)6));
            this.repoManager.createRepo(this.overlord, repo);
            this.repoManager.addContentSourcesToRepo(this.overlord, repo.getId(), new int[]{contentSourceId});
            assert (null != this.contentSourceManager.getContentSource(this.overlord, contentSourceId)) : "should exist";
            this.contentSourceManager.deleteContentSource(this.overlord, contentSourceId);
            assert (null == this.contentSourceManager.getContentSource(this.overlord, contentSourceId)) : "should have been deleted";
            this.repoManager.deleteRepo(this.overlord, repo.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.contentSourceMetadataManager.registerTypes(new HashSet());
        }
    }

    @Test(enabled=true)
    public void testUpdateContentSourceNoConfig() throws Exception {
        try {
            ContentSourceType type = null;
            ContentSource contentSource = null;
            type = new ContentSourceType("testUpdateContentSourceCST");
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            type = this.contentSourceManager.getContentSourceType(type.getName());
            assert (type != null);
            assert (type.getId() > 0);
            contentSource = new ContentSource("testUpdateContentSource", type);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            assert (contentSource != null);
            int contentSourceId = contentSource.getId();
            assert (contentSourceId > 0);
            ContentSource loaded = this.contentSourceManager.getContentSource(this.overlord, contentSourceId);
            assert (loaded != null) : "should exist";
            assert (loaded.getDescription() == null);
            loaded.setDescription("new updated description");
            loaded = this.contentSourceManager.updateContentSource(this.overlord, loaded, false);
            assert (loaded != null) : "should have been updated";
            loaded = this.contentSourceManager.getContentSource(this.overlord, contentSourceId);
            assert (loaded.getDescription().equals("new updated description"));
            assert (loaded.getConfiguration() == null) : "should not have a config yet";
            Configuration config = new Configuration();
            config.put((Property)new PropertySimple("updateCSName", (Object)"updateCSValue"));
            loaded.setConfiguration(config);
            loaded = this.contentSourceManager.updateContentSource(this.overlord, loaded, false);
            assert (loaded != null) : "should have been updated";
            config = loaded.getConfiguration();
            assert (config != null) : "should have a config now";
            assert (config.getSimple("updateCSName").getStringValue().equals("updateCSValue")) : config;
            assert (loaded.getDescription().equals("new updated description")) : "desc should still be there";
            this.contentSourceManager.deleteContentSource(this.overlord, contentSourceId);
            assert (null == this.contentSourceManager.getContentSource(this.overlord, contentSourceId)) : "should have been deleted";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.contentSourceMetadataManager.registerTypes(new HashSet());
        }
    }

    @Test(enabled=true)
    public void testUpdateContentSourceConfig() throws Exception {
        try {
            ContentSourceType type = null;
            ContentSource contentSource = null;
            type = new ContentSourceType("testUpdateContentSourceCST2");
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            type = this.contentSourceManager.getContentSourceType(type.getName());
            assert (type != null);
            assert (type.getId() > 0);
            Configuration config = new Configuration();
            config.put((Property)new PropertySimple("updateCSName", (Object)"updateCSValue"));
            contentSource = new ContentSource("testUpdateContentSource2", type);
            contentSource.setConfiguration(config);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            assert (contentSource != null);
            int contentSourceId = contentSource.getId();
            assert (contentSourceId > 0);
            ContentSource loaded = this.contentSourceManager.getContentSource(this.overlord, contentSourceId);
            assert (loaded != null) : "should exist";
            assert (loaded.getConfiguration() != null);
            assert (loaded.getConfiguration().getSimple("updateCSName").getStringValue().equals("updateCSValue"));
            loaded.getConfiguration().getSimple("updateCSName").setStringValue("UPDATED");
            loaded = this.contentSourceManager.updateContentSource(this.overlord, loaded, false);
            assert (loaded != null) : "should have been updated";
            assert (loaded.getConfiguration() != null);
            assert (loaded.getConfiguration().getSimple("updateCSName").getStringValue().equals("UPDATED"));
            loaded = this.contentSourceManager.getContentSource(this.overlord, contentSourceId);
            assert (loaded != null) : "should exist";
            assert (loaded.getConfiguration() != null);
            assert (loaded.getConfiguration().getSimple("updateCSName").getStringValue().equals("UPDATED"));
            loaded.setConfiguration(null);
            loaded = this.contentSourceManager.updateContentSource(this.overlord, loaded, false);
            assert (loaded != null) : "should have been updated";
            assert (loaded.getConfiguration() == null) : "config should be null -> " + loaded.getConfiguration();
            this.contentSourceManager.deleteContentSource(this.overlord, contentSourceId);
            assert (null == this.contentSourceManager.getContentSource(this.overlord, contentSourceId)) : "should have been deleted";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.contentSourceMetadataManager.registerTypes(new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testConstraintViolation() throws Exception {
        ContentSourceType type = null;
        ContentSource contentSource = null;
        try {
            type = new ContentSourceType("testConstraintViolationCST");
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            type = this.contentSourceManager.getContentSourceType(type.getName());
            assert (type != null);
            assert (type.getId() > 0);
            contentSource = new ContentSource("testConstraintViolation", type);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            assert (contentSource != null);
            int contentSourceId = contentSource.getId();
            assert (contentSourceId > 0);
            ContentSource dup = new ContentSource("testConstraintViolation", type);
            try {
                this.contentSourceManager.simpleCreateContentSource(this.overlord, dup);
                assert (false) : "Should not have been able to create the same content source";
            }
            catch (Exception expected) {
            }
            finally {
                this.contentSourceManager.deleteContentSource(this.overlord, contentSourceId);
                this.contentSourceMetadataManager.registerTypes(new HashSet());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testMergeWithRepo() throws Exception {
        try {
            ContentSourceType type = null;
            ContentSource contentSource = null;
            type = new ContentSourceType("testMergeWithRepoCST");
            HashSet<ContentSourceType> types = new HashSet<ContentSourceType>();
            types.add(type);
            this.contentSourceMetadataManager.registerTypes(types);
            type = this.contentSourceManager.getContentSourceType(type.getName());
            assert (type != null);
            assert (type.getId() > 0);
            contentSource = new ContentSource("testMergeWithRepoCS", type);
            contentSource = this.contentSourceManager.simpleCreateContentSource(this.overlord, contentSource);
            assert (contentSource != null);
            int contentSourceId = contentSource.getId();
            assert (contentSourceId > 0);
            Repo repo = new Repo("testMergeWithRepo");
            repo = this.repoManager.createRepo(this.overlord, repo);
            this.repoManager.addContentSourcesToRepo(this.overlord, repo.getId(), new int[]{contentSourceId});
            PackageSyncReport report = new PackageSyncReport();
            ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey("testMergeWithRepofoo", "testMergeWithRepo-Version", this.packageType1.getName(), this.architecture1.getName(), this.resourceType1.getName(), this.resourceType1.getPlugin());
            ContentProviderPackageDetails details = new ContentProviderPackageDetails(key);
            details.setExtraProperties(new Configuration());
            details.getExtraProperties().put((Property)new PropertySimple("hello", (Object)"world"));
            details.setLocation("dummy-location");
            details.setFileSize(Long.valueOf(0L));
            report.addNewPackage(details);
            HashMap previous = new HashMap();
            RepoSyncResults results = new RepoSyncResults(repo);
            results = this.repoManager.persistRepoSyncResults(results);
            assert (results != null);
            this.contentSourceManager.mergePackageSyncReport(contentSource, repo, report, previous, results);
            PageList inRepo = this.repoManager.findPackageVersionsInRepo(this.overlord, repo.getId(), PageControl.getUnlimitedInstance());
            assert (inRepo != null);
            assert (inRepo.size() == 1);
            assert ("testMergeWithRepo-Version".equals(((PackageVersion)inRepo.get(0)).getVersion()));
            this.getTransactionManager().begin();
            try {
                PackageVersion foundPv = (PackageVersion)this.getEntityManager().find(PackageVersion.class, (Object)((PackageVersion)inRepo.get(0)).getId());
                assert (foundPv != null);
                assert (foundPv.getExtraProperties() != null);
                assert (foundPv.getExtraProperties().getSimple("hello").getStringValue().equals("world"));
            }
            finally {
                this.getTransactionManager().rollback();
            }
            this.contentSourceManager.deleteContentSource(this.overlord, contentSourceId);
            this.getTransactionManager().begin();
            try {
                assert (null != this.getEntityManager().find(PackageVersion.class, (Object)((PackageVersion)inRepo.get(0)).getId()));
            }
            finally {
                this.getTransactionManager().rollback();
            }
            this.repoManager.deleteRepo(this.overlord, repo.getId());
            this.getTransactionManager().begin();
            try {
                assert (null == this.getEntityManager().find(PackageVersion.class, (Object)((PackageVersion)inRepo.get(0)).getId()));
            }
            finally {
                this.getTransactionManager().rollback();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.contentSourceMetadataManager.registerTypes(new HashSet());
        }
    }

    private void setupTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        try {
            this.architecture1 = (Architecture)this.em.find(Architecture.class, (Object)1);
            this.resourceType1 = new ResourceType("platform-" + System.currentTimeMillis(), "TestPlugin", ResourceCategory.PLATFORM, null);
            this.em.persist((Object)this.resourceType1);
            this.packageType1 = new PackageType();
            this.packageType1.setName("package1-" + System.currentTimeMillis());
            this.packageType1.setDescription("");
            this.packageType1.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType1.setDisplayName("TestResourcePackage");
            this.packageType1.setCreationData(true);
            this.packageType1.setResourceType(this.resourceType1);
            this.em.persist((Object)this.packageType1);
            this.packageType2 = new PackageType();
            this.packageType2.setName("package2-" + System.currentTimeMillis());
            this.packageType2.setDescription("");
            this.packageType2.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType2.setDisplayName("TestResourcePackage2");
            this.packageType2.setCreationData(true);
            this.packageType2.setResourceType(this.resourceType1);
            this.em.persist((Object)this.packageType2);
            this.packageType3 = new PackageType();
            this.packageType3.setName("package3-" + System.currentTimeMillis());
            this.packageType3.setDescription("");
            this.packageType3.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType3.setDisplayName("TestResourcePackage3");
            this.packageType3.setCreationData(true);
            this.packageType3.setResourceType(this.resourceType1);
            this.em.persist((Object)this.packageType3);
            this.packageType4 = new PackageType();
            this.packageType4.setName("package4-" + System.currentTimeMillis());
            this.packageType4.setDescription("");
            this.packageType4.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType4.setDisplayName("TestResourcePackage4");
            this.packageType4.setCreationData(true);
            this.packageType4.setResourceType(this.resourceType1);
            this.em.persist((Object)this.packageType4);
            this.resourceType1.addPackageType(this.packageType1);
            this.resourceType1.addPackageType(this.packageType2);
            this.resourceType1.addPackageType(this.packageType3);
            this.package1 = new Package("Package1", this.packageType1);
            this.package1.addVersion(new PackageVersion(this.package1, "1.0.0", this.architecture1));
            this.package1.addVersion(new PackageVersion(this.package1, "2.0.0", this.architecture1));
            this.em.persist((Object)this.package1);
            this.package2 = new Package("Package2", this.packageType2);
            this.package2.addVersion(new PackageVersion(this.package2, "1.0.0", this.architecture1));
            this.package2.addVersion(new PackageVersion(this.package2, "2.0.0", this.architecture1));
            this.em.persist((Object)this.package2);
            this.package3 = new Package("Package3", this.packageType3);
            this.package3.addVersion(new PackageVersion(this.package3, "1.0.0", this.architecture1));
            this.em.persist((Object)this.package3);
            this.package4 = new Package("Package4", this.packageType4);
            PackageVersion package4Installed = new PackageVersion(this.package4, "1.0.0", this.architecture1);
            this.package4.addVersion(package4Installed);
            this.package4.addVersion(new PackageVersion(this.package4, "2.0.0", this.architecture1));
            this.em.persist((Object)this.package4);
            this.package5 = new Package("Package5", this.packageType4);
            PackageVersion package5Installed = new PackageVersion(this.package5, "1.0.0", this.architecture1);
            this.package5.addVersion(package5Installed);
            this.em.persist((Object)this.package5);
            this.resource1 = new Resource("parent" + System.currentTimeMillis(), "name", this.resourceType1);
            this.resource1.setUuid("" + new Random().nextInt());
            this.em.persist((Object)this.resource1);
            this.installedPackage1 = new InstalledPackage();
            this.installedPackage1.setResource(this.resource1);
            this.installedPackage1.setPackageVersion(package4Installed);
            this.resource1.addInstalledPackage(this.installedPackage1);
            this.installedPackage2 = new InstalledPackage();
            this.installedPackage2.setResource(this.resource1);
            this.installedPackage2.setPackageVersion(package4Installed);
            this.resource1.addInstalledPackage(this.installedPackage2);
            this.installedPackage1.setResource(this.resource1);
            this.installedPackage2.setResource(this.resource1);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransactionManager().rollback();
            throw e;
        }
    }

    private void tearDownTestEnvironment() throws Exception {
        this.getTransactionManager().begin();
        try {
            this.resource1 = (Resource)this.em.find(Resource.class, (Object)this.resource1.getId());
            for (InstalledPackage ip : this.resource1.getInstalledPackages()) {
                this.em.remove((Object)ip);
            }
            this.package1 = (Package)this.em.find(Package.class, (Object)this.package1.getId());
            this.em.remove((Object)this.package1);
            this.package2 = (Package)this.em.find(Package.class, (Object)this.package2.getId());
            this.em.remove((Object)this.package2);
            this.package3 = (Package)this.em.find(Package.class, (Object)this.package3.getId());
            this.em.remove((Object)this.package3);
            this.package4 = (Package)this.em.find(Package.class, (Object)this.package4.getId());
            this.em.remove((Object)this.package4);
            this.package5 = (Package)this.em.find(Package.class, (Object)this.package5.getId());
            this.em.remove((Object)this.package5);
            this.packageType1 = (PackageType)this.em.find(PackageType.class, (Object)this.packageType1.getId());
            this.em.remove((Object)this.packageType1);
            this.packageType2 = (PackageType)this.em.find(PackageType.class, (Object)this.packageType2.getId());
            this.em.remove((Object)this.packageType2);
            this.packageType3 = (PackageType)this.em.find(PackageType.class, (Object)this.packageType3.getId());
            this.em.remove((Object)this.packageType3);
            this.packageType4 = (PackageType)this.em.find(PackageType.class, (Object)this.packageType4.getId());
            this.em.remove((Object)this.packageType4);
            ResourceTreeHelper.deleteResource(this.em, this.resource1);
            this.resourceType1 = (ResourceType)this.em.find(ResourceType.class, (Object)this.resourceType1.getId());
            this.em.remove((Object)this.resourceType1);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransactionManager().rollback();
            throw e;
        }
    }

    private void cleanupPreviousTestRuns() throws Exception {
        this.getTransactionManager().begin();
        try {
            ContentSource deleteMe;
            Query query = this.em.createNamedQuery("ContentSource.findByNameAndTypeName");
            query.setParameter("name", (Object)"testUpdateContentSource");
            query.setParameter("typeName", (Object)"testUpdateContentSourceCST");
            List results = query.getResultList();
            if (results.size() > 0) {
                deleteMe = (ContentSource)results.get(0);
                this.em.remove((Object)deleteMe);
            }
            query = this.em.createNamedQuery("ContentSource.findByNameAndTypeName");
            query.setParameter("name", (Object)"testUpdateContentSource2");
            query.setParameter("typeName", (Object)"testUpdateContentSourceCST2");
            results = query.getResultList();
            if (results.size() > 0) {
                deleteMe = (ContentSource)results.get(0);
                this.em.remove((Object)deleteMe);
            }
            query = this.em.createNamedQuery("ContentSource.findByNameAndTypeName");
            query.setParameter("name", (Object)"testConstraintViolation");
            query.setParameter("typeName", (Object)"testConstraintViolationCST");
            results = query.getResultList();
            if (results.size() > 0) {
                deleteMe = (ContentSource)results.get(0);
                this.em.remove((Object)deleteMe);
            }
            query = this.em.createNamedQuery("ContentSourceType.findByName");
            query.setParameter("name", (Object)"testUpdateContentSourceCST");
            results = query.getResultList();
            if (results.size() > 0) {
                deleteMe = (ContentSourceType)results.get(0);
                this.em.remove((Object)deleteMe);
            }
            query = this.em.createNamedQuery("ContentSourceType.findByName");
            query.setParameter("name", (Object)"testUpdateContentSourceCST2");
            results = query.getResultList();
            if (results.size() > 0) {
                deleteMe = (ContentSourceType)results.get(0);
                this.em.remove((Object)deleteMe);
            }
            query = this.em.createNamedQuery("ContentSourceType.findByName");
            query.setParameter("name", (Object)"testConstraintViolationCST");
            results = query.getResultList();
            if (results.size() > 0) {
                deleteMe = (ContentSourceType)results.get(0);
                this.em.remove((Object)deleteMe);
            }
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getTransactionManager().rollback();
            throw e;
        }
    }
}

